#!perl

use strict;
use warnings;

my $dir = shift;
$dir = "." unless defined $dir;

my %skip = map { $_ => 1 } ( '.', '..', '.svn', 'mkmat_h.pl', 'matrices.h' );

opendir(my $d, $dir) or die "kon dir $dir niet openen: $!\n";
my @m = grep { not $skip{$_} } readdir($d);
closedir($d);

my $count = scalar(@m);

open(my $out, ">$dir/matrices.h") or die "kon matrices.h bestand niet aanmaken: $!\n";

print $out <<EOF;
// Matrices as const char strings, generated by mkmat_h.pl using
// '$dir' as input directory

const uint32 kMatrixCount = $count;

const struct MatrixInfo {
	const char*	m_name;
	const char*	m_family;
	int			m_nr;
	const char*	m_data;
	
	std::string	name() const		{ return m_name; }
	
} kMatrices[] = {
EOF

foreach my $mat (@m) {
	open(my $fh, "<$dir/$mat") or die "kon matrix $mat niet openen: $!\n";
	local($/) = undef;
	my $text = <$fh>;
	close($fh);
	
	$text =~ s/"/\\"/g;
	$text =~ s/.+/\t\t"$&\\n"/g;

	my ($family, $nr) = split(m/(?=\d+$)/, $mat);

	print $out <<EOF;
	{
		"$mat", "$family", $nr,
$text
	},
EOF
}
print $out "};\n";

close($out);
