.\" Automatically generated by Pod::Man v1.37, Pod::Parser v1.32
.\"
.\" Standard preamble:
.\" ========================================================================
.de Sh \" Subsection heading
.br
.if t .Sp
.ne 5
.PP
\fB\\$1\fR
.PP
..
.de Sp \" Vertical space (when we can't use .PP)
.if t .sp .5v
.if n .sp
..
.de Vb \" Begin verbatim text
.ft CW
.nf
.ne \\$1
..
.de Ve \" End verbatim text
.ft R
.fi
..
.\" Set up some character translations and predefined strings.  \*(-- will
.\" give an unbreakable dash, \*(PI will give pi, \*(L" will give a left
.\" double quote, and \*(R" will give a right double quote.  | will give a
.\" real vertical bar.  \*(C+ will give a nicer C++.  Capital omega is used to
.\" do unbreakable dashes and therefore won't be available.  \*(C` and \*(C'
.\" expand to `' in nroff, nothing in troff, for use with C<>.
.tr \(*W-|\(bv\*(Tr
.ds C+ C\v'-.1v'\h'-1p'\s-2+\h'-1p'+\s0\v'.1v'\h'-1p'
.ie n \{\
.    ds -- \(*W-
.    ds PI pi
.    if (\n(.H=4u)&(1m=24u) .ds -- \(*W\h'-12u'\(*W\h'-12u'-\" diablo 10 pitch
.    if (\n(.H=4u)&(1m=20u) .ds -- \(*W\h'-12u'\(*W\h'-8u'-\"  diablo 12 pitch
.    ds L" ""
.    ds R" ""
.    ds C` ""
.    ds C' ""
'br\}
.el\{\
.    ds -- \|\(em\|
.    ds PI \(*p
.    ds L" ``
.    ds R" ''
'br\}
.\"
.\" If the F register is turned on, we'll generate index entries on stderr for
.\" titles (.TH), headers (.SH), subsections (.Sh), items (.Ip), and index
.\" entries marked with X<> in POD.  Of course, you'll have to process the
.\" output yourself in some meaningful fashion.
.if \nF \{\
.    de IX
.    tm Index:\\$1\t\\n%\t"\\$2"
..
.    nr % 0
.    rr F
.\}
.\"
.\" For nroff, turn off justification.  Always turn off hyphenation; it makes
.\" way too many mistakes in technical documents.
.hy 0
.if n .na
.\"
.\" Accent mark definitions (@(#)ms.acc 1.5 88/02/08 SMI; from UCB 4.2).
.\" Fear.  Run.  Save yourself.  No user-serviceable parts.
.    \" fudge factors for nroff and troff
.if n \{\
.    ds #H 0
.    ds #V .8m
.    ds #F .3m
.    ds #[ \f1
.    ds #] \fP
.\}
.if t \{\
.    ds #H ((1u-(\\\\n(.fu%2u))*.13m)
.    ds #V .6m
.    ds #F 0
.    ds #[ \&
.    ds #] \&
.\}
.    \" simple accents for nroff and troff
.if n \{\
.    ds ' \&
.    ds ` \&
.    ds ^ \&
.    ds , \&
.    ds ~ ~
.    ds /
.\}
.if t \{\
.    ds ' \\k:\h'-(\\n(.wu*8/10-\*(#H)'\'\h"|\\n:u"
.    ds ` \\k:\h'-(\\n(.wu*8/10-\*(#H)'\`\h'|\\n:u'
.    ds ^ \\k:\h'-(\\n(.wu*10/11-\*(#H)'^\h'|\\n:u'
.    ds , \\k:\h'-(\\n(.wu*8/10)',\h'|\\n:u'
.    ds ~ \\k:\h'-(\\n(.wu-\*(#H-.1m)'~\h'|\\n:u'
.    ds / \\k:\h'-(\\n(.wu*8/10-\*(#H)'\z\(sl\h'|\\n:u'
.\}
.    \" troff and (daisy-wheel) nroff accents
.ds : \\k:\h'-(\\n(.wu*8/10-\*(#H+.1m+\*(#F)'\v'-\*(#V'\z.\h'.2m+\*(#F'.\h'|\\n:u'\v'\*(#V'
.ds 8 \h'\*(#H'\(*b\h'-\*(#H'
.ds o \\k:\h'-(\\n(.wu+\w'\(de'u-\*(#H)/2u'\v'-.3n'\*(#[\z\(de\v'.3n'\h'|\\n:u'\*(#]
.ds d- \h'\*(#H'\(pd\h'-\w'~'u'\v'-.25m'\f2\(hy\fP\v'.25m'\h'-\*(#H'
.ds D- D\\k:\h'-\w'D'u'\v'-.11m'\z\(hy\v'.11m'\h'|\\n:u'
.ds th \*(#[\v'.3m'\s+1I\s-1\v'-.3m'\h'-(\w'I'u*2/3)'\s-1o\s+1\*(#]
.ds Th \*(#[\s+2I\s-2\h'-\w'I'u*3/5'\v'-.3m'o\v'.3m'\*(#]
.ds ae a\h'-(\w'a'u*4/10)'e
.ds Ae A\h'-(\w'A'u*4/10)'E
.    \" corrections for vroff
.if v .ds ~ \\k:\h'-(\\n(.wu*9/10-\*(#H)'\s-2\u~\d\s+2\h'|\\n:u'
.if v .ds ^ \\k:\h'-(\\n(.wu*10/11-\*(#H)'\v'-.4m'^\v'.4m'\h'|\\n:u'
.    \" for low resolution devices (crt and lpr)
.if \n(.H>23 .if \n(.V>19 \
\{\
.    ds : e
.    ds 8 ss
.    ds o a
.    ds d- d\h'-1'\(ga
.    ds D- D\h'-1'\(hy
.    ds th \o'bp'
.    ds Th \o'LP'
.    ds ae ae
.    ds Ae AE
.\}
.rm #[ #] #H #V #F C
.\" ========================================================================
.\"
.IX Title "regalgebra n"
.TH regalgebra n "April 14, 2011" "version 1.4.5" "SAORD Documentation"
.SH "NAME"
\&\fBRegAlgebra: Boolean Algebra on Spatial Regions\fR
.SH "SYNOPSIS"
.IX Header "SYNOPSIS"
This document describes the boolean arithmetic defined for 
region expressions.
.SH "DESCRIPTION"
.IX Header "DESCRIPTION"
When defining a region, several shapes can be  combined using boolean
operations.  The boolean operators are (in order of precedence):
.PP
.Vb 6
\&  Symbol        Operator                Associativity
\&  ------        --------                -------------
\&  !             not                     right to left
\&  &             and                     left to right
\&  ^             exclusive or            left to right
\&  |             inclusive or            left to right
.Ve
.PP
For example,  to  create a mask  consisting  of a large  circle with a
smaller  box   removed,  one  can  use   the   \fBand\fR and \fBnot\fR
operators:
.PP
.Vb 1
\&  CIRCLE(11,11,15) & !BOX(11,11,3,6)
.Ve
.PP
and the resulting mask is:
.PP
.Vb 42
\&         1234567890123456789012345678901234567890
\&         ----------------------------------------
\&       1:1111111111111111111111..................
\&       2:1111111111111111111111..................
\&       3:11111111111111111111111.................
\&       4:111111111111111111111111................
\&       5:111111111111111111111111................
\&       6:1111111111111111111111111...............
\&       7:1111111111111111111111111...............
\&       8:1111111111111111111111111...............
\&       9:111111111...1111111111111...............
\&      10:111111111...1111111111111...............
\&      11:111111111...1111111111111...............
\&      12:111111111...1111111111111...............
\&      13:111111111...1111111111111...............
\&      14:111111111...1111111111111...............
\&      15:1111111111111111111111111...............
\&      16:1111111111111111111111111...............
\&      17:111111111111111111111111................
\&      18:111111111111111111111111................
\&      19:11111111111111111111111.................
\&      20:1111111111111111111111..................
\&      21:1111111111111111111111..................
\&      22:111111111111111111111...................
\&      23:..11111111111111111.....................
\&      24:...111111111111111......................
\&      25:.....11111111111........................
\&      26:........................................
\&      27:........................................
\&      28:........................................
\&      29:........................................
\&      30:........................................
\&      31:........................................
\&      32:........................................
\&      33:........................................
\&      34:........................................
\&      35:........................................
\&      36:........................................
\&      37:........................................
\&      38:........................................
\&      39:........................................
\&      40:........................................
.Ve
.PP
A three-quarter circle can be defined as:
.PP
.Vb 1
\&  CIRCLE(20,20,10) & !PIE(20,20,270,360)
.Ve
.PP
and looks as follows:
.PP
.Vb 42
\&         1234567890123456789012345678901234567890
\&         ----------------------------------------
\&       1:........................................
\&       2:........................................
\&       3:........................................
\&       4:........................................
\&       5:........................................
\&       6:........................................
\&       7:........................................
\&       8:........................................
\&       9:........................................
\&      10:........................................
\&      11:...............111111111................
\&      12:..............11111111111...............
\&      13:............111111111111111.............
\&      14:............111111111111111.............
\&      15:...........11111111111111111............
\&      16:..........1111111111111111111...........
\&      17:..........1111111111111111111...........
\&      18:..........1111111111111111111...........
\&      19:..........1111111111111111111...........
\&      20:..........1111111111111111111...........
\&      21:..........1111111111....................
\&      22:..........1111111111....................
\&      23:..........1111111111....................
\&      24:..........1111111111....................
\&      25:...........111111111....................
\&      26:............11111111....................
\&      27:............11111111....................
\&      28:..............111111....................
\&      29:...............11111....................
\&      30:........................................
\&      31:........................................
\&      32:........................................
\&      33:........................................
\&      34:........................................
\&      35:........................................
\&      36:........................................
\&      37:........................................
\&      38:........................................
\&      39:........................................
\&      40:........................................
.Ve
.PP
Two non-intersecting ellipses can be made into the same region:
.PP
.Vb 1
\&  ELL(20,20,10,20,90) | ELL(1,1,20,10,0)
.Ve
.PP
and looks as follows:
.PP
.Vb 42
\&         1234567890123456789012345678901234567890
\&         ----------------------------------------
\&       1:11111111111111111111....................
\&       2:11111111111111111111....................
\&       3:11111111111111111111....................
\&       4:11111111111111111111....................
\&       5:1111111111111111111.....................
\&       6:111111111111111111......................
\&       7:1111111111111111........................
\&       8:111111111111111.........................
\&       9:111111111111............................
\&      10:111111111...............................
\&      11:...........11111111111111111............
\&      12:........111111111111111111111111........
\&      13:.....11111111111111111111111111111......
\&      14:....11111111111111111111111111111111....
\&      15:..11111111111111111111111111111111111...
\&      16:.1111111111111111111111111111111111111..
\&      17:111111111111111111111111111111111111111.
\&      18:111111111111111111111111111111111111111.
\&      19:111111111111111111111111111111111111111.
\&      20:111111111111111111111111111111111111111.
\&      21:111111111111111111111111111111111111111.
\&      22:111111111111111111111111111111111111111.
\&      23:111111111111111111111111111111111111111.
\&      24:.1111111111111111111111111111111111111..
\&      25:..11111111111111111111111111111111111...
\&      26:...11111111111111111111111111111111.....
\&      27:.....11111111111111111111111111111......
\&      28:.......111111111111111111111111.........
\&      29:...........11111111111111111............
\&      30:........................................
\&      31:........................................
\&      32:........................................
\&      33:........................................
\&      34:........................................
\&      35:........................................
\&      36:........................................
\&      37:........................................
\&      38:........................................
\&      39:........................................
\&      40:........................................
.Ve
.PP
You can use several boolean operations in a single region expression,
to create arbitrarily complex regions.  With the important exception
below, you can apply the operators in any order, using parentheses if
necessary to override the natural precedences of the operators.
.PP
\&\s-1NB:\s0 Using a panda shape is always much more efficient than explicitly
specifying \*(L"pie & annulus\*(R", due to the ability of panda to place a
limit on the number of pixels checked in the pie shape.  If you are
going to specify the intersection of pie and annulus, use panda
instead.
.PP
As described in \*(L"help regreometry\*(R", the \fB\s-1PIE\s0\fR slice goes to the
edge of the field. To limit its scope, \fB\s-1PIE\s0\fR usually is is
combined with other shapes, such as circles and annuli, using boolean
operations.  In this context, it is worth noting that that there is a
difference between \fB\-PIE\fR and \fB&!PIE\fR. The former is a
global exclude of all pixels in the \fB\s-1PIE\s0\fR slice, while the latter
is a local excludes of pixels affecting only the region(s) with which
the \fB\s-1PIE\s0\fR is combined.  For example, the following region uses
\&\fB&!PIE\fR as a local exclude of a single circle. Two other circles
are also defined and are unaffected by the local exclude:
.PP
.Vb 3
\&        CIRCLE(1,8,1)
\&        CIRCLE(8,8,7)&!PIE(8,8,60,120)&!PIE(8,8,240,300)
\&        CIRCLE(15,8,2)
.Ve
.PP
.Vb 17
\&          1 2 3 4 5 6 7 8 9 0 1 2 3 4 5
\&          - - - - - - - - - - - - - - -
\&      15: . . . . . . . . . . . . . . .
\&      14: . . . . 2 2 2 2 2 2 2 . . . .
\&      13: . . . 2 2 2 2 2 2 2 2 2 . . .
\&      12: . . 2 2 2 2 2 2 2 2 2 2 2 . .
\&      11: . . 2 2 2 2 2 2 2 2 2 2 2 . .
\&      10: . . . . 2 2 2 2 2 2 2 . . . .
\&       9: . . . . . . 2 2 2 . . . . 3 3
\&       8: 1 . . . . . . . . . . . . 3 3
\&       7: . . . . . . 2 2 2 . . . . 3 3
\&       6: . . . . 2 2 2 2 2 2 2 . . . .
\&       5: . . 2 2 2 2 2 2 2 2 2 2 2 . .
\&       4: . . 2 2 2 2 2 2 2 2 2 2 2 . .
\&       3: . . . 2 2 2 2 2 2 2 2 2 . . .
\&       2: . . . . 2 2 2 2 2 2 2 . . . .
\&       1: . . . . . . . . . . . . . . .
.Ve
.PP
Note that the two other regions are not affected by the \fB&!PIE\fR,
which only affects the circle with which it is combined.
.PP
On the other hand, a \fB\-PIE\fR is an global exclude that does
affect other regions with which it overlaps:
.PP
.Vb 5
\&        CIRCLE(1,8,1)
\&        CIRCLE(8,8,7)
\&        -PIE(8,8,60,120)
\&        -PIE(8,8,240,300)
\&        CIRCLE(15,8,2)
.Ve
.PP
.Vb 17
\&          1 2 3 4 5 6 7 8 9 0 1 2 3 4 5
\&          - - - - - - - - - - - - - - -
\&      15: . . . . . . . . . . . . . . .
\&      14: . . . . 2 2 2 2 2 2 2 . . . .
\&      13: . . . 2 2 2 2 2 2 2 2 2 . . .
\&      12: . . 2 2 2 2 2 2 2 2 2 2 2 . .
\&      11: . . 2 2 2 2 2 2 2 2 2 2 2 . .
\&      10: . . . . 2 2 2 2 2 2 2 . . . .
\&       9: . . . . . . 2 2 2 . . . . . .
\&       8: . . . . . . . . . . . . . . .
\&       7: . . . . . . 2 2 2 . . . . . .
\&       6: . . . . 2 2 2 2 2 2 2 . . . .
\&       5: . . 2 2 2 2 2 2 2 2 2 2 2 . .
\&       4: . . 2 2 2 2 2 2 2 2 2 2 2 . .
\&       3: . . . 2 2 2 2 2 2 2 2 2 . . .
\&       2: . . . . 2 2 2 2 2 2 2 . . . .
\&       1: . . . . . . . . . . . . . . .
.Ve
.PP
The two smaller circles are entirely contained within the two exclude
\&\fB\s-1PIE\s0\fR slices and therefore are excluded from the region.
.SH "SEE ALSO"
.IX Header "SEE ALSO"
See funtools(n) for a list of Funtools help pages
