#! /bin/ksh

fn="access_log"
log="/tmp/foo.log"

HTTPInit () {
  print "... processing $1"
  zcat -f /proj/webhead/www/logs/$1 | grep "download/ds9" | egrep "(\.gz)|(\.dmg)|(\.exe)" >> $log
}

HTTPUniq () {
  print `cat $log | egrep "$1" | awk '{print $1}' | sort | uniq | wc | awk '{print $1}'`
}

HTTPTotal () {
  print `cat $log | egrep "$1" | wc | awk '{print $1}'`
}

if [ "$1" = "-help" ]
then
    print "Usage: count.sh [mmm] [yyyy]"
    exit
fi

if [ "$1" = "" ]
then
    month=`date +%b`
else
    month="$1"
fi

if [ "$2" = "" ]
then
    year=`date +%Y`
else
    year="$2"
fi

# for http
yr="$year"

case "$month" in
"Jan")
    mm=01;;
"Feb")
    mm=02;;
"Mar")
    mm=03;;
"Apr")
    mm=04;;
"May")
    mm=05;;
"Jun")
    mm=06;;
"Jul")
    mm=07;;
"Aug")
    mm=08;;
"Sep")
    mm=09;;
"Oct")
    mm=10;;
"Nov")
    mm=11;;
"Dec")
    mm=12;;
esac

ff=$fn
if [ "$1" != "" ]
then
    ff=old/$fn.$yr-$mm-*
fi
rm -f $log
HTTPInit $ff

ii=1
while [ "$ii" -le 11 ]
do
  mm=`expr $mm - 1`
  if [ "$mm" -eq 0 ]
  then
      mm=12
      yr=`expr $year - 1`
  fi
  if [ "$mm" -lt 10 ]
  then
      mm=0$mm
  fi
  ff=old/$fn.$yr-$mm-*
  HTTPInit $ff
  ii=`expr $ii + 1`
done

print "Unique Downloads for year ending with $month $year"

print
http=`HTTPUniq "/ds9\..*\."`
print "IP Addresses\t\t$http"

print
http=`HTTPUniq "/ds9/solaris.*/ds9\."`
print "Solaris\t\t\t$http"

http=`HTTPUniq "/ds9/linux.*/ds9\."`
print "Linux\t\t\t$http"

http=`HTTPUniq "/ds9/macosx.*/SAOImage.*\.dmg"`
http2=`HTTPUniq "/ds9/darwin.*/ds9\."`
print "MacOSX\t\t\t`expr $http + $http2`"

http=`HTTPUniq "/ds9/windows/SAOImage.*\.exe"`
http2=`HTTPUniq "/ds9/windows/ds9\."`
print "Windows\t\t\t`expr $http + $http2`"

print
http=`HTTPUniq "/ds9/solaris/ds9\."`
print "Solaris\t\t\t$http"

http=`HTTPUniq "/ds9/linux/ds9\."`
print "Linux\t\t\t$http"

http=`HTTPUniq "/ds9/linux64/ds9\."`
print "Linux64\t\t\t$http"

http=`HTTPUniq "/ds9/macosxsnowleopard/SAOImage.*\.dmg"`
print "MacOSX Aqua 10.6\t$http"

http=`HTTPUniq "/ds9/macosxleopard/SAOImage.*\.dmg"`
print "MacOSX Aqua 10.5\t$http"

http=`HTTPUniq "/ds9/macosxtiger/SAOImage.*\.dmg"`
print "MacOSX Aqua 10.4\t$http"

http=`HTTPUniq "/ds9/darwinsnowleopard/ds9\."`
print "MacOSX X11 10.6\t\t$http"

http=`HTTPUniq "/ds9/darwinleopard/ds9\."`
print "MacOSX X11 10.5\t\t$http"

http=`HTTPUniq "/ds9/darwintiger/ds9\."`
print "MacOSX X11 10.4\t\t$http"

http=`HTTPUniq "/ds9/windows/SAOImage.*\.exe"`
http2=`HTTPUniq "/ds9/windows/ds9\."`
print "Windows\t\t\t`expr $http + $http2`"

print
http=`HTTPUniq "/ds9/source/ds9\."`
print "Source\t\t\t$http"

http=`HTTPUniq "/ds9/python/pyds9*"`
print "PyDS9\t\t\t$http"

print
http=`HTTPTotal "/ds9\..*\."`
print "Total Downloads\t\t$http"


