#include <iostream.h>
#include <fstream.h>
#include <strstream.h>
#include <float.h>

#include "mmap.h"

int main(int argc, char* argv[])
{
  if (argc != 5) {
    cerr << "Usage: tres <input> <output> <value> [nan|inf]" << endl;
    return 1;
  }

  FitsFitsMMap* fits = new FitsFitsMMap(argv[1], FitsFile::EXACT);
  if (!fits && !fits->isValid()) {
    cerr << "unable to open input " << argv[1] << endl;
    return 1;
  }

  ofstream out(argv[2]);

  FitsHead* head = fits->head();
  if (!head->isValid()) {
    cerr << "bad input fits header" << endl;
    return 1;
  }

  if (head->bitpix() != -32) {
    cerr << "only bitpix = -32 can be used" << endl;
    return 1;
  }

  float thres;
  istrstream tstr(argv[3]);
  tstr >> thres;

  cerr << "Threshold : " << thres << endl;

  union {
    float blank;
    unsigned char b[4];
  } bb;

  if (!strcmp(argv[4],"nan")) {
    bb.b[0] = 0x7F;
    bb.b[1] = 0x80;
    bb.b[2] = 0x01;
    bb.b[3] = 0x01;
  }
  else if (!strcmp(argv[4], "inf")) {
    bb.b[0] = 0xFF;
    bb.b[1] = 0x80;
    bb.b[2] = 0x01;
    bb.b[3] = 0x01;
  }
  else {
    cerr << "nan or inf only" << endl;
    return 1;
  }

  // primary header
  out.write(head->cards(), head->headbytes());

  // data
  float* data = (float*)fits->data();
  int width = head->naxis(1);
  int height = head->naxis(2);

  for (int y=0; y<height; y++)
    for (int x=0; x<width; x++) {
      float v = data[y*width + x];
      if (v <= thres)
	out.write(&bb.blank,4);
      else
	out.write(&v,4);
    }

  // we may need to add a buffer to round out to block size
  int diff = head->databytes() - head->realbytes();
  if (diff>0) {
    char* buf = new char[diff];
    memset(buf,'\0',diff);
    out.write(buf, diff);
    delete buf;
  }

  out.flush();
}
