// gcc -g -o bigfits -I $HOME/include -L$HOME/lib bigfits.c -lfuntools
// gcc -g -o bigfits -I $HOME/include -L$HOME/lib bigfits.c -lfuntools -lm -lsocket -ldl -lnsl

#include <iostream>
#include <sstream>
#include <iomanip>
using namespace std;

#include <stdio.h>
#include <limits.h>
#include <math.h>
 
#define FTY_BLOCK 2880
#define FTY_CARDLEN 80

int lsb()
{
  return (*(short *)"\001\000" & 0x0001);
}

void swap2(char* src, char* dest) {
  *(dest  ) = *(src+1);
  *(dest+1) = *(src  );
}

void swap4(char* src, char* dest) {
  *(dest  ) = *(src+3);
  *(dest+1) = *(src+2);
  *(dest+2) = *(src+1);
  *(dest+3) = *(src  );
}

void swap8(char* src, char* dest) {
  *(dest  ) = *(src+7);
  *(dest+1) = *(src+6);
  *(dest+2) = *(src+5);
  *(dest+3) = *(src+4);
  *(dest+4) = *(src+3);
  *(dest+5) = *(src+2);
  *(dest+6) = *(src+1);
  *(dest+7) = *(src  );
}

int main(int argc, char **argv)
{
  if(argc<6){
    cerr << "usage: " << argv[0] << " outfile width height depth bitpix [bscale bzero] [blank|inf|-nan]" << endl;
    exit(1);
  }

  FILE* out = fopen(argv[1],"w");
  int ww = atoi(argv[2]);
  int hh = atoi(argv[3]);
  int dd = atoi(argv[4]);
  int bitpix = atoi(argv[5]);
  float bscale = 1;
  float bzero = 0;
  float blank = 0;

  if (argc>6) {
    bscale = atof(argv[6]);
    bzero = atof(argv[7]);
  }
  if (argc>8)
    blank = atof(argv[8]);

  int ss = abs(bitpix)/8;
  char row[ww*ss];
  char buf[FTY_BLOCK];

  // header
  memset(buf,' ',FTY_BLOCK);

  char* hdu =buf;
  memcpy(hdu,"SIMPLE  = ",10);
  memcpy(hdu+32-3,"T /",3);
  hdu += FTY_CARDLEN;

  // bitpix
  {
    memcpy(hdu,"BITPIX  = ",10);
    ostringstream str;
    str << bitpix << " /" << ends;
    const char* ptr = str.str().c_str();
    int ll = strlen(ptr);
    memcpy(hdu+32-ll, ptr, ll);
    hdu += FTY_CARDLEN;
  }

  // NAXIS
  memcpy(hdu,"NAXIS   = ",10);
  if (dd == 1)
    memcpy(hdu+32-3,"2 /",3);
  else
    memcpy(hdu+32-3,"3 /",3);
  hdu += FTY_CARDLEN;

  // NAXIS1
  {
    memcpy(hdu,"NAXIS1  = ",10);
    ostringstream str;
    str << ww << " /" << ends;
    const char* ptr = str.str().c_str();
    int ll = strlen(ptr);
    memcpy(hdu+32-ll, ptr, ll);
    hdu += FTY_CARDLEN;
  }

  // NAXIS2
  {
    memcpy(hdu,"NAXIS2  = ",10);
    ostringstream str;
    str << hh << " /" << ends;
    const char* ptr = str.str().c_str();
    int ll = strlen(ptr);
    memcpy(hdu+32-ll, ptr, ll);
    hdu += FTY_CARDLEN;
  }

  // NAXIS3
  if (dd != 1) {
    memcpy(hdu,"NAXIS3  = ",10);
    ostringstream str;
    str << dd << " /" << ends;
    const char* ptr = str.str().c_str();
    int ll = strlen(ptr);
    memcpy(hdu+32-ll, ptr, ll);
    hdu += FTY_CARDLEN;
  }

  // BSCALE/BZERO
  if (bscale != 1) {
    memcpy(hdu,"BSCALE  = ",10);
    ostringstream str;
    str << bscale << " /" << ends;
    const char* ptr = str.str().c_str();
    int ll = strlen(ptr);
    memcpy(hdu+32-ll, ptr, ll);
    hdu += FTY_CARDLEN;
  }

  if (bzero != 0) {
    memcpy(hdu,"BZERO   = ",10);
    ostringstream str;
    str << bzero << " /" << ends;
    const char* ptr = str.str().c_str();
    int ll = strlen(ptr);
    memcpy(hdu+32-ll, ptr, ll);
    hdu += FTY_CARDLEN;
  }

  // BLANK
  if (blank && bitpix>0) {
    memcpy(hdu,"BLANK   = ",10);
    ostringstream str;
    str << blank << " /" << ends;
    const char* ptr = str.str().c_str();
    int ll = strlen(ptr);
    memcpy(hdu+32-ll, ptr, ll);
    hdu += FTY_CARDLEN;
  }

  // end
  memcpy(hdu,"END",3);

  fwrite(buf,FTY_BLOCK,1,out);

  // data
  switch (bitpix) {
  case 8:
    for (int kk=0; kk<dd; kk++) {
      for (int jj=0; jj<hh; jj++) {
	for (int ii=0; ii<ww; ii++) {
	  unsigned char vv = kk+jj+ii;
	  memcpy(row+ii,&vv,1);
	}

	fwrite(row,ww,1,out);
      }
    }
    break;
  case 16:
    for (int kk=0; kk<dd; kk++) {
      for (int jj=0; jj<hh; jj++) {
	for (int ii=0; ii<ww; ii++) {
	  short vv = kk+jj+ii;

	  if (lsb())
	    swap2((char*)&vv, row+(ii*ss));
	  else
	    memcpy(row+(ii*ss),(char*)&vv,ss);
	}

	fwrite(row,ww,ss,out);
      }
    }
    break;
  case 32:
    for (int kk=0; kk<dd; kk++) {
      for (int jj=0; jj<hh; jj++) {
	for (int ii=0; ii<ww; ii++) {
	  int vv = kk+jj+ii;

	  if (lsb())
	    swap4((char*)&vv, row+(ii*ss));
	  else
	    memcpy(row+(ii*ss),(char*)&vv,ss);
	}

	fwrite(row,ww,ss,out);
      }
    }
    break;
  case -32:
    for (int kk=0; kk<dd; kk++) {
      for (int jj=0; jj<hh; jj++) {
	for (int ii=0; ii<ww; ii++) {
	  float vv = kk+jj+ii;
	  if (blank && fabs(blank) == vv) {
	    if (blank>0)
	      vv = INFINITY;
	    else
	      vv = NAN;
	  }
	  if (lsb())
	    swap4((char*)&vv, row+(ii*ss));
	  else
	    memcpy(row+(ii*ss),(char*)&vv,ss);
	}

	fwrite(row,ww,ss,out);
      }
    }
    break;
  case 64:
    for (int kk=0; kk<dd; kk++) {
      for (int jj=0; jj<hh; jj++) {
	for (int ii=0; ii<ww; ii++) {
	  long long vv = kk+jj+ii;

	  if (lsb())
	    swap8((char*)&vv, row+(ii*ss));
	  else
	    memcpy(row+(ii*ss),(char*)&vv,ss);
	}

	fwrite(row,ww,ss,out);
      }
    }
    break;
  case -64:
    for (int kk=0; kk<dd; kk++) {
      for (int jj=0; jj<hh; jj++) {
	for (int ii=0; ii<ww; ii++) {
	  double vv = kk+jj+ii;
	  if (blank && fabs(blank) == vv) {
	    if (blank>0)
	      vv = INFINITY;
	    else
	      vv = NAN;
	  }

	  if (lsb())
	    swap8((char*)&vv, row+(ii*ss));
	  else
	    memcpy(row+(ii*ss),(char*)&vv,ss);
	}

	fwrite(row,ww,ss,out);
      }
    }
    break;
  }

  //	float vv = random();
  //      float exp = 1000;
  // linear
  //      float vv = ii;
  // log
  //      float vv = log10(exp*float(ii)/ww +1) / log10(exp);
  // pow
  //      float vv = (::pow(exp,float(ii)/ww) -1) / exp;
  // squared
  //      float vv = ii*ii;
  // sqrt
  //      float vv = sqrt(ii);
  // asinh
  //      float vv = asinh(10*float(ii)/ww)/3;
  // sinh
  //      float vv = sinh(3*float(ii)/ww)/10;

  // write any padding
  memset(buf,0,FTY_BLOCK);
  int npad = FTY_BLOCK - ((long(ww)*hh*dd*ss) % FTY_BLOCK);
  if (npad == FTY_BLOCK)
    npad = 0;
  if( npad > 0 )
    fwrite(buf, npad, 1, out);

  // done
  fclose(out);
}
