#! /bin/ksh

HTTPInit () {
    zcat -f /var/log/httpd/access_log* | grep "$month/$year" | egrep "(download)|(archive)" | egrep "(\.gz)|(\.dmg)|(\.exe)" > /tmp/foo.log
}

HTTPUniq () {
    print `cat /tmp/foo.log | egrep "$1" | awk '{print $1}' | sort | uniq | wc | awk '{print $1}'`
}

HTTPTotal () {
    print `cat /tmp/foo.log | wc | awk '{print $1}'`
}

if [ "$1" = "-help" ]
then
    print "Usage: count.sh [mmm] [yyyy]"
    exit
fi

if [ "$1" = "" ]
then
    month=`date +%b`
else
    month="$1"
fi

if [ "$2" = "" ]
then
    year=`date +%Y`
else
    year="$2"
fi

HTTPInit

print "Unique Downloads for $month $year"

print
http=`HTTPUniq "*"`
print "IP Addresses\t\t$http"

print
http=`HTTPUniq "solaris.*/ds9\."`
print "Solaris\t\t\t$http"

http=`HTTPUniq "linux.*/ds9\."`
print "Linux\t\t\t$http"

http=`HTTPUniq "macosx.*/SAOImage.*\.dmg"`
http2=`HTTPUniq "darwin.*/ds9\."`
print "MacOSX\t\t\t`expr $http + $http2`"

http=`HTTPUniq "windows/SAOImage.*\.exe"`
http2=`HTTPUniq "cygwin.*/ds9\."`
print "Windows\t\t\t`expr $http + $http2`"

print
http=`HTTPUniq "solaris.*/ds9\."`
print "Solaris\t\t\t$http"

http=`HTTPUniq "linux/ds9\."`
print "Linux\t\t\t$http"

http=`HTTPUniq "linux64/ds9\."`
print "Linux64\t\t\t$http"

http=`HTTPUniq "linux64_5/ds9\."`
print "Linux64_5\t\t$http"

http=`HTTPUniq "macosxelcapitan/SAOImage.*\.dmg"`
print "MacOSX Aqua 10.11\t$http"

http=`HTTPUniq "macosxyosemite/SAOImage.*\.dmg"`
print "MacOSX Aqua 10.10\t$http"

http=`HTTPUniq "macosxmavericks/SAOImage.*\.dmg"`
print "MacOSX Aqua 10.9\t$http"

http=`HTTPUniq "macosxmountainlion/SAOImage.*\.dmg"`
print "MacOSX Aqua 10.8\t$http"

http=`HTTPUniq "macosxlion/SAOImage.*\.dmg"`
print "MacOSX Aqua 10.7\t$http"

http=`HTTPUniq "macosxsnowleopard/SAOImage.*\.dmg"`
print "MacOSX Aqua 10.6\t$http"

http=`HTTPUniq "macosxleopard/SAOImage.*\.dmg"`
print "MacOSX Aqua 10.5\t$http"

http=`HTTPUniq "macosxtiger/SAOImage.*\.dmg"`
print "MacOSX Aqua 10.4\t$http"

http=`HTTPUniq "darwinelcapitan/ds9\."`
print "MacOSX X11 10.11\t$http"

http=`HTTPUniq "darwinyosemite/ds9\."`
print "MacOSX X11 10.10\t$http"

http=`HTTPUniq "darwinmavericks/ds9\."`
print "MacOSX X11 10.9\t\t$http"

http=`HTTPUniq "darwinmountainlion/ds9\."`
print "MacOSX X11 10.8\t\t$http"

http=`HTTPUniq "darwinlion/ds9\."`
print "MacOSX X11 10.7\t\t$http"

http=`HTTPUniq "darwinsnowleopard/ds9\."`
print "MacOSX X11 10.6\t\t$http"

http=`HTTPUniq "darwinleopard/ds9\."`
print "MacOSX X11 10.5\t\t$http"

http=`HTTPUniq "darwintiger/ds9\."`
print "MacOSX X11 10.4\t\t$http"

http=`HTTPUniq "windows/SAOImage.*\.exe"`
http2=`HTTPUniq "windows/ds9\."`
print "Windows\t\t\t`expr $http + $http2`"

http=`HTTPUniq "cygwin/ds9\."`
print "Cygwin\t\t\t$http"

http=`HTTPUniq "cygwin64/ds9\."`
print "Cygwin64\t\t$http"

print
http=`HTTPUniq "source/ds9\."`
print "Source\t\t\t$http"

http=`HTTPUniq "pyds9/pyds9*"`
print "PyDS9\t\t\t$http"

print
http=`HTTPTotal`
print "Total Downloads\t\t$http"


