// Copyright (C) 1999-2014
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#include <iostream>
#include <sstream>
#include <iomanip>
using namespace std;

#include "tk.h"
#include "tkWinInt.h"

extern "C" {
  void XXWarpPointer(Display* display, Window src_w, Window dest_w,
		     int src_x, int src_y,
		     unsigned int src_width, unsigned int src_height,
		     int dest_x, int dest_y)
  {
    if (dest_w != None)
      // move to absolute location
      XWarpPointer(display, src_w, dest_w, src_x, src_y, src_width, src_height,
		   dest_x, dest_y);
    else {
      // move to relative location
      POINT p;
      GetCursorPos(&p);
      SetCursorPos(p.x+dest_x, p.y+dest_y);
    }
  }

  Bool XXQueryPointer(Display* display, Window w, 
		      Window* root_return, Window* child_return, 
		      int* root_x_return, int* root_y_return, 
		      int* win_x_return, int* win_y_return, 
		      unsigned int* mask_return)
  {
    XQueryPointer(display, w, root_return, child_return, 
		  root_x_return, root_y_return, 
		  win_x_return, win_y_return, mask_return);
    *root_return = w;
    *child_return = w;
    *win_x_return = *root_x_return;
    *win_y_return = *root_y_return;
  }

  void XPutImage(Display* display, Drawable d, GC gc, XImage* image,
		 int src_x, int src_y, int dest_x, int dest_y,
		 unsigned int width, unsigned int height)
  {
    TkPutImage(NULL, 0, display, d, gc, image, src_x, src_y,
	       dest_x, dest_y, width, height);
  }
}
