// Copyright (C) 1999-2014
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#include <iostream>
#include <sstream>
#include <iomanip>
using namespace std;

#include <tkMacOSXPrivate.h>

#include <tk.h>
#include <tkInt.h>
#include <X11/Xlib.h>

extern "C" {
  void XPutImage(Display* display, Drawable d, GC gc, XImage* image,
		 int src_x, int src_y, int dest_x, int dest_y,
		 unsigned int width, unsigned int height)
  {
    TkPutImage(NULL, 0, display, d, gc, image, src_x, src_y,
	       dest_x, dest_y, width, height);
  }

  // Redefined Routines

  void XXWarpPointer(Display* display, Window src_w, Window dest_w,
		     int src_x, int src_y,
		     unsigned int src_width, unsigned int src_height,
		     int dest_x, int dest_y)
  {
    // only act upon relative moves
    if (!dest_w) {
      int xx, yy;
      XQueryPointer(display, dest_w, NULL, NULL, &xx, &yy, NULL, NULL, NULL);

      CGPoint pt;
      pt.x = xx+dest_x;
      pt.y = yy+dest_y;

      CGEventSourceRef src = CGEventSourceCreate(kCGEventSourceStateCombinedSessionState);
      CGEventRef ev = CGEventCreateMouseEvent(src,kCGEventMouseMoved,pt,kCGMouseButtonLeft);
      CGEventPost(kCGSessionEventTap,ev);
      CFRelease(ev);
      CFRelease(src);
    }
  }
}
