.\" Automatically generated by Pod::Man v1.37, Pod::Parser v1.32
.\"
.\" Standard preamble:
.\" ========================================================================
.de Sh \" Subsection heading
.br
.if t .Sp
.ne 5
.PP
\fB\\$1\fR
.PP
..
.de Sp \" Vertical space (when we can't use .PP)
.if t .sp .5v
.if n .sp
..
.de Vb \" Begin verbatim text
.ft CW
.nf
.ne \\$1
..
.de Ve \" End verbatim text
.ft R
.fi
..
.\" Set up some character translations and predefined strings.  \*(-- will
.\" give an unbreakable dash, \*(PI will give pi, \*(L" will give a left
.\" double quote, and \*(R" will give a right double quote.  | will give a
.\" real vertical bar.  \*(C+ will give a nicer C++.  Capital omega is used to
.\" do unbreakable dashes and therefore won't be available.  \*(C` and \*(C'
.\" expand to `' in nroff, nothing in troff, for use with C<>.
.tr \(*W-|\(bv\*(Tr
.ds C+ C\v'-.1v'\h'-1p'\s-2+\h'-1p'+\s0\v'.1v'\h'-1p'
.ie n \{\
.    ds -- \(*W-
.    ds PI pi
.    if (\n(.H=4u)&(1m=24u) .ds -- \(*W\h'-12u'\(*W\h'-12u'-\" diablo 10 pitch
.    if (\n(.H=4u)&(1m=20u) .ds -- \(*W\h'-12u'\(*W\h'-8u'-\"  diablo 12 pitch
.    ds L" ""
.    ds R" ""
.    ds C` ""
.    ds C' ""
'br\}
.el\{\
.    ds -- \|\(em\|
.    ds PI \(*p
.    ds L" ``
.    ds R" ''
'br\}
.\"
.\" If the F register is turned on, we'll generate index entries on stderr for
.\" titles (.TH), headers (.SH), subsections (.Sh), items (.Ip), and index
.\" entries marked with X<> in POD.  Of course, you'll have to process the
.\" output yourself in some meaningful fashion.
.if \nF \{\
.    de IX
.    tm Index:\\$1\t\\n%\t"\\$2"
..
.    nr % 0
.    rr F
.\}
.\"
.\" For nroff, turn off justification.  Always turn off hyphenation; it makes
.\" way too many mistakes in technical documents.
.hy 0
.if n .na
.\"
.\" Accent mark definitions (@(#)ms.acc 1.5 88/02/08 SMI; from UCB 4.2).
.\" Fear.  Run.  Save yourself.  No user-serviceable parts.
.    \" fudge factors for nroff and troff
.if n \{\
.    ds #H 0
.    ds #V .8m
.    ds #F .3m
.    ds #[ \f1
.    ds #] \fP
.\}
.if t \{\
.    ds #H ((1u-(\\\\n(.fu%2u))*.13m)
.    ds #V .6m
.    ds #F 0
.    ds #[ \&
.    ds #] \&
.\}
.    \" simple accents for nroff and troff
.if n \{\
.    ds ' \&
.    ds ` \&
.    ds ^ \&
.    ds , \&
.    ds ~ ~
.    ds /
.\}
.if t \{\
.    ds ' \\k:\h'-(\\n(.wu*8/10-\*(#H)'\'\h"|\\n:u"
.    ds ` \\k:\h'-(\\n(.wu*8/10-\*(#H)'\`\h'|\\n:u'
.    ds ^ \\k:\h'-(\\n(.wu*10/11-\*(#H)'^\h'|\\n:u'
.    ds , \\k:\h'-(\\n(.wu*8/10)',\h'|\\n:u'
.    ds ~ \\k:\h'-(\\n(.wu-\*(#H-.1m)'~\h'|\\n:u'
.    ds / \\k:\h'-(\\n(.wu*8/10-\*(#H)'\z\(sl\h'|\\n:u'
.\}
.    \" troff and (daisy-wheel) nroff accents
.ds : \\k:\h'-(\\n(.wu*8/10-\*(#H+.1m+\*(#F)'\v'-\*(#V'\z.\h'.2m+\*(#F'.\h'|\\n:u'\v'\*(#V'
.ds 8 \h'\*(#H'\(*b\h'-\*(#H'
.ds o \\k:\h'-(\\n(.wu+\w'\(de'u-\*(#H)/2u'\v'-.3n'\*(#[\z\(de\v'.3n'\h'|\\n:u'\*(#]
.ds d- \h'\*(#H'\(pd\h'-\w'~'u'\v'-.25m'\f2\(hy\fP\v'.25m'\h'-\*(#H'
.ds D- D\\k:\h'-\w'D'u'\v'-.11m'\z\(hy\v'.11m'\h'|\\n:u'
.ds th \*(#[\v'.3m'\s+1I\s-1\v'-.3m'\h'-(\w'I'u*2/3)'\s-1o\s+1\*(#]
.ds Th \*(#[\s+2I\s-2\h'-\w'I'u*3/5'\v'-.3m'o\v'.3m'\*(#]
.ds ae a\h'-(\w'a'u*4/10)'e
.ds Ae A\h'-(\w'A'u*4/10)'E
.    \" corrections for vroff
.if v .ds ~ \\k:\h'-(\\n(.wu*9/10-\*(#H)'\s-2\u~\d\s+2\h'|\\n:u'
.if v .ds ^ \\k:\h'-(\\n(.wu*10/11-\*(#H)'\v'-.4m'^\v'.4m'\h'|\\n:u'
.    \" for low resolution devices (crt and lpr)
.if \n(.H>23 .if \n(.V>19 \
\{\
.    ds : e
.    ds 8 ss
.    ds o a
.    ds d- d\h'-1'\(ga
.    ds D- D\h'-1'\(hy
.    ds th \o'bp'
.    ds Th \o'LP'
.    ds ae ae
.    ds Ae AE
.\}
.rm #[ #] #H #V #F C
.\" ========================================================================
.\"
.IX Title "funregions n"
.TH funregions n "April 14, 2011" "version 1.4.5" "SAORD Documentation"
.SH "NAME"
\&\fBRegions: Spatial Region Filtering\fR
.SH "SYNOPSIS"
.IX Header "SYNOPSIS"
This document contains a summary of the user interface for spatial
region filtering images and tables.
.SH "DESCRIPTION"
.IX Header "DESCRIPTION"
Spatial region filtering allows a program to select regions of an
image or rows of a table (e.g., X\-ray events) to process using
simple geometric shapes and boolean combinations of shapes.  When an
image is filtered, only pixels found within these shapes are
processed. When a table is filtered, only rows found within these
shapes are processed.
.PP
Spatial region filtering for images and tables is accomplished by
means of \fBregion specifications\fR.  A region specification
consists of one or more \fBregion expressions\fR, which are geometric
shapes,combined according to the rules of boolean algebra.  Region
specifications also can contain comments and local/global processing
directives.
.PP
Typically, region specifications are specified using bracket notation
appended to the filename of the data being processed:
.PP
.Vb 1
\&  foo.fits[circle(512,512,100)]
.Ve
.PP
It is also possible to put region specification inside a file and
then pass the filename in bracket notation:
.PP
.Vb 1
\&  foo.fits[@my.reg]
.Ve
.PP
When region filters are passed in bracket notation in this manner, the
filtering is set up automatically when the file is opened and all
processing occurs through the filter. Programs also can use the filter
library \s-1API\s0 to open filters explicitly.
.PP
\&\fBRegion Expressions\fR
.PP
More specifically, region specifications consist of one or more lines
containing:
.PP
.Vb 9
\&  # comment until end of line
\&  global   keyword=value keyword=value  ... # set global value(s)
\&  # include the following file in the region descriptor
\&  @file
\&  # use the FITS image as a mask (cannot be used with other regions)
\&  @fitsimage
\&  # each region expression contains shapes separated by operators
\&  [region_expression1], [region_expression2], ...
\&  [region_expression], [region_expression], ...
.Ve
.PP
A single region expression consists of:
.PP
.Vb 2
\&  # parens and commas are optional, as is the + sign
\&  [+-]shape(num , num , ...) OP1 shape num num num OP2 shape ...
.Ve
.PP
e.g.:
.PP
.Vb 3
\&  ([+-]shape(num , num , ...) && shape num  num || shape(num, num)
\&  # a comment can come after a region -- reserved for local properties
\&  [+-]shape(num , num , ...)  # local properties go here, e.g. color=red
.Ve
.PP
Thus, a region descriptor consists of one or more region
expressions or \fBregions\fR, separated by comas, new\-lines, or
semi\-colons.  Each \fBregion\fR consists of one or more geometric
shapes combined using standard boolean operation.  Several types
of shapes are supported, including:
.PP
.Vb 11
\&  shape:        arguments:
\&  -----         ----------------------------------------
\&  ANNULUS       xcenter ycenter inner_radius outer_radius
\&  BOX           xcenter ycenter xwidth yheight (angle)
\&  CIRCLE        xcenter ycenter radius
\&  ELLIPSE       xcenter ycenter xwidth yheight (angle)
\&  FIELD         none
\&  LINE          x1 y1 x2 y2
\&  PIE           xcenter ycenter angle1 angle2
\&  POINT         x1 y1
\&  POLYGON       x1 y1 x2 y2 ... xn yn
.Ve
.PP
In addition, the following regions accept \fBaccelerator\fR syntax:
.PP
.Vb 13
\&  shape      arguments
\&  -----      ------------------------------------------
\&  ANNULUS    xcenter ycenter radius1 radius2 ... radiusn
\&  ANNULUS    xcenter ycenter inner_radius outer_radius n=[number]
\&  BOX        xcenter ycenter xw1 yh1 xw2 yh2 ... xwn yhn (angle)
\&  BOX        xcenter ycenter xwlo yhlo xwhi yhhi n=[number] (angle)
\&  CIRCLE     xcenter ycenter r1 r2 ... rn              # same as annulus
\&  CIRCLE     xcenter ycenter rinner router n=[number]  # same as annulus
\&  ELLIPSE    xcenter ycenter xw1 yh1 xw2 yh2 ... xwn yhn (angle)
\&  ELLIPSE    xcenter ycenter xwlo yhlo xwhi yhhi n=[number] (angle)
\&  PIE        xcenter ycenter angle1 angle2 (angle3) (angle4) (angle5) ...
\&  PIE        xcenter ycenter angle1 angle2 (n=[number])
\&  POINT      x1 y1 x2 y2 ... xn yn
.Ve
.PP
Note that the circle accelerators are simply aliases for the annulus
accelerators.  See region geometry
for more information about accelerators.
.PP
Finally, the following are combinations of pie with different shapes
(called \*(L"panda\*(R" for \*(L"Pie \s-1AND\s0 Annulus\*(R") allow for easy specification of
radial sections:
.PP
.Vb 6
\&  shape:  arguments:
\&  -----   ---------
\&  PANDA   xcen ycen ang1 ang2 nang irad orad nrad   # circular
\&  CPANDA  xcen ycen ang1 ang2 nang irad orad nrad   # circular
\&  BPANDA  xcen ycen ang1 ang2 nang xwlo yhlo xwhi yhhi nrad (ang) # box
\&  EPANDA  xcen ycen ang1 ang2 nang xwlo yhlo xwhi yhhi nrad (ang) # ellipse
.Ve
.PP
The panda and cpanda specify combinations of annulus and circle with pie,
respectively and give identical results. The bpanda combines box and pie,
while epanda combines ellipse and pie.
See region geometry
for more information about pandas.
.PP
The following \*(L"shapes\*(R" are ignored by funtools (generated by ds9):
.PP
.Vb 8
\&  shape:        arguments:
\&  -----         ---------
\&  PROJECTION    x1 y1 x2 y2 width    # NB: ignored by funtools
\&  RULER         x1 y1 x2 y2          # NB: ignored by funtools
\&  TEXT          x y                  # NB: ignored by funtools
\&  GRID                               # NB: ignored by funtools
\&  TILE                               # NB: ignored by funtools
\&  COMPASS                            # NB: ignored by funtools
.Ve
.PP
All arguments to regions are real values; integer values are
automatically converted to real where necessary.  All angles are in
degrees and run from the positive image x\-axis to the positive image
y\-axis. If a rotation angle is part of the associated \s-1WCS\s0 header, that
angle is added implicitly as well.
.PP
Note that 3\-letter abbreviations are supported for all shapes, so that
you can specify \*(L"circle\*(R" or \*(L"cir\*(R".
.PP
\&\fBColumns Used in Region Filtering\fR
.PP
By default, the x,y values in a region expression refer to the two
\&\*(L"image binning\*(R" columns, i.e. the columns that would be used to
bin the data into an image. For images, these are just the 2 dimensions
of the image. For tables, these usually default to x and y but
can be changed as required. For example, in Funtools, new binning
columns are specified using a bincols=(col1,col2) statement within
the bracket string on the command line.
.PP
Alternate columns for region filtering can be specified by the syntax:
.PP
.Vb 1
\&  (col1,col2)=region(...)
.Ve
.PP
e.g.:
.PP
.Vb 3
\&  (X,Y)=annulus(x,y,ri,ro)
\&  (PHA,PI)=circle(x,y,r)
\&  (DX,DY)=ellipse(x,y,a,b[,angle])
.Ve
.PP
\&\fBRegion Algebra\fR
.PP
(See also Region Algebra for more complete
information.)
.PP
Region shapes can be combined together using Boolean operators:
.PP
.Vb 6
\&  Symbol        Operation       Use
\&  --------      ---------       -----------------------------------
\&  !             not             Exclude this shape from this region
\&  & or &&       and             Include only the overlap of these shapes
\&  | or ||       inclusive or    Include all of both shapes
\&  ^             exclusive or    Include both shapes except their overlap
.Ve
.PP
Note that the !region syntax must be combined with another region in order
that we be able to assign a region id properly. That is,
.PP
.Vb 1
\&  !circle(512,512,10)
.Ve
.PP
is not a legal region because there is no valid region id to work with.
To get the full field without a circle, combine the above with \fIfield()\fR,
as in:
.PP
.Vb 1
\&  field() && !circle(512,512,10)
.Ve
.PP
\&\fB Region Separators Also Are Operators\fR
.PP
As mentioned previously, multiple region expressions can be specified
in a region descriptor, separated by commas, new\-lines, or
semi\-colons.  When such a separator is used, the boolean \s-1OR\s0 operator
is automatically generated in its place but, unlike explicit use of
the \s-1OR\s0 operator, the region \s-1ID\s0 is incremented (starting from 1).
.PP
For example, the two shapes specified in this example are given the
same region value:
.PP
.Vb 1
\&  foo.fits[circle(512,512,10)||circle(400,400,20)]
.Ve
.PP
On the other hand, the two shapes defined in the following example are
given different region values:
.PP
.Vb 1
\&  foo.fits[circle(512,512,10),circle(400,400,20)]
.Ve
.PP
Of course these two examples will both mask the same table rows or
pixels. However, in programs that distinguish region id's (such as
funcnts ), they will act
differently.  The explicit \s-1OR\s0 operator will result in one region
expression consisting of two shapes having the same region id and
funcnts will report a single region. The comma operator will cause
funcnts to report two region expressions, each with one shape, in
its output.
.PP
In general, commas are used to separate region expressions entered
in bracket notation on the command line:
.PP
.Vb 2
\&  # regions are added to the filename in bracket notation
\&  foo.fits[circle(512,512,100),circle(400,400,20)]
.Ve
.PP
New-lines are used to separate region
expressions in a file:
.PP
.Vb 4
\&  # regions usually are separated by new-lines in a file
\&  # use @filename to include this file on the command line
\&  circle(512,512,100)
\&  circle(400,400,20)
.Ve
.PP
Semi-colons are provided for backward compatibility with the original
\&\s-1IRAF/PROS\s0 implementation and can be used in either case.
.PP
If a pixel is covered by two different regions expressions, it is
given the mask value of the \fBfirst\fR region that contains that
pixel.  That is, successive regions \fBdo not\fR overwrite previous
regions in the mask, as was the case with the original \s-1PROS\s0 regions.
In this way, an individual pixel is covered by one and only one
region.  This means that one must sometimes be careful about the order
in which regions are defined.  If region N is fully contained within
region M, then N should be defined \fBbefore\fR M, or else it will be
\&\*(L"covered up\*(R" by the latter.
.PP
\&\fBRegion Exclusion\fR
.PP
Shapes also can be globally excluded from all the region specifiers in
a region descriptor by using a minus sign before a region:
.PP
.Vb 4
\&  operator      arguments:
\&  --------      -----------
\&  -             Globally exclude the region expression following '-' sign
\&                from ALL regions specified in this file
.Ve
.PP
The global exclude region can be used by itself; in such a case, \fIfield()\fR is
implied.
.PP
A global exclude differs from the local exclude (i.e. a shape prefixed
by the logical not \*(L"!\*(R" symbol) in that global excludes are logically
performed last, so that no region will contain pixels from a globally
excluded shape. A local exclude is used in a boolean expression with
an include shape, and only excludes pixels from that include shape.
Global excludes cannot be used in boolean expressions.
.PP
\&\fBInclude Files\fR
.PP
The \fB@filename\fR directive specifies an include file
containing region expressions. This file is processed as part of
the overall region descriptor:
.PP
.Vb 1
\&  foo.fits[circle(512,512,10),@foo]
.Ve
.PP
A filter include file simply includes text without changing the state
of the filter. It therefore can be used in expression. That is, if the
file foo1 contains \*(L"pi==1\*(R" and foo2 contains \*(L"pha==2\*(R" then
the following expressions are equivalent:
.PP
.Vb 3
\&  "[@foo1&&@foo2]"   is equivalent to   "[pi==1&&pha==2]"
\&  "[pha==1||@foo2]"  is equivalent to   "[pi==1||pha==2]"
\&  "[@foo1,@foo2]"    is equivalent to   "[pi==1,pha==2]"
.Ve
.PP
Be careful that you specify evaluation order properly using
parenthesis, especially if the include file contains multiple
filter statements. For example, consider a file containing two
regions such as:
.PP
.Vb 2
\&  circle 512 512 10
\&  circle 520 520 10
.Ve
.PP
If you want to include only events (or pixels) that are in these regions
and have a pi value of 4, then the correct syntax is:
.PP
.Vb 1
\&    pi==4&&(@foo)
.Ve
.PP
since this is equivalent to:
.PP
.Vb 1
\&    pi==4 && (circle 512 512 10 || circle 520 520 10)
.Ve
.PP
If you leave out the parenthesis, you are filtering this statement:
.PP
.Vb 1
\&    pi==4 && circle 512 512 10 || circle 520 520 10)
.Ve
.PP
which is equivalent to:
.PP
.Vb 1
\&    (pi==4 && circle 512 512 10) || circle 520 520 10)
.Ve
.PP
The latter syntax only applies the pi test to the first region.
.PP
For image-style filtering, the \fB@filename\fR can specify an 8\-bit
or 16\-bit \s-1FITS\s0 image. In this case, the pixel values in the mask image
are used as the region mask. The valid pixels in the mask must have
positive values.  Zero values are excluded from the mask and negative
values are not allowed.  Moreover, the region id value is taken as
the image pixel value and the total number of regions is taken to be
the highest pixel value. The dimensions of the image mask must be less
than or equal to the image dimensions of the data. The mask will be
replicated as needed to match the size of the image. (Thus, best
results are obtained when the data dimensions are an even multiple of
the mask dimensions.)
.PP
An image mask can be used in any image filtering operation, regardless
of whether the data is of type image or table. For example, the
funcnts )
program performs image filtering on images or tables, and so
\&\s-1FITS\s0 image masks are valid input for either type of data in this
program.. An image mask cannot be used in a program such as
fundisp )
when the input data is a table, because fundisp displays
rows of a table and processes these rows using event-style filtering.
.PP
\&\fBGlobal and Local Properties of Regions\fR
.PP
The ds9 image display program describes a host of properties such as
color, font, fix/free state, etc. Such properties can be specified
globally (for all regions) or locally (for an individual region).
The \fBglobal\fR keyword specifies properties and qualifiers for all
regions, while local properties are specified in comments on the same
line as the region:
.PP
.Vb 4
\&  global color=red
\&  circle(10,10,2)
\&  circle(20,20,3) # color=blue
\&  circle(30,30,4)
.Ve
.PP
The first and third circles will be red, which the second circle will
be blue.  Note that funtools currently ignores region properties, as
they are used in display only.
.PP
\&\fB Coordinate Systems\fR
.PP
For each region, it is important to specify the coordinate system
used to interpret the region, i.e., to set the context in which position and
size values are interpreted. For this purpose, the following keywords
are recognized:
.PP
.Vb 12
\&  name                  description
\&  ----                  ------------------------------------------
\&  PHYSICAL              pixel coords of original file using LTM/LTV
\&  IMAGE                 pixel coords of current file
\&  FK4, B1950            sky coordinate systems
\&  FK5, J2000            sky coordinate systems
\&  GALACTIC              sky coordinate systems
\&  ECLIPTIC              sky coordinate systems
\&  ICRS                  currently same as J2000
\&  LINEAR                linear wcs as defined in file
\&  AMPLIFIER             mosaic coords of original file using ATM/ATV
\&  DETECTOR              mosaic coords of original file using DTM/DTV
.Ve
.PP
\&\fBSpecifying Positions, Sizes, and Angles\fR
.PP
The arguments to region shapes can be floats or integers describing
positions and sizes.  They can be specified as pure numbers or using
explicit formatting directives:
.PP
.Vb 11
\&  position arguments    description
\&  ------------------    ------------------------------
\&  [num]                 context-dependent (see below)
\&  [num]d                degrees
\&  [num]r                radians
\&  [num]p                physical pixels
\&  [num]i                image pixels
\&  [num]:[num]:[num]     hms for 'odd' position arguments
\&  [num]:[num]:[num]     dms for 'even' position arguments
\&  [num]h[num]m[num]s    explicit hms
\&  [num]d[num]m[num]s    explicit dms
.Ve
.PP
.Vb 9
\&  size arguments        description
\&  --------------        -----------
\&  [num]                 context-dependent (see below)
\&  [num]"                arc seconds
\&  [num]'                arc minutes
\&  [num]d                degrees
\&  [num]r                radians
\&  [num]p                physical pixels
\&  [num]i                image pixels
.Ve
.PP
When a \*(L"pure number\*(R" (i.e. one without a format directive such as 'd'
for 'degrees') is specified, its interpretation depends on the context
defined by the 'coordsys' keyword. In general, the rule is:
.PP
All pure numbers have implied units corresponding to the current
coordinate system.
.PP
If no such system is explicitly specified, the default system is
implicitly assumed to be \s-1PHYSICAL\s0.
.PP
In practice this means that for \s-1IMAGE\s0 and \s-1PHYSICAL\s0 systems, pure
numbers are pixels.  Otherwise, for all systems other than linear,
pure numbers are degrees. For \s-1LINEAR\s0 systems, pure numbers are in the
units of the linear system.  This rule covers both positions and
sizes.
.PP
The input values to each shape can be specified in several coordinate
systems including:
.PP
.Vb 12
\&  name                  description
\&  ----                  ----------------------------
\&  IMAGE                 pixel coords of current file
\&  LINEAR                linear wcs as defined in file
\&  FK4, B1950            various sky coordinate systems
\&  FK5, J2000
\&  GALACTIC
\&  ECLIPTIC
\&  ICRS
\&  PHYSICAL              pixel coords of original file using LTM/LTV
\&  AMPLIFIER             mosaic coords of original file using ATM/ATV
\&  DETECTOR              mosaic coords of original file using DTM/DTV
.Ve
.PP
If no coordinate system is specified, \s-1PHYSICAL\s0 is assumed. \s-1PHYSICAL\s0 or
a World Coordinate System such as J2000 is preferred and most general.
The coordinate system specifier should appear at the beginning of the
region description, on a separate line (in a file), or followed by a
new-line or semicolon; e.g.,
.PP
.Vb 2
\&  global coordsys physical
\&  circle 6500 9320 200
.Ve
.PP
The use of celestial input units automatically implies \s-1WORLD\s0
coordinates of the reference image.  Thus, if the world coordinate
system of the reference image is J2000, then
.PP
.Vb 1
\&  circle 10:10:0 20:22:0 3'
.Ve
.PP
is equivalent to:
.PP
.Vb 1
\&  circle 10:10:0 20:22:0 3' # j2000
.Ve
.PP
Note that by using units as described above, you may mix coordinate
systems within a region specifier; e.g.,
.PP
.Vb 1
\&  circle 6500 9320 3' # physical
.Ve
.PP
Note that, for regions which accept a rotation angle:
.PP
ellipse (x, y, r1, r2, angle)
box(x, y, w, h, angle)
.PP
the angle is relative to the specified coordinate system. In
particular, if the region is specified in \s-1WCS\s0 coordinates, the angle
is related to the \s-1WCS\s0 system, not x/y image coordinate axis.  For \s-1WCS\s0
systems with no rotation, this obviously is not an issue.  However,
some images do define an implicit rotation (e.g., by using a non-zero
\&\s-1CROTA\s0 value in the \s-1WCS\s0 parameters) and for these images, the angle
will be relative to the \s-1WCS\s0 axes. In such case, a region specification
such as:
.PP
fk4;ellipse(22:59:43.985, +58:45:26.92,320\*(L", 160\*(R", 30)
.PP
will not, in general, be the same region specified as:
.PP
physical;ellipse(465, 578, 40, 20, 30)
.PP
even when positions and sizes match. The angle is relative to \s-1WCS\s0 axes
in the first case, and relative to physical x,y axes in the second.
.PP
More detailed descriptions are available for:
Region Geometry,
Region Algebra,
Region Coordinates, and
Region Boundaries.
.SH "SEE ALSO"
.IX Header "SEE ALSO"
See funtools(n) for a list of Funtools help pages
