## Conventions

### Draco File Format

* All Draco encoded mesh files are comprised of four main sections. This first
section is the header. The second section contains the metadata. This section is optional. The third section contains the connectivity data. The fourth section contains the attribute data.

<figure>
  <img alt="" src="images/draco_file.png">
  <figcaption>Figure 1. Draco file format.</figcaption>
</figure>

* The header must be decoded first, then the metadata section (if present), then the connectivity section, and then the attribute section.


#### Sequential Connectivity

* The sequential connectivity is comprised of two sections. The first section is the connectivity header. The second section is the indices data.

<figure>
  <img alt="" src="images/sequential_connectivity.png">
  <figcaption>Figure 2. Sequential connectivity format.</figcaption>
</figure>

#### EdgeBreaker Connectivity

* The EdgeBreaker connectivity section is composed of five sections. The first section is the connectivity header. The second section is the encoded split data. The third section is the encoded EdgeBreaker symbol data. The fourth section is the encoded start face configuration data. The fifth section is the attribute connectivity data.

<figure>
  <img alt="" src="images/edgebreaker_connectivity.png">
  <figcaption>Figure 3. EdgeBreaker connectivity format.</figcaption>
</figure>

#### Valence EdgeBreaker Connectivity

* The valence EdgeBreaker connectivity adds two sections after the attribute connectivity data. The first additional section is the EdgeBreaker valence header. The second additional section is the context data for the valence prediction.

<figure>
  <img alt="" src="images/edgebreaker_valence_connectivity.png">
  <figcaption>Figure 4. Valence EdgeBreaker connectivity format.</figcaption>
</figure>

#### Attributes

* The attributes data contains two sections. The first section is the attribute header. The second section is comprised of one or more attribute types, such as positions, texture coordinates, normals… Each attribute type section is comprised of one or more unique attributes.

<figure>
  <img alt="" src="images/attributes.png">
  <figcaption>Figure 5. Attribute data format.</figcaption>
</figure>


### Draco Conventions

* f[n]
  * Unsigned n-bit number appearing directly in the bitstream. The bits are read from high to low order.
  * When bit reading is finished it will always pad the read to the current byte. ResetBitReader() will signify when the bit reading is finished.

* I16, UI16, I32, UI32, I64, UI64, and Float values must be little endian.

* Float is IEEE 754 Single precision.

* varUI32 and varUI64 types must be decoded by the LEB128() function.

* varUI32 can represent values in the range 0 to 2^32 - 1.
  * E.g. 0x10000000 will be stored using 5 bytes.

* varUI64 can represent values in the range 0 to 2^64 - 1.
  * E.g. 0x100000000000000 will be stored using 9 bytes.

* Metadata keys per metadata element must be unique.

* att_metadata_id values must be unique.

* All values of att_metadata_id must equal a value stored in att_dec_unique_id.

* When parsing a value, that value can be assigned to a variable after the value has been parsed.
  * E.g. sz = buffer_size                              varUI32
  * buffer                                             UI8[sz]

* All uninitialized elements of opposite_corners_ shall be set to kInvalidCornerIndex.

### General Conventions


The mathematical operators and their precedence rules used to describe this
Specification are similar to those used in the C programming language.

Assignment of an array is represented using the normal notation `A = B` and is
specified to mean the same as doing both the individual assignments
`A[ 0 ] = B[ 0 ]` and `A[ 1 ] = B[ 1 ].` Equality testing of 2 arrays is
represented using the notation `A == B` and is specified to mean the same as
`(A[ 0 ] == B[ 0 ] && A[ 1 ] == B[ 1 ])`. Inequality testing is defined as
`A != B` and is specified to mean the same as
`(A[ 0 ] != B[ 0 ] || A[ 1 ] != B[ 1 ])`.

Unless otherwise noted, array element assignment will increase the size of the array to include the element. Any remaining new elements will be uninitialized.

The functions `assign`, `back`, `empty`, `pop_back`, `push_back`, and `size` behave
similarly on arrays as it is defined for c++ std::vector.

When a variable is said to be representable by a signed integer with `x` bits,
it means that the variable is greater than or equal to `-(1 << (x-1))`, and that
the variable is less than or equal to `(1 << (x-1))-1`.

The function ReadBits(X), reads the next X bits from an array.

### Arithmetic operators

|          |         |
|:--------:| ------- |
| `+`      | Addition
| `–`      | Subtraction (as a binary operator) or negation (as a unary prefix operator)
| `*`      | Multiplication
| `/`      | Division
| `a % b`  |  Remainder from division of `a` by `b`. Both `a` and `b` are positive integers.
{:.conventions }


### Logical operators

|          |         |
|:--------:| ------- |
| `a && b` | Logical AND operation between `a` and `b`
| `a || b` | Logical OR operation between `a` and `b`
| `!`      | Logical NOT operation.
{:.conventions }


### Relational operators

|          |         |
|:--------:| ------- |
| `>`      | Greater than
| `>=`     | Greater than or equal to
| `<`      | Less than
| `<=`     | Less than or equal to
| `==`     | Equal to
| `!=`     | Not equal to
{:.conventions }


### Bitwise operators

|          |         |
|:--------:| ------- |
| `&`      | AND operation
| `|`      | OR operation
| `~`      | Negation operation
| `a >> b` | Shift `a` in 2's complement binary integer representation format to the right by `b` bit positions. This operator is only used with `b` being a non-negative integer. Bits shifted into the MSBs as a result of the right shift have a value equal to the MSB of `a` prior to the shift operation.
| `a << b` | Shift `a` in 2's complement binary integer representation format to the left by `b` bit positions. This operator is only used with `b` being a non-negative integer. Bits shifted into the LSBs as a result of the left shift have a value equal to `0`.
{:.conventions }


### Assignment

|          |         |
|:--------:| ------- |
| `=`      | Assignment operator
| `++`     | Increment, `x++` is equivalent to `x = x + 1`. When this operator is used for an array index, the variable value is obtained before the auto increment operation
| `--`     | Decrement, i.e. `x--` is equivalent to `x = x - 1`. When this operator is used for an array index, the variable value is obtained before the auto decrement operation
| `+=`     | Addition assignment operator, for example `x += 3` corresponds to `x = x + 3`
| `-=`     | Subtraction assignment operator, for example `x -= 3` corresponds to `x = x - 3`
{:.conventions }



### Mathematical functions

The following mathematical functions (Abs, Min, and Max)
are defined as follows:

<script type="math/asciimath">
"Abs"(x)={[x;,x >= 0],[-x;,x<0]}
</script>

<br>

<script type="math/asciimath">
"Min"(x,y)={[x;,x<=y],[y;,x>y]}
</script>

<br>

<script type="math/asciimath">
"Max"(x,y)={[x;,x>=y],[y;,x<y]}
</script>


### Method of describing bitstream syntax

Each syntax element is described by its name (using only lower case letters
with underscore characters) and a descriptor for its method of coded
representation. The decoding process behaves according to the value of the
syntax element and to the values of previously decoded syntax elements.

In some cases the syntax tables may use the values of other variables derived
from syntax elements values.

{% comment %}

The description style of the syntax is similar to the C++ programming language.
Syntax elements in the bitstream are represented in bold type. Each syntax
element is described by its name (using only lower case letters with
underscore characters) and a descriptor for its method of coded
representation. The decoding process behaves according to the value of the
syntax element and to the values of previously decoded syntax elements. When a
value of a syntax element is used in the syntax tables or the text, it appears
in regular (i.e. not bold) type. If the value of a syntax element is being
computed (e.g. being written with a default value instead of being coded in
the bitstream), it also appears in regular type.

In some cases the syntax tables may use the values of other variables derived
from syntax elements values. Such variables appear in the syntax tables, or
text, named by a mixture of lower case and upper case letter and without any
underscore characters. Variables starting with an upper case letter are
derived for the decoding of the current syntax structure and all depending
syntax structures. These variables may be used in the decoding process for
later syntax structures. Variables starting with a lower case letter are only
used within the process from which they are derived.

Constant values appear in all upper case letters with underscore characters.

Constant lookup tables appear in all lower case letters with underscore
characters.

Hexadecimal notation, indicated by prefixing the hexadecimal number by `0x`,
may be used when the number of bits is an integer multiple of 4. For example,
`0x1a` represents a bit string `0001 1010`.

Binary notation is indicated by prefixing the binary number by `0b`. For
example, `0b00011010` represents a bit string `0001 1010`. Binary numbers may
include underscore characters to enhance readability. If present, the
underscore characters appear every 4 binary digits starting from the LSB. For
example, `0b11010` may also be written as `0b1_1010`.

A value equal to 0 represents a FALSE condition in a test statement. The
value TRUE is represented by any value not equal to 0.

The following table lists examples of the syntax specification format. When
`syntax_element` appears (with bold face font), it specifies that this syntax
element is parsed from the bitstream.

{% endcomment %}
