.\" dpkg manual page - dpkg-gensymbols(1)
.\"
.\" Copyright © 2007-2011 Raphaël Hertzog <hertzog@debian.org>
.\" Copyright © 2009-2010 Modestas Vainius <modestas@vainius.eu>
.\" Copyright © 2012-2015 Guillem Jover <guillem@debian.org>
.\"
.\" This is free software; you can redistribute it and/or modify
.\" it under the terms of the GNU General Public License as published by
.\" the Free Software Foundation; either version 2 of the License, or
.\" (at your option) any later version.
.\"
.\" This is distributed in the hope that it will be useful,
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\" GNU General Public License for more details.
.\"
.\" You should have received a copy of the GNU General Public License
.\" along with this program.  If not, see <https://www.gnu.org/licenses/>.
.
.\"*******************************************************************
.\"
.\" This file was generated with po4a. Translate the source file.
.\"
.\"*******************************************************************
.TH dpkg\-gensymbols 1 %RELEASE_DATE% %VERSION% "suite dpkg"
.ad l
.nh
.SH NOM
dpkg\-gensymbols \- Création des fichiers de symboles (information de
dépendances de bibliothèques partagées)
.
.SH SYNOPSIS
\fBdpkg\-gensymbols\fP [\fIoption\fP...]
.
.SH DESCRIPTION
\fBdpkg\-gensymbols\fP analyse un répertoire temporaire de construction (par
défaut debian/tmp), y recherche les bibliothèques et crée un fichier
\fIsymbols\fP qui les décrit. Si ce fichier n'est pas vide, il est installé
dans le sous\-répertoire DEBIAN du répertoire de construction afin de pouvoir
être inclus dans les informations de contrôle du paquet.
.P
Lors de la création de ces fichiers, il utilise en entrée certains fichiers
de symboles fournis par le responsable. Il recherche les fichiers suivants
(en utilisant le premier trouvé)\ :
.IP • 4
debian/\fIpaquet\fP.symbols.\fIarch\fP
.IP • 4
debian/symbols.\fIarch\fP
.IP • 4
debian/\fIpaquet\fP.symbols
.IP • 4
debian/symbols
.P
L'intérêt principal de ces fichiers est de fournir la version minimale
associée à chaque symbole fourni par les bibliothèques. En général, cela
correspond à la première version du paquet qui a fourni ce symbole, mais
cette valeur peut être augmentée manuellement par le responsable si
l'interface binaire applicative (ABI) du symbole est étendue sans casser la
compatibilité avec les versions précédentes. La tenue à jour de ces fichiers
est à la charge du responsable du paquet, avec l'aide de
\fBdpkg\-gensymbols\fP.
.P
Quand les fichiers de symboles créés sont différents de ceux fournis par le
responsable, \fBdpkg\-gensymbols\fP affichera les différences entre les deux
versions. Si ces différences sont trop importantes, le programme peut même
se terminer en échec (le nombre de différences tolérées peut être réglé avec
l'option \fB\-c\fP).
.SH "TENUE À JOUR DES FICHIERS SYMBOLES"
The base interchange format of the symbols file is described in
\fBdeb\-symbols\fP(5), which is used by the symbols files included in binary
packages. These are generated from template symbols files with a format
based on the former, described in \fBdeb\-src\-symbols\fP(5)  and included in
source packages.
.P
The symbols files are really useful only if they reflect the evolution of
the package through several releases. Thus the maintainer has to update them
every time that a new symbol is added so that its associated minimal version
matches reality.
.P
The diffs contained in the build logs can be used as a starting point, but
the maintainer, additionally, has to make sure that the behaviour of those
symbols has not changed in a way that would make anything using those
symbols and linking against the new version, stop working with the old
version.
.P
In most cases, the diff applies directly to the debian/\fIpackage\fP.symbols
file. That said, further tweaks are usually needed: it's recommended for
example to drop the Debian revision from the minimal version so that
backports with a lower version number but the same upstream version still
satisfy the generated dependencies.  If the Debian revision can't be dropped
because the symbol really got added by the Debian specific change, then one
should suffix the version with ‘\fB~\fP’.
.P
Avant d'appliquer le correctif au fichier de symboles, le responsable doit
contrôler qu'il est correct. Les symboles publics sont supposés ne jamais
disparaître et le correctif ne devrait donc qu'ajouter des lignes.
.P
Note that you can put comments in symbols files.
.P
N'oubliez pas de vérifier si les anciennes versions des symboles ne doivent
pas être incrémentées. Il n'y a pas de moyen pour que \fBdpkg\-gensymbols\fP
prévienne de cela. Appliquer aveuglement le fichier de différences ou
supposer qu'il n'y a rien à changer, s'il n'y a pas de fichier de
différences, sans vérifier s'il y a ces modifications, peut faire que des
paquets, avec des dépendances lâches, prétendent qu'ils peuvent fonctionner
avec des paquets plus anciens avec lesquels ils ne peuvent fonctionner. Cela
introduira des bogues difficiles à trouver avec des mises à niveau
(partielles).
.SS "Bonnes pratiques de gestion des bibliothèques"
.P
Une bibliothèque bien maintenue offre les possibilités suivantes\ :
.IP • 4
son interface de programmation (API) est stable (les symboles publics ne
sont jamais supprimés et les changements ne concernent que des ajouts de
nouveaux symboles publics) et les modifications provoquant une
incompatibilité doivent être combinés avec un changement de SONAME\ ;
.IP • 4
idéalement, elle utilise le versionnage des symboles pour garantir la
stabilité de l'interface applicative binaire (ABI) malgré ses modifications
internes et l'extension de son API\ ;
.IP • 4
elle n'exporte pas les symboles privés (afin de contourner cela, de tels
symboles peuvent être étiquetés comme optionnels).
.P
En maintenant le fichier de symboles, il est facile d'en voir apparaître et
disparaître. Cependant, il est plus difficile de contrôler la présence
d'éventuelles modifications d'API ou ABI. En conséquence, le responsable
doit contrôler soigneusement le journal des modifications amont, à la
recherche de cas où une saine gestion des bibliothèques peut avoir été
omise. Si des problèmes potentiels sont découverts, l'auteur amont doit être
averti(e) car une correction en amont est meilleure qu'un travail spécifique
au paquet Debian.
.SH OPTIONS
.TP 
\fB\-P\fP\fIrépertoire\-construction\-paquet\fP
Analyse de \fIrépertoire\-construction\-paquet\fP, plutôt que debian/tmp.
.TP 
\fB\-p\fP\fIpaquet\fP
Définit le nom du paquet. Requis si plus d'un paquet binaire est indiqué
dans debian/control (ou s'il n'y a pas de fichier debian/control).
.TP 
\fB\-v\fP\fIversion\fP
Définit la version du paquet. La valeur par défaut est la version extraite
de debian/changelog. Ce paramètre est requis si le programme est lancé en
dehors de l'arborescence source d'un paquet.
.TP 
\fB\-e\fP\fIfichier\-bibliothèque\fP
N'analyse que les bibliothèques explicitement mentionnées au lieu de
rechercher toutes les bibliothèques publiques. Les motifs du shell peuvent
être utilisés pour l'expansion des chemins d'accès (voir la page de manuel
de \fBFile::Glob\fP(3perl) pour plus d'informations) dans
\fIfichier\-bibliothèque\fP pour établir une correspondance avec plusieurs
bibliothèques avec un seul paramètre (afin d'éviter d'utiliser plusieurs
options \fB\-e\fP).
.TP 
\fB\-l\fP\fIrépertoire\fP
Ajoute \fIrépertoire\fP au début de la liste des répertoires où chercher des
bibliothèques partagées privées (depuis dpkg\ 1.19.1). Cette option peut être
utilisée plusieurs fois.

Note\ : Utilisez cette option plutôt que le réglage de \fBLD_LIBRARY_PATH\fP,
parce que cette variable d'environnement est utilisée pour contrôler
l'éditeur de liens d'exécution et se servir d'elle pour définir les chemins
des bibliothèques partagées au moment de la construction peut être
problématique, par exemple, lors d'une compilation croisée.
.TP 
\fB\-I\fP\fInom\-de\-fichier\fP
Utilise \fInom\-de\-fichier\fP comme fichier de référence pour créer le fichier
de symboles à intégrer dans le paquet lui\-même.
.TP 
\fB\-O\fP[\fInom\-de\-fichier\fP]
Affiche le fichier de symboles créé sur la sortie standard ou dans le
\fInom\-de\-fichier\fP, si spécifié, plutôt que dans \fBdebian/tmp/DEBIAN/symbols\fP
(ou \fIrépertoire\-construction\-paquet\fP\fB/DEBIAN/symbols\fP si \fB\-P\fP est
présent). Si \fInom\-de\-fichier\fP existe déjà, son contenu sera utilisé comme
base pour le fichier créé. Cette fonctionnalité permet de mettre à jour le
fichier de symboles pour qu'il corresponde à une nouvelle version amont de
la bibliothèque.
.TP 
\fB\-t\fP
Écrit le fichier de symboles en mode modèle plutôt que dans un format
compatible avec \fBdeb\-symbols\fP(5). La différence majeure réside dans le fait
que les noms de symboles et les étiquettes sont écrits dans leur forme
d'origine au lieu d'être interprétés, avec réduction des étiquettes en mode
de compatibilité. De plus, certains symboles peuvent être omis lors de
l'écriture d'un fichier \fBdeb\-symbols\fP(5) standard (selon les règles de
traitement des étiquettes) alors que tous les symboles sont écrits lors de
la création d'un modèle de fichier de symboles.
.TP 
\fB\-c\fP\fI[0\-4]\fP
Définit les contrôles à effectuer lors de la comparaison du fichier de
symboles créé en utilisant le fichier de modèle comme point de départ. Le
niveau par défaut est\ 1. Plus le niveau est augmenté, plus le nombre de
contrôles effectués est important. Chaque niveau de contrôle comporte les
contrôles effectués pour les niveaux inférieurs. Le niveau\ 0 n'échoue
jamais. Le niveau\ 1 échoue si certains symboles ont disparu. Le niveau\ 2
échoue si de nouveaux symboles ont été ajoutés. Le niveau\ 3 échoue si
certaines bibliothèques ont disparu. Le niveau\ 4 échoue si des bibliothèques
ont été ajoutées.

Cette valeur peut être remplacée par la valeur de la variable
d'environnement \fBDPKG_GENSYMBOLS_CHECK_LEVEL\fP.
.TP 
\fB\-q\fP
Fonctionne en mode silencieux et ne crée jamais de fichier de différences
entre le fichier de symboles créé et le fichier modèle utilisé comme point
de départ. N'affiche également aucun avertissement à propos de bibliothèques
nouvelles ou disparues ou de symboles nouveaux ou disparus. Cette option ne
désactive que l'affichage informatif, mais pas les contrôles eux\-mêmes (voir
l'option \fB\-c\fP).
.TP 
\fB\-a\fP\fIarch\fP
Définit \fIarch\fP comme architecture lors du traitement des fichiers de
symboles. Cette option permet de créer un fichier de symboles ou un fichier
de différences pour n'importe quelle architecture, à condition que les
fichiers binaires correspondants soient déjà disponibles.
.TP 
\fB\-d\fP
Active le mode bavard. De nombreux messages sont affichés pour expliquer ce
que \fBdpkg\-gensymbols\fP fait.
.TP 
\fB\-V\fP
Active le mode bavard. Le fichier de symboles créé contiendra les symboles
dépréciés sous forme de commentaires. De plus, en mode modèle, les motifs de
symboles seront suivis de commentaires affichant les symboles réels qui
correspondent au motif.
.TP 
\fB\-?\fP, \fB\-\-help\fP
Affiche un message d'aide puis quitte.
.TP 
\fB\-\-version\fP
Affiche le numéro de version puis quitte.
.
.SH ENVIRONNEMENT
.TP 
\fBDPKG_GENSYMBOLS_CHECK_LEVEL\fP
Remplace le niveau de vérification de commande, même si l'argument en ligne
de commande \fB\-c\fP a été donné (notez que cela va à l'encontre de la
convention générale qui veut que les arguments en ligne de commande ont la
préséance sur les variables d'environnement).
.TP 
\fBDPKG_COLORS\fP
Définit le mode de couleur (depuis dpkg\ 1.18.5). Les valeurs actuellement
acceptées sont \fBauto\fP (par défaut), \fBalways\fP et \fBnever\fP.
.TP 
\fBDPKG_NLS\fP
Si cette variable est définie, elle sera utilisée pour décider l'activation
de la prise en charge des langues (NLS –\ Native Language Support), connu
aussi comme la gestion de l'internationalisation (ou i18n) (depuis
dpkg\ 1.19.0). Les valeurs permises sont\ : \fB0\fP et \fB1\fP (par défaut).
.
.SH "VOIR AUSSI"
\fBhttps://people.redhat.com/drepper/symbol\-versioning\fP
.br
\fBhttps://people.redhat.com/drepper/goodpractice.pdf\fP
.br
\fBhttps://people.redhat.com/drepper/dsohowto.pdf\fP
.br
\fBdeb\-src\-symbol\fP(5), \fBdeb\-symbols\fP(5), \fBdpkg\-shlibdeps\fP(1).
.SH TRADUCTION
Ariel VARDI <ariel.vardi@freesbee.fr>, 2002.
Philippe Batailler, 2006.
Nicolas François, 2006.
Veuillez signaler toute erreur à <debian\-l10n\-french@lists.debian.org>.
