.\" dpkg manual page - deb-version(7)
.\"
.\" Copyright © 1996-1998 Ian Jackson and Christian Schwarz
.\"   for parts of the text reused from the Debian Policy
.\" Copyright © 2007 Frank Lichtenheld <djpig@debian.org>
.\" Copyright © 2011, 2013, 2015 Guillem Jover <guillem@debian.org>
.\"
.\" This is free software; you can redistribute it and/or modify
.\" it under the terms of the GNU General Public License as published by
.\" the Free Software Foundation; either version 2 of the License, or
.\" (at your option) any later version.
.\"
.\" This is distributed in the hope that it will be useful,
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\" GNU General Public License for more details.
.\"
.\" You should have received a copy of the GNU General Public License
.\" along with this program.  If not, see <https://www.gnu.org/licenses/>.
.
.\"*******************************************************************
.\"
.\" This file was generated with po4a. Translate the source file.
.\"
.\"*******************************************************************
.TH deb\-version 7 %RELEASE_DATE% %VERSION% "suite dpkg"
.ad l
.nh
.SH NOM
deb\-version \- Format du numéro de version des paquets Debian
.
.SH SYNOPSIS
[\fIepoch\fP\fB:\fP]\fIversion_amont\fP[\fB\-\fP\fIrévision_debian\fP]
.SH DESCRIPTION
Les numéros de version utilisés pour les paquets sources et binaires se
composent de trois parties. Celles\-ci sont\ :
.TP 
\fIepoch\fP
Ce nombre est un entier positif (usuellement petit). Il peut être omis (dans
ce cas, la valeur nulle est implicite). S'il est omis, la \fIversion_amont\fP
peut ne pas contenir de caractère deux\-points.
.IP
Cette valeur est destinée à permettre de gérer des erreurs dans les anciens
numéros de version d'un paquet ou un changement dans la méthode de
numérotation des versions amont.
.TP 
\fIversion_amont\fP
Cela est la partie principale du numéro de version. Cela correspond
normalement au numéro de version du paquet d'origine («\ upstream\ ») qui a
servi à créer le fichier \fI.deb\fP, si cela peut s'appliquer. Le format
d'origine spécifié par l'auteur est généralement conservé\ ; cependant, il
arrive qu'il soit nécessaire d'adapter ce numéro pour qu'il se conforme au
format du système de gestion de paquet et du procédé de comparaison des
numéros de version.
.IP
Le principe de comparaison du système de gestion de paquets en ce qui
concerne la \fIversion_amont\fP est décrit ci\-dessous. La partie
\fIversion_amont\fP du numéro de version est obligatoire.
.IP
La \fIversion_amont\fP ne doit contenir que des caractères alphanumériques
(«\ A\-Za\-z0\-9\ ») et les caractères \fB.\fP \fB+\fP \fB\-\fP \fB:\fP \fB~\fP (point, plus,
tiret, deux\-points, tilde) et devrait commencer par un chiffre. S'il n'y a
pas de partie \fIrévision_Debian\fP alors le tiret n'est pas autorisé\ ; s'il
n'y a pas d'\fIepoch\fP, alors c'est le caractère deux\-points qui n'est pas
autorisé.
.TP 
\fIrévision_Debian\fP
Cette partie du numéro de version indique la version du paquet Debian à
partir du numéro de la version amont. Elle ne doit contenir que des symboles
alphanumériques et les caractères \fB+\fP \fB.\fP \fB~\fP (plus, point, tilde). Elle
est analysée de la même façon que la \fIversion_amont\fP.
.IP
Cette partie est facultative\ ; si elle n'est pas présente, la
\fIversion_amont\fP ne doit pas contenir de tiret. Ce format est prévu pour le
cas où un logiciel a été directement conçu comme paquet Debian, il n'y a
donc qu'une seule «\ debianisation\ » et donc par la suite pas besoin
d'indication de révision.
.IP
Il est convenu de repartir à «\ 1\ » pour la \fIrévision_Debian\fP à chaque fois
que la \fIversion_amont\fP est incrémentée.
.IP
Dpkg s'arrêtera au dernier tiret du numéro de version (s'il y en a un) pour
déterminer la partie \fIversion_amont\fP et la \fIrévision_Debian\fP. L'absence de
\fIrévision_Debian\fP est comparée avant sa présence, mais il faut noter que la
\fIrévision_Debian\fP est la partie la moins significative du numéro de
version.
.SS "Algorithme de tri"
Les parties \fIversion_amont\fP et \fIrévision_Debian\fP sont comparées par le
système de gestion de paquet en utilisant le même algorithme\ :
.PP
Les chaînes sont comparées de la gauche vers la droite.
.PP
Pour commencer, la première partie de chaque chaîne composée uniquement de
caractères non numériques est déterminée. Puis ces deux parties (l'une peut
être vide) sont comparées lexicalement. Si une différence est trouvée, elle
est renvoyée. La comparaison lexicale est effectuée sur une version modifiée
des valeurs ASCII afin que les lettres passent avant les autres caractères
et que les tildes ("~") passent avant tous les caractères, même la fin d'une
partie. Par exemple, les éléments suivants sont ordonnés ainsi\ : «\ ~~\ »,
«\ ~~a\ », «\ ~\ », partie vide, «\ a\ ».
.PP
Puis, le début de ce qui reste des chaînes de caractères qui ne doivent plus
contenir que des chiffres est déterminé. Ces valeurs numériques sont
comparées et les différences sont remontées. Dans le cas d'une chaîne vide
(ce qui peut arriver si une chaîne est plus longue que l'autre lors de la
comparaison) elle compte pour un zéro.
.PP
Ces deux étapes (comparaison et suppression des caractères non numériques
puis de suppression des caractères numériques dans le début de la chaîne)
sont répétées jusqu'à ce qu'une différence soit trouvée ou la fin des
chaînes atteinte.
.PP
Notez que le rôle de epoch est de permettre de se sortir des problèmes de
numérotation de version, et de faire face à des situations de changement de
logique de numérotation. Cela n'est \fBpas\fP destiné à faire face à des
numéros de version qui contiennent des chaînes de lettres que le système de
gestion de paquet ne sait pas interpréter (comme «\ ALPHA\ », «\ pre\-\ ») ou
d'autres choses stupides.
.SH NOTES
Le caractère tilde («\ ~\ ») et sa propriété spéciale pour les comparaisons
ont été introduites dans la version\ 1.10 de dpkg. Ce n'est qu'à partir des
versions supérieures (1.10.x) que certaines parties des scripts de
construction de dpkg ont commencé à gérer ce système.
.SH "VOIR AUSSI"
\fBdeb\-control\fP(5), \fBdeb\fP(5), \fBdpkg\fP(1).
.SH TRADUCTION
Ariel VARDI <ariel.vardi@freesbee.fr>, 2002.
Philippe Batailler, 2006.
Nicolas François, 2006.
Veuillez signaler toute erreur à <debian\-l10n\-french@lists.debian.org>.
