.\" dpkg manual page - dpkg-source(1)
.\"
.\" Copyright © 1995-1996 Ian Jackson <ijackson@chiark.greenend.org.uk>
.\" Copyright © 2000 Wichert Akkerman <wakkerma@debian.org>
.\" Copyright © 2006-2007 Frank Lichtenheld <djpig@debian.org>
.\" Copyright © 2006-2015 Guillem Jover <guillem@debian.org>
.\" Copyright © 2008-2011 Raphaël Hertzog <hertzog@debian.org>
.\" Copyright © 2010 Joey Hess <joeyh@debian.org>
.\"
.\" This is free software; you can redistribute it and/or modify
.\" it under the terms of the GNU General Public License as published by
.\" the Free Software Foundation; either version 2 of the License, or
.\" (at your option) any later version.
.\"
.\" This is distributed in the hope that it will be useful,
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\" GNU General Public License for more details.
.\"
.\" You should have received a copy of the GNU General Public License
.\" along with this program.  If not, see <https://www.gnu.org/licenses/>.
.
.TH dpkg\-source 1 "%RELEASE_DATE%" "%VERSION%" "dpkg suite"
.ad l
.nh
.SH NAME
dpkg\-source \- Debian source package (.dsc) manipulation tool
.
.SH SYNOPSIS
.B dpkg\-source
.RI [ option "...] " command
.
.SH DESCRIPTION
.B dpkg\-source
packs and unpacks Debian source archives.

None of these commands allow multiple options to be combined into one,
and they do not allow the value for an option to be specified in a
separate argument.
.
.SH COMMANDS
.TP
.BR \-x ", " \-\-extract " \fIfilename\fP.dsc [\fIoutput-directory\fP]"
Extract a source package (\fB\-\-extract\fP since dpkg 1.17.14).
One non-option argument must be supplied,
the name of the Debian source control file
.RB ( .dsc ).
An optional second non-option argument may be supplied to specify the
directory to extract the source package to, this must not exist. If
no output directory is specified, the source package is extracted into
a directory named \fIsource\fR-\fIversion\fR under the current working
directory.

.B dpkg\-source
will read the names of the other file(s) making up the source package
from the control file; they are assumed to be in the same directory as
the
.BR .dsc .

The files in the extracted package will have their permissions and
ownerships set to those which would have been expected if the files
and directories had simply been created - directories and executable
files will be 0777 and plain files will be 0666, both modified by the
extractors' umask; if the parent directory is setgid then the
extracted directories will be too, and all the files and directories
will inherit its group ownership.

If the source package uses a non-standard format (currently this means all
formats except “1.0”), its name will be stored in
\fBdebian/source/format\fP so that the following builds of the source
package use the same format by default.

.TP
.BR \-b ", " \-\-build " \fIdirectory\fP [\fIformat-specific-parameters\fP]"
Build a source package (\fB\-\-build\fP since dpkg 1.17.14).
The first non-option argument is taken as the
name of the directory containing the debianized source tree (i.e. with a
debian sub-directory and maybe changes to the original files).
Depending on the source package format used to build the package,
additional parameters might be accepted.

\fBdpkg\-source\fP will build the source package with the first format
found in this ordered list:
the format indicated with the \fI\-\-format\fP command line option,
the format indicated in \fBdebian/source/format\fP,
“1.0”.
The fallback to “1.0” is deprecated and will be removed at some
point in the future, you should always document the desired source format
in \fBdebian/source/format\fP. See section \fBSOURCE PACKAGE FORMATS\fP
for an extensive description of the various source package formats.

.TP
.RI "\fB\-\-print\-format\fP " directory
Print the source format that would be used to build the source package if
\fBdpkg\-source \-\-build \fIdirectory\fR was called (in the same conditions
and with the same parameters; since dpkg 1.15.5).

.TP
.RI "\fB\-\-before\-build\fP " directory
Run the corresponding hook of the source package format (since dpkg 1.15.8).
This hook is
called before any build of the package (\fBdpkg\-buildpackage\fP calls it
very early even before \fBdebian/rules clean\fP). This command is
idempotent and can be called multiple times. Not all source formats
implement something in this hook, and those that do usually prepare the
source tree for the build for example by ensuring that the Debian patches
are applied.

.TP
.RI "\fB\-\-after\-build\fP " directory
Run the corresponding hook of the source package format (since dpkg 1.15.8).
This hook is
called after any build of the package (\fBdpkg\-buildpackage\fP calls it
last). This command is idempotent and can be called multiple times. Not
all source formats implement something in this hook, and those that do
usually use it to undo what \fB\-\-before\-build\fP has done.

.TP
.RI "\fB\-\-commit\fP [" directory "] ..."
Record changes in the source tree unpacked in \fIdirectory\fP
(since dpkg 1.16.1).
This command can take supplementary parameters depending on the source format.
It will error out for formats where this operation doesn't mean anything.

.TP
.BR \-? ", " \-\-help
Show the usage message and exit.
The format specific build and extract options can be shown by using the
\fB\-\-format\fP option.
.TP
.BR \-\-version
Show the version and exit.
.
.SH OPTIONS
.SS Generic build options
.TP
.BI \-c control-file
Specifies the main source control file to read information from. The
default is
.BR debian/control .
If given with relative pathname this is interpreted starting at
the source tree's top level directory.
.TP
.BI \-l changelog-file
Specifies the changelog file to read information from. The
default is
.BR debian/changelog .
If given with relative pathname this is interpreted starting at
the source tree's top level directory.
.TP
.BI \-F changelog-format
Specifies the format of the changelog. See \fBdpkg\-parsechangelog\fP(1)
for information about alternative formats.
.TP
.BI \-\-format= value
Use the given format for building the source package (since dpkg 1.14.17).
It does override any format given in \fBdebian/source/format\fP.
.TP
.BI \-V name = value
Set an output substitution variable.
See \fBdeb\-substvars\fP(5) for a discussion of output substitution.
.TP
.BI \-T substvars-file
Read substitution variables in
.IR substvars-file ;
the default is to not read any file. This option can be used multiple
times to read substitution variables from multiple files (since dpkg 1.15.6).
.TP
.BI \-D field = value
Override or add an output control file field.
.TP
.BI \-U field
Remove an output control file field.
.TP
.BR \-Z "\fIcompression\fP, " \-\-compression =\fIcompression\fP
Specify the compression to use for created tarballs and diff files
(\fB\-\-compression\fP since dpkg 1.15.5).
Note that this option will not cause existing tarballs to be recompressed,
it only affects new files. Supported values are:
.IR gzip ", " bzip2 ", " lzma " and " xz .
The default is \fIxz\fP for formats 2.0 and newer, and \fIgzip\fP for
format 1.0. \fIxz\fP is only supported since dpkg 1.15.5.
.TP
.BR \-z "\fIlevel\fP, " \-\-compression\-level =\fIlevel\fP
Compression level to use (\fB\-\-compression\-level\fP since dpkg 1.15.5).
As with \fB\-Z\fP it only affects newly created
files. Supported values are:
.IR 1 " to " 9 ", " best ", and " fast .
The default is \fI9\fP for gzip and bzip2, \fI6\fP for xz and lzma.
.TP
.BR \-i "[\fIregex\fP], " \-\-diff\-ignore [=\fIregex\fP]
You may specify a perl regular expression to match files you want
filtered out of the list of files for the diff (\fB\-\-diff\-ignore\fP
since dpkg 1.15.6).
(This list is
generated by a find command.) (If the source package is being built as a
version 3 source package using a VCS, this can be used to ignore
uncommitted changes on specific files. Using \-i.* will ignore all of them.)

The \fB\-i\fP option by itself enables this setting with a default regex
(preserving any modification to the default regex done by a previous use
of \fB\-\-extend\-diff\-ignore\fP) that will filter out control files and
directories of the most common revision control systems, backup and swap
files and Libtool build output directories. There can only be one active
regex, of multiple \fB\-i\fP options only the last one will take effect.

This is very helpful in cutting out extraneous files that get included
in the diff, e.g. if you maintain your source in a revision control
system and want to use a checkout to build a source package without
including the additional files and directories that it will usually
contain (e.g. CVS/, .cvsignore, .svn/). The default regex is already
very exhaustive, but if you need to replace it, please note that by
default it can match any part of a path, so if you want to match the
begin of a filename or only full filenames, you will need to provide
the necessary anchors (e.g. ‘(^|/)’, ‘($|/)’) yourself.
.TP
.BR \-\-extend\-diff\-ignore =\fIregex\fP
The perl regular expression specified will extend the default value used by
\fB\-\-diff\-ignore\fP and its current value, if set (since dpkg 1.15.6).
It does this by concatenating “\fB|\fP\fIregex\fP” to the existing value.
This option is convenient to use in \fBdebian/source/options\fP to exclude
some auto-generated files from the automatic patch generation.
.TP
.BR \-I "[\fIfile-pattern\fP], " \-\-tar\-ignore [=\fIfile-pattern\fP]
If this option is specified, the pattern will be passed to
.BR tar (1)'s
.B \-\-exclude
option when it is called to generate a .orig.tar or .tar file
(\fB\-\-tar\-ignore\fP since dpkg 1.15.6).
For
example, \fB\-I\fPCVS will make tar skip over CVS directories when generating
a .tar.gz file. The option may be repeated multiple times to list multiple
patterns to exclude.

\fB\-I\fP by itself adds default \fB\-\-exclude\fP options that will
filter out control files and directories of the most common revision
control systems, backup and swap files and Libtool build output
directories.
.PP
.B Note:
While they have similar purposes, \fB\-i\fP and \fB\-I\fP have very
different syntax and semantics. \fB\-i\fP can only be specified once and
takes a perl compatible regular expression which is matched against
the full relative path of each file. \fB\-I\fP can specified
multiple times and takes a filename pattern with shell wildcards.
The pattern is applied to the full relative path but also
to each part of the path individually. The exact semantic of tar's
\fB\-\-exclude\fP option is somewhat complicated, see
https://www.gnu.org/software/tar/manual/tar.html#wildcards for a full
documentation.

The default regex and patterns for both options can be seen
in the output of the \fB\-\-help\fP command.
.SS Generic extract options
.TP
.BI \-\-no\-copy
Do not copy original tarballs near the extracted source package
(since dpkg 1.14.17).
.TP
.BI \-\-no\-check
Do not check signatures and checksums before unpacking (since dpkg 1.14.17).
.TP
.B \-\-no\-overwrite\-dir
Do not overwrite the extraction directory if it already exists
(since dpkg 1.18.8).
.TP
.BI \-\-require\-valid\-signature
Refuse to unpack the source package if it doesn't contain an OpenPGP
signature that can be verified (since dpkg 1.15.0) either with the user's
\fItrustedkeys.gpg\fP keyring, one of the vendor-specific keyrings, or one
of the official Debian keyrings
(\fI/usr/share/keyrings/debian\-keyring.gpg\fP
and \fI/usr/share/keyrings/debian\-maintainers.gpg\fP).
.TP
.BI \-\-require\-strong\-checksums
Refuse to unpack the source package if it does not contain any strong
checksums (since dpkg 1.18.7).
Currently the only known checksum considered strong is \fBSHA-256\fP.
.TP
.B \-\-ignore\-bad\-version
Turns the bad source package version check into a non-fatal warning
(since dpkg 1.17.7).
This option should only be necessary when extracting ancient source
packages with broken versions, just for backwards compatibility.

.SH SOURCE PACKAGE FORMATS
If you don't know what source format to use, you should probably pick
either “3.0 (quilt)” or “3.0 (native)”.
See https://wiki.debian.org/Projects/DebSrc3.0 for information on the
deployment of those formats within Debian.

.SS Format: 1.0
A source package in this format consists either of a \fB.orig.tar.gz\fP
associated to a \fB.diff.gz\fP or a single \fB.tar.gz\fP (in that case
the package is said to be \fInative\fP).
Optionally the original tarball might be accompanied by a detached
upstream signature \fB.orig.tar.gz.asc\fP, extraction
supported since dpkg 1.18.5.

.B Extracting

Extracting a native package is a simple extraction of the single
tarball in the target directory. Extracting a non-native package
is done by first unpacking the \fB.orig.tar.gz\fP and then applying
the patch contained in the \fB.diff.gz\fP file. The timestamp of
all patched files is reset to the extraction time of the source
package (this avoids timestamp skews leading to problems when
autogenerated files are patched). The diff can create new files (the whole
debian directory is created that way) but can't remove files (empty files
will be left over).

.B Building

Building a native package is just creating a single tarball with
the source directory. Building a non-native package involves
extracting the original tarball in a separate “.orig” directory and
regenerating the \fB.diff.gz\fP by comparing the source package
\fIdirectory\fP with the .orig directory.

.B Build options (with \-\-build):

If a second non-option argument is supplied it should be the name of the
original source directory or tarfile or the empty string if the package is
a Debian-specific one and so has no debianization diffs. If no second
argument is supplied then
.B dpkg\-source
will look for the original source tarfile
.IB package _ upstream-version .orig.tar.gz
or the original source directory
.IB directory .orig
depending on the \fB\-sX\fP arguments.

.BR \-sa ", " \-sp ", " \-sk ", " \-su " and " \-sr
will not overwrite existing tarfiles or directories. If this is
desired then
.BR \-sA ", " \-sP ", " \-sK ", " \-sU " and " \-sR
should be used instead.
.PP
.TP
.BR \-sk
Specifies to expect the original source as a tarfile, by default
.IB package _ upstream-version .orig.tar. extension \fR.
It will leave this original source in place as a tarfile, or copy it
to the current directory if it isn't already there. The
tarball will be unpacked into
.IB directory .orig
for the generation of the diff.
.TP
.B \-sp
Like
.B \-sk
but will remove the directory again afterwards.
.TP
.B \-su
Specifies that the original source is expected as a directory, by
default
.IB package - upstream-version .orig
and
.B dpkg\-source
will create a new original source archive from it.
.TP
.B \-sr
Like
.B \-su
but will remove that directory after it has been used.
.TP
.B \-ss
Specifies that the original source is available both as a directory
and as a tarfile. \fBdpkg\-source\fP will use the directory to create
the diff, but the tarfile to create the
.BR .dsc .
This option must be used with care - if the directory and tarfile do
not match a bad source archive will be generated.
.TP
.B \-sn
Specifies to not look for any original source, and to not generate a diff.
The second argument, if supplied, must be the empty string. This is
used for Debian-specific packages which do not have a separate
upstream source and therefore have no debianization diffs.
.TP
.BR \-sa " or " \-sA
Specifies to look for the original source archive as a tarfile or as a
directory - the second argument, if any, may be either, or the empty
string (this is equivalent to using
.BR \-sn ).
If a tarfile is found it will unpack it to create the diff and remove
it afterwards (this is equivalent to
.BR \-sp );
if a directory is found it will pack it to create the original source
and remove it afterwards (this is equivalent to
.BR \-sr );
if neither is found it will assume that the package has no
debianization diffs, only a straightforward source archive (this is
equivalent to
.BR \-sn ).
If both are found then \fBdpkg\-source\fP will ignore the directory,
overwriting it, if
.B \-sA
was specified (this is equivalent to
.BR \-sP )
or raise an error if
.B \-sa
was specified.
.B \-sa
is the default.
.TP
.B \-\-abort\-on\-upstream\-changes
The process fails if the generated diff contains changes to files
outside of the debian sub-directory (since dpkg 1.15.8).
This option is not allowed in
\fBdebian/source/options\fP but can be used in
\fBdebian/source/local\-options\fP.
.PP

.B Extract options (with \-\-extract):

In all cases any existing original source tree will be removed.
.TP
.B \-sp
Used when extracting then the original source (if any) will be left
as a tarfile. If it is not already located in the current directory
or if an existing but different file is there it will be copied there.
(\fBThis is the default\fP).
.TP
.B \-su
Unpacks the original source tree.
.TP
.B \-sn
Ensures that the original source is neither copied to the current
directory nor unpacked. Any original source tree that was in the
current directory is still removed.
.PP
All the
.BI \-s X
options are mutually exclusive. If you specify more than one only the
last one will be used.
.TP
.B \-\-skip\-debianization
Skips application of the debian diff on top of the upstream sources
(since dpkg 1.15.1).
.
.SS Format: 2.0
Extraction supported since dpkg 1.13.9, building supported since dpkg 1.14.8.
Also known as wig&pen. This format is not recommended for wide-spread
usage, the format “3.0 (quilt)” replaces it.
Wig&pen was the first specification of a new-generation source package format.

The behaviour of this format is the same as the “3.0 (quilt)” format
except that it doesn't use an explicit list of patches. All files in
\fBdebian/patches/\fP matching the perl regular expression \fB[\\w\-]+\fP
must be valid patches: they are applied at extraction time.

When building a new source package, any change to the upstream source
is stored in a patch named \fBzz_debian\-diff\-auto\fP.
.
.SS Format: 3.0 (native)
Supported since dpkg 1.14.17.
This format is an extension of the native package format as defined
in the 1.0 format. It supports all compression methods and
will ignore by default any VCS specific files and directories
as well as many temporary files (see default value associated to
\fB\-I\fP option in the \fB\-\-help\fP output).
.
.SS Format: 3.0 (quilt)
Supported since dpkg 1.14.17.
A source package in this format contains at least
an original tarball (\fB.orig.tar.\fP\fIext\fP where \fIext\fP can be
\fBgz\fP, \fBbz2\fP, \fBlzma\fP and \fBxz\fP) and a debian tarball
(\fB.debian.tar.\fP\fIext\fP). It can also contain additional original
tarballs (\fB.orig\-\fP\fIcomponent\fP\fB.tar.\fP\fIext\fP).
\fIcomponent\fP can only contain alphanumeric (‘a-zA-Z0-9’) characters
and hyphens (‘\-’).
Optionally each original tarball can be accompanied by a detached
upstream signature (\fB.orig.tar.\fP\fIext\fP\fB.asc\fP and
\fB.orig\-\fP\fIcomponent\fP\fB.tar.\fP\fIext\fP\fB.asc\fP), extraction
supported since dpkg 1.17.20, building supported since dpkg 1.18.5.

.PP
.B Extracting
.PP
The main original tarball is extracted first, then all additional original
tarballs are extracted in subdirectories named after the \fIcomponent\fP
part of their filename (any pre-existing directory is replaced). The
debian tarball is extracted on top of the source directory after prior
removal of any pre-existing \fBdebian\fP directory. Note that the
debian tarball must contain a \fBdebian\fP sub-directory but it
can also contain binary files outside of that directory (see
\fB\-\-include\-binaries\fP option).
.PP
All patches listed in \fBdebian/patches/\fP\fIvendor\fP\fB.series\fP or
\fBdebian/patches/series\fP are then applied, where \fIvendor\fP will be
the lowercase name of the current vendor, or \fBdebian\fP if there is
no vendor defined.
If the former file is used and the latter one doesn't exist (or is a
symlink), then the latter is replaced with a symlink to the former.
This is meant to simplify usage of \fBquilt\fP to manage the set of patches.
Vendor-specific series files are intended to make it possible to serialize
multiple development branches based on the vendor, in a declarative way,
in preference to open-coding this handling in \fBdebian/rules\fP.
This is particularly useful when the source would need to be patched
conditionally because the affected files do not have built-in conditional
occlusion support.
Note however that while \fBdpkg\-source\fP parses correctly series files
with explicit options used for patch application (stored on each line
after the patch filename and one or more spaces), it does ignore those
options and always expect patches that can be applied with the \fB\-p1\fP
option of \fBpatch\fP. It will thus emit a warning when it encounters
such options, and the build is likely to fail.
.PP
Note that \fBlintian\fP(1) will emit unconditional warnings when using
vendor series due to a controversial Debian specific ruling, which should
not affect any external usage; to silence these, the dpkg lintian profile
can be used by passing «\fB--profile dpkg\fP» to \fBlintian\fP(1).
.PP
The timestamp of all patched files is reset to the extraction time of
the source package (this avoids timestamp skews leading to problems
when autogenerated files are patched).
.PP
Contrary to \fBquilt\fP's default behaviour, patches are expected to apply
without any fuzz. When that is not the case, you should refresh such
patches with \fBquilt\fP, or \fBdpkg\-source\fP will error out while
trying to apply them.
.PP
Similarly to \fBquilt\fP's default behaviour, the patches can remove
files too.
.PP
The file \fB.pc/applied\-patches\fP is created if some
patches have been applied during the extraction.
.PP
.B Building
.PP
All original tarballs found in the current directory are extracted in a
temporary directory by following the same logic as for the unpack, the
debian directory is copied over in the temporary directory, and all
patches except the automatic patch (\fBdebian\-changes\-\fP\fIversion\fP
or \fBdebian\-changes\fP, depending on \fB\-\-single\-debian\-patch\fP) are
applied. The temporary directory is compared to the source package
directory. When the diff is non-empty, the build fails unless
\fB\-\-single\-debian\-patch\fP or \fB\-\-auto\-commit\fP
has been used, in which case the diff is stored in the automatic patch.
If the automatic patch is created/deleted, it's added/removed from the
series file and from the \fBquilt\fP metadata.

Any change
on a binary file is not representable in a diff and will thus lead to a
failure unless the maintainer deliberately decided to include that
modified binary file in the debian tarball (by listing it in
\fBdebian/source/include\-binaries\fP). The build will also fail if it
finds binary files in the debian sub-directory unless they have been
whitelisted through \fBdebian/source/include\-binaries\fP.

The updated debian directory and the list of modified binaries is then
used to generate the debian tarball.

The automatically generated diff doesn't include changes on VCS specific
files as well as many temporary files (see default value associated to
\fB\-i\fP option in the \fB\-\-help\fP output). In particular, the
\fB.pc\fP directory used by \fBquilt\fP is ignored during generation of the
automatic patch.

Note: \fBdpkg\-source\fP \fB\-\-before\-build\fP (and \fB\-\-build\fP) will
ensure that all patches listed in the series file are applied so that a
package build always has all patches applied. It does this by finding
unapplied patches (they are listed in the \fBseries\fP file but not in
\fB.pc/applied\-patches\fP), and if the first patch in that set can be
applied without errors, it will apply them all. The option
\fB\-\-no\-preparation\fP can be used to disable this
behavior.

.PP
.B Recording changes
.TP
.RI "\fB\-\-commit\fP [" directory "] [" patch-name "] [" patch-file ]
Generates a patch corresponding to the local changes that are not managed
by the \fBquilt\fP patch system and integrates it in the patch system under
the name \fIpatch-name\fP. If the name is missing, it will be asked
interactively. If \fIpatch-file\fP is given, it is used as the patch
corresponding to the local changes to integrate. Once integrated, an
editor is launched so that you can edit the meta-information in the patch
header.

Passing \fIpatch-file\fP is mainly useful after a build failure that
pre-generated this file, and on this ground the given file is removed
after integration. Note also that the changes contained in the patch file
must already be applied on the tree and that the files modified by the
patch must not have supplementary unrecorded changes.

If the patch generation detects modified binary files, they will be
automatically added to \fBdebian/source/include\-binaries\fP so that
they end up in the debian tarball (exactly like \fBdpkg-source
\-\-include\-binaries \-\-build\fP would do).
.PP
.B Build options
.TP
.BI \-\-allow\-version\-of\-quilt\-db= version
Allow \fBdpkg\-source\fP to build the source package if the version of
the \fBquilt\fP metadata is the one specified, even if \fBdpkg\-source\fP
doesn't know about it (since dpkg 1.15.5.4).
Effectively this says that the given version of the
\fBquilt\fP metadata is compatible with the version 2 that \fBdpkg\-source\fP
currently supports. The version of the \fBquilt\fP metadata is stored in
\fB.pc/.version\fP.
.TP
.B \-\-include\-removal
Do not ignore removed files and include them in the automatically
generated patch.
.TP
.B \-\-include\-timestamp
Include timestamp in the automatically generated patch.
.TP
.B \-\-include\-binaries
Add all modified binaries in the debian tarball. Also add them to
\fBdebian/source/include\-binaries\fP: they will be added by default
in subsequent builds and this option is thus no more needed.
.TP
.B \-\-no\-preparation
Do not try to prepare the build tree by applying patches which are
apparently unapplied (since dpkg 1.14.18).
.TP
.B \-\-single\-debian\-patch
Use \fBdebian/patches/debian\-changes\fP instead of
\fBdebian/patches/debian\-changes\-\fP\fIversion\fP for the name of the
automatic patch generated during build (since dpkg 1.15.5.4).
This option is particularly
useful when the package is maintained in a VCS and a patch set can't reliably
be generated. Instead the current diff with upstream should be stored in a
single patch. The option would be put in \fBdebian/source/local\-options\fP
and would be accompanied by a \fBdebian/source/local\-patch\-header\fP file
explaining how the Debian changes can be best reviewed, for example in the
VCS that is used.
.TP
.B \-\-create\-empty\-orig
Automatically create the main original tarball as empty if it's missing
and if there are supplementary original tarballs (since dpkg 1.15.6).
This option is meant to
be used when the source package is just a bundle of multiple upstream
software and where there's no “main” software.
.TP
.B \-\-no\-unapply\-patches, \-\-unapply\-patches
By default, \fBdpkg\-source\fP will automatically unapply the patches in the
\fB\-\-after\-build\fP hook if it did apply them during
\fB\-\-before\-build\fP (\fB\-\-unapply\-patches\fP since dpkg 1.15.8,
\fB\-\-no\-unapply\-patches\fP since dpkg 1.16.5).
Those options allow you to forcefully disable
or enable the patch unapplication process. Those options are only allowed
in \fBdebian/source/local\-options\fP so that all generated source
packages have the same behavior by default.
.TP
.B \-\-abort\-on\-upstream\-changes
The process fails if an automatic patch has been generated
(since dpkg 1.15.8).
This option
can be used to ensure that all changes were properly recorded in separate
\fBquilt\fP patches prior to the source package build. This option is not
allowed in \fBdebian/source/options\fP but can be used in
\fBdebian/source/local\-options\fP.
.TP
.B \-\-auto\-commit
The process doesn't fail if an automatic patch has been generated, instead
it's immediately recorded in the \fBquilt\fP series.

.PP
.B Extract options
.TP
.B \-\-skip\-debianization
Skips extraction of the debian tarball on top of the upstream sources
(since dpkg 1.15.1).
.TP
.B \-\-skip\-patches
Do not apply patches at the end of the extraction (since dpkg 1.14.18).
.
.SS Format: 3.0 (custom)
Supported since dpkg 1.14.17.
This format is special.
It doesn't represent a real source package
format but can be used to create source packages with arbitrary files.
.PP
.B Build options
.PP
All non-option arguments are taken as files to integrate in the
generated source package. They must exist and are preferably
in the current directory. At least one file must be given.
.TP
.BI \-\-target\-format= value
\fBRequired\fP. Defines the real format of the generated source package.
The generated .dsc file will contain this value in its \fBFormat\fP field
and not “3.0 (custom)”.
.
.SS Format: 3.0 (git)
Supported since dpkg 1.14.17.
This format is experimental.
.PP
A source package in this format consists of a
single bundle of a git repository \fB.git\fP to hold the source of a package.
There may also be a \fB.gitshallow\fP file listing revisions for a shallow
git clone.
.PP
.B Extracting
.PP
The bundle is cloned as a git repository to the target directory.
If there is a gitshallow file, it is installed as \fI.git/shallow\fP inside
the cloned git repository.
.PP
Note that by default the new repository will have the same branch checked
out that was checked out in the original source.
(Typically “master”, but it could be anything.)
Any other branches will be available under \fIremotes/origin/\fP.
.PP
.B Building
.PP
Before going any further, some checks are done to ensure that we
don't have any non-ignored uncommitted changes.
.PP
\fBgit\-bundle\fP(1) is used to generate a bundle of the git repository.
By default, all branches and tags in the repository are included in the
bundle.
.PP
.B Build options
.TP
.BI \-\-git\-ref= ref
Allows specifying a git ref to include in the git bundle. Use disables
the default behavior of including all branches and tags. May be specified
multiple times. The \fIref\fP can be the name of a branch or tag to
include. It may also be any parameter that can be passed to
\fBgit\-rev\-list\fP(1). For example, to include only
the master branch, use \fB\-\-git\-ref=\fPmaster. To include all tags and
branches, except for the private branch, use \fB\-\-git\-ref=\fP\-\-all
\fB\-\-git\-ref=\fP^private
.TP
.BI \-\-git\-depth= number
Creates a shallow clone with a history truncated to the specified number of
revisions.
.SS Format: 3.0 (bzr)
Supported since dpkg 1.14.17.
This format is experimental.
It generates a single tarball containing the bzr repository.
.PP
.B Extracting
.PP
The tarball is unpacked and then bzr is used to checkout the current
branch.
.PP
.B Building
.PP
Before going any further, some checks are done to ensure that we
don't have any non-ignored uncommitted changes.
.PP
Then the VCS specific part of the source directory is copied over to a
temporary directory. Before this temporary directory is packed in a tarball,
various cleanup are done to save space.
.SH DIAGNOSTICS
.SS no source format specified in debian/source/format
The file \fBdebian/source/format\fP should always exist and indicate the
desired source format. For backwards compatibility, format “1.0” is
assumed when the file doesn't exist but you should not rely on this:
at some point in the future \fBdpkg\-source\fP will be modified to fail
when that file doesn't exist.

The rationale is that format “1.0” is no longer the recommended format,
you should usually pick one of the newer formats (“3.0 (quilt)”, “3.0
(native)”) but \fBdpkg\-source\fP will not do this automatically for you.
If you want to continue using the old format, you should be explicit about
it and put “1.0” in \fBdebian/source/format\fP.
.SS the diff modifies the following upstream files
When using source format “1.0” it is usually a bad idea to modify
upstream files directly as the changes end up hidden and mostly
undocumented in the .diff.gz file. Instead you should store your changes
as patches in the debian directory and apply them at build-time. To avoid
this complexity you can also use the format “3.0 (quilt)” that offers
this natively.
.SS cannot represent change to \fIfile\fP
Changes to upstream sources are usually stored with patch files, but not
all changes can be represented with patches: they can only alter the
content of plain text files. If you try replacing a file with something of
a different type (for example replacing a plain file with a symlink or a
directory), you will get this error message.
.SS newly created empty file \fIfile\fB will not be represented in diff
Empty files can't be created with patch files. Thus this change is not
recorded in the source package and you are warned about it.
.SS executable mode \fIperms\fB of \fIfile\fB will not be represented in diff
Patch files do not record permissions of files and thus executable
permissions are not stored in the source package. This warning reminds you
of that fact.
.SS special mode \fIperms\fB of \fIfile\fB will not be represented in diff
Patch files do not record permissions of files and thus modified
permissions are not stored in the source package. This warning reminds you
of that fact.
.
.SH ENVIRONMENT
.TP
.B DPKG_COLORS
Sets the color mode (since dpkg 1.18.5).
The currently accepted values are: \fBauto\fP (default), \fBalways\fP and
\fBnever\fP.
.TP
.B DPKG_NLS
If set, it will be used to decide whether to activate Native Language Support,
also known as internationalization (or i18n) support (since dpkg 1.19.0).
The accepted values are: \fB0\fP and \fB1\fP (default).
.TP
.B SOURCE_DATE_EPOCH
If set, it will be used as the timestamp (as seconds since the epoch) to
clamp the mtime in the \fBtar\fP(5) file entries.
.TP
.B VISUAL
.TQ
.B EDITOR
Used by the “2.0” and “3.0 (quilt)” source format modules.
.TP
.B GIT_DIR
.TQ
.B GIT_INDEX_FILE
.TQ
.B GIT_OBJECT_DIRECTORY
.TQ
.B GIT_ALTERNATE_OBJECT_DIRECTORIES
.TQ
.B GIT_WORK_TREE
Used by the “3.0 (git)” source format modules.
.
.SH FILES
.SS debian/source/format
This file contains on a single line the format that should be used to
build the source package (possible formats are described above). No leading
or trailing spaces are allowed.
.SS debian/source/include\-binaries
This file contains a list of pathnames of binary files (one per line) relative
to the source root directory that should be included in the debian tarball.
Leading and trailing spaces are stripped.
Lines starting with ‘\fB#\fP’ are comments and are skipped.
Empty lines are ignored.
.SS debian/source/options
This file contains a list of long options that should be automatically
prepended to the set of command line options of a \fBdpkg\-source \-\-build\fR
or \fBdpkg\-source \-\-print\-format\fR call. Options like
\fB\-\-compression\fR and \fB\-\-compression\-level\fR are well suited for
this file.
.P
Each option should be put on a separate line. Empty lines and lines
starting with ‘\fB#\fP’ are ignored.
The leading ‘\fB\-\-\fP’ should be stripped and short options are
not allowed.
Optional spaces are allowed around the ‘\fB=\fP’ symbol and optional
quotes are allowed around the value.
Here's an example of such a file:
.P
  # let dpkg\-source create a debian.tar.bz2 with maximal compression
  compression = "bzip2"
  compression\-level = 9
  # use debian/patches/debian\-changes as automatic patch
  single\-debian\-patch
  # ignore changes on config.{sub,guess}
  extend-diff-ignore = "(^|/)(config\.sub|config\.guess)$"
.P
Note: \fBformat\fR options are not accepted in this file, you should
use \fBdebian/source/format\fR instead.
.SS debian/source/local\-options
Exactly like \fBdebian/source/options\fP except that the file is not
included in the generated source package. It can be useful to store
a preference tied to the maintainer or to the VCS repository where
the source package is maintained.
.SS debian/source/local\-patch\-header \fRand\fP debian/source/patch\-header
Free form text that is put on top of the automatic patch generated
in formats “2.0” or “3.0 (quilt)”. \fBlocal\-patch\-header\fP is not
included in the generated source package while \fBpatch\-header\fP is.
.SS debian/patches/\fIvendor\fP.series
.SS debian/patches/series
This file lists all patches that have to be applied (in the given order)
on top of the upstream source package. Leading and trailing spaces are
stripped.
The \fIvendor\fP will be the lowercase name of the current vendor, or
\fBdebian\fP if there is no vendor defined.
If the vendor-specific series file does not exist, the vendor-less series
file will be used.
Lines starting with ‘\fB#\fP’ are comments and are skipped.
Empty lines are ignored.
Remaining lines start with a patch filename (relative
to the \fBdebian/patches/\fP directory) up to the first space character or
the end of line. Optional \fBquilt\fP options can follow up to the end of line
or the first ‘\fB#\fP’ preceded by one or more spaces (which marks the
start of a comment up to the end of line).
.SH BUGS
The point at which field overriding occurs compared to certain
standard output field settings is rather confused.
.SH SEE ALSO
.BR deb\-src\-control (5),
.BR deb\-changelog (5),
.BR dsc (5).
