.\" dpkg manual page - dpkg-parsechangelog(1)
.\"
.\" Copyright © 1995-1996 Ian Jackson <ijackson@chiark.greenend.org.uk>
.\" Copyright © 2000 Wichert Akkerman <wakkerma@debian.org>
.\" Copyright © 2006, 2011-2015 Guillem Jover <guillem@debian.org>
.\" Copyright © 2007-2008 Frank Lichtenheld <djpig@debian.org>
.\" Copyright © 2009 Raphaël Hertzog <hertzog@debian.org>
.\"
.\" This is free software; you can redistribute it and/or modify
.\" it under the terms of the GNU General Public License as published by
.\" the Free Software Foundation; either version 2 of the License, or
.\" (at your option) any later version.
.\"
.\" This is distributed in the hope that it will be useful,
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\" GNU General Public License for more details.
.\"
.\" You should have received a copy of the GNU General Public License
.\" along with this program.  If not, see <https://www.gnu.org/licenses/>.
.
.TH dpkg\-parsechangelog 1 "%RELEASE_DATE%" "%VERSION%" "dpkg suite"
.ad l
.nh
.SH NAME
dpkg\-parsechangelog \- parse Debian changelog files
.
.SH SYNOPSIS
.B dpkg\-parsechangelog
.RI [ option ...]
.
.SH DESCRIPTION
.B dpkg\-parsechangelog
reads and parses the changelog of an unpacked Debian source tree and
outputs the information in it to standard output in a machine-readable
form.
.
.SH OPTIONS
.TP
.BR \-l ", " \-\-file " \fIchangelog-file\fP"
Specifies the changelog file to read information from.
A ‘\-’ can be used to specify reading from standard input.
The default is
.BR debian/changelog .
.TP
.BR \-F " \fIchangelog-format\fP"
Specifies the format of the changelog. By default the format is read
from a special line near the bottom of the changelog or failing that
defaults to the \fBdebian\fP standard format. See also
\fBCHANGELOG FORMATS\fP.
.TP
.BR \-L " \fIlibdir\fP"
Obsolete option without effect (since dpkg 1.18.8).
Setting the perl environment variables \fBPERL5LIB\fP or \fBPERLLIB\fP
has a similar effect when looking for the parser perl modules.
.TP
.BR \-S ", " \-\-show\-field " \fIfield\fP"
Specifies the name of the field to show (since dpkg 1.17.0).
The field name is not printed, only its value.
.TP
.BR \-? ", " \-\-help
Show the usage message and exit.
.TP
.BR \-\-version
Show the version and exit.
.SS Parser Options
The following options can be used to influence the output of
the changelog parser, e.g. the range of entries or the format
of the output.
.TP
.BI \-\-format " output-format"
Set the output format. Currently supported values are
.BR dpkg " and " rfc822 .
\fBdpkg\fP is the classic output format (from before this
option existed) and the default. It consists of one paragraph
in Debian control format (see \fBdeb\-control\fP(5)). If more
than one entry is requested, then most fields are taken from the
first entry (usually the most recent entry), except otherwise stated:
.RS
.TP
.BI Source: " pkg-name"
.TP
.BI Version: " version"
.TP
.BI Distribution: " target-distribution"
.TP
.BI Urgency: " urgency"
The highest urgency of all included entries is used, followed by the
concatenated (space-separated) comments from all the versions requested.
.TP
.BI Maintainer: " author"
.TP
.BI Date: " date"
The date of the entry as a string, as it appears in the changelog.
With a \fBstrptime\fP(3) format "\fB%a, %d %b %Y %T %z\fP", but where the
day of the week might not actually correspond to the real day obtained
from the rest of the date string.
If you need a more accurate representation of the date, use the
\fBTimestamp\fP field, but take into account it might not be possible to
map it back to the exact value in this field.
.TP
.BI Timestamp: " timestamp"
The date of the entry as a timestamp in seconds since the epoch
(since dpkg 1.18.8).
.TP
.BI Closes: " bug-number"
The Closes fields of all included entries are merged.
.TP
.BI Changes: " changelog-entries"
The text of all changelog entries is concatenated. To make
this field a valid Debian control format multiline field
empty lines are replaced with a single full stop and all lines
is intended by one space character. The exact content depends
on the changelog format.
.RE
.IP
The \fBVersion\fP, \fBDistribution\fP, \fBUrgency\fP, \fBMaintainer\fP and
\fBChanges\fP fields are mandatory.
.IP
There might be additional user-defined fields present.
.IP
The \fBrfc822\fP format uses the same fields but outputs
a separate paragraph for each changelog entry so that all
metadata for each entry is preserved.
.TP
.B \-\-reverse
Include all changes in reverse order (since dpkg 1.19.1).
Note: for the \fBdpkg\fP format the first entry will be the most ancient entry.
.TP
.B \-\-all
Include all changes. Note: other options have no effect when this is in use.
.TP
.BR \-s ", " \-\-since " \fIversion\fP"
.TQ
.BR \-v " \fIversion\fP"
Include all changes later than \fIversion\fP.
.TP
.BR \-u ", " \-\-until " \fIversion\fP"
Include all changes earlier than \fIversion\fP.
.TP
.BR \-f ", " \-\-from " \fIversion\fP"
Include all changes equal or later than \fIversion\fP.
.TP
.BR \-t ", " \-\-to " \fIversion\fP"
Include all changes up to or equal than \fIversion\fP.
.TP
.BR \-c ", " \-\-count " \fInumber\fP"
.TQ
.BR \-n " \fInumber\fP"
Include \fInumber\fP entries from the top (or the tail
if \fInumber\fP is lower than 0).
.TP
.BR \-o ", " \-\-offset " \fInumber\fP"
Change the starting point for \fB\-\-count\fP, counted from the top
(or the tail if \fInumber\fP is lower than 0).
.
.SH CHANGELOG FORMATS
It is possible to use a different format to the standard one, by providing
a parser for that alternative format.

In order to have \fBdpkg\-parsechangelog\fP run the new parser, a line must
be included within the last 40 lines of the changelog file, matching the Perl
regular expression: “\fB\\schangelog-format:\\s+([0-9a-z]+)\\W\fP”.
The part in parentheses should be the name of the format. For example:

       @@@ changelog-format: \fIotherformat\fP @@@

Changelog format names are non-empty strings of lowercase alphanumerics
(“a-z0-9”).

If such a line exists then \fBdpkg\-parsechangelog\fP will look for
the parser as a \fBDpkg::Changelog::\fP\fIOtherformat\fP perl module;
it is an error for it not being present.
The parser name in the perl module will be automatically capitalized.
The default changelog format is \fBdebian\fP, and a parser for it is
provided by default.

The parser should be derived from the Dpkg::Changelog class and implement
the required documented interface.

If the changelog format which is being parsed always or almost always
leaves a blank line between individual change notes, these blank lines
should be stripped out, so as to make the resulting output compact.

If the changelog format does not contain date or package name information
this information should be omitted from the output. The parser should not
attempt to synthesize it or find it from other sources.

If the changelog does not have the expected format the parser should
error out, rather than trying to muddle through and possibly generating
incorrect output.

A changelog parser may not interact with the user at all.
.
.SH NOTES
All \fBParser Options\fP except for \fB\-v\fP are only supported
since dpkg 1.14.16.
.PP
Short option parsing with non-bundled values available only since dpkg 1.18.0.
.
.SH ENVIRONMENT
.TP
.B DPKG_COLORS
Sets the color mode (since dpkg 1.18.5).
The currently accepted values are: \fBauto\fP (default), \fBalways\fP and
\fBnever\fP.
.TP
.B DPKG_NLS
If set, it will be used to decide whether to activate Native Language Support,
also known as internationalization (or i18n) support (since dpkg 1.19.0).
The accepted values are: \fB0\fP and \fB1\fP (default).
.
.SH FILES
.TP
.B debian/changelog
The changelog file, used to obtain version-dependent information about
the source package, such as the urgency and distribution of an upload,
the changes made since a particular release, and the source version
number itself.
.
.SH SEE ALSO
.BR deb\-changelog (5).
