.\" dpkg manual page - deb-symbols(5)
.\"
.\" Copyright © 2007-2012 Raphaël Hertzog <hertzog@debian.org>
.\" Copyright © 2011, 2013-2015 Guillem Jover <guillem@debian.org>
.\"
.\" This is free software; you can redistribute it and/or modify
.\" it under the terms of the GNU General Public License as published by
.\" the Free Software Foundation; either version 2 of the License, or
.\" (at your option) any later version.
.\"
.\" This is distributed in the hope that it will be useful,
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\" GNU General Public License for more details.
.\"
.\" You should have received a copy of the GNU General Public License
.\" along with this program.  If not, see <https://www.gnu.org/licenses/>.
.
.TH deb\-symbols 5 "%RELEASE_DATE%" "%VERSION%" "dpkg suite"
.ad l
.nh
.SH NAME
deb\-symbols \- Debian's extended shared library information file
.
.SH SYNOPSIS
symbols
.
.SH DESCRIPTION
The symbol files are shipped in Debian binary packages, and its format
is a subset of the template symbol files used by \fBdpkg\-gensymbols\fP(1)
in Debian source packages.
.P
The format for an extended shared library dependency information entry
in these files is:
.PP
.I library-soname main-dependency-template
.br
[| \fIalternative-dependency-template\fP]
.br
[...]
.br
[* \fIfield-name\fP: \fIfield-value\fP]
.br
[...]
 \fIsymbol\fP \fIminimal-version\fP [\fIid-of-dependency-template\fP]
.P
The \fIlibrary-soname\fR is exactly the value of the SONAME field
as exported by \fBobjdump\fR(1). A \fIdependency-template\fR is a
dependency where \fI#MINVER#\fR is dynamically replaced either by
a version check like “(>= \fIminimal-version\fR)” or by nothing (if
an unversioned dependency is deemed sufficient).
.P
Each exported \fIsymbol\fR (listed as \fIname\fR@\fIversion\fR, with
\fIversion\fR being “Base” if the library is not versioned) is associated
to a \fIminimal-version\fR of its dependency template (the main dependency
template is always used and will end up being combined with the dependency
template referenced by \fIid-of-dependency-template\fR if present). The
first alternative dependency template is numbered 1, the second one 2,
etc.
.P
Each entry for a library can also have some fields of meta-information.
Those fields are stored on lines starting with an asterisk. Currently,
the only valid fields are:
.TP
.B Build\-Depends\-Package
It indicates the name of the “\-dev” package associated to the library
and is used by \fBdpkg\-shlibdeps\fP to make sure that the dependency
generated is at least as strict as the corresponding build dependency
(since dpkg 1.14.13).
.TP
.B Build\-Depends\-Packages
The same as \fBBuild\-Depends\-Package\fP but accepts a comma-separated
list of package names (since dpkg 1.20.0).
This field will override any \fBBuild\-Depends\-Package\fP field present,
and is mostly useful with “\-dev” packages and metapackages depending
on these, say for a transition period.
.TP
.B Ignore\-Blacklist\-Groups
It indicates what blacklist groups should be ignored, as a whitespace
separated list, so that the symbols contained in those groups get
included in the output file (since dpkg 1.17.6).
This should only be necessary for toolchain
packages providing those blacklisted symbols. The available groups are
system dependent, for ELF and GNU-based systems these are \fBaeabi\fP
and \fBgomp\fP.
.SH EXAMPLES
.SS Simple symbols file
.PP
libftp.so.3 libftp3 #MINVER#
 DefaultNetbuf@Base 3.1-1-6
 FtpAccess@Base 3.1-1-6
 [...]
.SS Advanced symbols file
.PP
libGL.so.1 libgl1
.br
| libgl1\-mesa\-glx #MINVER#
.br
* Build\-Depends\-Package: libgl1\-mesa\-dev
 publicGlSymbol@Base 6.3-1
 [...]
 implementationSpecificSymbol@Base 6.5.2-7 1
 [...]
.SH SEE ALSO
.BR https://wiki.debian.org/Projects/ImprovedDpkgShlibdeps
.br
.BR dpkg\-shlibdeps (1),
.BR dpkg\-gensymbols (1).
