.\" dpkg manual page - update-alternatives(1)
.\"
.\" Copyright © 1997-1998 Charles Briscoe-Smith
.\" Copyright © 1999 Ben Collins <bcollins@debian.org>
.\" Copyright © 2000 Wichert Akkerman <wakkerma@debian.org>
.\" Copyright © 2003 Adam Heath <doogie@debian.org>
.\" Copyright © 2005 Scott James Remnant <scott@netsplit.com>
.\" Copyright © 2006-2015 Guillem Jover <guillem@debian.org>
.\" Copyright © 2008 Pierre Habouzit <madcoder@debian.org>
.\" Copyright © 2009-2011 Raphaël Hertzog <hertzog@debian.org>
.\"
.\" This is free software; you can redistribute it and/or modify
.\" it under the terms of the GNU General Public License as published by
.\" the Free Software Foundation; either version 2 of the License, or
.\" (at your option) any later version.
.\"
.\" This is distributed in the hope that it will be useful,
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\" GNU General Public License for more details.
.\"
.\" You should have received a copy of the GNU General Public License
.\" along with this program.  If not, see <https://www.gnu.org/licenses/>.
.
.\"*******************************************************************
.\"
.\" This file was generated with po4a. Translate the source file.
.\"
.\"*******************************************************************
.TH update\-alternatives 1 %RELEASE_DATE% %VERSION% dpkg\-Programmsammlung
.nh
.SH BEZEICHNUNG
update\-alternatives \- Verwaltung symbolischer Links zur Bestimmung von
Standardwerten für Befehle
.
.SH ÜBERSICHT
\fBupdate\-alternatives\fP [\fIOption\fP …] \fIBefehl\fP
.
.SH BESCHREIBUNG
\fBupdate\-alternatives\fP erzeugt, entfernt, verwaltet und zeigt die
Informationen über die symbolischen Links, die das »Debian
Alternativ\-System« bilden, an.
.PP
Es ist möglich, mehrere Programme, die die gleiche oder ähnliche
Funktionalität bereitstellen, gleichzeitig auf einem System zu
installieren. Beispielsweise sind auf vielen Systemen mehrere Texteditoren
gleichzeitig installiert. Dies gibt den Benutzern eines Systems die
Möglichkeit, falls gewünscht, jeweils einen anderen Editor zu verwenden,
allerdings wird es damit für ein Programm schwierig, eine gute Wahl für
einen Editor zum Starten zu treffen, falls der Benutzer keine spezielle Wahl
getroffen hat.
.PP
Debians Alternativ\-System hat das Ziel, dieses Problem zu lösen. Ein
generischer Name im Dateisystem wird von allen Dateien, die austauschbare
Funktionalität bereitstellen, verwendet. Das Alternativ\-System bestimmt
zusammen mit dem Systemadministrator welche Datei tatsächlich durch diesen
generischen Namen referenziert wird. Falls beispielsweise sowohl der
Texteditor \fBed\fP(1) als auch \fBnvi\fP(1) im System installiert sind, wird das
Alternativ\-System dafür sorgen, dass der generische Name \fI/usr/bin/editor\fP
standardmäßig auf \fI/usr/bin/nvi\fP zeigt. Der Systemadministrator kann dies
Ändern und dafür sorgen, dass er stattdessen auf \fI/usr/bin/ed\fP zeigt, und
das Alternativ\-System wird diese Einstellung nicht verändern, bis es
explizit dazu aufgefordert wird.
.PP
Der generische Name ist nicht ein direkter symbolischer Link auf die
ausgewählte Alternative. Stattdessen ist es ein symbolischer Link auf einen
Namen im \fIAlternativ\-Verzeichnis\fP, welches wiederum ein symbolischer Link
auf die tatsächlich referenzierte Datei ist. Dies ist so realisiert, damit
die Änderungen des Systemadministrators auf das \fI%CONFDIR%\fP Verzeichnis
beschränkt bleiben: der FHS (siehe dort) erklärt warum dies eine Gute Idee
ist.
.PP
Für jedes Paket, das eine Datei mit einer bestimmten Funktionalität
bereitstellt, wird bei der Installation, der Änderung oder der Entfernung
\fBupdate\-alternatives\fP aufgerufen, um die Informationen über diese Datei im
Alternativ\-System zu aktualisieren. \fBupdate\-alternatives\fP wird gewöhnlich
vom Skript \fBpostinst\fP (configure) oder \fBprerm\fP (remove und deconfigure)
eines Debian\-Paketes aufgerufen.
.PP
Es ist oft sinnvoll, dass eine Reihe von Alternativen synchronisiert werden,
so dass sie als Gruppe geändert werden; wenn beispielsweise mehrere
Versionen des \fBvi\fP(1) Editors installiert sind, sollte die Handbuchseite,
die durch \fI/usr/share/man/man1/vi.1\fP referenziert wird, zu dem ausführbaren
Programm, dass durch \fI/usr/bin/vi\fP referenziert wird,
gehören. \fBupdate\-alternatives\fP erledigt dies mit Hilfe von \fIMaster\-\fP und
\fISlave\-Links\fP; wird der Master\-Link geändert, wird auch jeder zugehörige
Slave\-Link geändert. Ein Master\-Link und seine zugehörigen Slave\-Links
bilden zusammen eine \fILink\-Gruppe\fP.
.PP
Eine Linkgruppe ist zu jeder Zeit in einem der beiden Modi: automatisch oder
manuell. Ist eine Gruppe im automatischen Modus, dann wird das
Alternativ\-System bei der Paketinstallation und \-entfernung automatisch
entscheiden, ob und wie die Links aktualisiert werden. Im manuellen Modus
wird das Alternativ\-System die Wahl des Administrators beibehalten und
Änderungen der Links vermeiden (außer irgendetwas ist defekt).
.PP
Beim erstmaligen Einführen in das System befindet sich eine Linkgruppe im
automatischen Modus. Führt der Systemadministrator Änderungen an den
automatischen Einstellungen des Systems durch, wird dies beim nächsten
Aufruf von \fBupdate\-alternatives\fP auf die Linkgruppe bemerkt und die Gruppe
wird automatisch in den manuellen Modus umgeschaltet.
.PP
Jede Alternative hat eine ihr zugeordnete \fIPriorität\fP. Befindet sich eine
Linkgruppe im automatischen Modus, zeigen die Mitglieder einer Gruppe auf
die Alternative mit der höchsten Priorität.
.PP
Wird die \fB\-\-config\fP\-Option verwendet, dann zeigt \fBupdate\-alternatives\fP
alle Auswahlmöglichkeiten für die Link\-Gruppe an, für die der gegebene
\fIName\fP der Master\-Alternative\-Name ist. Die aktuelle Auswahl ist mit ‚*’
markiert. Sie werden dann aufgefordert, Ihre Auswahl bezüglich der
Linkgruppe anzugeben. Abhängig von der getroffenen Auswahl könnte sich die
Link\-Gruppe nicht mehr im \fIautomatischen\fP Modus befinden. Sie müssen dann
die Option \fB\-\-auto\fP verwenden, um wieder in den automatischen Zustand
zurückzukehren (oder Sie können \fB\-\-config\fP erneut ausführen und den als
automatisch markierten Eintrag auswählen).
.PP
Falls Sie nicht\-interaktiv konfigurieren möchten, können Sie stattdessen die
Option \fB\-\-set\fP verwenden (siehe unten).
.PP
Verschiedene Pakete, die die gleiche Datei bereitstellen, müssen dies
\fBkooperativ\fP durchführen. Anders gesagt ist in diesem Fall die Verwendung
von \fBupdate\-alternatives\fP für alle beteiligten Pakete \fBzwingend\fP. Es ist
nicht möglich, sich über eine Datei in einem Paket hinwegzusetzen, welches
den \fBupdate\-alternatives\fP\-Mechanismus nicht verwendet.
.
.SH BEGRIFFE
Da die Tätigkeiten von \fBupdate\-alternatives\fP recht komplex sind, sollen
einige spezielle Begriffe helfen, seine Vorgehensweise zu erläutern.
.TP 
generischer Name (oder Alternativ\-Link)
Ein Name wie \fI/usr/bin/editor\fP, der sich über das Alternativ\-System auf
eine Reihe von Dateien mit ähnlicher Funktionalität bezieht.
.TP 
Alternativ\-Name
Der Name eines symbolischen Links im Alternativ\-Verzeichnis.
.TP 
Alternative (oder Alternativ\-Pfad)
Der Name einer speziellen Datei im Dateisystem, die mittels eines
generischen Namens über das Alternativ\-System zugreifbar gemacht werden
kann.
.TP 
Alternativ\-Verzeichnis
Ein Verzeichnis, standardmäßig \fI%CONFDIR%/alternatives\fP, das die Symlinks
enthält.
.TP 
administratives Verzeichnis
Ein Verzeichnis, standardmäßig \fI%ADMINDIR%/alternatives\fP, das die
\fBupdate\-alternatives\fP Zustandsinformationen enthält.
.TP 
Linkgruppe
Ein Satz zusammengehörender Symlinks, die als Gruppe aktualisiert werden
sollen.
.TP 
Master\-Link
Der Alternativ\-Link in einer Linkgruppe der bestimmt, wie die anderen Links
in der Gruppe konfiguriert werden.
.TP 
Slave\-Link
Ein Alternativ\-Link in einer Linkgruppe, der durch die Einstellung des
Master\-Links gesteuert wird.
.TP 
automatischer Modus
Ist eine Linkgruppe im automatischen Modus, dann sorgt das Alternativ\-System
dafür, dass die Links in der Gruppe auf die für die Gruppe passende
Alternative mit der höchsten Priorität zeigen.
.TP 
manueller Modus
Ist eine Linkgruppe im manuellen Modus, dann führt das Alternativ\-System
keine Änderungen an den Einstellungen des Systemadministrators durch.
.
.SH BEFEHLE
.TP 
\fB\-\-install\fP \fILink Name Pfad Priorität\fP [\fB\-\-slave\fP \fILink Name Pfad\fP] …
Füge eine Gruppe von Alternativen zum System hinzu. \fILink\fP ist der
generische Name des Master\-Links, \fIName\fP ist der Name seines Symlinks im
Alternativ\-Verzeichnis und \fIPfad\fP ist die Alternative, die für den
Master\-Link eingeführt wird. Die Argumente nach \fB\-\-slave\fP sind der
generische Name, Symlink\-Name in dem Alternativ\-Verzeichnis und der
Alternativ\-Pfad für den Slave\-Link. Null oder mehrere \fB\-\-slave\fP\-Optionen,
jede von drei Argumenten gefolgt, können spezifiziert werden. Beachten Sie,
dass die Master\-Alternative existieren muss, ansonsten schlägt der Aufruf
fehl. Falls allerdings eine Slave\-Alternative nicht existiert wird der
zugehörige Slave\-Alternative\-Link einfach nicht installiert (es wird noch
eine Warnung ausgegeben). Falls eine echte Datei an einer Stelle installiert
wird, an der ein Alternativ\-Link installiert werden muss, wird diese
beibehalten, solange \fB\-\-force\fP nicht verwandt wird.
.IP
Falls der angegebene Alternativ\-Name bereits in den Aufzeichnungen des
Alternativ\-Systems existiert, werden die angegebenen Informationen als neuer
Satz von Alternativen für die Gruppe hinzugefügt. Andernfalls wird eine neue
Gruppe, eingestellt im automatischen Modus, mit dieser Information
hinzugefügt. Falls die Gruppe sich im automatischen Modus befindet und die
Priorität der neu hinzugefügten Alternative höher ist als die jeder anderen
installierten Alternative für diese Gruppe werden die Symlinks aktualisiert,
so dass sie auf die neu hinzugefügte Alternative zeigen.
.TP 
\fB\-\-set\fP \fIName Pfad\fP
Setzt das Programm \fIPfad\fP als Alternative für \fIName\fP. Dies ist äquivalent
zu \fB\-\-config\fP, ist aber nicht interaktiv und kann somit geskriptet werden.
.TP 
\fB\-\-remove\fP \fIName Pfad\fP
Entferne eine Alternative und alle zugehörigen Slave\-Links. \fIName\fP ist ein
Name im Alternativ\-Verzeichnis, und \fIPfad\fP ist ein absoluter Dateiname zu
dem \fIName\fP gelinkt werden könnte. Falls \fIName\fP tatsächlich nach \fIPfad\fP
gelinkt ist, dann wird \fIName\fP aktualisiert, um auf eine andere geeignete
Alternative zu zeigen (und die Gruppe wird wieder in den automatischen Modus
versetzt) oder entfernt, falls keine solche Alternative übrig
bleibt. Zugehörige Slave\-Links werden entsprechend aktualisiert oder
entfernt. Falls der Link derzeit nicht auf \fIPfad\fP zeigt, werden keine Links
geändert; nur die Information über die Alternative wird entfernt.
.TP 
\fB\-\-remove\-all\fP \fIName\fP
Entferne alle Alternativen und deren zugehörige Slave\-Links. \fIName\fP ist ein
Name im Alternativ\-Verzeichnis.
.TP 
\fB\-\-all\fP
Ruft \fB\-\-config\fP für alle Alternativen auf. In der Kombination mit
\fB\-\-skip\-auto\fP kann dies nützlich sein, um alle Alternativen zu prüfen und
zu konfigurieren, die sich nicht im automatischen Modus befinden. Defekte
Alternativen werden auch angezeigt. Um alle defekten Alternativen zu
reparieren dient daher ein einfacher Aufruf von \fByes \*(rq |
update\-alternatives \-\-force \-\-all\fP.
.TP 
\fB\-\-auto\fP \fIName\fP
Überführt die Linkgruppe hinter der Alternative mit Name \fIName\fP in den
automatischen Modus. Bei diesem Prozess werden der Master\-Symlink und seine
Slave\-Links aktualisiert, um auf die installierte Alternative mit höchster
Priorität zu zeigen.
.TP 
\fB\-\-display\fP \fIName\fP
Zeige Informationen über die Linkgruppe an. Die angezeigten Informationen
enthalten den Modus der Gruppe (automatisch oder manuell), die Master\- und
Slave\-Links, auf welche Alternative der Master\-Link derzeit zeigt, welche
weiteren Alternativen zur Verfügung stehen (und ihre zugehörigen
Slave\-Alternativen), und die installierte Alternative mit der höchsten
Priorität.
.TP 
\fB\-\-get\-selections\fP
Führe alle Master\-Alternativ\-Namen (die eine Linkgruppe steuern) mit ihrem
Status auf (seit Version 1.15.0). Jede Zeile enthält bis zu 3 Felder
(getrennt durch mindestens ein Leerzeichen). Im ersten Feld steht der
Alternativ\-Name, im zweiten der Status (entweder \fBauto\fP oder \fBmanual\fP) und
im letzten die derzeitige Wahl der Alternative (Achtung: Dies ist ein
Dateiname, der Leerzeichen enthalten kann).
.TP 
\fB\-\-set\-selections\fP
Lese eine Konfiguration von Alternativen über die Standardeingabe im von
»\fB\-\-get\-selections\fP« generierten Format und konfiguriere die Alternativen
entsprechend neu (seit Version 1.15.0).
.TP 
\fB\-\-query\fP \fIName\fP
Zeige alle Informationen über die Linkgruppe an, wie dies auch von
\fB\-\-display\fP erfolgt, allerdings in einem maschinenlesbaren Format (seit
Version 1.15.0, siehe Abschnitt \fBABFRAGE\-FORMAT\fP unten).
.TP 
\fB\-\-list\fP \fIName\fP
Zeige alle Ziele der Linkgruppe an.
.TP 
\fB\-\-config\fP \fIName\fP
Zeige die verfügbaren Alternativen für eine Linkgruppe an und erlaube es dem
Benutzer interaktiv auszuwählen, welche zu benutzen ist. Die Linkgruppe wird
aktualisiert.
.TP 
\fB\-\-help\fP
Zeige den Bedienungshinweis und beende.
.TP 
\fB\-\-version\fP
Gebe die Version aus und beende sich.
.
.SH OPTIONEN
.TP 
\fB\-\-altdir\fP\fI Verzeichnis\fP
Spezifiziert das Alternativ\-Verzeichnis, wenn sich dieses von der
Standardeinstellung unterscheiden soll.
.TP 
\fB\-\-admindir\fP\fI Verzeichnis\fP
Spezifiziert das administrative Verzeichnis, wenn sich dieses von der
Standardeinstellung unterscheiden soll.
.TP 
\fB\-\-log\fP\fI Datei\fP
Gibt die Protokolldatei an (seit Version 1.15.0), wenn diese sich von der
Vorgabe (%LOGDIR%/alternatives.log) unterscheiden soll.
.TP 
\fB\-\-force\fP
Erlaubt die Ersetzung oder Entfernung von echten Dateien, die sich an
Stellen befinden, an denen ein Alternativ\-Link installiert werden muss.
.TP 
\fB\-\-skip\-auto\fP
Überspringt die Konfigurationsabfrage für Alternativen, die korrekt im
automatische Modus konfiguriert sind. Diese Option ist nur mit \fB\-\-config\fP
oder \fB\-\-all\fP relevant.
.TP 
\fB\-\-quiet\fP
Do not generate any comments unless errors occur.
.TP 
\fB\-\-verbose\fP
Erzeugt mehr Kommentare darüber, was getan wird.
.TP 
\fB\-\-debug\fP
Generate even more comments, helpful for debugging, about what is being done
(since version 1.19.3).
.
.SH RÜCKGABEWERT
.TP 
\fB0\fP
Die angeforderte Aktion wurde erfolgreich ausgeführt.
.TP 
\fB2\fP
Beim Lesen der Befehlszeile oder beim Ausführen der Aktion traten Probleme
auf.
.
.SH UMGEBUNG
.TP 
\fBDPKG_ADMINDIR\fP
Falls gesetzt und die Option \fB\-\-admindir\fP nicht angegeben wurde, wird dies
als Basis\-Administrationsverzeichnis verwandt.
.
.SH DATEIEN
.TP 
\fI%CONFDIR%/alternatives/\fP
Das standardmäßige Alternativ\-Verzeichnis. Kann mittels der Option
\fB\-\-altdir\fP geändert werden.
.TP 
\fI%ADMINDIR%/alternatives/\fP
Das standardmäßige administrative Verzeichnis. Kann mittels der
\fB\-\-admindir\fP Option geändert werden.
.
.SH ABFRAGE\-FORMAT
Das Format von \fB\-\-query\fP ist ein RFC822\-artiges, flaches Format. Es besteht
aus \fIn\fP+1 Blöcken, wobei \fIn\fP die Anzahl der in einer abgefragten
Linkgruppe verfügbaren Alternativen ist. Der erste Block enthält die
folgenden Felder:
.TP 
\fBName:\fP\fI Name\fP
Der alternative Name im Alternativ\-Verzeichnis.
.TP 
\fBLink:\fP\fI Link\fP
Der generische Name der Alternative.
.TP 
\fBSlaves:\fP\fI Liste\-von\-Slaves\fP
Wenn diese Feld vorhanden ist enthält die \fBnächste\fP Zeile alle Slave\-Links,
die dem Masterlink dieser Alternativen zugeordnet sind. Pro Zeile wird ein
Slave aufgeführt. Jede Zeile enthält ein Leerzeichen, den generischen Namen
des Slaves, ein weiteres Leerzeichen und den Pfad zu dem Slave\-Link.
.TP 
\fBStatus:\fP\fI Status\fP
Der Status der Alternative (\fBauto\fP oder \fBmanual\fP).
.TP 
\fBBest:\fP\fI beste\-Wahl\fP
Der Pfad der besten Alternative für diese Linkgruppe. Nicht vorhanden, falls
keine Alternative verfügbar ist.
.TP 
\fBValue:\fP\fI derzeit\-ausgewählte\-Alternative\fP
Der Pfad der derzeit ausgewählten Alternative. Es akzeptiert auch den
magischen Wert \fBnone\fP, der verwandt wird, falls der Link nicht existiert.
.PP
Die anderen Blöcke beschreiben die verfügbaren Alternativen in der
abgefragten Linkgruppe:
.TP 
\fBAlternative:\fP\fI Pfad\-dieser\-Alternativen\fP
Pfad zum Block dieser Alternativen.
.TP 
\fBPriority:\fP\fI Prioritätswert\fP
Wert der Priorität dieser Alternativen.
.TP 
\fBSlaves:\fP\fI Liste\-von\-Slaves\fP
Wenn dieses Feld vorhanden ist enthält die \fBnächste\fP Zeile alle
Slave\-Alternativen, die dem Masterlink dieser Alternativen zugeordnet
sind. Pro Zeile wird ein Slave aufgeführt. Jede Zeile enthält ein
Leerzeichen, den generischen Namen des Slaves, ein weiteres Leerzeichen und
den Pfad zu der Slave\-Alternative.
.
.SS Beispiel
.nf
$ update\-alternatives \-\-query editor
Name: editor
Link: /usr/bin/editor
Slaves:
 editor.1.gz /usr/share/man/man1/editor.1.gz
 editor.fr.1.gz /usr/share/man/fr/man1/editor.1.gz
 editor.it.1.gz /usr/share/man/it/man1/editor.1.gz
 editor.pl.1.gz /usr/share/man/pl/man1/editor.1.gz
 editor.ru.1.gz /usr/share/man/ru/man1/editor.1.gz
Status: auto
Best: /usr/bin/vim.basic
Value: /usr/bin/vim.basic

Alternative: /bin/ed
Priority: \-100
Slaves:
 editor.1.gz /usr/share/man/man1/ed.1.gz

Alternative: /usr/bin/vim.basic
Priority: 50
Slaves:
 editor.1.gz /usr/share/man/man1/vim.1.gz
 editor.fr.1.gz /usr/share/man/fr/man1/vim.1.gz
 editor.it.1.gz /usr/share/man/it/man1/vim.1.gz
 editor.pl.1.gz /usr/share/man/pl/man1/vim.1.gz
 editor.ru.1.gz /usr/share/man/ru/man1/vim.1.gz
.fi
.
.SH DIAGNOSE
Mit \fB\-\-verbose\fP quatscht \fBupdate\-alternatives\fP ohne Unterlass über seine
Aktivitäten auf seinem Standardausgabekanal. Falls Probleme auftreten, gibt
\fBupdate\-alternatives\fP eine Fehlermeldung auf seinem Standardfehlerkanal aus
und beendet sich mit dem Exit\-Status 2. Die Diagnostiken sollten
selbsterklärend sein; falls Sie dies nicht so empfinden, melden Sie dies
bitte als Fehler.
.
.SH BEISPIELE
Es gibt mehrere Pakete, die einen zum \fBvi\fP\-kompatiblen Texteditor
bereitstellen, beispielsweise \fBnvi\fP und \fBvim\fP. Welcher benutzt wird, wird
durch die Linkgruppe \fBvi\fP eingestellt, welche Links für das Programm selber
und die zugehörige Handbuchseite beinhaltet.
.PP
Um alle verfügbaren Programme anzuzeigen, die \fBvi\fP bereitstellen, und die
dazu gehörigen Einstellungen, benutzen Sie die Aktion \fB\-\-display\fP:
.PP
.RS
\fBupdate\-alternatives \-\-display vi\fP
.RE
.PP
Um eine bestimmte \fBvi\fP\-Implementation auszuwählen, benutzen Sie als Root
den folgenden Befehl und wählen dann eine Zahl aus der Liste aus:
.PP
.RS
\fBupdate\-alternatives \-\-config vi\fP
.RE
.PP
Um zur automatischen Auswahl der \fBvi\fP\-Implementation zurückzukehren, führen
Sie folgendes als Root aus:
.PP
.RS
\fBupdate\-alternatives \-\-auto vi\fP
.RE
.
.SH "SIEHE AUCH"
\fBln\fP(1), FHS, der Dateisystem Hierarchie\-Standard (Filesystem Hierarchy
Standard).
.SH ÜBERSETZUNG
Die deutsche Übersetzung wurde 2004, 2006-2018 von Helge Kreutzmann
<debian@helgefjell.de>, 2007 von Florian Rehnisch <eixman@gmx.de> und
2008 von Sven Joachim <svenjoac@gmx.de>
angefertigt. Diese Übersetzung ist Freie Dokumentation; lesen Sie die
GNU General Public License Version 2 oder neuer für die Kopierbedingungen.
Es gibt KEINE HAFTUNG.
