.\" dselect manual page - dselect(1)
.\"
.\" Copyright © 1995 Juho Vuori <javuori@cc.helsinki.fi>
.\" Copyright © 2000 Josip Rodin
.\" Copyright © 2001 Joost Kooij
.\" Copyright © 2001 Wichert Akkerman <wakkerma@debian.org>
.\" Copyright © 2010-2015 Guillem Jover <guillem@debian.org>
.\"
.\" This is free software; you can redistribute it and/or modify
.\" it under the terms of the GNU General Public License as published by
.\" the Free Software Foundation; either version 2 of the License, or
.\" (at your option) any later version.
.\"
.\" This is distributed in the hope that it will be useful,
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\" GNU General Public License for more details.
.\"
.\" You should have received a copy of the GNU General Public License
.\" along with this program.  If not, see <https://www.gnu.org/licenses/>.
.
.\"*******************************************************************
.\"
.\" This file was generated with po4a. Translate the source file.
.\"
.\"*******************************************************************
.TH dselect 1 %RELEASE_DATE% %VERSION% "suite dpkg"
.nh
.SH NOM
dselect \- Interface de gestion de paquets Debian.
.
.SH SYNOPSIS
\fBdselect\fP [\fIoption\fP...] [\fIcommand\fP...]
.
.SH DESCRIPTION
\fBdselect\fP est une des principales interfaces de gestion des paquets sur un système Debian. À partir du menu principal de \fBdselect\fP, l'administrateur système peut\ :
 \- Mettre à jour la liste des versions des paquets disponibles,
 \- Voir l'état des paquets installés ou disponibles,
 \- Modifier les sélections de paquets et gérer les dépendances,
 \- Installer de nouveaux paquets ou mettre à jour vers de nouvelles versions.
.PP
\fBdselect\fP est une interface au dessus de \fBdpkg\fP(1), l'outil bas niveau de
gestion des paquets Debian. Il propose à l'écran un gestionnaire de
sélections de paquets avec la possibilité de résoudre les conflits et
dépendances. Exécuté avec les droits administrateur, il permet d'installer
des paquets, les mettre à jour ou les retirer. Plusieurs méthodes d'accès
peuvent être configurées pour récupérer les informations sur les versions
des paquets disponibles et les paquets eux\-mêmes dans les dépôts de
paquets. Suivant la méthode d'accès utilisée, ces dépôts peuvent être des
serveurs d'archives publics sur Internet, des serveurs locaux ou des
CDROM. La méthode d'accès recommandée est \fIapt\fP, qui est fournie par le
paquet \fBapt\fP.
.PP
Normally \fBdselect\fP is invoked without parameters. An interactive menu is
presented, offering the user a list of commands. If a command is given as
argument, then that command is started immediately. Several command line
parameters are still available to modify the running behaviour of \fBdselect\fP
or show additional information about the program.
.
.SH OPTIONS
All options can be specified both on the command line and in the \fBdselect\fP
configuration file \fI%PKGCONFDIR%/dselect.cfg\fP or the files on the
configuration directory \fI%PKGCONFDIR%/dselect.cfg.d/\fP. Each line in the
configuration file is either an option (exactly the same as the command line
option but without leading hyphens) or a comment (if it starts with a
‘\fB#\fP’).
.br
.TP 
\fB\-\-admindir\fP\fI répertoire\fP
Changes the directory where the dpkg ‘\fIstatus\fP’, ‘\fIavailable\fP’ and similar
files are located.  This defaults to \fI%ADMINDIR%\fP and normally there
shouldn't be any need to change it.
.TP 
\fB\-D\fP\fIfile\fP, \fB\-\-debug\fP \fIfile\fP
Activer le débogage. Les informations de débogage sont envoyées dans
\fIfichier\fP.
.TP 
\fB\-\-expert\fP
Activer le mode expert, c'est\-à\-dire ne pas afficher les messages d'aide
ennuyeux.
.TP 
\fB\-\-colour\fP|\fB\-\-color\fP \fIscreenpart\fP:[\fIforeground\fP],[\fIbackground\fP][:\fIattr\fP[\fI+attr\fP]...]
Configure les couleurs des écrans. Cela ne fonctionne que si votre terminal
gère les couleurs. Cette option peut\-être utilisée plusieurs fois (et il est
préférable de l'utiliser dans \fIdselect.cfg\fP). Chaque utilisation change la
couleur (et, en option, d'autres attributs) d'une partie de l'écran. Les
parties de l'écran (de haut en bas) sont\ :
.RS
.TP 
\fBtitle\fP
Le titre de l'écran.
.TP 
\fBlisthead\fP
La ligne d'en\-tête au dessus de la liste de paquets.
.TP 
\fBlist\fP
La liste déroulante de paquets (et de textes explicatifs).
.TP 
\fBlistsel\fP
L'élément sélectionné dans la liste.
.TP 
\fBpkgstate\fP
Dans la liste des paquets, le texte qui indique l'état actuel de chaque
paquet.
.TP 
\fBpkgstatesel\fP
Dans la liste des paquets, le texte qui indique l'état actuel du paquet
sélectionné.
.TP 
\fBinfohead\fP
La ligne d'en\-tête qui affiche l'état du paquet sélectionné.
.TP 
\fBinfodesc\fP
La description courte du paquet.
.TP 
\fBinfo\fP
Utilisé pour afficher les informations sur le paquet, comme par exemple la
description du paquet.
.TP 
\fBinfofoot\fP
La dernière ligne de l'écran lors de la sélection des paquets.
.TP 
\fBquery\fP
Utilisé pour les lignes des recherches.
.TP 
\fBhelpscreen\fP
La couleur des écrans d'aide.
.RE
.IP
Après la partie de l'écran concernée, vient un signe deux\-points et la
spécification des couleurs. Pour surcharger les valeurs des couleurs
compilées, vous pouvez indiquer la couleur du premier plan, de
l'arrière\-plan, ou les deux. Utilisez les noms standard de couleurs curses.
.IP
Optionally, after the color specification is another colon, and an attribute
specification. This is a list of one or more attributes, separated by plus
(‘+’) characters.  Available attributes include (not all of these will work
on all terminals): \fBnormal\fP, \fBstandout\fP, \fBunderline\fP, \fBreverse\fP,
\fBblink\fP, \fBbright\fP, \fBdim\fP, \fBbold\fP
.TP 
\fB\-?\fP, \fB\-\-help\fP
Affiche une aide rapide et se termine normalement.
.TP 
\fB\-\-version\fP
Affiche la version et se termine normalement.
.
.SH COMMANDES
When \fBdselect\fP is started it can perform the following commands, either
directly if it was specified on the command line or by prompting the user
with a menu of available commands if running interactively:
.SS "Accéder (access)"
Choisir et configurer une méthode d'accès aux dépôts de paquets.
.sp
Par défaut, \fBdselect\fP fournit plusieurs méthodes telles que \fIcdrom\fP,
\fImulti_cd\fP, \fInfs\fP, \fImulti_nfs\fP, \fIharddisk\fP, \fImounted\fP, \fImulti_mount\fP,
\fIfloppy\fP ou \fIftp\fP, mais d'autres paquets peuvent fournir des méthodes
supplémentaires, comme la méthode d'accès \fIapt\fP fournie par le paquet
\fBapt\fP.
.sp
L'utilisation de la méthode d'accès \fIapt\fP est fortement conseillée.
.sp
.SS "Mise à jour (update)"
Rafraîchir la liste des paquets disponibles.
.sp
Récupère une liste de versions de paquets disponibles depuis un dépôt de
paquets, qui a été configuré pour la méthode d'accès actuelle, puis met à
jour la base de données de dpkg. Les listes de paquets sont d'habitude
fournies par les dépôts sous la forme de fichiers \fIPackages\fP ou
\fIPackages.gz\fP. Ces fichiers peuvent être générés par les responsables des
dépôts grâce au programme \fBdpkg\-scanpackages\fP(1).
.sp
Details of the update command depend on the access method's implementation.
Normally the process is straightforward and requires no user interaction.
.sp
.SS "Sélectionner (select)"
Voir ou gérer les paquets sélectionnés et les dépendances.
.sp
Il s'agit de la fonction principale de \fBdselect\fP. Dans l'écran de
sélection, l'utilisateur peut consulter la liste de tous les paquets
disponibles ou installés. Exécuté avec les privilèges administrateur, il
permet également de changer de façon interactive l'état de paquets
sélectionnés. \fBdselect\fP vérifie les implications de ces changements
vis\-à\-vis des dépendances et des conflits entre paquets.
.sp
Lorsqu'un conflit ou une dépendance manquante est détecté, un sous\-écran de
résolution des dépendances est proposé à l'utilisateur. Dans cet écran, une
liste de paquets avec des conflits ou avec des dépendances manquantes est
affichée et pour chaque paquet listé, la raison de sa présence dans cette
liste est indiquée. L'utilisateur peut ensuite appliquer les suggestion de
\fBdselect\fP, les modifier ou supprimer toutes les modifications, dont celles
qui ont créé les conflits ou dépendances non résolues.
.sp
L'utilisation de l'écran interactif des sélections de paquets est expliquée
de façon plus détaillée ci\-dessous.
.sp
.SS "Installer (install)"
Installer les paquets sélectionnés.
.sp
La méthode d'accès récupérera dans les dépôts les paquets qui peuvent être
installés ou mis à jour, puis les installe avec \fBdpkg\fP. En fonction de la
méthode d'accès, les paquets peuvent être tous récupérés avant installation,
ou récupérés à la demande. Certaines méthodes d'accès retirent également les
paquets qui ont été marqués pour être retirés.
.sp
Si une erreur apparaît lors de l'installation, il est recommandé de
redémarrer une installation. La plupart des fois, les problèmes
disparaissent ou sont résolus. Si les problèmes persistent ou si
l'installation n'est pas correcte, veuillez examiner les causes et
circonstances puis soumettez un rapport de bogue au système de suivi des
bogues Debian. Les instructions pour soumettre ces rapports de bogues se
trouvent sur https://bugs.debian.org/ ou dans la page de manuel de
\fBreportbug\fP(1), si ce paquet est installé.
.sp
Details of the install command depend on the access method's
implementation.  The user's attention and input may be required during
installation, configuration or removal of packages. This depends on the
maintainer scripts in the package. Some packages make use of the
\fBdebconf\fP(1)  library, allowing for more flexible or even automated
installation setups.
.sp
.SS "Configurer (config)"
Configure les paquets déjà installés mais n'étant pas complètement
installés.
.sp
.SS "Retirer (remove)"
Retirer ou purger les paquets installés qui sont marqués comme étant à
retirer.
.sp
.SS "Quitter (quit)"
Quit \fBdselect\fP.
.sp
Quitte le programme avec un code d'erreur de 0 (succès).
.sp
.
.SH "GESTION DE LA SÉLECTION DES PAQUETS"
.sp
.SS Introduction
.sp
\fBdselect\fP directly exposes the administrator to some of the complexities
involved with managing large sets of packages with many
interdependencies. For a user who is unfamiliar with the concepts and the
ways of the debian package management system, it can be quite
overwhelming. Although \fBdselect\fP is aimed at easing package management and
administration, it is only instrumental in doing so and cannot be assumed to
be a sufficient substitute for administrator skill and understanding. The
user is required to be familiar with the concepts underlying the Debian
packaging system.  In case of doubt, consult the \fBdpkg\fP(1) manpage and the
distribution policy.
.sp
Unless \fBdselect\fP is run in expert or immediate mode, a help screen is first
displayed when choosing this command from the menu. The user is \fIstrongly\fP
advised to study all of the information presented in the online help
screens, when one pops up.  The online help screens can at any time be
invoked with the ‘\fB?\fP’ key.
.sp
.SS "Disposition de l'écran"
.sp
L'écran de sélection est découpé par défaut en une moitié supérieure et une
moitié inférieure. La moitié supérieure affiche une liste de paquets. Un
curseur permet de sélectionner un paquet, ou un groupe de paquets en
sélectionnant le titre du groupe, si ça s'applique. La moitié inférieure de
l'écran affiche les détails du paquet sélectionné dans la moitié
supérieure. Le type de détail affiché peut varier.
.sp
Pressing the ‘\fBI\fP’ key toggles a full\-screen display of the packages list,
an enlarged view of the package details, or the equally split screen.
.sp
.SS "Vue des détails d'un paquet"
.sp
The package details view by default shows the extended package description
for the package that is currently selected in the packages status list.
The type of detail can be toggled by pressing the ‘\fBi\fP’ key.
This alternates between:
 \- the extended description
 \- the control information for the installed version
 \- the control information for the available version
.sp
Dans un écran de résolution des dépendances, on peut également voir les
dépendances et conflits spécifiques au paquet qui expliquent la présence du
paquet dans la liste.
.sp
.SS "Liste des états des paquets"
.sp
L'écran principal de sélection affiche une liste de tous les paquets connus
par le système de gestion des paquets Debian. Ceci inclut les paquets
installés sur le système et les paquets connus par la base de données des
paquets disponibles.
.sp
For every package, the list shows the package's status, priority, section,
installed and available architecture, installed and available versions, the
package name and its short description, all in one line.  By pressing the
‘\fBA\fP’ key, the display of the installed and available architecture can be
toggled between on an off.  By pressing the ‘\fBV\fP’ key, the display of the
installed and available version can be toggled between on an off.  By
pressing the ‘\fBv\fP’ key, the package status display is toggled between
verbose and shorthand.  Shorthand display is the default.
.sp
L'état raccourci consiste en 4 parties\ : un drapeau d'erreur, qui est
habituellement vide, l'état courant, l'état de sélection précédent et l'état
de sélection actuel. Les deux premiers donnent des indications sur l'état
courant du paquet, les deux suivants concernent les sélections définies par
l'utilisateur.
.sp
Voici la signification des codes d'indication des états\ :
 Drapeau d'erreur\ :
  \fIvide\fP    aucune erreur\ ;
  \fBR\fP       erreur sérieuse, réinstallation nécessaire.
 État d'installation\ :
  \fIvide\fP    pas installé\ ;
  \fB*\fP       complètement installé et configuré\ ;
  \fB\-\fP       pas installé, mais des fichiers de configuration existent toujours\ ;
  \fBU\fP       dépaqueté, mais toujours pas configuré\ ;
  \fBC\fP       à moitié configuré (il y a eu une erreur)\ ;
  \fBI\fP       à moitié installé (il y a eu une erreur).
 Sélection actuelle et demandée\ :
  \fB*\fP       marqué comme étant à installer ou à mettre à jour\ ;
  \fB\-\fP       marqué comme étant à retirer, en conservant la configuration\ ;
  \fB=\fP       marqué comme étant à conserver\ : le paquet ne sera pas traité\ ;
  \fB_\fP       marqué comme étant à nettoyer, la configuration sera retirée également\ ;
  \fBn\fP       nouveau paquet, n'a toujours pas été marqué.
.sp
.SS "Déplacement du curseur et de l'écran"
.sp
Vous pouvez naviguer dans la liste de sélection des paquets et dans l'écran
de résolution des dépendances et des conflits à l'aide des touches
suivantes\ :
.br
  \fBp, Haut, k\fP             déplace le curseur vers le haut
  \fBn, Bas, j\fP              déplace le curseur vers le bas
  \fBP, Page\-préc., Effacer\fP fait défiler la liste d'une page vers le haut
  \fBN, Page\-suiv., Espace\fP  fait défiler la liste d'une page vers le bas
  \fB^p\fP                     fait défiler la liste d'une ligne vers le haut
  \fB^n\fP                     fait défiler la liste d'une ligne vers le bas
  \fBt, Home\fP                saute au début de la liste
  \fBe, Fin\fP                 saute à la fin de la liste
  \fBu\fP                      fait défiler les informations d'une page vers le haut
  \fBd\fP                      fait défiler les informations d'une page vers le bas
  \fB^u\fP                     fait défiler les informations d'une ligne vers le haut
  \fB^d\fP                     fait défiler les informations d'une ligne vers le bas
  \fBB, gauche\fP              déplace l'affichage de 1/3 vers la gauche
  \fBF, droite\fP              déplace l'affichage de 1/3 vers la droite
  \fB^b\fP                     déplace l'affichage d'un caractère vers la gauche
  \fB^f\fP                     déplace l'affichage d'un caractère vers la droite
.sp
.SS "Recherches et tris"
.sp
The list of packages can be searched by package name. This is done by
pressing ‘\fB/\fP’, and typing a simple search string. The string is
interpreted as a \fBregex\fP(7)  regular expression.  If you add ‘\fB/d\fP’ to the
search expression, dselect will also search in descriptions.  If you add
‘\fB/i\fP’ the search will be case insensitive.  You may combine these two
suffixes like this: ‘\fB/id\fP’.  Repeated searching is accomplished by
repeatedly pressing the ‘\fBn\fP’ or ‘\fB\e\fP’ keys, until the wanted package is
found.  If the search reaches the bottom of the list, it wraps to the top
and continues searching from there.
.sp
The list sort order can be varied by pressing
the ‘\fBo\fP’ and ‘\fBO\fP’ keys repeatedly.
The following nine sort orderings can be selected:
 alphabet          available           status
 priority+section  available+priority  status+priority
 section+priority  available+section   status+section
.br
Lorsqu'il n'est pas indiqué, l'ordre alphabétique est utilisé comme dernier
critère de tri.
.sp
.SS "Modifier les sélections"
.sp
Le type de sélection demandé d'un paquet peut être changé à l'aide des commandes suivantes\ :
  \fB+, Inser\fP     installer ou mettre à jour
  \fB=, H\fP         à garder dans l'état et la version actuels
  \fB:, G\fP         ne plus garder\ : mettre à jour ou laisser non installé
  \fB\-, Suppr\fP     retirer, en gardant la configuration
  \fB_\fP            retirer et supprimer la configuration
.sp
Lorsque la demande de modification entraîne des dépendances non satisfaites
ou des conflits, \fBdselect\fP fournit à l'utilisateur un écran de résolution
des dépendances. Ceci sera décrit plus tard.
.sp
Il est également possible d'appliquer ces commandes à des groupes de
sélections de paquets en plaçant le curseur sur le titre d'un groupe. Le
regroupement des paquets dépend de la façon dont les paquets sont triés dans
la liste.
.sp
Une attention particulière doit être prise lors de la modification de grands
groupes de sélections, parce qu'ils peuvent créer rapidement un nombre
important de dépendances non résolues ou de conflits, qui seraient tous
listés dans un écran de résolution de dépendances, le rendant difficile à
utiliser. En pratique, seules les opérations «\ à garder\ » et «\ ne plus
garder\ » sont utiles pour les groupes.
.sp
.SS "Résoudre les dépendances et les conflits"
.sp
Lorsque la demande de modification entraîne des dépendances non satisfaites
ou des conflits, \fBdselect\fP fournit à l'utilisateur un écran de résolution
des dépendances. Mais un écran d'information est affiché dans un premier
temps.
.sp
La moitié supérieure de cet écran liste tous les paquets ayant des
dépendances non résolues ou des conflits dus aux modifications demandées,
ainsi que les paquets dont l'installation permettrait de résoudre une
dépendance ou dont le retrait permettrait de résoudre un conflit. La moitié
inférieure affiche par défaut les dépendances ou conflits pour lesquels le
paquet sélectionné se trouve présent dans la liste.
.sp
Quand la sous\-liste de paquets est affichée pour la première fois,
\fBdselect\fP peut avoir déjà fixé les états demandés pour certains des paquets
listés, cela afin de résoudre les dépendances ou les conflits qui ont causé
l'apparition de l'écran de résolution des dépendances. Il est habituellement
recommandé de suivre les suggestions de \fBdselect\fP.
.sp
The listed packages' selection state may be reverted to the original
settings, as they were before the unresolved depends or conflicts were
created, by pressing the ‘\fBR\fP’ key.  By pressing the ‘\fBD\fP’ key, the
automatic suggestions are reset, but the change that caused the dependency
resolution screen to be prompted is kept as requested.  Finally, by pressing
‘\fBU\fP’, the selections are again set to the automatic suggestion values.
.sp
.SS "Établir les sélections demandées"
.sp
En appuyant sur \fBEntrée\fP, les sélections affichées sont acceptées. Si
\fBdselect\fP ne détecte pas de dépendances non résolues du fait de ces
sélections, les nouvelles sélections sont établies. Cependant, si des
dépendances non résolues sont trouvées, \fBdselect\fP affichera de nouveau un
écran de résolution des dépendances.
.sp
To alter a set of selections that creates unresolved depends or conflicts
and forcing \fBdselect\fP to accept it, press the ‘\fBQ\fP’ key. This sets the
selections as specified by the user, unconditionally. Generally, don't do
this unless you've read the fine print.
.sp
The opposite effect, to back out any selections change requests and go back
to the previous list of selections, is attained by pressing the ‘\fBX\fP’ or
\fBescape\fP keys. By repeatedly pressing these keys, any possibly detrimental
changes to the requested package selections can be backed out completely to
the last established settings.
.sp
If you mistakenly establish some settings and wish to revert all the
selections to what is currently installed on the system, press the ‘\fBC\fP’
key.  This is somewhat similar to using the unhold command on all packages,
but provides a more obvious panic button in cases where the user pressed
\fBenter\fP by accident.
.sp
.
.SH "CODE DE SORTIE"
.TP 
\fB0\fP
The requested command was successfully performed.
.TP 
\fB2\fP
Fatal or unrecoverable error due to invalid command\-line usage, or
interactions with the system, such as accesses to the database, memory
allocations, etc.
.
.SH ENVIRONNEMENT
.TP 
\fBHOME\fP
Si positionné, sera utilisé par \fBdselect\fP comme le répertoire d'où sera lu
le fichier de configuration propre à l'utilisateur.
.
.SH BOGUES
L'interface \fBdselect\fP de sélection de paquets est déroutante pour les
nouveaux utilisateurs. On rapporte même qu'elle fait pleurer certains
développeurs chevronnés du noyau (NdT\ :\ du moins les derniers historiques
dinosaures qui s'en servent encore).
.sp
La documentation manque.
.sp
Il n'existe pas d'option d'aide dans le menu.
.sp
La liste visible des paquets disponibles ne peut pas être réduite.
.sp
La méthode d'accès intégrée ne satisfait pas les normes de qualité
actuelles. Utilisez plutôt la méthode fournie par APT. Non seulement elle
n'est pas cassée, mais en plus elle est plus souple que la méthode d'accès
intégrée.
.
.SH "VOIR AUSSI"
\fBdpkg\fP(1), \fBapt\-get\fP(8), \fBsources.list\fP(5), \fBdeb\fP(5).
.SH TRADUCTION
Ariel VARDI <ariel.vardi@freesbee.fr>, 2002.
Philippe Batailler, 2006.
Nicolas François, 2006.
Veuillez signaler toute erreur à <debian\-l10n\-french@lists.debian.org>.
