/* -*-C-*- ux2dos.c */
/*-->ux2dos*/
/**********************************************************************/
/****************************** ux2dos ********************************/
/**********************************************************************/

/***********************************************************************
Convert one or more files from UNIX to DOS format (\n -> \r\n),
preserving time stamps.

Usage:
	ux2dos filelist

[08-Mar-2002] -- Add support for --?, --help, and --version.
[20-Sep-1997] -- Adapt for GNU automake and autoconf.
[29-Jan-1992] -- original version
***********************************************************************/

#include "headers.h"

RCSID("$Id: ux2dos.c,v 1.14 1995/07/22 20:21:18 beebe Exp beebe $")

#define TMPFILE "ux2dos.$$$"

int		main ARGS((int argc_, char *argv_[]));
static int	ux2dos ARGS((const char *file_, int dummy));

int
#if STDC
main(
int argc,
char  *argv[]
)
#else /* NOT STDC */
main(argc,argv)
int argc;
char  *argv[];
#endif /* STDC */
{
    exit(do_args(argv,argc,ux2dos) ? EXIT_FAILURE : EXIT_SUCCESS);
    return (0);
}

static int
#if STDC
ux2dos(
const char  *file,
int dummy
)
#else /* NOT STDC */
ux2dos(file,dummy)
const char  *file;
int dummy;
#endif /* STDC */
{
    FILE  *fpin;
    FILE  *fpout;
    int cprev;
    int c;

    (void)fprintf(stderr,"%s",file);

    if ((fpin = fopen(file,RB_OPEN)) == (FILE*)NULL)
    {
	(void)fprintf(stderr," - [FAILED]\n");
	return (1);
    }
    if ((fpout = fopen(TMPFILE,WB_OPEN)) == (FILE*)NULL)
    {
	(void)fprintf(stderr," [%s] - [FAILED]\n",TMPFILE);
	return (1);
    }

    cprev = -1;
    while ((c = getc(fpin)) != EOF)
    {
	if ((c == '\n') && (cprev != '\r'))
	    (void)putc('\r',fpout);
	(void)putc(c,fpout);
	cprev = c;
    }

    return (finish_file(fpin,file,fpout,TMPFILE));
}
