/* -*-C-*- strnic.c */
/*-->strnicmp*/
/**********************************************************************/
/****************************** strnicmp ******************************/
/**********************************************************************/

#include "headers.h"

RCSID("$Id: strnic.c,v 1.1 2001/09/15 18:55:42 beebe Exp beebe $")


/***********************************************************************
Compare strings ignoring case, stopping after n characters, or at
end-of-string, whichever comes first.
***********************************************************************/

int
#if STDC
strnicmp(
const char	*s1,
const char	*s2,
size_t		n
)
#else /* NOT STDC */
strnicmp(s1,s2,n)
const char	*s1;
const char	*s2;
size_t		n;
#endif /* STDC */
{
    int	   c1;
    int	   c2;
    int	   result;

    for (; (n > 0) && *s1 && *s2; ++s1, ++s2, --n)
    {
	c1 = 0xff & (islower(*s1) ? (int)*s1 : tolower(*s1));
	c2 = 0xff & (islower(*s2) ? (int)*s2 : tolower(*s2));
	if (c1 < c2)
	    return (-1);
	else if (c1 > c2)
	    return (1);
    }
    if (n <= 0)		   /* first n characters match */
	result = 0;
    else if (*s1 == '\0')
	result = ((*s2 == '\0') ? 0 : -1);
    else /* (*s2 == '\0') */
	result = 1;

    return (result);
}
