/* -*-C-*- match.c */
/*-->match*/
/**********************************************************************/
/******************************* match ********************************/
/**********************************************************************/

#include "headers.h"

RCSID("$Id: match.c,v 1.1 2001/09/15 18:55:42 beebe Exp beebe $")


int		match ARGS((const char *user_string_, const char *keyword_));

/* Return the length of the longest common prefix in user_string and
keyword, ignoring case differences.  The first mismatching character
in user_string may not be alphabetic, however, in order to avoid
ambiguities (e.g. "outfile" will not match "output").  A return value
of 0 signals total match failure. */

int
#if STDC
match(
const char	*user_string,		/* user-specified string */
const char	*keyword		/* keyword to match against */
)
#else /* NOT STDC */
match(user_string,keyword)
const char	*user_string;		/* user-specified string */
const char	*keyword;		/* keyword to match against */
#endif /* STDC */
{
    register size_t	k;		/* loop index */
    register size_t	n;		/* match length limit */
    int			result;

    n = strlen(keyword);
    for (k = 0; k < n; ++k,++user_string,++keyword)
    {
	if (strnicmp(user_string,keyword,1) != 0)
	    break;			/* only first k chars match */
    }
    if (isalpha(*user_string))		/* forbid letter mismatches */
	result = 0;			/* match fails completely */
    else
	result = (int)k;		/* match is okay */

    return (result);
}
