.TH MAC2UX 1 "08 March 2002"
.\"=====================================================================
.SH NAME
mac2ux \- convert text file(s) from Apple Macintosh format to UNIX format
.\"=====================================================================
.SH SYNOPSIS
.B mac2ux
[
.B \-?
]
[
.B \-help
]
[
.B \-version
]
[
.B \-z
]
.I filelist
.\"=====================================================================
.SH DESCRIPTION
.IX mac2ux "" "\fLmac2ux\fP \(em convert text file(s) from Apple Macintosh \
format to UNIX format"
.LP
.B mac2ux
replaces carriage returns by newlines in Apple Macintosh format text
files to conform to UNIX requirements.  Existing isolated newlines are
left intact, so that no changes are made to a file which is already in
UNIX format.
.LP
Access and modification time stamps of the files are preserved.
.LP
This command can be invoked from either DOS or UNIX.  However, the
filenames must conform to the conventions of the environment in which
the command is invoked.
.LP
Each file on the command line is converted in turn to a temporary
file, and then the original is deleted, and the temporary file renamed
to the original name.  If you interrupt the execution of this command,
then be sure to check for a file in the current directory named
.I "mac2ux.$$$"
and rename it manually, if necessary.
.\"=====================================================================
.SH OPTIONS
Options can be prefixed with either one or two hyphens, and can be
abbreviated to any unique prefix.  Thus,
.BR \-h ,
.BR \-he ,
and
.B \-\-help
are equivalent.
.PP
Command-line arguments are parsed in strict order of appearance:
options that follow filenames will not affect processing of those
files.
.PP
To avoid confusion with options, if a filename begins with a hyphen,
it must be disguised by a leading absolute or relative directory path,
e.g.,
.I /tmp/-foo.txt
or
.IR ./-foo.txt .
.\"---------------------------------------------------------------------
.TP \w'\-\-version'u+3n
.BR \-help " or " \-?
Display a help message on
.IR stderr ,
giving a brief usage description, and then terminate with a success
return code.
.\"---------------------------------------------------------------------
.TP
.B \-version
Display the program version number and release date on
.IR stderr ,
and then terminate with a success return code.
.\"---------------------------------------------------------------------
.TP
.B \-z
This option is ignored; it is retained for compatibility with other
members of the
.I dosmacux
family.
.\"=====================================================================
.SH SEE ALSO
.BR dos2ux (1),
.BR dos2mac (1),
.BR mac2dos (1),
.BR ux2dos (1),
.BR ux2mac (1),
.BR unix2dos (1),
.BR dos2unix (1).
.\"=====================================================================
.SH AUTHOR
.nf
Nelson H. F. Beebe
Center for Scientific Computing
University of Utah
Department of Mathematics, 110 LCB
155 S 1400 E RM 233
Salt Lake City, UT 84112-0090
USA
Email: beebe@math.utah.edu, beebe@acm.org, beebe@computer.org, beebe@ieee.org (Internet)
WWW URL: http://www.math.utah.edu/~beebe
Tel: +1 801 581 5254
FAX: +1 801 585 1640, +1 801 581 4148
.fi
.\"=====================================================================
