/* -*-C-*- mac2ux.c */
/*-->mac2ux*/
/**********************************************************************/
/****************************** mac2ux ********************************/
/**********************************************************************/

/***********************************************************************
Convert one or more files from Macintosh to UNIX format (\r -> \n),
preserving time stamps.

Usage:
	mac2ux filelist

[08-Mar-2002] -- Add support for --?, --help, and --version.
[20-Sep-1997] -- Adapt for GNU automake and autoconf.
[15-Aug-1994] -- original version
***********************************************************************/

#include "headers.h"

RCSID("$Id: mac2ux.c,v 1.3 1995/07/22 19:59:21 beebe Exp beebe $")

#define TMPFILE "mac2ux.$$$"

static int	mac2ux ARGS((const char *file_, int dummy));
int		main ARGS((int argc_, char *argv_[]));

int
#if STDC
main(
int argc,
char  *argv[]
)
#else /* NOT STDC */
main(argc,argv)
int argc;
char  *argv[];
#endif /* STDC */
{
    exit(do_args(argv,argc,mac2ux) ? EXIT_FAILURE : EXIT_SUCCESS);
    return (0);
}

static int
#if STDC
mac2ux(
const char *file,
int dummy
)
#else /* NOT STDC */
mac2ux(file,dummy)
const char  *file;
int dummy;
#endif /* STDC */
{
    FILE  *fpin;
    FILE  *fpout;
    int c;

    (void)fprintf(stderr,"%s",file);

    if ((fpin = fopen(file,RB_OPEN)) == (FILE*)NULL)
    {
	(void)fprintf(stderr," - [FAILED]\n");
	return (1);
    }
    if ((fpout = fopen(TMPFILE,WB_OPEN)) == (FILE*)NULL)
    {
	(void)fprintf(stderr," [%s] - [FAILED]\n",TMPFILE);
	return (1);
    }

    while ((c = getc(fpin)) != EOF)
    {
	if (c == '\r')			/* peek ahead to see if we have \r\n */
	    c = '\n';
	(void)putc(c,fpout);
    }

    return (finish_file(fpin,file,fpout,TMPFILE));
}
