#if defined(c_plusplus) && !defined(__cplusplus)
#define __cplusplus 1			/* want modern-C++-style identifier */
#endif

#if defined(__cplusplus)
#define C_DECL_BEGIN		extern "C" {
#define C_DECL_END		}
#else
#define C_DECL_BEGIN
#define C_DECL_END
#endif

#include <config.h>
#include <custom.h>		/* to override anything in config.h */

#include <stdio.h>		/* NB: this must come BEFORE <sys/types.h>, */
				/* because on DEC Alpha OSF/1 3.x with lcc, the */
				/* reverse order fails because of a conflicting */
				/* redefinition of NULL, sigh... */

#if defined(HAVE_SYS_TYPES_H)
#include <sys/types.h>		/* include second, because other headers may
				   depend (incorrectly) on it */
#endif

#if    HAVE_DOS_H
#include <dos.h>	/* for struct date and struct time */
#endif /* HAVE_DOS_H */

#if defined(HAVE_ERRNO_H)
#include <errno.h>
#endif

#if defined(HAVE_FILE_H)
#include <file.h>
#endif

#if defined(HAVE_IO_H)
#include <io.h>		/* for struct ftime */
#endif

#if defined(HAVE_JSYS_H)
#include <jsys.h>
#endif

#if defined(HAVE_MON_S_H)
#include <mon_s.h>
#endif

#if defined(HAVE_STDLIB_H)
#include <stdlib.h>
#endif

#if defined(HAVE_STRING_H)
#include <string.h>
#endif

#if defined(HAVE_SYS_STAT_H)
#include <sys/stat.h>
#endif

#if defined(HAVE_UNISTD_H)
#include <unistd.h>
#endif

#if HAVE_UTIME_H
#include <utime.h>			/* different args to utime() */
#define ACCESS_TIME(t)		t.actime
#define MODIFICATION_TIME(t)	t.modtime
#define UTIMEBUF(t)		struct utimbuf t
#define UTIME(p,t)		utime(p,&t)
#else /* NOT HAVE_UTIME_H */
#define ACCESS_TIME(t)		t[0]
#define MODIFICATION_TIME(t)	t[1]
#define UTIMEBUF(t)		time_t t[2]
#define UTIME(p,t)		utime(p,t)
#endif /* HAVE_UTIME_H */

/***********************************************************************
fopen() mode flags differ between systems.  Here are symbolic values:
	R_OPEN		-- text read
	RB_OPEN		-- binary read
	RW_OPEN		-- text read/write
	W_OPEN		-- text write
	WB_OPEN		-- binary write
***********************************************************************/

#define R_OPEN			"r"
#define RB_OPEN			"r"
#define RW_OPEN			"w+"
#define W_OPEN			"w"
#define WB_OPEN			"w"

#if    OS_PCDOS
#undef RB_OPEN
#define RB_OPEN			"rb"

#undef WB_OPEN
#define WB_OPEN			"wb"
#endif /* OS_PCDOS */

#if    OS_PRIMOS
#undef HAVE_TYPES_H
#undef RB_OPEN
#define RB_OPEN			"i"

#undef RW_OPEN
#define RW_OPEN			"w"

#undef WB_OPEN
#define WB_OPEN			"o"
#endif /* OS_PRIMOS */

#if    OS_TOPS20
#undef RB_OPEN
#define RB_OPEN			"rb"

#undef WB_OPEN
#define WB_OPEN			"wb"
#endif /* OS_TOPS20 */

#if    OS_VAXVMS
#undef RB_OPEN
#define RB_OPEN			"rb"

#undef WB_OPEN
#define WB_OPEN			"wb"
#endif /* OS_VAXVMS */

/***********************************************************************
On [02-Nov-1991], driver development on UNIX was placed under the
Revision Control System (RCS).  For now, RCSID() will always generate
a static RCS version string.  We may later wish to suppress this to
conserve memory on small systems.  Thus, the expansion includes a
semicolon so that it can be made to completely disappear if we wish.
A typical initial usage is RCSID("<dollar>Id<dollar>"), where <dollar>
is a literal dollar sign.
***********************************************************************/

#define RCSID(s) static char rcsid[] = s;

#if defined(HAVE_STDC_PROTOTYPES)
#define ARGS(parenthesized_list) parenthesized_list
#define VOID_ARG		void
#else /* NOT STDC_HEADERS */
#define ARGS(parenthesized_list) ()
#define VOID_ARG
#endif /* STDC_HEADERS */

#if defined(HAVE_VOIDP)
#define VOIDP			void*
#else
#define VOIDP			char*
#endif

#if !defined(EXIT_FAILURE)
#define EXIT_FAILURE 1 /* gcc defines this only if _ANSI_C_SOURCE is defined */
#endif

#if !defined(EXIT_SUCCESS)
#define EXIT_SUCCESS 0 /* gcc defines this only if _ANSI_C_SOURCE is defined */
#endif

#if    KCC_20
#undef WB_OPEN
#define WB_OPEN		"wb7"
#endif /* KCC_20 */

#if !defined(BUFSIZ)
#define BUFSIZ	1024
#endif

#define CTL(c)	((int)((int)(c) & 037))

extern int		do_args ARGS((char *argv_[], int argc_,
				      int (*doit_)ARGS((const char *file_,
							int remove_ctl_z_))));
extern int		finish_file ARGS((FILE *fpin_, const char *infile_,
					  FILE *fptmp_, const char *tmpfile));
extern int		is_switch ARGS((int c_));
extern int		match ARGS((const char *user_string_, 
				    const char *keyword_));
extern int		strnicmp ARGS((const char *s1_, const char *s2_,
				       size_t n_));
extern void		help_and_exit ARGS((const char *program));
extern void		usage ARGS((const char *program));
extern void		usage_and_exit ARGS((const char *program));
extern void		version_and_exit ARGS((const char *program));
