/* -*-C-*- dos2ux.c */
/*-->dos2ux*/
/**********************************************************************/
/****************************** dos2ux ********************************/
/**********************************************************************/

/***********************************************************************
Convert one or more files from DOS to UNIX format (\r\n -> \n),
preserving time stamps.

Usage:
	dos2ux [-z] filelist

If the -z option is specified, then in all subsequent files, Ctl-Z
characters (DOS end-of-file markers) are recognized: they are discarded,
treated as an immediate end-of-file indicator, and any following
characters in the file are ignored.

[08-Mar-2002] -- Add support for --?, --help, and --version.

[20-Sep-1997] -- Adapt for GNU automake and autoconf.

		 Add -z option.

		 Ensure temporary file is in same file directory, so
		 that rename() should always succeed.

[29-Jan-1992] -- original version
***********************************************************************/

#include "headers.h"

RCSID("$Id: dos2ux.c,v 1.14 1995/07/22 19:23:18 beebe Exp beebe $")

#define TMPFILE "dos2ux.$$$"

static int	dos2ux ARGS((const char *file_, int remove_ctl_z_));
int		main ARGS((int argc_, char *argv_[]));


int
#if STDC
main(
int argc,
char  *argv[]
)
#else /* NOT STDC */
main(argc,argv)
int argc;
char  *argv[];
#endif /* STDC */
{
    exit(do_args(argv,argc,dos2ux) ? EXIT_FAILURE : EXIT_SUCCESS);
    return (0);
}

static int
#if STDC
dos2ux(
const char  *file,
int remove_ctl_z
)
#else /* NOT STDC */
dos2ux(file,remove_ctl_z)
const char  *file;
int remove_ctl_z;
#endif /* STDC */
{
    FILE  *fpin;
    FILE  *fpout;
    int c;

    (void)fprintf(stderr,"%s",file);

    if ((fpin = fopen(file,RB_OPEN)) == (FILE*)NULL)
    {
	(void)fprintf(stderr," - [FAILED]\n");
	return (1);
    }
    if ((fpout = fopen(TMPFILE,WB_OPEN)) == (FILE*)NULL)
    {
	(void)fprintf(stderr," [%s] - [FAILED]\n",TMPFILE);
	return (1);
    }

    while ((c = getc(fpin)) != EOF)
    {
	if (c == '\r')			/* peek ahead to see if we have \r\n */
	{
	    c = getc(fpin);
	    if (c != '\n')
	    {
		(void)ungetc(c,fpin);
		c = '\r';
	    }
	}
	else if (remove_ctl_z && (c == CTL('Z')))
	    break;			/* DOS end-of-file signal */
	(void)putc(c,fpout);
    }

    return (finish_file(fpin,file,fpout,TMPFILE));
}
