/* -*-C-*- common.c */
/*-->common*/
/**********************************************************************/
/****************************** common ********************************/
/**********************************************************************/

/* This file contains common functions required by dos2mac, dos2ux
   mac2dos, mac2ux ux2dos, and ux2mac. */

#include "headers.h"

static int		copy ARGS((const char* infile_, const char* file_));
static const char *	tail ARGS((const char *program));

RCSID("$Id: common.c,v 1.1 1997/09/20 20:51:15 beebe Exp beebe $")

static int
#if STDC
copy(
const char* infile,
const char* outfile
)
#else /* NOT STDC */
copy(infile, outfile)
const char* infile;
const char* outfile;
#endif /* STDC */
{
    char buffer[BUFSIZ];
    FILE  *fpin;
    FILE  *fpout;
    size_t nread;
    size_t nwrite;
    char *p;

    if ((fpin = fopen(infile,RB_OPEN)) == (FILE*)NULL)
    {
	(void)fprintf(stderr," - [FAILED]\n");
	return (1);
    }
    if ((fpout = fopen(outfile,WB_OPEN)) == (FILE*)NULL)
    {
	(void)fprintf(stderr," [%s] - [FAILED]\n",infile);
	return (1);
    }

    nread = (size_t)fread(buffer, (size_t)1, (size_t)BUFSIZ, fpin);
    while (nread > 0)
    {
	p = &buffer[0];
	while (nread > 0)  /* NB: fwrite() can write fewer items than requested */
	{
	    nwrite = (size_t)fwrite(p, (size_t)1, (size_t)nread, fpout);
	    nread -= nwrite;
	    p += nwrite;
	}
	nread = (size_t)fread(buffer, (size_t)1, (size_t)BUFSIZ, fpin);
    }
    (void)fclose(fpin);
    (void)fclose(fpout);
    return (0);
}

int
#if STDC
do_args(char *argv[], int argc,
	int (*doit)(const char *file, int remove_ctl_z))
#else /* NOT STDC */
do_args(argv, argc, doit)
char *argv[];
int argc;
int (*doit)();
#endif /* STDC */
{
    int errors = 0;
    int k;
    int remove_ctl_z = 0;

    for (k = 1; k < argc; ++k)
    {
	char *p;
	p = argv[k];
	if (is_switch(p[0]) && is_switch(p[1]))
		p++;
	if (is_switch(p[0]))
	{
	    ++p;
	    if (match(p,"z"))
		remove_ctl_z++;
	    else if (match(p,"?"))
		help_and_exit(argv[0]);
	    else if (match(p,"help"))
		help_and_exit(argv[0]);
	    else if (match(p,"version"))
		version_and_exit(argv[0]);
	    else
		usage_and_exit(argv[0]);
	}
	else
	    errors += (*doit)(argv[k], remove_ctl_z);
    }
    return (errors);
}

int
#if STDC
finish_file(
FILE *fpin,
const char *infilename,
FILE *fptmp,
const char *tmpfilename
)
#else /* NOT STDC */
finish_file(fpin, infilename, fptmp, tmpfilename)
FILE *fpin;
const char *infilename;
FILE *fptmp;
const char *tmpfilename;
#endif /* STDC */
{
    struct stat inbuf;
    UTIMEBUF(ftimes);

    if (fstat((int)fileno(fpin),&inbuf) == -1)
    {
	(void)fprintf(stderr," [%s] - [FAILED]\n",tmpfilename);
	return (1);
    }

    ACCESS_TIME(ftimes)       = inbuf.st_atime;
    MODIFICATION_TIME(ftimes) = inbuf.st_mtime;

    (void)fclose(fpin);
    (void)fclose(fptmp);
    (void)unlink(infilename);

    if ((rename(tmpfilename,infilename) != 0) &&
	(copy(tmpfilename,infilename) != 0))
    {
	(void)fprintf(stderr," [RENAME/COPY FAILED]\n");
	return (1);
    }

    if (UTIME(infilename,ftimes) == 0)
    {
	(void)fprintf(stderr," [OK]\n");
	(void)unlink(tmpfilename);
	return (0);
    }
    else
    {
	(void)fprintf(stderr," [TIMESTAMP RESET FAILED]\n");
	return (1);
    }
}

int
#if STDC
is_switch(
int c
)
#else /* NOT STDC */
is_switch(c)
int c;
#endif /* STDC */
{
#if defined(OS_UNIX)
    return (c == '-');
#else
    return ((c == '-') || (c == '/'));
#endif
}

#if    IBM_PC_TURBO
int
#if STDC
utime(
const char	*path,			/* full filename */
time_t		ftimes[2]		/* access and modification times */
)
#else /* NOT STDC */
utime(path,ftimes)			/* set file access/modification times */
const char	*path;			/* full filename */
time_t		ftimes[2];		/* access and modification times */
#endif /* STDC */
{
	int		code;
	struct date	dt;
	FILE		*fp;
	struct ftime	ft;
	struct time	tt;

	fp = fopen(path,"r");
	if (fp == (FILE*)NULL)
	{
		errno = ENOENT;	/* fopen() should set this, but doesn't */
		return (-1);
	}

	if (ftimes == (time_t*)NULL)	/* use current time */
		(void)unixtodos(time((time_t*)NULL), &dt, &tt);
	else	/* use modification time (DOS has no access time) */
		(void)unixtodos(ftimes[1], &dt, &tt);

	ft.ft_tsec  = (unsigned)tt.ti_sec / 2; /* ft_tsec: 2-sec intervals */
	ft.ft_min   = (unsigned)tt.ti_min;
	ft.ft_hour  = (unsigned)tt.ti_hour;
	ft.ft_day   = (unsigned)dt.da_day;
	ft.ft_month = (unsigned)dt.da_mon;
	ft.ft_year  = ((unsigned)dt.da_year) - 1980;

	code = setftime((int)fileno(fp),&ft);
	(void)fclose(fp);

	return (code);
}
#endif /* IBM_PC_TURBO */

void
#if STDC
help_and_exit(const char *program)
#else /* NOT STDC */
help_and_exit(program)
const char *program;
#endif /* STDC */
{
    usage(program);
    exit(EXIT_SUCCESS);
}

const char *
#if STDC
tail(const char *program)
#else /* NOT STDC */
tail(program)
const char *program;
#endif /* STDC */
{
    const char *p;
    p = strrchr(program,'/');
    if (p == (const char*)NULL)
	p = strrchr(program,'\\');
    if (p == (const char*)NULL)
	p = program - 1;
    return (p + 1);
}

void
#if STDC
usage(const char *program)
#else /* NOT STDC */
usage(program)
const char *program;
#endif /* STDC */
{
    (void)fprintf(stderr, "Usage:\n");
    (void)fprintf(stderr, "\t%s [--?] [--help] [--version] [--z]\n", tail(program));
}

void
#if STDC
usage_and_exit(const char *program)
#else /* NOT STDC */
usage_and_exit(program)
const char *program;
#endif /* STDC */
{
    usage(program);
    exit(EXIT_FAILURE);
}

void
#if STDC
version_and_exit(const char *program)
#else /* NOT STDC */
version_and_exit(program)
const char *program;
#endif /* STDC */
{
    (void)fprintf(stderr, "This is %s from package %s [version %s of %s]\n",
		  tail(program), PACKAGE, PACKAGE_VERSION, PACKAGE_DATE);
    (void)fprintf(stderr, "Send bug reports and/or comments to: %s\n",
		  PACKAGE_BUGREPORT);
    exit(EXIT_SUCCESS);
}
