; master library
;
; Description:
;	q[v^}l[W
;
; Functions:
;	unsigned hmem_allocbyte( unsigned bytesize ) ;
;	unsigned hmem_alloc( unsigned parasize ) ;
;	void hmem_free( unsigned memseg ) ;
;
; Returns:
;	unsigned hmem_alloc:	 (cy=0) mۂZOg
;				0(cy=1) Ǘs
;
; Notes:
;	hmem_alloc śAmem_AllocID  0ɂȂ܂B
;	hmem_alloc(0)ƂČĂяoƁAsԂ܂B
;
;	q[v̍\
;		Ǘ: 16bytes
;			Using	2bytes	gpȂ1, gpȂ 0
;			NextSeg	2bytes	̃ubN̐擪
;					Ȃ mem_OutSegƓl
;			ID	2bytes	prID(mێmem_AllocID̒l])
;		pOtf[^
;
; Assembly Language Note:
;	AXȊȎSẴWX^ۑ܂B
;
; Running Target:
;	MS-DOS
;
; Author:
;	ˏF
;
; Rebision History:
;	93/ 3/20 Initial
;	93/ 5/ 3 bugfix: hmem_allocbyte(2{̊mۂĂ(^^;)
;	93/11/ 7 [M0.21] a=hmem_alloc(x); b=hmem_alloc(y);
;			hmem_free(a); hmem_free(b); ƂƂ
;			mem_TopHeapُɂȂoOC(hmem_freebug)
;			(holeł̒OŗB̃ubNJƂ)
;	93/11/ 7 [M0.21] hmem_freeAholeAڂƂɐڑ镔
;			(;_;)
;	93/12/27 [M0.22] hmem_free̘AڐڑSł͂Ȃ
;	93/12/29 [M0.22] hmem_freeɓnľꂽ
;			(Œl菬ƂƁAusing flag1łȂƂ
;			 return悤ɂ)
;	95/ 2/14 [M0.22k] mem_AllocIDΉ
;	95/ 3/19 [M0.22k] mۃTCY(mem_OutSeg-mem_EndMark)ȏȂ
;			ɎsԂ悤ɂB
;	95/ 3/21 [M0.22k] BUGFIX hmem_free() 擪̃ubNJƂ
;			オt[ubNŁA̎̃t[ubNŏI
;			ubN̂ƂɁA̍ŏIt[ubN
;			mem_FirstHole0ɂĂB
;			@̂߁Aɖ2Ԗڂ̃ubNJĂ
;			ŏ̋󂫂ƎvĘAڍƂs킸A
;			"Yꋎꂽ"t[ubNƘAڂȂB
;
	.MODEL SMALL
	include func.inc
	include super.inc

	.DATA
	EXTRN mem_TopSeg:WORD
	EXTRN mem_OutSeg:WORD
	EXTRN mem_TopHeap:WORD
	EXTRN mem_FirstHole:WORD	; "Hole": t[ubN̂
	EXTRN mem_EndMark:WORD
	EXTRN mem_AllocID:WORD

	.CODE

	EXTRN	MEM_ASSIGN_ALL:CALLMODEL

MEMHEAD STRUC
using	dw	?
nextseg	dw	?
mem_id	dw	?
MEMHEAD	ENDS

func HMEM_ALLOCBYTE	; hmem_allocbyte() {
	push	BX
	mov	BX,SP
	;
	bytesize = (RETSIZE+1)*2
	mov	BX,SS:[BX+bytesize]
	add	BX,15
	rcr	BX,1
	shr	BX,1
	shr	BX,1
	shr	BX,1
	jmp	short hmem_allocb
endfunc			; }

func HMEM_ALLOC		; hmem_alloc() {
	push	BX
	mov	BX,SP
	;
	parasize = (RETSIZE+1)*2

	mov	BX,SS:[BX+parasize]
hmem_allocb:
	cmp	mem_TopSeg,0	; house keeping
	jne	short A_S
	call	MEM_ASSIGN_ALL
A_S:
	push	CX
	push	ES

	test	BX,BX
	jz	short NO_MEMORY	; house keeping
	mov	AX,mem_OutSeg
	sub	AX,mem_EndMark
	cmp	BX,AX
	jae	short NO_MEMORY	; house keeping (add 95/3/19)

	inc	BX

	mov	AX,mem_FirstHole
	test	AX,AX
	jz	short ALLOC_CENTER	; Ŝ

	; t[ubNT
SEARCH_HOLE_S:
	mov	CX,mem_OutSeg
SEARCH_HOLE:
	mov	ES,AX
	mov	AX,ES:[0].nextseg
	cmp	ES:[0].using,0
	jne	short SEARCH_HOLE_E
	mov	CX,ES
	add	CX,BX
	jc	short SEARCH_HOLE_E0	; 95/3/22
	cmp	CX,AX	; now+size <= next
	jbe	short FOUND_HOLE
SEARCH_HOLE_E0:
	mov	CX,mem_OutSeg
SEARCH_HOLE_E:
	cmp	AX,CX
	jne	short SEARCH_HOLE
	; t[ubNɂ͂߂ڂ̂͂Ȃ

ALLOC_CENTER:
	; Smۂ̂
	mov	AX,mem_TopHeap
	mov	CX,AX
	sub	AX,BX
	jc	short NO_MEMORY		; 95/3/22
	cmp	AX,mem_EndMark
	jb	short NO_MEMORY
	mov	mem_TopHeap,AX
	mov	ES,AX
	mov	ES:[0].nextseg,CX
	mov	ES:[0].using,1
	mov	BX,AX
	jmp	short RETURN

NO_MEMORY:			; ȂƂ
	mov	AX,0
	mov	mem_AllocID,AX
	stc
	pop	ES
	pop	CX
	pop	BX
	ret	2

	; ES=now
	; AX=next
	; CX=now+size
FOUND_HOLE:
	; t[ubN̂
	; O̕Kv؂̂
	sub	AX,CX
	cmp	AX,1	; V 0`1p̑傫ȂȂ猊L
	jbe	short JUST_FIT
	add	AX,CX
	mov	ES:[0].using,1
	mov	ES:[0].nextseg,CX
	mov	BX,ES
	mov	ES,CX
	mov	ES:[0].nextseg,AX
	mov	ES:[0].using,0
	cmp	BX,mem_FirstHole
	jne	short RETURN
	mov	mem_FirstHole,CX ; ̂擪t[ubNXV
	jmp	short RETURN

	; 傤ǂzŃt[ubN̂
JUST_FIT:
	mov	ES:[0].using,1
	mov	BX,ES
	cmp	BX,mem_FirstHole
	jne	short RETURN
	; Ԃ̂擪t[ubN̂Ȃ猟
	mov	AX,mem_OutSeg
	mov	CX,BX
	push	BX
SEARCH_NEXT_HOLE:
	les	CX,ES:[0]	; CX=using, ES=nextseg
	jcxz	short FOUND_NEXT_HOLE
	mov	BX,ES
	cmp	BX,AX
	jb	short SEARCH_NEXT_HOLE
	xor	BX,BX
FOUND_NEXT_HOLE:
	mov	mem_FirstHole,BX
	pop	BX
	; jmp	short RETURN

 ; in: BX = mۂł̊ǗubNsegment
RETURN:	mov	ES,BX
	mov	AX,0
	xchg	AX,mem_AllocID
	mov	ES:[0].mem_id,AX
	lea	AX,[BX+1]
	clc
NO_THANKYOU:				; hmem_freẽG[͂ɂ()
	pop	ES
	pop	CX
	pop	BX
	ret	2
endfunc			; }


func HMEM_FREE		; hmem_free() {
	push	BX
	mov	BX,SP
	push	CX
	push	ES
	;
	memseg = (RETSIZE+1)*2
	mov	BX,SS:[BX+memseg]
	dec	BX
	mov	ES,BX
	cmp	BX,mem_TopHeap
	je	short EXPAND_CENTER	; 擪̃ubNȂp
	jb	short NO_THANKYOU	; mem_TopHeap菬Ȃ疳

	; 擪ł͂ȂubN̊J
	xor	BX,BX
	cmp	ES:[BX].using,1
	jne	short NO_THANKYOU	; using1łȂΖ
	mov	ES:[BX].using,BX	; using <- 0
	mov	CX,mem_FirstHole
	mov	AX,ES
	mov	mem_FirstHole,AX
	jcxz	short FREE_RETURN	; Ȃ̂Ȃ炷OK
	cmp	AX,CX
	jb	short CONNECT_START
	mov	AX,CX		; ȑO̍ŏ̌ƌ݈ʒûǂ炩Ⴂ
	mov	mem_FirstHole,AX	; Vŏ̌ɁB
CONNECT_START:

	mov	CX,AX
	mov	AX,ES:[BX].nextseg	; In_́AړIubN̎

	cmp	AX,mem_OutSeg
	jne	short NO_TAIL
	mov	AX,ES			; AIn_ЂƂO
NO_TAIL:
	; EAڂĂ܂t[ubNڑ
	push	DS
CONNECT_FREE:
	; 󂫂T[v
	mov	DS,CX			; DS<-CX
	mov	CX,[BX].nextseg		; CX=next seg
	cmp	CX,AX
	ja	short CONNECT_SKIP_OVER	; nextsegŏIseg傫ΏI
	cmp	[BX].using,BX
	jne	short CONNECT_FREE	; t[ubNɂȂ܂Ői߂
	; A󂫂q[v
CONNECT_FREE2:
	mov	ES,CX			; ES<-CX(=next seg)
	cmp	ES:[BX].using,BX	; Aڂt[܂Ői߂
	jne	short CONNECT_FREE
	; DSES̃t[ubNAڂĂ
	mov	CX,ES:[BX].nextseg	; CX=Vnext seg
	mov	[BX].nextseg,CX		; ڑ
	cmp	CX,AX
	jbe	short CONNECT_FREE2	; CXŏIsegȓȂ܂
CONNECT_SKIP_OVER:
	pop	DS
	jmp	short FREE_RETURN

	EVEN
EXPAND_CENTER:	; 擪ubN̊J
	xor	BX,BX
	mov	AX,ES:[BX].nextseg
	mov	mem_TopHeap,AX
	cmp	AX,mem_OutSeg
	je	short FREE_RETURN	; I
	mov	ES,AX
	cmp	ES:[BX].using,BX
	jne	short FREE_RETURN	; ̃ubNgpȂI

	; (ES:)t[ubNȂ̂łl߂B
	mov	AX,ES:[BX].nextseg
	mov	mem_TopHeap,AX
	; Ȍ̍ŏ̃t[ubNȀꏊmem_FirstHoleɓ
	mov	CX,mem_OutSeg
	cmp	AX,CX
	je	short FREE_LOST_HOLE	; ꂪŏIubNȂ
	jmp	short X_SEARCH_HOLE
	EVEN
X_SEARCH_NEXT_HOLE:
	mov	AX,ES:[BX].nextseg
	cmp	AX,CX
	je	short FREE_LOST_HOLE
X_SEARCH_HOLE:
	mov	ES,AX
	cmp	ES:[BX].using,BX
	jne	short X_SEARCH_NEXT_HOLE
	mov	BX,ES
FREE_LOST_HOLE:
	mov	mem_FirstHole,BX

FREE_RETURN:
	clc
	pop	ES
	pop	CX
	pop	BX
	ret	2
endfunc			; }

END
