/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.xs.impl;

import org.apache.ws.jaxme.xs.XSAnnotation;
import org.apache.ws.jaxme.xs.XSAny;
import org.apache.ws.jaxme.xs.XSElement;
import org.apache.ws.jaxme.xs.XSGroup;
import org.apache.ws.jaxme.xs.XSModelGroup;
import org.apache.ws.jaxme.xs.XSObject;
import org.apache.ws.jaxme.xs.XSParticle;
import org.apache.ws.jaxme.xs.impl.XSModelGroupImpl;
import org.apache.ws.jaxme.xs.impl.XSOpenAttrsImpl;
import org.apache.ws.jaxme.xs.impl.XSParticleImpl;
import org.apache.ws.jaxme.xs.parser.impl.LocSAXException;
import org.apache.ws.jaxme.xs.xml.XsEAnnotation;
import org.apache.ws.jaxme.xs.xml.XsEAny;
import org.apache.ws.jaxme.xs.xml.XsEChoice;
import org.apache.ws.jaxme.xs.xml.XsESchema;
import org.apache.ws.jaxme.xs.xml.XsESequence;
import org.apache.ws.jaxme.xs.xml.XsNCName;
import org.apache.ws.jaxme.xs.xml.XsObject;
import org.apache.ws.jaxme.xs.xml.XsQName;
import org.apache.ws.jaxme.xs.xml.XsTAll;
import org.apache.ws.jaxme.xs.xml.XsTGroupRef;
import org.apache.ws.jaxme.xs.xml.XsTLocalElement;
import org.apache.ws.jaxme.xs.xml.XsTNamedGroup;
import org.apache.ws.jaxme.xs.xml.XsTNestedParticle;
import org.apache.ws.jaxme.xs.xml.XsTParticle;
import org.apache.ws.jaxme.xs.xml.impl.XsTGroupRefImpl;
import org.xml.sax.SAXException;

public class XSGroupImpl
extends XSOpenAttrsImpl
implements XSGroup {
    private final XsQName name;
    private final XsTNestedParticle[] nestedParticles;
    private final XsTParticle[] particles;
    private final XsEAnnotation xsAnnotation;
    private XSAnnotation[] annotations;
    private boolean isGlobal;
    private XSModelGroup modelGroup;
    private final XSModelGroupImpl modelGroupImpl;
    private boolean isValidated;

    protected XSGroupImpl(XSObject pParent, XsTGroupRef pBaseGroup) throws SAXException {
        super(pParent, pBaseGroup);
        XsQName qName = pBaseGroup.getRef();
        if (qName == null) {
            qName = this.getQName(pBaseGroup.getName());
        }
        this.name = qName;
        this.modelGroupImpl = null;
        this.nestedParticles = null;
        this.particles = null;
        this.xsAnnotation = pBaseGroup.getAnnotation();
    }

    /*
     * WARNING - void declaration
     */
    protected XSGroupImpl(XSObject pParent, XsTNamedGroup pBaseGroup) throws SAXException {
        super(pParent, pBaseGroup);
        void var3_4;
        XSModelGroupImpl myModelGroup;
        this.name = this.getQName(pBaseGroup.getName());
        XsTNamedGroup group = (XsTNamedGroup)this.getXsObject();
        if (group.getSequence() != null) {
            myModelGroup = this.modelGroupImpl = new XSModelGroupImpl(XSModelGroup.SEQUENCE, pBaseGroup.getLocator());
            this.nestedParticles = group.getSequence().getParticles();
            this.particles = null;
        } else if (group.getChoice() != null) {
            myModelGroup = this.modelGroupImpl = new XSModelGroupImpl(XSModelGroup.CHOICE, pBaseGroup.getLocator());
            this.nestedParticles = group.getChoice().getParticles();
            this.particles = null;
        } else if (group.getAll() != null) {
            myModelGroup = this.modelGroupImpl = new XSModelGroupImpl(XSModelGroup.ALL, pBaseGroup.getLocator());
            this.nestedParticles = group.getAll().getElements();
            this.particles = null;
        } else {
            throw new IllegalStateException("Invalid group: Neither of 'sequence', 'choice'. or 'all' elements is set.");
        }
        this.modelGroup = var3_4;
        this.xsAnnotation = pBaseGroup.getAnnotation();
    }

    protected XSGroupImpl(XSObject pParent, XsEChoice pChoice) throws SAXException {
        super(pParent, pChoice);
        this.name = null;
        this.modelGroupImpl = new XSModelGroupImpl(XSModelGroup.CHOICE, pChoice.getLocator());
        this.modelGroup = this.modelGroupImpl;
        this.particles = pChoice.getParticles();
        this.nestedParticles = null;
        this.xsAnnotation = pChoice.getAnnotation();
    }

    protected XSGroupImpl(XSObject pParent, XsESequence pSequence) throws SAXException {
        super(pParent, pSequence);
        this.name = null;
        this.modelGroupImpl = new XSModelGroupImpl(XSModelGroup.SEQUENCE, pSequence.getLocator());
        this.modelGroup = this.modelGroupImpl;
        this.particles = pSequence.getParticles();
        this.nestedParticles = null;
        this.xsAnnotation = pSequence.getAnnotation();
    }

    protected XSGroupImpl(XSObject pParent, XsTAll pAll) throws SAXException {
        super(pParent, pAll);
        this.name = null;
        this.modelGroupImpl = new XSModelGroupImpl(XSModelGroup.ALL, pAll.getLocator());
        this.modelGroup = this.modelGroupImpl;
        this.particles = pAll.getParticles();
        this.nestedParticles = null;
        this.xsAnnotation = pAll.getAnnotation();
    }

    protected XsQName getQName(XsNCName pName) throws SAXException {
        if (pName == null) {
            throw new LocSAXException("Invalid group: Either of its 'ref' or 'name' attributes must be set.", this.getLocator());
        }
        XsESchema syntaxSchema = this.getXsObject().getXsESchema();
        return new XsQName(syntaxSchema.getTargetNamespace(), pName.toString(), syntaxSchema.getTargetNamespacePrefix());
    }

    protected void initParticles(XSModelGroupImpl pModelGroup, XsTNestedParticle[] pParticles) throws SAXException {
        for (int i = 0; i < pParticles.length; ++i) {
            this.addParticle(pModelGroup, pParticles[i]);
        }
    }

    protected void initParticles(XSModelGroupImpl pModelGroup, XsTParticle[] pParticles) throws SAXException {
        for (int i = 0; i < pParticles.length; ++i) {
            this.addParticle(pModelGroup, pParticles[i]);
        }
    }

    protected void addParticle(XSModelGroupImpl pModelGroup, XsTParticle pParticle) throws SAXException {
        XsTAll all;
        if (!(pParticle instanceof XsTAll)) {
            if (pParticle instanceof XsTNestedParticle) {
                this.addParticle(pModelGroup, (XsTNestedParticle)pParticle);
                return;
            }
            throw new IllegalStateException("Unknown particle type: " + pParticle.getClass().getName());
        }
        XsTAll occurs = all = (XsTAll)pParticle;
        XSGroup group = this.getXSSchema().getXSObjectFactory().newXSGroup((XSObject)this, all);
        group.validate();
        XSParticleImpl p = new XSParticleImpl(group);
        pModelGroup.addParticle(p);
        p.setMaxOccurs(occurs.getMaxOccurs());
        p.setMinOccurs(occurs.getMinOccurs());
    }

    protected void addParticle(XSModelGroupImpl pModelGroup, XsTNestedParticle pParticle) throws SAXException {
        XSParticleImpl p;
        XsTNestedParticle occurs;
        if (pParticle instanceof XsEAny) {
            XsEAny any = (XsEAny)pParticle;
            occurs = any;
            XSAny wildcard = this.getXSSchema().getXSObjectFactory().newXSAny(this, any);
            wildcard.validate();
            p = new XSParticleImpl(wildcard);
        } else if (pParticle instanceof XsEChoice) {
            XsEChoice choice = (XsEChoice)pParticle;
            occurs = choice;
            XSGroup group = this.getXSSchema().getXSObjectFactory().newXSGroup((XSObject)this, choice);
            group.validate();
            p = new XSParticleImpl(group);
        } else if (pParticle instanceof XsESequence) {
            XsESequence sequence = (XsESequence)pParticle;
            occurs = sequence;
            XSGroup group = this.getXSSchema().getXSObjectFactory().newXSGroup((XSObject)this, sequence);
            group.validate();
            p = new XSParticleImpl(group);
        } else {
            XsTGroupRef groupRef = null;
            XsTLocalElement localElement = null;
            if (pParticle instanceof XsTGroupRef) {
                groupRef = (XsTGroupRef)pParticle;
            } else if (pParticle instanceof XsTLocalElement) {
                localElement = (XsTLocalElement)pParticle;
                XsQName ref = localElement.getRef();
                if (ref != null) {
                    XSElement referencedElement = this.getXSSchema().getElement(ref);
                    if (referencedElement == null) {
                        throw new LocSAXException("The referenced element " + ref + " is undefined.", localElement.getLocator());
                    }
                    XSGroup substitutedGroup = referencedElement.getSubstitutionGroup();
                    if (substitutedGroup != null && substitutedGroup != this) {
                        XsObject parent = localElement.getParentObject();
                        XsTGroupRefImpl groupRefImpl = (XsTGroupRefImpl)localElement.getObjectFactory().newXsTGroupRef(parent);
                        groupRefImpl.setRef(substitutedGroup.getName());
                        int maxOccurs = localElement.getMaxOccurs();
                        if (maxOccurs == -1) {
                            groupRefImpl.setMaxOccurs("unbounded");
                        } else {
                            groupRefImpl.setMaxOccurs(Integer.toString(maxOccurs));
                        }
                        groupRefImpl.setMinOccurs(localElement.getMinOccurs());
                        groupRef = groupRefImpl;
                    }
                }
            } else {
                throw new IllegalStateException("Unknown particle type: " + pParticle.getClass().getName());
            }
            if (groupRef == null) {
                occurs = localElement;
                XSElement element = this.getXSSchema().getXSObjectFactory().newXSElement(this, localElement);
                element.validate();
                p = new XSParticleImpl(element);
            } else {
                occurs = groupRef;
                XSGroup group = this.getXSSchema().getXSObjectFactory().newXSGroup((XSObject)this, groupRef);
                group.validate();
                p = new XSParticleImpl(group);
            }
        }
        pModelGroup.addParticle(p);
        p.setMaxOccurs(occurs.getMaxOccurs());
        p.setMinOccurs(occurs.getMinOccurs());
    }

    public boolean isGlobal() {
        return this.isGlobal;
    }

    public void setGlobal(boolean pGlobal) {
        this.isGlobal = pGlobal;
    }

    public XsQName getName() {
        return this.name;
    }

    protected boolean isValidated() {
        return this.isValidated;
    }

    public void validate() throws SAXException {
        if (this.isValidated()) {
            return;
        }
        this.isValidated = true;
        if (this.xsAnnotation == null) {
            this.annotations = new XSAnnotation[0];
        } else {
            XSAnnotation result = this.getXSSchema().getXSObjectFactory().newXSAnnotation(this, this.xsAnnotation);
            result.validate();
            this.annotations = new XSAnnotation[]{result};
        }
        if (this.modelGroup == null) {
            XsQName myName = this.getName();
            if (myName == null) {
                throw new NullPointerException("Missing group name");
            }
            XSGroup group = this.getXSSchema().getGroup(myName);
            if (group == null) {
                throw new LocSAXException("Unknown group: " + myName, this.getLocator());
            }
            this.modelGroup = group;
        }
        if (this.particles != null) {
            this.initParticles(this.modelGroupImpl, this.particles);
        } else if (this.nestedParticles != null) {
            this.initParticles(this.modelGroupImpl, this.nestedParticles);
        }
        this.modelGroup.validate();
    }

    public XSModelGroup.Compositor getCompositor() {
        return this.modelGroup.getCompositor();
    }

    public XSParticle[] getParticles() {
        return this.modelGroup.getParticles();
    }

    public boolean isSequence() {
        return this.modelGroup.isSequence();
    }

    public boolean isChoice() {
        return this.modelGroup.isChoice();
    }

    public boolean isAll() {
        return this.modelGroup.isAll();
    }

    public XSAnnotation[] getAnnotations() {
        return this.annotations;
    }
}

