/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.xs;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.ws.jaxme.xs.XSAttributable;
import org.apache.ws.jaxme.xs.XSAttribute;
import org.apache.ws.jaxme.xs.XSComplexType;
import org.apache.ws.jaxme.xs.XSElement;
import org.apache.ws.jaxme.xs.XSElementOrAttrRef;
import org.apache.ws.jaxme.xs.XSGroup;
import org.apache.ws.jaxme.xs.XSParticle;
import org.apache.ws.jaxme.xs.XSType;
import org.apache.ws.jaxme.xs.parser.impl.LocSAXException;
import org.apache.ws.jaxme.xs.xml.XsEField;
import org.apache.ws.jaxme.xs.xml.XsESelector;
import org.apache.ws.jaxme.xs.xml.XsQName;
import org.apache.ws.jaxme.xs.xml.XsTKeybase;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public final class XPathMatcher {
    private static final XSElementOrAttrRef[] NO_MATCHES = new XSElementOrAttrRef[0];
    private final InternalNode[] _stateMachineRoots;
    private final Locator _saxLocator;

    private XPathMatcher(Locator locator, InternalNode[] roots) {
        this._saxLocator = locator;
        this._stateMachineRoots = roots;
    }

    public static XSElementOrAttrRef[][] match(XsTKeybase keybase, XSElement startingNode) throws SAXException {
        XsESelector selector = keybase.getSelector();
        XsEField[] fields = keybase.getFields();
        String selectorXPath = selector.getXpath().getToken();
        XPathMatcher baseMatcher = XPathMatcher.parse(selector.getLocator(), selectorXPath, true);
        XSElementOrAttrRef[] baseElements = baseMatcher.match(startingNode);
        int numBaseElements = baseElements.length;
        int numFields = fields.length;
        XSElementOrAttrRef[][] results = new XSElementOrAttrRef[numFields][];
        for (int i = 0; i < numFields; ++i) {
            XsEField field = fields[i];
            String fieldXPath = field.getXpath().getToken();
            XPathMatcher fieldMatcher = XPathMatcher.parse(field.getLocator(), fieldXPath, false);
            HashSet matches = new HashSet(3);
            for (int baseElementIndex = 0; baseElementIndex < numBaseElements; ++baseElementIndex) {
                fieldMatcher.match(baseElements[baseElementIndex].getElement(), matches);
            }
            int numResults = matches.size();
            results[i] = matches.toArray(new XSElementOrAttrRef[numResults]);
        }
        return results;
    }

    public static XPathMatcher parse(Locator locator, String xpath, boolean elementsOnly) throws SAXException {
        Tokenizer tokenizer = new Tokenizer(locator, xpath);
        ArrayList<InternalNode> automatasList = new ArrayList<InternalNode>(3);
        InternalNode automata = XPathMatcher.createNextAutomata(tokenizer, elementsOnly);
        while (automata != null) {
            automatasList.add(automata);
            automata = XPathMatcher.createNextAutomata(tokenizer, elementsOnly);
        }
        int numAutomatas = automatasList.size();
        InternalNode[] automataRoots = new InternalNode[numAutomatas];
        automataRoots = automatasList.toArray(automataRoots);
        return new XPathMatcher(locator, automataRoots);
    }

    public XSElementOrAttrRef[] match(XSElement startingNode) throws SAXException {
        HashSet matches = new HashSet(5);
        this.match(startingNode, matches);
        int numMatches = matches.size();
        if (numMatches == 0) {
            return NO_MATCHES;
        }
        XSElementOrAttrRef[] matchesArray = new XSElementOrAttrRef[numMatches];
        return matches.toArray(matchesArray);
    }

    public void match(XSElement startingNode, Set matches) throws SAXException {
        InternalNode[] roots = this._stateMachineRoots;
        int numRoots = roots.length;
        for (int i = 0; i < numRoots; ++i) {
            roots[i].match(startingNode, matches);
        }
    }

    private static InternalNode createNextAutomata(Tokenizer tokenizer, boolean elementsOnly) throws SAXException {
        InternalNode rootNode = XPathMatcher.createAnEntityNode(tokenizer, elementsOnly);
        if (rootNode != null) {
            XPathMatcher.appendASeperatorNode(tokenizer, rootNode, elementsOnly);
        }
        return rootNode;
    }

    private static InternalNode createAnEntityNode(Tokenizer tokenizer, boolean elementsOnly) throws SAXException {
        Token token = tokenizer.next();
        switch (token.getTokenCode()) {
            case 0: {
                return new NamedChildElementNode(token.getNameSpace(), token.getLabel());
            }
            case 2: {
                if (elementsOnly) {
                    tokenizer.throwException("No references to an attribute are allowed here.");
                }
                return new StaticAttributeNode(token.getNameSpace(), token.getLabel());
            }
            case 1: {
                return new ThisNode();
            }
            case 3: {
                return new AllChildrenNode(token.getNameSpace());
            }
            case 7: {
                return null;
            }
        }
        tokenizer.throwException("Read '" + token.getImage() + "' when a reference to either an " + "attribute or an element was expected.");
        return null;
    }

    private static void appendAnEntityNode(Tokenizer tokenizer, InternalNode previousNode, boolean elementsOnly) throws SAXException {
        InternalNode newNode = XPathMatcher.createAnEntityNode(tokenizer, elementsOnly);
        if (newNode != null) {
            previousNode.setNextNode(newNode);
            XPathMatcher.appendASeperatorNode(tokenizer, newNode, elementsOnly);
        }
    }

    private static void appendASeperatorNode(Tokenizer tokenizer, InternalNode previousNode, boolean elementsOnly) throws SAXException {
        Token token = tokenizer.next();
        switch (token.getTokenCode()) {
            case 5: {
                XPathMatcher.appendAnEntityNode(tokenizer, previousNode, elementsOnly);
                return;
            }
            case 6: {
                return;
            }
            case 7: {
                return;
            }
            case 4: {
                AllDescendantsNode newNode = new AllDescendantsNode(token.getNameSpace());
                previousNode.setNextNode(newNode);
                XPathMatcher.appendAnEntityNode(tokenizer, newNode, elementsOnly);
                return;
            }
        }
        tokenizer.throwException("Unexpected string '" + token.getImage() + "' encountered. Expected" + " either | / or nothing.");
    }

    private static final class AllDescendantsNode
    extends InternalNode {
        private final String _nameSpace;

        public AllDescendantsNode(String nameSpace) {
            this._nameSpace = nameSpace;
        }

        public void match(XSElement currentElement, Set matches) throws SAXException {
            String nameSpace = this._nameSpace;
            Iterator iterator = this.getChildrenIteratorFor(currentElement);
            while (iterator.hasNext()) {
                XSElement element = (XSElement)iterator.next();
                if (!this.doesNSMatch(nameSpace, element.getName())) continue;
                this.continueSearchFor(element, matches);
                this.match(element, matches);
            }
        }
    }

    private static final class AllChildrenNode
    extends InternalNode {
        private final String _nameSpace;

        public AllChildrenNode(String nameSpace) {
            this._nameSpace = nameSpace;
        }

        public void match(XSElement currentElement, Set matches) throws SAXException {
            String nameSpace = this._nameSpace;
            Iterator iterator = this.getChildrenIteratorFor(currentElement);
            while (iterator.hasNext()) {
                XSElement element = (XSElement)iterator.next();
                if (!this.doesNSMatch(nameSpace, element.getName())) continue;
                this.continueSearchFor(element, matches);
            }
        }
    }

    private static final class StaticAttributeNode
    extends InternalNode {
        private final String _nameSpace;
        private final String _name;

        public StaticAttributeNode(String nameSpace, String name) {
            this._nameSpace = nameSpace;
            this._name = name;
        }

        public void match(XSElement currentElement, Set matches) throws SAXException {
            XSType type = currentElement.getType();
            if (!type.isSimple()) {
                XSComplexType complexType = type.getComplexType();
                XSAttributable[] attributables = complexType.getAttributes();
                int numAttribables = attributables.length;
                for (int i = 0; i < numAttribables; ++i) {
                    XSAttribute attribute;
                    XSAttributable attributable = attributables[i];
                    if (!(attributable instanceof XSAttribute) || !this.doesMatch(this._nameSpace, this._name, (attribute = (XSAttribute)attributable).getName())) continue;
                    matches.add(new XSElementOrAttrRef(attribute));
                    return;
                }
            }
        }
    }

    private static final class NamedChildElementNode
    extends InternalNode {
        private final String _nameSpace;
        private final String _name;

        public NamedChildElementNode(String nameSpace, String name) {
            this._nameSpace = nameSpace;
            this._name = name;
        }

        public void match(XSElement currentElement, Set matches) throws SAXException {
            Iterator iterator = this.getChildrenIteratorFor(currentElement);
            while (iterator.hasNext()) {
                XSElement element = (XSElement)iterator.next();
                if (!this.doesMatch(this._nameSpace, this._name, element.getName())) continue;
                this.continueSearchFor(element, matches);
                break;
            }
        }
    }

    private static final class ThisNode
    extends InternalNode {
        public static final ThisNode LEAF_INSTANCE = new ThisNode();

        private ThisNode() {
        }

        public void match(XSElement currentElement, Set matches) throws SAXException {
            this.continueSearchFor(currentElement, matches);
        }
    }

    private static abstract class InternalNode {
        private InternalNode _next;

        private InternalNode() {
        }

        public abstract void match(XSElement var1, Set var2) throws SAXException;

        public final void setNextNode(InternalNode next) {
            this._next = next;
        }

        protected final void continueSearchFor(XSElement currentElement, Set matches) throws SAXException {
            InternalNode next = this._next;
            if (next == null) {
                matches.add(new XSElementOrAttrRef(currentElement));
            } else {
                next.match(currentElement, matches);
            }
        }

        protected boolean doesMatch(String nameSpace, String name, XsQName qName) {
            boolean boo = this.doesNSMatch(nameSpace, qName) && name.equals(qName.getLocalName());
            return boo;
        }

        protected boolean doesNSMatch(String nameSpace, XsQName qName) {
            if (nameSpace == null) {
                return qName.getPrefix() == null;
            }
            return nameSpace.equals(qName.getPrefix());
        }

        protected Iterator getChildrenIteratorFor(XSElement element) throws SAXException {
            XSComplexType complexType;
            ArrayList<XSElement> children = new ArrayList<XSElement>(5);
            XSType type = element.getType();
            if (!type.isSimple() && !(complexType = type.getComplexType()).isEmpty()) {
                XSParticle particle = complexType.getParticle();
                if (particle.isElement()) {
                    children.add(particle.getElement());
                } else if (particle.isGroup()) {
                    XSGroup group = particle.getGroup();
                    XSParticle[] particles = group.getParticles();
                    int numParticles = particles.length;
                    for (int i = 0; i < numParticles; ++i) {
                        XSParticle groupedParticle = particles[i];
                        if (!groupedParticle.isElement()) continue;
                        children.add(groupedParticle.getElement());
                    }
                }
            }
            return children.iterator();
        }
    }

    private static final class Token {
        private final int _tokenCode;
        private final String _nameSpace;
        private final String _label;
        private final String _image;

        public Token(int tokenCode, String nameSpace, String label, String image) {
            this._tokenCode = tokenCode;
            this._nameSpace = nameSpace;
            this._label = label;
            this._image = image;
        }

        public int getTokenCode() {
            return this._tokenCode;
        }

        public String getNameSpace() {
            return this._nameSpace;
        }

        public String getLabel() {
            return this._label;
        }

        public String getImage() {
            return this._image;
        }
    }

    private static final class Tokenizer {
        public static final int ELEMENT_TOKEN = 0;
        public static final int THIS_TOKEN = 1;
        public static final int ATTR_TOKEN = 2;
        public static final int ALL_CHILDREN_TOKEN = 3;
        public static final int ALL_DESCENDANTS_TOKEN = 4;
        public static final int SEPARATOR_TOKEN = 5;
        public static final int OR_TOKEN = 6;
        public static final int END_TOKEN = 7;
        public static final CharHandler STARTING_HANDLER = new InitialCharHandler();
        public static final CharHandler ATTRIBUTE_HANDLER = new AttributeCharHandler();
        public static final CharHandler ELEMENT_HANDLER = new ElementCharHandler();
        private final String _xpath;
        private final Locator _saxLocator;
        private int _pos;

        public Tokenizer(Locator locator, String xpath) {
            this._xpath = xpath;
            this._saxLocator = locator;
        }

        public boolean hasNext() {
            return this._pos < this._xpath.length();
        }

        public Token next() throws SAXException {
            TokenizerState context = new TokenizerState();
            while (context.hasNext()) {
                CharHandler ch = context.getCharHandler();
                ch.process(context);
            }
            this._pos = context.getPos();
            return context.createToken();
        }

        public void throwException(String msg) throws SAXException {
            throw new LocSAXException(msg, this._saxLocator);
        }

        private static final class AttributeCharHandler
        extends CharHandler {
            private AttributeCharHandler() {
            }

            public void process(TokenizerState context) throws SAXException {
                context.skipOverIdentifier();
                if (context.hasNext() && context.peekAhead() == ':') {
                    context.saveNameSpace();
                    context.scrollAhead();
                    context.markPos();
                    context.skipOverIdentifier();
                }
                context.saveLabel();
                context.setTokenCode(2);
            }
        }

        private static final class ElementCharHandler
        extends CharHandler {
            private ElementCharHandler() {
            }

            public void process(TokenizerState context) throws SAXException {
                context.skipOverIdentifier();
                if (context.hasNext() && context.peekAhead() == ':') {
                    context.saveNameSpace();
                    context.scrollAhead();
                    if (context.hasNext() && context.peekAhead() == '*') {
                        context.scrollAhead();
                        context.setTokenCode(3);
                        return;
                    }
                    context.markPos();
                    context.skipOverIdentifier();
                }
                context.saveLabel();
                context.setTokenCode(0);
            }
        }

        private static final class InitialCharHandler
        extends CharHandler {
            private InitialCharHandler() {
            }

            public void process(TokenizerState context) throws SAXException {
                context.skipWhiteSpace();
                if (!context.hasNext()) {
                    return;
                }
                char ch = context.peekAhead();
                switch (ch) {
                    case '*': {
                        context.scrollAhead();
                        context.setTokenCode(3);
                        break;
                    }
                    case '.': {
                        context.scrollAhead();
                        context.setTokenCode(1);
                        break;
                    }
                    case '/': {
                        context.scrollAhead();
                        if (context.peekAhead() == '/') {
                            context.scrollAhead();
                            context.setTokenCode(4);
                            break;
                        }
                        context.setTokenCode(5);
                        break;
                    }
                    case '|': {
                        context.scrollAhead();
                        context.setTokenCode(6);
                        break;
                    }
                    case '@': {
                        context.scrollAhead();
                        context.markPos();
                        context.setCharHandler(ATTRIBUTE_HANDLER);
                        break;
                    }
                    default: {
                        context.setCharHandler(ELEMENT_HANDLER);
                    }
                }
            }
        }

        private static abstract class CharHandler {
            private CharHandler() {
            }

            public abstract void process(TokenizerState var1) throws SAXException;
        }

        private class TokenizerState {
            private final int _startPos;
            private int _pos;
            private int _markedPos;
            private int _tokenCode = -1;
            private String _nameSpace;
            private String _label;
            private CharHandler _charHandler = STARTING_HANDLER;

            public TokenizerState() {
                this._startPos = Tokenizer.this._pos;
                this._pos = Tokenizer.this._pos;
                this._markedPos = Tokenizer.this._pos;
            }

            public int getPos() {
                return this._pos;
            }

            public CharHandler getCharHandler() {
                return this._charHandler;
            }

            public void setCharHandler(CharHandler ch) {
                this._charHandler = ch;
            }

            public boolean hasMatch() {
                return this._tokenCode >= 0;
            }

            public boolean hasNext() {
                boolean boo = !this.hasMatch() && this._pos < Tokenizer.this._xpath.length();
                return boo;
            }

            public char peekAhead() {
                return Tokenizer.this._xpath.charAt(this._pos);
            }

            public char scrollAhead() {
                return Tokenizer.this._xpath.charAt(this._pos++);
            }

            public void skipWhiteSpace() {
                char ch;
                int pos;
                String xpath = Tokenizer.this._xpath;
                int maxPos = xpath.length();
                for (pos = this._pos; pos < maxPos && Character.isWhitespace(ch = xpath.charAt(pos)); ++pos) {
                }
                this._pos = pos;
            }

            public void skipOverIdentifier() {
                char ch;
                int pos;
                String xpath = Tokenizer.this._xpath;
                int maxPos = xpath.length();
                for (pos = this._pos; pos < maxPos && (Character.isLetterOrDigit(ch = xpath.charAt(pos)) || ch == '_' || ch == '-'); ++pos) {
                }
                this._pos = pos;
            }

            public void setTokenCode(int tokenCode) {
                this._tokenCode = tokenCode;
            }

            public void markPos() {
                this._markedPos = this._pos;
            }

            public void saveNameSpace() {
                this._nameSpace = Tokenizer.this._xpath.substring(this._markedPos, this._pos);
                this._markedPos = this._pos;
            }

            public void saveLabel() {
                this._label = Tokenizer.this._xpath.substring(this._markedPos, this._pos);
                this._markedPos = this._pos;
            }

            public Token createToken() {
                if (!this.hasMatch() && !this.hasNext()) {
                    this._tokenCode = 7;
                }
                return new Token(this._tokenCode, this._nameSpace, this._label, Tokenizer.this._xpath.substring(this._startPos, this._pos));
            }

            public void throwException(String msg) throws SAXException {
                Tokenizer.this.throwException(msg);
            }
        }
    }
}

