/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.NamespaceContext;

public class NamespaceSupport
implements NamespaceContext {
    List prefixList;
    String cachedURI;
    String cachedPrefix;

    public void reset() {
        this.cachedPrefix = null;
        this.cachedURI = null;
        if (this.prefixList != null) {
            this.prefixList.clear();
        }
    }

    public void declarePrefix(String pPrefix, String pURI) {
        if (pURI == null) {
            pURI = "";
        }
        if (this.cachedURI == null) {
            this.cachedURI = pURI;
            this.cachedPrefix = pPrefix;
        } else {
            if (this.prefixList == null) {
                this.prefixList = new ArrayList();
            }
            this.prefixList.add(this.cachedPrefix);
            this.prefixList.add(this.cachedURI);
            this.cachedPrefix = pPrefix;
            this.cachedURI = pURI;
        }
    }

    public void undeclarePrefix(String pPrefix) {
        if (pPrefix.equals(this.cachedPrefix)) {
            if (this.prefixList != null && this.prefixList.size() > 0) {
                this.cachedURI = this.prefixList.remove(this.prefixList.size() - 1).toString();
                this.cachedPrefix = this.prefixList.remove(this.prefixList.size() - 1).toString();
            } else {
                this.cachedURI = null;
                this.cachedPrefix = null;
            }
        } else {
            for (int i = this.prefixList.size() - 2; i >= 0; i -= 2) {
                if (!pPrefix.equals(this.prefixList.get(i))) continue;
                this.prefixList.remove(i);
                this.prefixList.remove(i);
                return;
            }
            throw new IllegalStateException("Undeclared prefix: " + pPrefix);
        }
    }

    public String getNamespaceURI(String pPrefix) {
        if (pPrefix == null) {
            throw new IllegalArgumentException("Namespace prefix must not be null");
        }
        if (this.cachedURI != null) {
            if (this.cachedPrefix.equals(pPrefix)) {
                return this.cachedURI;
            }
            if (this.prefixList != null) {
                for (int i = this.prefixList.size(); i > 0; i -= 2) {
                    if (!pPrefix.equals(this.prefixList.get(i - 2))) continue;
                    return (String)this.prefixList.get(i - 1);
                }
            }
        }
        if ("xml".equals(pPrefix)) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        if ("xmlns".equals(pPrefix)) {
            return "http://www.w3.org/2000/xmlns/";
        }
        return null;
    }

    public String getPrefix(String pURI) {
        if (pURI == null) {
            throw new IllegalArgumentException("Namespace URI must not be null");
        }
        if (this.cachedURI != null) {
            if (this.cachedURI.equals(pURI)) {
                return this.cachedPrefix;
            }
            if (this.prefixList != null) {
                for (int i = this.prefixList.size(); i > 0; i -= 2) {
                    if (!pURI.equals(this.prefixList.get(i - 1))) continue;
                    return (String)this.prefixList.get(i - 2);
                }
            }
        }
        if ("http://www.w3.org/XML/1998/namespace".equals(pURI)) {
            return "xml";
        }
        if ("http://www.w3.org/2000/xmlns/".equals(pURI)) {
            return "xmlns";
        }
        return null;
    }

    public String getAttributePrefix(String pURI) {
        if (pURI == null) {
            throw new IllegalArgumentException("Namespace URI must not be null");
        }
        if (pURI == null || pURI.length() == 0) {
            return "";
        }
        if (this.cachedURI != null) {
            if (this.cachedURI.equals(pURI) && this.cachedPrefix.length() > 0) {
                return this.cachedPrefix;
            }
            if (this.prefixList != null) {
                for (int i = this.prefixList.size(); i > 0; i -= 2) {
                    String prefix;
                    if (!pURI.equals(this.prefixList.get(i - 1)) || (prefix = (String)this.prefixList.get(i - 2)).length() <= 0) continue;
                    return prefix;
                }
            }
        }
        if ("http://www.w3.org/XML/1998/namespace".equals(pURI)) {
            return "xml";
        }
        if ("http://www.w3.org/2000/xmlns/".equals(pURI)) {
            return "xmlns";
        }
        return null;
    }

    public Iterator getPrefixes(String pURI) {
        if (pURI == null) {
            throw new IllegalArgumentException("Namespace URI must not be null");
        }
        ArrayList<String> list = new ArrayList<String>();
        if (this.cachedURI != null) {
            if (this.cachedURI.equals(pURI)) {
                list.add(this.cachedPrefix);
            }
            if (this.prefixList != null) {
                for (int i = this.prefixList.size(); i > 0; i -= 2) {
                    if (!pURI.equals(this.prefixList.get(i - 1))) continue;
                    list.add((String)this.prefixList.get(i - 2));
                }
            }
        }
        if (pURI.equals("http://www.w3.org/2000/xmlns/")) {
            list.add("xmlns");
        } else if (pURI.equals("http://www.w3.org/XML/1998/namespace")) {
            list.add("xml");
        }
        return list.iterator();
    }

    public boolean isPrefixDeclared(String pPrefix) {
        if (this.cachedURI != null) {
            if (this.cachedPrefix != null && this.cachedPrefix.equals(pPrefix)) {
                return true;
            }
            if (this.prefixList != null) {
                for (int i = this.prefixList.size(); i > 0; i -= 2) {
                    if (!this.prefixList.get(i - 2).equals(pPrefix)) continue;
                    return true;
                }
            }
        }
        return "xml".equals(pPrefix);
    }

    public int getContext() {
        return (this.prefixList == null ? 0 : this.prefixList.size()) + (this.cachedURI == null ? 0 : 2);
    }

    public String setContext(int i) {
        if (this.getContext() == i) {
            return null;
        }
        String result = this.cachedPrefix;
        if (this.prefixList != null && this.prefixList.size() > 0) {
            this.cachedURI = this.prefixList.remove(this.prefixList.size() - 1).toString();
            this.cachedPrefix = this.prefixList.remove(this.prefixList.size() - 1).toString();
        } else {
            this.cachedURI = null;
            this.cachedPrefix = null;
        }
        return result;
    }
}

