/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.util;

import java.io.Serializable;

public class Duration
implements Serializable,
Comparable {
    private final boolean isNegative;
    private final int years;
    private final int months;
    private final int days;
    private final int hours;
    private final int minutes;
    private final int seconds;
    private final long millis;

    public Duration(boolean pNegative, int pYears, int pMonths, int pDays, int pHours, int pMinutes, int pSeconds, long pMillis) {
        this.isNegative = pNegative;
        this.years = pYears;
        this.months = pMonths;
        this.days = pDays;
        this.hours = pHours;
        this.minutes = pMinutes;
        this.seconds = pSeconds;
        this.millis = pMillis;
    }

    public int getYears() {
        return this.years;
    }

    public int getMonths() {
        return this.months;
    }

    public int getDays() {
        return this.days;
    }

    public int getHours() {
        return this.hours;
    }

    public int getMinutes() {
        return this.minutes;
    }

    public int getSeconds() {
        return this.seconds;
    }

    public long getMillis() {
        return this.millis;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append('P');
        sb.append(this.getYears());
        sb.append('Y');
        sb.append(this.getMonths());
        sb.append('M');
        sb.append(this.getDays());
        sb.append("DT");
        sb.append(this.getHours());
        sb.append('H');
        sb.append(this.getMinutes());
        sb.append('M');
        sb.append(this.getSeconds());
        long m = this.getMillis();
        if (m != 0L) {
            sb.append('.');
            sb.append(m);
        }
        sb.append('S');
        return sb.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Duration valueOf(String pValue) {
        boolean isNegative;
        if (pValue == null) {
            throw new NullPointerException("The duration value must not be null.");
        }
        int len = pValue.length();
        int offset = 0;
        if (len <= 0) throw new IllegalArgumentException("Invalid duration: Empty string");
        char c = pValue.charAt(0);
        if (c == '-') {
            isNegative = true;
            ++offset;
        } else if (c == '+') {
            isNegative = false;
            ++offset;
        } else {
            isNegative = false;
        }
        if (len == 0 || pValue.charAt(offset) != 'P') {
            throw new IllegalArgumentException("Invalid duration: " + pValue + " (must start with P, +P, or -P)");
        }
        ++offset;
        int years = -1;
        int months = -1;
        int daysOfMonth = -1;
        int hours = -1;
        int minutes = -1;
        int seconds = -1;
        long millis = -1L;
        int preDecimalPoint = -1;
        boolean separatorSeen = false;
        StringBuffer digits = new StringBuffer();
        while (offset < len) {
            char c2 = pValue.charAt(offset);
            if (Character.isDigit(c2)) {
                digits.append(c2);
            } else if (c2 == 'T') {
                if (separatorSeen) {
                    throw new IllegalArgumentException("Invalid duration: " + pValue + " (date/time separator 'T' used twice)");
                }
                separatorSeen = true;
            } else {
                long l;
                if (digits.length() == 0) {
                    l = 0L;
                } else {
                    try {
                        l = Long.parseLong(digits.toString());
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException("Invalid duration: " + pValue + " (max long value exceeded by " + digits + ")");
                    }
                    digits.setLength(0);
                }
                if (preDecimalPoint >= 0) {
                    if (c2 != 'S') throw new IllegalArgumentException("Invalid duration: " + pValue + " (decimal point not allowed here: " + preDecimalPoint + "." + digits + c2 + ")");
                    if (!separatorSeen) {
                        throw new IllegalArgumentException("Invalid duration: " + pValue + "(seconds specified before date/time separator 'T' seen)");
                    }
                    if (seconds != -1) {
                        throw new IllegalArgumentException("Invalid duration: " + pValue + " (seconds specified twice)");
                    }
                    seconds = preDecimalPoint;
                    millis = l;
                    preDecimalPoint = -1;
                } else {
                    if (l > Integer.MAX_VALUE) {
                        throw new IllegalArgumentException("Invalid duration: " + pValue + " (max integer value exceeded by " + digits + ")");
                    }
                    int i = (int)l;
                    if (c2 == '.') {
                        preDecimalPoint = i;
                    } else if (separatorSeen) {
                        if (c2 == 'Y' || c2 == 'D') {
                            throw new IllegalArgumentException("Invalid duration: " + pValue + " (years or days of month specified after date/time separator 'T' seen)");
                        }
                        if (c2 == 'S') {
                            if (seconds != -1) {
                                throw new IllegalArgumentException("Invalid duration: " + pValue + " (seconds specified twice)");
                            }
                            seconds = i;
                            millis = 0L;
                        } else if (c2 == 'M') {
                            if (minutes != -1) {
                                throw new IllegalArgumentException("Invalid duration: " + pValue + " (minutes specified twice)");
                            }
                            if (seconds != -1) {
                                throw new IllegalArgumentException("Invalid duration: " + pValue + " (minutes specified after seconds)");
                            }
                            minutes = i;
                        } else if (c2 == 'H') {
                            if (hours != -1) {
                                throw new IllegalArgumentException("Invalid duration: " + pValue + " (hours specified twice)");
                            }
                            if (minutes != -1) {
                                throw new IllegalArgumentException("Invalid duration: " + pValue + " (hours specified after minutes)");
                            }
                            if (seconds != -1) {
                                throw new IllegalArgumentException("Invalid duration: " + pValue + " (seconds specified after minutes)");
                            }
                            hours = i;
                        }
                    } else {
                        if (c2 == 'H' || c2 == 'S') {
                            throw new IllegalArgumentException("Invalid duration: " + pValue + " (hours or seconds specified before date/time separator 'T' seen)");
                        }
                        if (c2 == 'Y') {
                            if (years != -1) {
                                throw new IllegalArgumentException("Invalid duration: " + pValue + " (years specified twice)");
                            }
                            if (months != -1) {
                                throw new IllegalArgumentException("Invalid duration: " + pValue + " (years specified after months)");
                            }
                            if (daysOfMonth != -1) {
                                throw new IllegalArgumentException("Invalid duration: " + pValue + " (years specified after days of month)");
                            }
                            years = i;
                        } else if (c2 == 'M') {
                            if (months != -1) {
                                throw new IllegalArgumentException("Invalid duration: " + pValue + " (months specified twice)");
                            }
                            if (daysOfMonth != -1) {
                                throw new IllegalArgumentException("Invalid duration: " + pValue + " (days of month specified after months)");
                            }
                            months = i;
                        } else if (c2 == 'D') {
                            if (daysOfMonth != -1) {
                                throw new IllegalArgumentException("Invalid duration: " + pValue + " (days of month specified twice)");
                            }
                            daysOfMonth = i;
                        }
                    }
                }
            }
            ++offset;
        }
        return new Duration(isNegative, years == -1 ? 0 : years, months == -1 ? 0 : months, daysOfMonth == -1 ? 0 : daysOfMonth, hours == -1 ? 0 : hours, minutes == -1 ? 0 : minutes, seconds == -1 ? 0 : seconds, millis == -1L ? 0L : millis);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof Duration)) {
            return false;
        }
        return this.compareTo((Duration)o) == 0;
    }

    public int compareTo(Object o) {
        return this.compareTo((Duration)o);
    }

    public int compareTo(Duration d) {
        if (this.isNegative != d.isNegative) {
            return this.isNegative ? -1 : 1;
        }
        if (this.years != d.years) {
            return this.years - d.years;
        }
        if (this.months != d.months) {
            return this.months - d.months;
        }
        if (this.days != d.days) {
            return this.days - d.days;
        }
        if (this.hours != d.hours) {
            return this.hours - d.hours;
        }
        if (this.minutes != d.minutes) {
            return this.minutes - d.minutes;
        }
        if (this.seconds != d.seconds) {
            return this.seconds - d.seconds;
        }
        if (this.millis > d.millis) {
            return 1;
        }
        if (this.millis < d.millis) {
            return -1;
        }
        return 0;
    }

    public int hashCode() {
        return this.isNegative ? 1 : 0 + this.years + this.months + this.days + this.hours + this.minutes + this.seconds + (int)this.millis;
    }
}

