/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.impl;

import javax.xml.bind.DatatypeConverterInterface;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import org.apache.ws.jaxme.JMMarshaller;
import org.apache.ws.jaxme.JMXmlSerializer;
import org.apache.ws.jaxme.impl.JAXBContextImpl;
import org.apache.ws.jaxme.util.NamespaceSupport;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class JMXmlSerializerImpl
implements JMXmlSerializer {
    private static final Attributes zeroAttributes = new AttributesImpl();

    public void init(JAXBContextImpl pFactory) throws JAXBException {
    }

    public String getPreferredPrefix(String pURI) {
        return null;
    }

    public JMXmlSerializer.Data getData(JMMarshaller pMarshaller, ContentHandler pHandler) {
        return new Data(pMarshaller, pHandler);
    }

    protected AttributesImpl getAttributes(JMXmlSerializer.Data pData, Object pElement) throws SAXException {
        return new AttributesImpl();
    }

    protected String getAttributeQName(JMXmlSerializer.Data pData, String pURI, String pLocalName) throws SAXException {
        NamespaceSupport nss = pData.getNamespaceContext();
        String prefix = nss.getAttributePrefix(pURI);
        if (prefix == null) {
            String preferredPrefix = this.getPreferredPrefix(pURI);
            if (preferredPrefix == null || preferredPrefix.length() == 0) {
                preferredPrefix = "p";
            }
            prefix = pData.getNewPrefix(pURI, preferredPrefix);
            pData.getContentHandler().startPrefixMapping(prefix, pURI);
        }
        if (prefix.length() == 0) {
            return pLocalName;
        }
        return prefix + ":" + pLocalName;
    }

    protected String getElementQName(JMXmlSerializer.Data pData, String pURI, String pLocalName) throws SAXException {
        NamespaceSupport nss = pData.getNamespaceContext();
        String prefix = nss.getPrefix(pURI);
        if (prefix == null) {
            prefix = pData.getNewPrefix(pURI, this.getPreferredPrefix(pURI));
            pData.getContentHandler().startPrefixMapping(prefix, pURI);
        }
        if (prefix.length() == 0) {
            return pLocalName;
        }
        return prefix + ":" + pLocalName;
    }

    protected void marshalChilds(JMXmlSerializer.Data pData, Object pElement) throws SAXException {
    }

    protected void marshalAtomicChild(JMXmlSerializer.Data pData, QName pQName, String pValue) throws SAXException {
        ContentHandler handler = pData.getContentHandler();
        String uri = pQName.getNamespaceURI();
        String localName = pQName.getLocalPart();
        String qName = this.getElementQName(pData, uri, localName);
        handler.startElement(uri, localName, qName, zeroAttributes);
        handler.characters(pValue.toCharArray(), 0, pValue.length());
        handler.endElement(uri, localName, qName);
    }

    protected void marshalAtomicChild(JMXmlSerializer.Data pData, String pNamespaceURI, String pLocalName, String pValue) throws SAXException {
        ContentHandler handler = pData.getContentHandler();
        String qName = this.getElementQName(pData, pNamespaceURI, pLocalName);
        handler.startElement(pNamespaceURI, pLocalName, qName, zeroAttributes);
        handler.characters(pValue.toCharArray(), 0, pValue.length());
        handler.endElement(pNamespaceURI, pLocalName, qName);
    }

    public void marshal(JMXmlSerializer.Data pData, QName pName, Object pElement) throws SAXException {
        String prefix;
        NamespaceSupport nss = pData.getNamespaceContext();
        int context = nss.getContext();
        ContentHandler handler = pData.getContentHandler();
        String uri = pName.getNamespaceURI();
        if (uri == null) {
            uri = "";
        }
        String name = pName.getLocalPart();
        String qName = this.getElementQName(pData, uri, name);
        handler.startElement(uri, name, qName, this.getAttributes(pData, pElement));
        this.marshalChilds(pData, pElement);
        handler.endElement(uri, name, qName);
        while ((prefix = nss.setContext(context)) != null) {
            handler.endPrefixMapping(prefix);
        }
    }

    protected class Data
    implements JMXmlSerializer.Data {
        private int cnt;
        private JMMarshaller marshaller;
        private ContentHandler handler;
        private NamespaceSupport nss = new NamespaceSupport();

        protected Data(JMMarshaller pMarshaller, ContentHandler pHandler) {
            this.marshaller = pMarshaller;
            this.handler = pHandler;
        }

        public JMMarshaller getJMMarshaller() {
            return this.marshaller;
        }

        public ContentHandler getContentHandler() {
            return this.handler;
        }

        public NamespaceSupport getNamespaceContext() {
            return this.nss;
        }

        public DatatypeConverterInterface getDatatypeConverter() {
            return this.getJMMarshaller().getDatatypeConverter();
        }

        public JMXmlSerializer getJMXmlSerializer() {
            return JMXmlSerializerImpl.this;
        }

        public String getNewPrefix(String pURI, String pSuggestedPrefix) {
            if (pSuggestedPrefix == null || pSuggestedPrefix.length() == 0) {
                if (!this.nss.isPrefixDeclared("")) {
                    this.nss.declarePrefix("", pURI);
                    return "";
                }
                pSuggestedPrefix = "p";
            }
            String pc = pSuggestedPrefix;
            while (true) {
                if (!this.nss.isPrefixDeclared(pc)) {
                    this.nss.declarePrefix(pc, pURI);
                    return pc;
                }
                pc = pSuggestedPrefix + ++this.cnt;
            }
        }
    }
}

