/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.impl;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBException;
import javax.xml.bind.UnmarshallerHandler;
import javax.xml.namespace.QName;
import org.apache.ws.jaxme.JMHandler;
import org.apache.ws.jaxme.JMUnmarshaller;
import org.apache.ws.jaxme.Observer;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class JMUnmarshallerHandlerImpl
implements UnmarshallerHandler,
Observer {
    private JMUnmarshaller unmarshaller;
    private JMHandler myHandler;
    private Object result;
    private Locator locator;
    private List prefixes = new ArrayList();

    public void setJMUnmarshaller(JMUnmarshaller pUnmarshaller) {
        this.unmarshaller = pUnmarshaller;
    }

    public JMUnmarshaller getJMUnmarshaller() {
        return this.unmarshaller;
    }

    public void notify(Object pObject) {
        this.result = pObject;
    }

    public Object getResult() throws JAXBException, IllegalStateException {
        if (this.myHandler == null) {
            throw new IllegalStateException("No startElement event has been seen.");
        }
        if (this.result == null) {
            throw new IllegalStateException("Parsing is not yet finished.");
        }
        return this.result;
    }

    public void setDocumentLocator(Locator pLocator) {
        this.locator = pLocator;
        if (this.myHandler != null) {
            this.myHandler.setDocumentLocator(pLocator);
        }
    }

    public void startDocument() throws SAXException {
        this.result = null;
        this.myHandler = null;
    }

    public void endDocument() throws SAXException {
        if (this.myHandler != null) {
            this.myHandler.endDocument();
        }
    }

    public void startPrefixMapping(String pPrefix, String pURI) throws SAXException {
        if (this.myHandler != null) {
            this.myHandler.startPrefixMapping(pPrefix, pURI);
        } else {
            this.prefixes.add(pPrefix);
            this.prefixes.add(pURI);
        }
    }

    public void endPrefixMapping(String pPrefix) throws SAXException {
        if (this.myHandler == null) {
            for (int i = this.prefixes.size() - 2; i >= 0; i -= 2) {
                if (!pPrefix.equals(this.prefixes.get(i))) continue;
                this.prefixes.remove(i);
                this.prefixes.remove(i);
                return;
            }
            throw new SAXException("Undeclared namespace prefix: " + pPrefix);
        }
        this.myHandler.endPrefixMapping(pPrefix);
    }

    public void startElement(String pNamespaceURI, String pLocalName, String pQName, Attributes pAttr) throws SAXException {
        if (this.myHandler == null) {
            QName name = new QName(pNamespaceURI, pLocalName);
            try {
                this.myHandler = this.unmarshaller.getJAXBContextImpl().getJMHandler(name);
                this.myHandler.init(this.unmarshaller);
            }
            catch (JAXBException e) {
                throw new SAXException((Exception)((Object)e));
            }
            if (this.locator != null) {
                this.myHandler.setDocumentLocator(this.locator);
            }
            this.myHandler.setObserver(this);
            this.myHandler.startDocument();
            if (this.prefixes.size() > 0) {
                for (int i = 0; i < this.prefixes.size(); i += 2) {
                    this.myHandler.startPrefixMapping(this.prefixes.get(i).toString(), this.prefixes.get(i + 1).toString());
                }
                this.prefixes.clear();
            }
        }
        this.myHandler.startElement(pNamespaceURI, pLocalName, pQName, pAttr);
    }

    public void endElement(String pNamespaceURI, String pLocalName, String pQName) throws SAXException {
        this.myHandler.endElement(pNamespaceURI, pLocalName, pQName);
    }

    public void characters(char[] pChars, int pStart, int pLen) throws SAXException {
        this.myHandler.characters(pChars, pStart, pLen);
    }

    public void ignorableWhitespace(char[] pChars, int pStart, int pLen) throws SAXException {
        this.myHandler.ignorableWhitespace(pChars, pStart, pLen);
    }

    public void processingInstruction(String pTarget, String pData) throws SAXException {
        if (this.myHandler != null) {
            this.myHandler.processingInstruction(pTarget, pData);
        }
    }

    public void skippedEntity(String pName) throws SAXException {
        if (this.myHandler != null) {
            this.myHandler.skippedEntity(pName);
        }
    }
}

