/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.generator.sg.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.ws.jaxme.generator.Generator;
import org.apache.ws.jaxme.generator.impl.SchemaReaderImpl;
import org.apache.ws.jaxme.generator.sg.SGFactory;
import org.apache.ws.jaxme.generator.sg.SGFactoryChain;
import org.apache.ws.jaxme.generator.sg.SchemaSG;
import org.apache.ws.jaxme.generator.sg.impl.JAXBSGFactory;
import org.apache.ws.jaxme.generator.sg.impl.SGFactoryImpl;
import org.apache.ws.jaxme.logging.Logger;
import org.apache.ws.jaxme.logging.LoggerAccess;
import org.apache.ws.jaxme.xs.XSParser;
import org.apache.ws.jaxme.xs.XSSchema;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class JAXBSchemaReader
extends SchemaReaderImpl {
    private static final Logger log = LoggerAccess.getLogger((Class)(class$org$apache$ws$jaxme$generator$sg$impl$JAXBSchemaReader == null ? (class$org$apache$ws$jaxme$generator$sg$impl$JAXBSchemaReader = JAXBSchemaReader.class$("org.apache.ws.jaxme.generator.sg.impl.JAXBSchemaReader")) : class$org$apache$ws$jaxme$generator$sg$impl$JAXBSchemaReader));
    private boolean isSupportingExtensions = false;
    private List sgFactoryChains = new ArrayList();
    static /* synthetic */ Class class$org$apache$ws$jaxme$generator$sg$impl$JAXBSchemaReader;
    static /* synthetic */ Class class$org$apache$ws$jaxme$generator$sg$SGFactoryChain;

    public boolean isSupportingExtensions() {
        return this.isSupportingExtensions;
    }

    public void setSupportingExtensions(boolean pSupportingExtensions) {
        this.isSupportingExtensions = pSupportingExtensions;
    }

    public void addSGFactoryChain(Class pChainClass) {
        String mName = "addSGFactoryChain";
        if (pChainClass == null) {
            throw new NullPointerException("The pChainClass argument must not be null.");
        }
        log.finest("addSGFactoryChain", "->", (Object)pChainClass.getName());
        this.sgFactoryChains.add(pChainClass);
        log.finest("addSGFactoryChain", "<-", (Object)Integer.toString(this.sgFactoryChains.size()));
    }

    protected SGFactoryChain newSGFactoryChain(Generator pGenerator) {
        return new JAXBSGFactory(pGenerator);
    }

    public SGFactory getSGFactory() throws SAXException {
        String mName = "getSGFactory";
        log.finest("getSGFactory", "->");
        SGFactoryChain chain = this.newSGFactoryChain(this.getGenerator());
        log.finest("getSGFactory", "Created instance of " + chain.getClass().getName());
        Iterator iter = this.sgFactoryChains.iterator();
        while (iter.hasNext()) {
            Object o;
            Class c = (Class)iter.next();
            log.finest("getSGFactory", "Adding instance of " + c.getName());
            try {
                Constructor con = c.getConstructor(class$org$apache$ws$jaxme$generator$sg$SGFactoryChain == null ? JAXBSchemaReader.class$("org.apache.ws.jaxme.generator.sg.SGFactoryChain") : class$org$apache$ws$jaxme$generator$sg$SGFactoryChain);
                o = con.newInstance(chain);
            }
            catch (NoSuchMethodException e) {
                throw new SAXException("The SGFactoryChain class " + c.getName() + " has no constructor taking the backing chain as an argument.");
            }
            catch (InvocationTargetException e) {
                Throwable t = e.getCause();
                String msg = "Failed to invoke the constructor of class " + c.getName() + " with an argument of type " + chain.getClass().getName() + ": " + t.getClass().getName() + ", " + t.getMessage();
                if (t instanceof Exception) {
                    throw new SAXException(msg, (Exception)t);
                }
                throw new SAXException(msg, e);
            }
            catch (Exception e) {
                throw new SAXException("Failed to invoke the constructor of class " + c.getName() + " with an argument of type " + chain.getClass().getName() + ": " + e.getClass().getName() + ", " + e.getMessage(), e);
            }
            chain = (SGFactoryChain)o;
        }
        SGFactoryImpl result = new SGFactoryImpl(chain);
        result.init();
        log.finest("getSGFactory", "<-", (Object)result);
        return result;
    }

    public SchemaSG parse(InputSource pSource) throws Exception {
        String mName = "parse";
        log.finest("parse", "->", (Object)pSource.getSystemId());
        SGFactory factory = this.getSGFactory();
        XSParser parser = factory.newXSParser();
        log.finest("parse", "Parser = " + parser + ", validating = " + this.getGenerator().isValidating());
        parser.setValidating(this.getGenerator().isValidating());
        XSSchema schema = parser.parse(pSource);
        log.finest("parse", "Schema = " + schema);
        SchemaSG result = factory.getSchemaSG(schema);
        log.finest("parse", "<-", (Object)result);
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

