/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.generator.sg.impl;

import org.apache.ws.jaxme.generator.sg.Context;
import org.apache.ws.jaxme.generator.sg.GroupSG;
import org.apache.ws.jaxme.generator.sg.ObjectSG;
import org.apache.ws.jaxme.generator.sg.ParticleSG;
import org.apache.ws.jaxme.generator.sg.ParticleSGChain;
import org.apache.ws.jaxme.generator.sg.PropertySG;
import org.apache.ws.jaxme.generator.sg.PropertySGChain;
import org.apache.ws.jaxme.generator.sg.SGlet;
import org.apache.ws.jaxme.generator.sg.TypeSG;
import org.apache.ws.jaxme.generator.sg.impl.AnyElementPropertySG;
import org.apache.ws.jaxme.generator.sg.impl.JAXBPropertySG;
import org.apache.ws.jaxme.generator.sg.impl.MultiplePropertySG;
import org.apache.ws.jaxme.generator.sg.impl.PropertySGImpl;
import org.apache.ws.jaxme.js.DirectAccessible;
import org.apache.ws.jaxme.js.JavaMethod;
import org.apache.ws.jaxme.xs.XSAny;
import org.apache.ws.jaxme.xs.XSElement;
import org.apache.ws.jaxme.xs.XSParticle;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class JAXBParticleSG
implements ParticleSGChain {
    private final int minOccurs;
    private final int maxOccurs;
    private final XSParticle.Type type;
    private PropertySG propertySG;
    private final GroupSG groupSG;
    private final ObjectSG objectSG;
    private final Locator locator;
    private XSElement element;
    private XSAny wildcard;

    public JAXBParticleSG(GroupSG pGroup, XSParticle pParticle, Context pClassContext) throws SAXException {
        this.minOccurs = pParticle.getMinOccurs();
        this.maxOccurs = pParticle.getMaxOccurs();
        this.type = pParticle.getType();
        if (pParticle.isGroup()) {
            this.groupSG = pGroup.getFactory().getGroupSG(pParticle.getGroup(), pClassContext);
            this.objectSG = null;
        } else if (pParticle.isElement()) {
            this.objectSG = pGroup.getFactory().getObjectSG(pParticle.getElement(), pClassContext);
            this.groupSG = null;
            this.element = pParticle.getElement();
        } else if (pParticle.isWildcard()) {
            this.objectSG = pGroup.getFactory().getObjectSG(pParticle.getWildcard(), pClassContext);
            this.groupSG = null;
            this.wildcard = pParticle.getWildcard();
        } else {
            throw new IllegalStateException("Particle is neither group, nor element, or wildcard.");
        }
        this.locator = pParticle.getLocator();
    }

    public Object newPropertySGChain(ParticleSG pController) {
        MultiplePropertySG multiplePropertySG;
        JAXBPropertySG result;
        if (this.element != null) {
            result = new JAXBPropertySG(this.objectSG, this.element);
            this.element = null;
        } else if (this.wildcard != null) {
            result = new AnyElementPropertySG(this.objectSG, this.wildcard);
            this.wildcard = null;
        } else {
            throw new IllegalStateException("A new PropertySGChain cannot be obtained.");
        }
        if (this.maxOccurs > 1 || this.maxOccurs == -1) {
            multiplePropertySG = new MultiplePropertySG(result, this.objectSG, this.minOccurs, this.maxOccurs);
        }
        return multiplePropertySG;
    }

    public void init(ParticleSG pController) throws SAXException {
        if (this.element != null || this.wildcard != null) {
            PropertySGChain chain = (PropertySGChain)pController.newPropertySGChain();
            this.propertySG = new PropertySGImpl(chain);
            this.propertySG.init();
        }
    }

    public Locator getLocator(ParticleSG pController) {
        return this.locator;
    }

    public int getMinOccurs(ParticleSG pController) {
        return this.minOccurs;
    }

    public int getMaxOccurs(ParticleSG pController) {
        return this.maxOccurs;
    }

    public boolean isMultiple(ParticleSG pController) {
        return this.maxOccurs == -1 || this.maxOccurs > 1;
    }

    public boolean isGroup(ParticleSG pController) {
        return this.type.equals((Object)XSParticle.GROUP);
    }

    public boolean isElement(ParticleSG pController) {
        return this.type.equals((Object)XSParticle.ELEMENT);
    }

    public boolean isWildcard(ParticleSG pController) {
        return this.type.equals((Object)XSParticle.WILDCARD);
    }

    public PropertySG getPropertySG(ParticleSG pController) {
        if (this.propertySG == null) {
            throw new IllegalStateException("This particle has no PropertySG.");
        }
        return this.propertySG;
    }

    public ObjectSG getObjectSG(ParticleSG pController) {
        if (this.objectSG == null) {
            throw new IllegalStateException("This particle is neither an element nor a wildcard.");
        }
        return this.objectSG;
    }

    public GroupSG getGroupSG(ParticleSG pController) {
        if (this.groupSG == null) {
            throw new IllegalStateException("This particle is no group.");
        }
        return this.groupSG;
    }

    public void forAllNonNullValues(ParticleSG pController, JavaMethod pMethod, DirectAccessible pElement, SGlet pSGlet) throws SAXException {
        if (pController.isElement()) {
            PropertySG pSG = pController.getPropertySG();
            boolean hasIsSetMethod = pSG.hasIsSetMethod();
            if (hasIsSetMethod) {
                pMethod.addIf((Object)pSG.getXMLIsSetMethodName(), (Object)"()");
            }
            TypeSG typeSG = pController.getObjectSG().getTypeSG();
            Object v = pController.getPropertySG().getValue(pElement);
            if (typeSG.isComplex()) {
                pSGlet.generate(pMethod, v);
            } else {
                typeSG.getSimpleTypeSG().forAllValues(pMethod, v, pSGlet);
            }
            if (hasIsSetMethod) {
                pMethod.addEndIf();
            }
        } else {
            throw new IllegalStateException("Wildcards and subgroups are not yet supported.");
        }
    }
}

