/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.sqls.impl;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.ws.jaxme.logging.Logger;
import org.apache.ws.jaxme.logging.LoggerAccess;
import org.apache.ws.jaxme.sqls.BinaryColumn;
import org.apache.ws.jaxme.sqls.Column;
import org.apache.ws.jaxme.sqls.DeleteStatement;
import org.apache.ws.jaxme.sqls.ForeignKey;
import org.apache.ws.jaxme.sqls.Index;
import org.apache.ws.jaxme.sqls.InsertStatement;
import org.apache.ws.jaxme.sqls.ObjectFactory;
import org.apache.ws.jaxme.sqls.SQLFactory;
import org.apache.ws.jaxme.sqls.SQLGenerator;
import org.apache.ws.jaxme.sqls.Schema;
import org.apache.ws.jaxme.sqls.SelectStatement;
import org.apache.ws.jaxme.sqls.StringColumn;
import org.apache.ws.jaxme.sqls.Table;
import org.apache.ws.jaxme.sqls.UpdateStatement;
import org.apache.ws.jaxme.sqls.impl.ColumnImpl;
import org.apache.ws.jaxme.sqls.impl.DeleteStatementImpl;
import org.apache.ws.jaxme.sqls.impl.InsertStatementImpl;
import org.apache.ws.jaxme.sqls.impl.ObjectFactoryImpl;
import org.apache.ws.jaxme.sqls.impl.SQLGeneratorImpl;
import org.apache.ws.jaxme.sqls.impl.SchemaImpl;
import org.apache.ws.jaxme.sqls.impl.SelectStatementImpl;
import org.apache.ws.jaxme.sqls.impl.TableImpl;
import org.apache.ws.jaxme.sqls.impl.UpdateStatementImpl;

public class SQLFactoryImpl
implements SQLFactory {
    private static final Logger logger = LoggerAccess.getLogger(class$org$apache$ws$jaxme$sqls$impl$SQLFactoryImpl == null ? (class$org$apache$ws$jaxme$sqls$impl$SQLFactoryImpl = SQLFactoryImpl.class$("org.apache.ws.jaxme.sqls.impl.SQLFactoryImpl")) : class$org$apache$ws$jaxme$sqls$impl$SQLFactoryImpl);
    private List schemas = new ArrayList();
    private Integer maxTableNameLength;
    private Integer maxSchemaNameLength;
    private Integer maxColumnNameLength;
    private boolean tableNameCaseSensitive;
    private boolean schemaNameCaseSensitive;
    private boolean columnNameCaseSensitive;
    private Schema defaultSchema;
    private ObjectFactory objectFactory = this.newObjectFactory();
    static /* synthetic */ Class class$org$apache$ws$jaxme$sqls$impl$SQLFactoryImpl;

    protected ObjectFactory newObjectFactory() {
        return new ObjectFactoryImpl();
    }

    public ObjectFactory getObjectFactory() {
        return this.objectFactory;
    }

    protected void setObjectFactory(ObjectFactory pFactory) {
        this.objectFactory = pFactory;
    }

    public void setMaxTableNameLength(Integer pMaxLength) {
        this.maxTableNameLength = pMaxLength;
    }

    public Integer getMaxTableNameLength() {
        return this.maxTableNameLength;
    }

    public void setTableNameCaseSensitive(boolean pTableNameCaseSensitive) {
        this.tableNameCaseSensitive = pTableNameCaseSensitive;
    }

    public boolean isTableNameCaseSensitive() {
        return this.tableNameCaseSensitive;
    }

    public void setMaxColumnNameLength(Integer pMaxLength) {
        this.maxColumnNameLength = pMaxLength;
    }

    public Integer getMaxColumnNameLength() {
        return this.maxColumnNameLength;
    }

    public void setColumnNameCaseSensitive(boolean pColumnNameCaseSensitive) {
        this.columnNameCaseSensitive = pColumnNameCaseSensitive;
    }

    public boolean isColumnNameCaseSensitive() {
        return this.columnNameCaseSensitive;
    }

    public void setSchemaNameCaseSensitive(boolean pSchemaNameCaseSensitive) {
        this.schemaNameCaseSensitive = pSchemaNameCaseSensitive;
    }

    public boolean isSchemaNameCaseSensitive() {
        return this.schemaNameCaseSensitive;
    }

    public void setMaxSchemaNameLength(Integer pMaxLength) {
        this.maxSchemaNameLength = pMaxLength;
    }

    public Integer getMaxSchemaNameLength() {
        return this.maxSchemaNameLength;
    }

    public SQLFactory.Ident newIdent(String pName) {
        if (pName == null) {
            throw new NullPointerException("An SQL identifier must not be null.");
        }
        if (pName.length() == 0) {
            throw new IllegalArgumentException("An SQL identifier must not be empty.");
        }
        char c = pName.charAt(0);
        if (!(c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z')) {
            throw new IllegalArgumentException("An SQL identifiers first character must be A..Z");
        }
        for (int i = 1; i < pName.length(); ++i) {
            c = pName.charAt(i);
            if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9') continue;
            throw new IllegalArgumentException("An SQL identifier must not contain the character " + c + ", only A..Z, a..z, or 0..9 are allowed.");
        }
        return new IdentImpl(pName);
    }

    public Schema newSchema(String pName) {
        if (pName == null) {
            throw new NullPointerException("A schema name must not be null.");
        }
        return this.newSchema(new SchemaImpl.NameImpl(pName));
    }

    public Schema newSchema(Schema.Name pName) {
        if (pName == null) {
            throw new NullPointerException("A schema name must not be null.");
        }
        Integer maxLength = this.getMaxSchemaNameLength();
        if (maxLength != null && pName.getName().length() > maxLength) {
            throw new IllegalArgumentException("The length of the schema name " + pName + " exceeds the valid maximum of " + maxLength);
        }
        Schema schema = this.getSchema(pName);
        if (schema != null) {
            throw new IllegalStateException("A schema named " + schema.getName() + " already exists.");
        }
        schema = this.newSchemaImpl(pName);
        this.schemas.add(schema);
        return schema;
    }

    public Schema getDefaultSchema() {
        if (this.defaultSchema == null) {
            this.defaultSchema = this.newSchemaImpl(null);
            this.schemas.add(this.defaultSchema);
        }
        return this.defaultSchema;
    }

    public Schema getSchema(String pName) {
        return this.getSchema(new SchemaImpl.NameImpl(pName));
    }

    public Schema getSchema(Schema.Name pName) {
        if (pName == null) {
            throw new NullPointerException("A schema name must not be null.");
        }
        Iterator iter = this.getSchemas();
        while (iter.hasNext()) {
            Schema schema = (Schema)iter.next();
            if (!(this.isSchemaNameCaseSensitive() ? pName.getName().equalsIgnoreCase(schema.getName().getName()) : pName.equals(schema.getName()))) continue;
            return schema;
        }
        return null;
    }

    public Iterator getSchemas() {
        return this.schemas.iterator();
    }

    public SelectStatement newSelectStatement() {
        return new SelectStatementImpl(this);
    }

    public InsertStatement newInsertStatement() {
        return new InsertStatementImpl(this);
    }

    public UpdateStatement newUpdateStatement() {
        return new UpdateStatementImpl(this);
    }

    public DeleteStatement newDeleteStatement() {
        return new DeleteStatementImpl(this);
    }

    protected Schema newSchemaImpl(Schema.Name pName) {
        return new SchemaImpl(this, pName);
    }

    protected Table newTableImpl(Schema pSchema, Table.Name pName) {
        return new TableImpl(pSchema, pName);
    }

    protected Column newColumnImpl(Table pTable, Column.Name pName, Column.Type pType) {
        return new ColumnImpl(pTable, pName, pType);
    }

    public SQLGenerator newSQLGenerator() {
        return new SQLGeneratorImpl();
    }

    public Schema getSchema(Connection pConn, String pName) throws SQLException {
        return this.getSchema(pConn, pName == null ? null : new SchemaImpl.NameImpl(pName));
    }

    protected Schema makeSchema(Schema.Name pName) {
        Schema schema;
        if (pName == null) {
            schema = this.getDefaultSchema();
        } else {
            schema = this.getSchema(pName);
            if (schema == null) {
                schema = this.newSchema(pName);
            }
        }
        return schema;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JDBCTable[] readTables(DatabaseMetaData pData, Schema.Name pSchema, Table.Name pTable) throws SQLException {
        String mName = "readTables";
        ArrayList<JDBCTable> tables = new ArrayList<JDBCTable>();
        ResultSet rs = pData.getTables(null, pSchema == null ? null : pSchema.getName(), pTable == null ? null : pTable.getName(), null);
        boolean isRsClosed = false;
        try {
            while (rs.next()) {
                JDBCTable table = new JDBCTable(rs.getString(1), rs.getString(2), rs.getString(3), rs.getString(4));
                if (!"TABLE".equals(table.getTableType()) || pSchema != null && !table.getSchemaName().equals(pSchema.toString())) continue;
                logger.finest("readTables", "Found table " + table);
                tables.add(table);
            }
            isRsClosed = true;
            rs.close();
        }
        finally {
            if (!isRsClosed) {
                try {
                    rs.close();
                }
                catch (Throwable ignore) {}
            }
        }
        return tables.toArray(new JDBCTable[tables.size()]);
    }

    /*
     * WARNING - void declaration
     */
    protected Column readColumn(Table pTable, String pColumnName, int pDataType, String pTypeName, long pColumnSize, int pDecimalDigits, int pNullable) {
        void var9_9;
        String mName = "readColumn";
        switch (pDataType) {
            case -5: {
                Column.Type type = Column.Type.BIGINT;
                break;
            }
            case -2: {
                Column.Type type = Column.Type.BINARY;
                break;
            }
            case -7: {
                Column.Type type = Column.Type.BIT;
                break;
            }
            case 2004: {
                Column.Type type = Column.Type.BLOB;
                break;
            }
            case 16: {
                Column.Type type = Column.Type.BIT;
                break;
            }
            case 1: {
                Column.Type type = Column.Type.CHAR;
                break;
            }
            case 2005: {
                Column.Type type = Column.Type.CLOB;
                break;
            }
            case 91: {
                Column.Type type = Column.Type.DATE;
                break;
            }
            case 8: {
                Column.Type type = Column.Type.DOUBLE;
                break;
            }
            case 6: {
                Column.Type type = Column.Type.FLOAT;
                break;
            }
            case 7: {
                Column.Type type = Column.Type.DOUBLE;
                break;
            }
            case 4: {
                Column.Type type = Column.Type.INTEGER;
                break;
            }
            case -4: {
                Column.Type type = Column.Type.VARBINARY;
                break;
            }
            case -1: {
                Column.Type type = Column.Type.VARCHAR;
                break;
            }
            case 1111: {
                Column.Type type = Column.Type.OTHER;
                break;
            }
            case 5: {
                Column.Type type = Column.Type.SMALLINT;
                break;
            }
            case 93: {
                Column.Type type = Column.Type.TIMESTAMP;
                break;
            }
            case 92: {
                Column.Type type = Column.Type.TIME;
                break;
            }
            case -6: {
                Column.Type type = Column.Type.TINYINT;
                break;
            }
            case -3: {
                Column.Type type = Column.Type.VARBINARY;
                break;
            }
            case 12: {
                Column.Type type = Column.Type.VARCHAR;
                break;
            }
            default: {
                throw new IllegalArgumentException("Column " + pColumnName + " in table " + pTable.getQName() + " has unknown JDBC data type " + pDataType);
            }
        }
        Column column = pTable.newColumn(pColumnName, (Column.Type)var9_9);
        logger.finest("readColumn", "Found column " + pColumnName);
        if (column instanceof StringColumn) {
            ((StringColumn)column).setLength(pColumnSize);
        } else if (column instanceof BinaryColumn) {
            ((BinaryColumn)column).setLength(pColumnSize);
        }
        if (pNullable == 1) {
            column.setNullable(true);
        }
        return column;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Table readTable(DatabaseMetaData pData, Schema pSchema, JDBCTable pTable) throws SQLException {
        String mName = "readTable";
        ResultSet rs = pData.getColumns(pTable.getCatalogName(), pTable.getSchemaName(), pTable.getTableName(), null);
        boolean isRsClosed = false;
        try {
            Table sqlTable = pSchema.newTable(pTable.getTableName());
            logger.finest("readTable", "Looking for columns of " + pTable + "=" + sqlTable.getQName());
            while (rs.next()) {
                String columnName = rs.getString(4);
                int dataType = rs.getInt(5);
                String typeName = rs.getString(6);
                long columnSize = rs.getLong(7);
                int decimalDigits = rs.getInt(9);
                int isNullable = rs.getInt(11);
                this.readColumn(sqlTable, columnName, dataType, typeName, columnSize, decimalDigits, isNullable);
            }
            pTable.setTable(sqlTable);
            isRsClosed = true;
            rs.close();
            Table table = sqlTable;
            return table;
        }
        finally {
            if (!isRsClosed) {
                try {
                    rs.close();
                }
                catch (Throwable ignore) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Index readPrimaryKey(DatabaseMetaData pData, JDBCTable pTable) throws SQLException {
        String mName = "readPrimaryKey";
        logger.finest("readPrimaryKey", "Looking for primary keys of " + pTable + "=" + pTable.getTable().getQName());
        ResultSet rs = pData.getPrimaryKeys(pTable.getCatalogName(), pTable.getSchemaName(), pTable.getTableName());
        Index primaryKey = null;
        boolean isRsClosed = false;
        try {
            while (rs.next()) {
                if (primaryKey == null) {
                    primaryKey = pTable.getTable().newPrimaryKey();
                }
                String columnName = rs.getString(4);
                logger.finest("readPrimaryKey", "Found column " + columnName);
                primaryKey.addColumn(columnName);
            }
            isRsClosed = true;
            rs.close();
        }
        finally {
            if (!isRsClosed) {
                try {
                    rs.close();
                }
                catch (Throwable ignore) {}
            }
        }
        return primaryKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ForeignKey[] readForeignKeys(DatabaseMetaData pData, JDBCTable pTable, JDBCTable[] pTables) throws SQLException {
        String mName = "readForeignKeys";
        logger.finest("readForeignKeys", "Looking for foreign keys of " + pTable + "=" + pTable.getTable().getQName());
        ArrayList<ForeignKey> result = new ArrayList<ForeignKey>();
        ResultSet rs = pData.getImportedKeys(pTable.getCatalogName(), pTable.getSchemaName(), pTable.getTableName());
        ForeignKey foreignKey = null;
        boolean isRsClosed = false;
        try {
            while (rs.next()) {
                JDBCTable referencedTable = new JDBCTable(rs.getString(1), rs.getString(2), rs.getString(3), "TABLE");
                String referencedColumnName = rs.getString(4);
                String localColumnName = rs.getString(8);
                logger.finest("readForeignKeys", "Found column " + localColumnName + " referencing " + referencedColumnName + " in " + referencedTable);
                for (int i = 0; i < pTables.length; ++i) {
                    JDBCTable refIterTable = pTables[i];
                    if (!refIterTable.equals(referencedTable)) continue;
                    referencedTable.setTable(refIterTable.getTable());
                    break;
                }
                if (referencedTable.getTable() == null) {
                    logger.finest("readForeignKeys", "Unknown table, ignoring");
                    continue;
                }
                short seq = rs.getShort(9);
                if (seq == 1) {
                    foreignKey = pTable.getTable().newForeignKey(referencedTable.getTable());
                    result.add(foreignKey);
                }
                foreignKey.addColumnLink(localColumnName, referencedColumnName);
            }
            isRsClosed = true;
            rs.close();
        }
        finally {
            if (!isRsClosed) {
                try {
                    rs.close();
                }
                catch (Throwable ignore) {}
            }
        }
        return result.toArray(new ForeignKey[result.size()]);
    }

    public Schema getSchema(Connection pConn, Schema.Name pName) throws SQLException {
        int i;
        String mName = "getSchema(Connection,Schema.Name)";
        logger.finest("getSchema(Connection,Schema.Name)", "->", new Object[]{pConn, pName});
        Schema schema = this.makeSchema(pName);
        DatabaseMetaData metaData = pConn.getMetaData();
        JDBCTable[] tables = this.readTables(metaData, pName, null);
        for (i = 0; i < tables.length; ++i) {
            this.readTable(metaData, schema, tables[i]);
            this.readPrimaryKey(metaData, tables[i]);
        }
        for (i = 0; i < tables.length; ++i) {
            this.readForeignKeys(metaData, tables[i], tables);
        }
        logger.finest("getSchema(Connection,Schema.Name)", "<-", schema);
        return schema;
    }

    public Table getTable(Connection pConnection, Schema.Name pSchema, Table.Name pTable) throws SQLException {
        String mName = "getSchema(Connection,Schema.Name)";
        logger.finest("getSchema(Connection,Schema.Name)", "->", new Object[]{pConnection, pSchema, pTable});
        Schema schema = this.makeSchema(pSchema);
        DatabaseMetaData metaData = pConnection.getMetaData();
        JDBCTable[] tables = this.readTables(metaData, pSchema, pTable);
        if (tables.length == 0) {
            String ucSchemaName;
            String tableName = pTable.toString();
            String schemaName = pSchema == null ? null : pSchema.toString();
            String ucTableName = tableName.toUpperCase();
            String string = ucSchemaName = schemaName == null ? null : schemaName.toUpperCase();
            if (tableName.equals(ucTableName) && (schemaName == null || schemaName.equals(ucSchemaName))) {
                throw new IllegalStateException("No table named " + pTable + " found in schema " + pSchema);
            }
            return this.getTable(pConnection, ucSchemaName, ucTableName);
        }
        if (tables.length != 1) {
            throw new IllegalStateException("Multiple tables named " + pTable + " found in schema " + pSchema);
        }
        JDBCTable jdbcTable = tables[0];
        Table result = this.readTable(metaData, schema, jdbcTable);
        this.readPrimaryKey(metaData, jdbcTable);
        return result;
    }

    public Table getTable(Connection pConnection, String pSchema, String pTable) throws SQLException {
        return this.getTable(pConnection, pSchema == null ? null : new SchemaImpl.NameImpl(pSchema), new TableImpl.NameImpl(pTable));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class JDBCTable {
        private final String catalogName;
        private final String schemaName;
        private final String tableName;
        private final String tableType;
        private final String toStringValue;
        private Table table;

        public JDBCTable(String pCatalogName, String pSchemaName, String pTableName, String pTableType) {
            this.catalogName = pCatalogName;
            this.schemaName = pSchemaName;
            this.tableName = pTableName;
            this.tableType = pTableType;
            String s = this.tableName;
            if (this.schemaName != null && this.schemaName.length() > 0 || this.catalogName != null && this.schemaName.length() > 0) {
                s = this.catalogName + "." + this.schemaName + "." + this.tableName;
            }
            this.toStringValue = s;
        }

        public String getCatalogName() {
            return this.catalogName;
        }

        public String getSchemaName() {
            return this.schemaName;
        }

        public String getTableName() {
            return this.tableName;
        }

        public String getTableType() {
            return this.tableType;
        }

        public String toString() {
            return this.toStringValue;
        }

        public void setTable(Table pTable) {
            this.table = pTable;
        }

        public Table getTable() {
            return this.table;
        }

        public int hashCode() {
            int result = 0;
            if (this.catalogName != null) {
                result += this.catalogName.hashCode();
            }
            if (this.schemaName != null) {
                result += this.schemaName.hashCode();
            }
            if (this.tableName != null) {
                result += this.tableName.hashCode();
            }
            return result;
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof JDBCTable)) {
                return false;
            }
            JDBCTable t = (JDBCTable)o;
            if (this.catalogName == null ? t.catalogName != null : !this.catalogName.equals(t.catalogName)) {
                return false;
            }
            if (this.schemaName == null ? t.schemaName != null : !this.schemaName.equals(t.schemaName)) {
                return false;
            }
            if (this.tableName == null) {
                return t.tableName == null;
            }
            return this.tableName.equals(t.tableName);
        }
    }

    public static class IdentImpl
    implements SQLFactory.Ident,
    Serializable {
        private String name;

        protected IdentImpl(String pName) {
            if (pName == null) {
                throw new NullPointerException("An ident's string representation must not be null.");
            }
            this.name = pName;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof SQLFactory.Ident)) {
                return false;
            }
            return this.name.equalsIgnoreCase(((SQLFactory.Ident)o).getName());
        }

        public int hashcode() {
            return this.name.hashCode();
        }
    }
}

