/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.sqls.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.ws.jaxme.sqls.ColumnReference;
import org.apache.ws.jaxme.sqls.Function;
import org.apache.ws.jaxme.sqls.SelectStatement;
import org.apache.ws.jaxme.sqls.Statement;
import org.apache.ws.jaxme.sqls.Value;
import org.apache.ws.jaxme.sqls.impl.ValueImpl;

public abstract class PartsImpl {
    private final Statement statement;
    private final List parts = new ArrayList();

    protected PartsImpl(Statement pStatement) {
        this.statement = pStatement;
    }

    protected void add(Object o) {
        this.parts.add(o);
    }

    public Statement getStatement() {
        return this.statement;
    }

    public void addPart(Value pValue) {
        if (pValue == null) {
            throw new NullPointerException("A constant value must not be null.");
        }
        this.parts.add(pValue);
    }

    public void addPart(ColumnReference pColumn) {
        if (pColumn == null) {
            throw new NullPointerException("Referenced column must not be null.");
        }
        this.add(pColumn);
    }

    public void addPart(ColumnReference[] pColumns) {
        if (pColumns == null) {
            throw new NullPointerException("The array of referenced columns must not be null.");
        }
        for (int i = 0; i < pColumns.length; ++i) {
            if (pColumns[i] != null) continue;
            throw new NullPointerException("The referenced column with number " + i + " must not be null.");
        }
        this.add(pColumns);
    }

    public void addPart(SelectStatement pStatement) {
        if (pStatement == null) {
            throw new NullPointerException("The subselect statement must not be null.");
        }
        this.add(pStatement);
    }

    public void addPart(String pString) {
        this.add(new ValueImpl(Value.Type.STRING, pString));
    }

    public void addPart() {
        this.add(new ValueImpl(Value.Type.NULL, null));
    }

    public void addPart(byte pByte) {
        this.add(new ValueImpl(Value.Type.BYTE, new Byte(pByte)));
    }

    public void addPart(int pInt) {
        this.add(new ValueImpl(Value.Type.INT, new Integer(pInt)));
    }

    public void addPart(long pLong) {
        this.add(new ValueImpl(Value.Type.LONG, new Long(pLong)));
    }

    public void addPart(short pShort) {
        this.add(new ValueImpl(Value.Type.SHORT, new Short(pShort)));
    }

    public void addPart(float pFloat) {
        this.add(new ValueImpl(Value.Type.FLOAT, new Float(pFloat)));
    }

    public void addPart(double pDouble) {
        this.add(new ValueImpl(Value.Type.DOUBLE, new Double(pDouble)));
    }

    public void addPart(boolean pBoolean) {
        this.add(new ValueImpl(Value.Type.BOOLEAN, pBoolean ? Boolean.TRUE : Boolean.FALSE));
    }

    public void addPart(Function pFunction) {
        this.add(pFunction);
    }

    public void addPlaceholder() {
        this.add(new ValueImpl(Value.Type.PLACEHOLDER, null));
    }

    public void addRawSQLPart(String pRawSQL) {
        this.add(this.getStatement().getSQLFactory().getObjectFactory().newRawSQL(pRawSQL));
    }

    public int getNumParts() {
        return this.parts.size();
    }

    public Iterator getParts() {
        return this.parts.iterator();
    }
}

