/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.sqls.impl;

import java.util.Iterator;
import org.apache.ws.jaxme.sqls.Column;
import org.apache.ws.jaxme.sqls.Index;
import org.apache.ws.jaxme.sqls.Table;
import org.apache.ws.jaxme.sqls.impl.AbstractColumn;
import org.apache.ws.jaxme.sqls.impl.SQLFactoryImpl;

public class ColumnImpl
extends AbstractColumn {
    private Table table;

    protected ColumnImpl(Table pTable, Column.Name pName, Column.Type pType) {
        super(pName, pType);
        this.table = pTable;
    }

    public Table getTable() {
        return this.table;
    }

    public String getQName() {
        return this.getTable().getQName() + "." + this.getName();
    }

    public boolean isVirtual() {
        return false;
    }

    public boolean isPrimaryKeyPart() {
        Index index = this.getTable().getPrimaryKey();
        if (index == null) {
            return false;
        }
        Iterator iter = index.getColumns();
        while (iter.hasNext()) {
            Column column = (Column)iter.next();
            if (!column.equals(this)) continue;
            return true;
        }
        return false;
    }

    public static class TypeImpl
    extends SQLFactoryImpl.IdentImpl
    implements Column.Type {
        private int jdbcType;

        public TypeImpl(String pName, int pJDBCType) {
            super(pName);
            this.jdbcType = pJDBCType;
        }

        public int getJDBCType() {
            return this.jdbcType;
        }
    }

    public static class NameImpl
    extends SQLFactoryImpl.IdentImpl
    implements Column.Name {
        public NameImpl(String pName) {
            super(pName);
        }

        public boolean equals(Object o) {
            return o != null && o instanceof Column.Name && super.equals(o);
        }
    }
}

