/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.js;

import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.ws.jaxme.js.IndentationEngine;
import org.apache.ws.jaxme.js.IndentationTarget;
import org.apache.ws.jaxme.js.IndentedObject;
import org.apache.ws.jaxme.js.JavaInnerClass;
import org.apache.ws.jaxme.js.JavaQName;
import org.apache.ws.jaxme.js.JavaQNameImpl;
import org.apache.ws.jaxme.js.JavaSource;
import org.apache.ws.jaxme.js.JavaSourceObject;
import org.apache.ws.jaxme.js.PlaceHolder;
import org.apache.ws.jaxme.js.WriterTarget;

public abstract class IndentationEngineImpl
implements IndentationEngine {
    private int level = 0;
    private final List lines = new ArrayList();
    private int cursor = -1;

    protected IndentationEngineImpl() {
    }

    public boolean isEmpty() {
        return this.lines.size() == 0;
    }

    public void clear() {
        this.lines.clear();
    }

    public void indent() {
        ++this.level;
    }

    public void unindent() {
        --this.level;
    }

    public void setLevel(int pLevel) {
        this.level = pLevel;
    }

    public int getLevel() {
        return this.level;
    }

    public void addLine(int pLevel, Object[] pTokens) {
        IndentedLine l = new IndentedLine();
        l.indLevel = pLevel;
        l.tokens = pTokens;
        if (this.cursor == -1) {
            this.lines.add(l);
        } else {
            this.lines.add(this.cursor++, l);
        }
    }

    public void moveToTop() {
        this.cursor = 0;
    }

    public void moveToBottom() {
        this.cursor = -1;
    }

    public PlaceHolder newPlaceHolder(String pName, boolean pAutoRemovable) {
        PlaceHolderImpl result = new PlaceHolderImpl(pName, pAutoRemovable);
        this.addLine(result);
        return result;
    }

    public PlaceHolder getPlaceHolder(String pName) {
        for (int i = 0; i < this.lines.size(); ++i) {
            PlaceHolder placeHolder;
            IndentedLine l = (IndentedLine)this.lines.get(i);
            Object[] tokens = l.tokens;
            if (tokens.length <= 0 || !(tokens[0] instanceof PlaceHolder) || !pName.equals((placeHolder = (PlaceHolder)tokens[0]).getName())) continue;
            this.cursor = i + 1;
            this.level = placeHolder.getLevel();
            return placeHolder;
        }
        return null;
    }

    protected void removePlaceHolder(PlaceHolder pPlaceHolder) {
        String name = pPlaceHolder.getName();
        for (int i = 0; i < this.lines.size(); ++i) {
            PlaceHolder placeHolder;
            IndentedLine l = (IndentedLine)this.lines.get(i);
            Object[] tokens = l.tokens;
            if (tokens.length <= 0 || !(tokens[0] instanceof PlaceHolder) || !name.equals((placeHolder = (PlaceHolder)tokens[0]).getName())) continue;
            this.lines.remove(i);
            if (this.cursor > i) {
                --this.cursor;
            }
            return;
        }
        throw new IllegalStateException("The placeholder " + pPlaceHolder.getName() + " was not found and cannot be removed.");
    }

    protected void checkNulls(Object pTokens) {
        if (pTokens == null) {
            throw new NullPointerException("Null token detected.");
        }
        if (pTokens.getClass().isArray()) {
            Object[] tokens = (Object[])pTokens;
            for (int i = 0; i < tokens.length; ++i) {
                this.checkNulls(tokens[i]);
            }
        } else if (pTokens instanceof Collection) {
            Iterator iter = ((Collection)pTokens).iterator();
            while (iter.hasNext()) {
                this.checkNulls(iter.next());
            }
        } else if (pTokens instanceof JavaSource) {
            if (!(this instanceof JavaSource)) {
                throw new IllegalStateException("An instance of JavaSource cannot be added to an instance of " + this.getClass().getName());
            }
            if (!(pTokens instanceof JavaInnerClass)) {
                throw new IllegalStateException("Only inner classes can be added, outer classes are standalone objects.");
            }
            JavaInnerClass jic = (JavaInnerClass)pTokens;
            JavaSource js = (JavaSource)this;
            if (!jic.getOuterClass().equals(js)) {
                throw new IllegalStateException("The inner class " + jic.getQName() + " cannot be added to a different outer class " + js.getQName());
            }
        }
    }

    public void addLine(Object[] pTokens) {
        this.checkNulls(pTokens);
        this.addLine(this.getLevel(), pTokens);
    }

    public void addLine() {
        this.addLine(new Object[0]);
    }

    public void addLine(Object pLine) {
        this.addLine(new Object[]{pLine});
    }

    public void addLine(Object pToken1, Object pToken2) {
        this.addLine(new Object[]{pToken1, pToken2});
    }

    public void addLine(Object pToken1, Object pToken2, Object pToken3) {
        this.addLine(new Object[]{pToken1, pToken2, pToken3});
    }

    public void addLine(Object pToken1, Object pToken2, Object pToken3, Object pToken4) {
        this.addLine(new Object[]{pToken1, pToken2, pToken3, pToken4});
    }

    public void addLine(Object pToken1, Object pToken2, Object pToken3, Object pToken4, Object pToken5) {
        this.addLine(new Object[]{pToken1, pToken2, pToken3, pToken4, pToken5});
    }

    public void addLine(Object pToken1, Object pToken2, Object pToken3, Object pToken4, Object pToken5, Object pToken6) {
        this.addLine(new Object[]{pToken1, pToken2, pToken3, pToken4, pToken5, pToken6});
    }

    public void addLine(Object pToken1, Object pToken2, Object pToken3, Object pToken4, Object pToken5, Object pToken6, Object pToken7) {
        this.addLine(new Object[]{pToken1, pToken2, pToken3, pToken4, pToken5, pToken6, pToken7});
    }

    public void addLine(Object pToken1, Object pToken2, Object pToken3, Object pToken4, Object pToken5, Object pToken6, Object pToken7, Object pToken8) {
        this.addLine(new Object[]{pToken1, pToken2, pToken3, pToken4, pToken5, pToken6, pToken7, pToken8});
    }

    public void addLine(Object pToken1, Object pToken2, Object pToken3, Object pToken4, Object pToken5, Object pToken6, Object pToken7, Object pToken8, Object pToken9) {
        this.addLine(new Object[]{pToken1, pToken2, pToken3, pToken4, pToken5, pToken6, pToken7, pToken8, pToken9});
    }

    public void addLine(Object pToken1, Object pToken2, Object pToken3, Object pToken4, Object pToken5, Object pToken6, Object pToken7, Object pToken8, Object pToken9, Object pToken10) {
        this.addLine(new Object[]{pToken1, pToken2, pToken3, pToken4, pToken5, pToken6, pToken7, pToken8, pToken9, pToken10});
    }

    public void addLine(Object pToken1, Object pToken2, Object pToken3, Object pToken4, Object pToken5, Object pToken6, Object pToken7, Object pToken8, Object pToken9, Object pToken10, Object pToken11) {
        this.addLine(new Object[]{pToken1, pToken2, pToken3, pToken4, pToken5, pToken6, pToken7, pToken8, pToken9, pToken10, pToken11});
    }

    public void addLine(Object pToken1, Object pToken2, Object pToken3, Object pToken4, Object pToken5, Object pToken6, Object pToken7, Object pToken8, Object pToken9, Object pToken10, Object pToken11, Object pToken12) {
        this.addLine(new Object[]{pToken1, pToken2, pToken3, pToken4, pToken5, pToken6, pToken7, pToken8, pToken9, pToken10, pToken11, pToken12});
    }

    public void addLine(Object pToken1, Object pToken2, Object pToken3, Object pToken4, Object pToken5, Object pToken6, Object pToken7, Object pToken8, Object pToken9, Object pToken10, Object pToken11, Object pToken12, Object pToken13) {
        this.addLine(new Object[]{pToken1, pToken2, pToken3, pToken4, pToken5, pToken6, pToken7, pToken8, pToken9, pToken10, pToken11, pToken12, pToken13});
    }

    public void addLine(Object pToken1, Object pToken2, Object pToken3, Object pToken4, Object pToken5, Object pToken6, Object pToken7, Object pToken8, Object pToken9, Object pToken10, Object pToken11, Object pToken12, Object pToken13, Object pToken14) {
        this.addLine(new Object[]{pToken1, pToken2, pToken3, pToken4, pToken5, pToken6, pToken7, pToken8, pToken9, pToken10, pToken11, pToken12, pToken13, pToken14});
    }

    public void addLine(Object pToken1, Object pToken2, Object pToken3, Object pToken4, Object pToken5, Object pToken6, Object pToken7, Object pToken8, Object pToken9, Object pToken10, Object pToken11, Object pToken12, Object pToken13, Object pToken14, Object pToken15) {
        this.addLine(new Object[]{pToken1, pToken2, pToken3, pToken4, pToken5, pToken6, pToken7, pToken8, pToken9, pToken10, pToken11, pToken12, pToken13, pToken14, pToken15});
    }

    public String[] getLines(int pLevel) {
        String[] result = new String[this.lines.size()];
        return result;
    }

    protected Iterator getLines() {
        return this.lines.iterator();
    }

    public void write(IndentationTarget pTarget, Object pObject) throws IOException {
        if (pObject.getClass().isArray()) {
            Object[] objects = (Object[])pObject;
            for (int i = 0; i < objects.length; ++i) {
                this.write(pTarget, objects[i]);
            }
        } else if (pObject instanceof JavaSourceObject) {
            pTarget.write(((JavaSourceObject)pObject).getName());
        } else if (pObject instanceof List) {
            Iterator iter = ((List)pObject).iterator();
            while (iter.hasNext()) {
                this.write(pTarget, iter.next());
            }
        } else if (pObject instanceof Class) {
            JavaQName name = JavaQNameImpl.getInstance((Class)pObject);
            this.write(pTarget, pTarget.asString(name));
        } else if (pObject instanceof JavaQName) {
            this.write(pTarget, pTarget.asString((JavaQName)pObject));
        } else if (pObject instanceof IndentedObject) {
            ((IndentedObject)pObject).write(this, pTarget);
        } else {
            pTarget.write(pObject.toString());
        }
    }

    public void write(IndentationTarget pTarget) throws IOException {
        Iterator iter = this.getLines();
        while (iter.hasNext()) {
            IndentedLine l = (IndentedLine)iter.next();
            Object[] tokens = l.tokens;
            if (tokens.length == 1 && tokens[0] instanceof PlaceHolder) {
                PlaceHolder placeHolder = (PlaceHolder)tokens[0];
                if (placeHolder.isAutoRemovable()) continue;
                throw new IllegalStateException("The PlaceHolder " + placeHolder.getName() + " has not been removed.");
            }
            pTarget.indent(l.indLevel);
            for (int i = 0; i < tokens.length; ++i) {
                this.write(pTarget, tokens[i]);
            }
            pTarget.write();
        }
    }

    public String asString() {
        StringWriter sw = new StringWriter();
        WriterTarget target = new WriterTarget(sw);
        try {
            this.write(target);
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getMessage());
        }
        return sw.toString();
    }

    private class PlaceHolderImpl
    implements PlaceHolder {
        private final boolean autoRemovable;
        private final String name;
        private final int plLevel;
        private Map properties;

        public PlaceHolderImpl(String pName, boolean pAutoRemovable) {
            this.name = pName;
            this.autoRemovable = pAutoRemovable;
            this.plLevel = IndentationEngineImpl.this.getLevel();
        }

        public String getName() {
            return this.name;
        }

        public boolean isAutoRemovable() {
            return this.autoRemovable;
        }

        public void remove() {
            IndentationEngineImpl.this.removePlaceHolder(this);
        }

        public void setProperty(String pKey, Object pValue) {
            if (this.properties == null) {
                this.properties = new HashMap();
            }
            this.properties.put(pKey, pValue);
        }

        public Object getProperty(String pKey) {
            return this.properties == null ? null : this.properties.get(pKey);
        }

        public int getLevel() {
            return this.plLevel;
        }
    }

    private class IndentedLine {
        int indLevel;
        Object[] tokens;

        private IndentedLine() {
        }
    }
}

