"This module provides a simple Python wrapper for the SWIG-generated Mesh class"

# Copyright (C) 2012-2014 Anders Logg
#
# This file is part of DOLFIN.
#
# DOLFIN is free software: you can redistribute it and/or modify
# it under the terms of the GNU Lesser General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# DOLFIN is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with DOLFIN. If not, see <http://www.gnu.org/licenses/>.
#
# Modified by Marie E. Rognes (meg@simula.no)
# Modified by Martin S. Alnaes (martinal@simula.no) 2014

__all__ = []

# Import SWIG-generated extension module (DOLFIN C++)
import dolfin.cpp as cpp

# Replacement constructor for Mesh class. We cannot create a Python
# subclass of cpp.Mesh since then isinstance(UnitSquare, Mesh) would
# not be true.

def __init__(self, *args, **kwargs):
    """Create a mesh from a filename or a geometry.

    A mesh may be created from a given filename, which should contain
    mesh data stored in DOLFIN XML format:

    .. code-block:: python

        mesh = Mesh("mesh.xml")

    An empty mesh may be created as follows:

    .. code-block:: python

        mesh = Mesh()

    A copy of a mesh may be created as follows:

    .. code-block:: python

        mesh_copy = Mesh(mesh)

    A mesh may also be created from a CSG geometry and a resolution:

    .. code-block:: python

        mesh = Mesh(geometry, resolution)

    """

    # Reuse C++ doc-string too
    __doc__ = cpp.Mesh.__doc__

    # Initialize base class
    cpp.Mesh.__cppinit__(self, *args, **kwargs)

# Change mesh constructor
cpp.Mesh.__cppinit__ = cpp.Mesh.__init__
cpp.Mesh.__init__ = __init__

# Attach ipython notebook svg rendering function for 1D and 2D meshes
from dolfin.mesh.svgtools import mesh2svg
cpp.Mesh._repr_svg_ = mesh2svg
