// Code generated by protoc-gen-gogo.
// source: ca.proto
// DO NOT EDIT!

package api

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "github.com/gogo/protobuf/gogoproto"
import _ "github.com/docker/swarmkit/protobuf/plugin"

import github_com_docker_swarmkit_api_deepcopy "github.com/docker/swarmkit/api/deepcopy"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

import raftselector "github.com/docker/swarmkit/manager/raftselector"
import codes "google.golang.org/grpc/codes"
import metadata "google.golang.org/grpc/metadata"
import transport "google.golang.org/grpc/transport"
import rafttime "time"

import strings "strings"
import reflect "reflect"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

type NodeCertificateStatusRequest struct {
	NodeID string `protobuf:"bytes,1,opt,name=node_id,json=nodeId,proto3" json:"node_id,omitempty"`
}

func (m *NodeCertificateStatusRequest) Reset()                    { *m = NodeCertificateStatusRequest{} }
func (*NodeCertificateStatusRequest) ProtoMessage()               {}
func (*NodeCertificateStatusRequest) Descriptor() ([]byte, []int) { return fileDescriptorCa, []int{0} }

type NodeCertificateStatusResponse struct {
	Status      *IssuanceStatus `protobuf:"bytes,1,opt,name=status" json:"status,omitempty"`
	Certificate *Certificate    `protobuf:"bytes,2,opt,name=certificate" json:"certificate,omitempty"`
}

func (m *NodeCertificateStatusResponse) Reset()                    { *m = NodeCertificateStatusResponse{} }
func (*NodeCertificateStatusResponse) ProtoMessage()               {}
func (*NodeCertificateStatusResponse) Descriptor() ([]byte, []int) { return fileDescriptorCa, []int{1} }

type IssueNodeCertificateRequest struct {
	// DEPRECATED: Role is now selected based on which secret is matched.
	Role NodeRole `protobuf:"varint,1,opt,name=role,proto3,enum=docker.swarmkit.v1.NodeRole" json:"role,omitempty"`
	// CSR is the certificate signing request.
	CSR []byte `protobuf:"bytes,2,opt,name=csr,proto3" json:"csr,omitempty"`
	// Token represents a user-provided string that is necessary for new
	// nodes to join the cluster
	Token string `protobuf:"bytes,3,opt,name=token,proto3" json:"token,omitempty"`
	// Availability allows a user to control the current scheduling status of a node
	Availability NodeSpec_Availability `protobuf:"varint,4,opt,name=availability,proto3,enum=docker.swarmkit.v1.NodeSpec_Availability" json:"availability,omitempty"`
}

func (m *IssueNodeCertificateRequest) Reset()                    { *m = IssueNodeCertificateRequest{} }
func (*IssueNodeCertificateRequest) ProtoMessage()               {}
func (*IssueNodeCertificateRequest) Descriptor() ([]byte, []int) { return fileDescriptorCa, []int{2} }

type IssueNodeCertificateResponse struct {
	NodeID         string              `protobuf:"bytes,1,opt,name=node_id,json=nodeId,proto3" json:"node_id,omitempty"`
	NodeMembership NodeSpec_Membership `protobuf:"varint,2,opt,name=node_membership,json=nodeMembership,proto3,enum=docker.swarmkit.v1.NodeSpec_Membership" json:"node_membership,omitempty"`
}

func (m *IssueNodeCertificateResponse) Reset()                    { *m = IssueNodeCertificateResponse{} }
func (*IssueNodeCertificateResponse) ProtoMessage()               {}
func (*IssueNodeCertificateResponse) Descriptor() ([]byte, []int) { return fileDescriptorCa, []int{3} }

type GetRootCACertificateRequest struct {
}

func (m *GetRootCACertificateRequest) Reset()                    { *m = GetRootCACertificateRequest{} }
func (*GetRootCACertificateRequest) ProtoMessage()               {}
func (*GetRootCACertificateRequest) Descriptor() ([]byte, []int) { return fileDescriptorCa, []int{4} }

type GetRootCACertificateResponse struct {
	Certificate []byte `protobuf:"bytes,1,opt,name=certificate,proto3" json:"certificate,omitempty"`
}

func (m *GetRootCACertificateResponse) Reset()                    { *m = GetRootCACertificateResponse{} }
func (*GetRootCACertificateResponse) ProtoMessage()               {}
func (*GetRootCACertificateResponse) Descriptor() ([]byte, []int) { return fileDescriptorCa, []int{5} }

type GetUnlockKeyRequest struct {
}

func (m *GetUnlockKeyRequest) Reset()                    { *m = GetUnlockKeyRequest{} }
func (*GetUnlockKeyRequest) ProtoMessage()               {}
func (*GetUnlockKeyRequest) Descriptor() ([]byte, []int) { return fileDescriptorCa, []int{6} }

type GetUnlockKeyResponse struct {
	UnlockKey []byte  `protobuf:"bytes,1,opt,name=unlock_key,json=unlockKey,proto3" json:"unlock_key,omitempty"`
	Version   Version `protobuf:"bytes,2,opt,name=version" json:"version"`
}

func (m *GetUnlockKeyResponse) Reset()                    { *m = GetUnlockKeyResponse{} }
func (*GetUnlockKeyResponse) ProtoMessage()               {}
func (*GetUnlockKeyResponse) Descriptor() ([]byte, []int) { return fileDescriptorCa, []int{7} }

func init() {
	proto.RegisterType((*NodeCertificateStatusRequest)(nil), "docker.swarmkit.v1.NodeCertificateStatusRequest")
	proto.RegisterType((*NodeCertificateStatusResponse)(nil), "docker.swarmkit.v1.NodeCertificateStatusResponse")
	proto.RegisterType((*IssueNodeCertificateRequest)(nil), "docker.swarmkit.v1.IssueNodeCertificateRequest")
	proto.RegisterType((*IssueNodeCertificateResponse)(nil), "docker.swarmkit.v1.IssueNodeCertificateResponse")
	proto.RegisterType((*GetRootCACertificateRequest)(nil), "docker.swarmkit.v1.GetRootCACertificateRequest")
	proto.RegisterType((*GetRootCACertificateResponse)(nil), "docker.swarmkit.v1.GetRootCACertificateResponse")
	proto.RegisterType((*GetUnlockKeyRequest)(nil), "docker.swarmkit.v1.GetUnlockKeyRequest")
	proto.RegisterType((*GetUnlockKeyResponse)(nil), "docker.swarmkit.v1.GetUnlockKeyResponse")
}

type authenticatedWrapperCAServer struct {
	local     CAServer
	authorize func(context.Context, []string) error
}

func NewAuthenticatedWrapperCAServer(local CAServer, authorize func(context.Context, []string) error) CAServer {
	return &authenticatedWrapperCAServer{
		local:     local,
		authorize: authorize,
	}
}

func (p *authenticatedWrapperCAServer) GetRootCACertificate(ctx context.Context, r *GetRootCACertificateRequest) (*GetRootCACertificateResponse, error) {

	return p.local.GetRootCACertificate(ctx, r)
}

func (p *authenticatedWrapperCAServer) GetUnlockKey(ctx context.Context, r *GetUnlockKeyRequest) (*GetUnlockKeyResponse, error) {

	if err := p.authorize(ctx, []string{"swarm-manager"}); err != nil {
		return nil, err
	}
	return p.local.GetUnlockKey(ctx, r)
}

type authenticatedWrapperNodeCAServer struct {
	local     NodeCAServer
	authorize func(context.Context, []string) error
}

func NewAuthenticatedWrapperNodeCAServer(local NodeCAServer, authorize func(context.Context, []string) error) NodeCAServer {
	return &authenticatedWrapperNodeCAServer{
		local:     local,
		authorize: authorize,
	}
}

func (p *authenticatedWrapperNodeCAServer) IssueNodeCertificate(ctx context.Context, r *IssueNodeCertificateRequest) (*IssueNodeCertificateResponse, error) {

	return p.local.IssueNodeCertificate(ctx, r)
}

func (p *authenticatedWrapperNodeCAServer) NodeCertificateStatus(ctx context.Context, r *NodeCertificateStatusRequest) (*NodeCertificateStatusResponse, error) {

	return p.local.NodeCertificateStatus(ctx, r)
}

func (m *NodeCertificateStatusRequest) Copy() *NodeCertificateStatusRequest {
	if m == nil {
		return nil
	}
	o := &NodeCertificateStatusRequest{}
	o.CopyFrom(m)
	return o
}

func (m *NodeCertificateStatusRequest) CopyFrom(src interface{}) {

	o := src.(*NodeCertificateStatusRequest)
	*m = *o
}

func (m *NodeCertificateStatusResponse) Copy() *NodeCertificateStatusResponse {
	if m == nil {
		return nil
	}
	o := &NodeCertificateStatusResponse{}
	o.CopyFrom(m)
	return o
}

func (m *NodeCertificateStatusResponse) CopyFrom(src interface{}) {

	o := src.(*NodeCertificateStatusResponse)
	*m = *o
	if o.Status != nil {
		m.Status = &IssuanceStatus{}
		github_com_docker_swarmkit_api_deepcopy.Copy(m.Status, o.Status)
	}
	if o.Certificate != nil {
		m.Certificate = &Certificate{}
		github_com_docker_swarmkit_api_deepcopy.Copy(m.Certificate, o.Certificate)
	}
}

func (m *IssueNodeCertificateRequest) Copy() *IssueNodeCertificateRequest {
	if m == nil {
		return nil
	}
	o := &IssueNodeCertificateRequest{}
	o.CopyFrom(m)
	return o
}

func (m *IssueNodeCertificateRequest) CopyFrom(src interface{}) {

	o := src.(*IssueNodeCertificateRequest)
	*m = *o
	if o.CSR != nil {
		m.CSR = make([]byte, len(o.CSR))
		copy(m.CSR, o.CSR)
	}
}

func (m *IssueNodeCertificateResponse) Copy() *IssueNodeCertificateResponse {
	if m == nil {
		return nil
	}
	o := &IssueNodeCertificateResponse{}
	o.CopyFrom(m)
	return o
}

func (m *IssueNodeCertificateResponse) CopyFrom(src interface{}) {

	o := src.(*IssueNodeCertificateResponse)
	*m = *o
}

func (m *GetRootCACertificateRequest) Copy() *GetRootCACertificateRequest {
	if m == nil {
		return nil
	}
	o := &GetRootCACertificateRequest{}
	o.CopyFrom(m)
	return o
}

func (m *GetRootCACertificateRequest) CopyFrom(src interface{}) {}
func (m *GetRootCACertificateResponse) Copy() *GetRootCACertificateResponse {
	if m == nil {
		return nil
	}
	o := &GetRootCACertificateResponse{}
	o.CopyFrom(m)
	return o
}

func (m *GetRootCACertificateResponse) CopyFrom(src interface{}) {

	o := src.(*GetRootCACertificateResponse)
	*m = *o
	if o.Certificate != nil {
		m.Certificate = make([]byte, len(o.Certificate))
		copy(m.Certificate, o.Certificate)
	}
}

func (m *GetUnlockKeyRequest) Copy() *GetUnlockKeyRequest {
	if m == nil {
		return nil
	}
	o := &GetUnlockKeyRequest{}
	o.CopyFrom(m)
	return o
}

func (m *GetUnlockKeyRequest) CopyFrom(src interface{}) {}
func (m *GetUnlockKeyResponse) Copy() *GetUnlockKeyResponse {
	if m == nil {
		return nil
	}
	o := &GetUnlockKeyResponse{}
	o.CopyFrom(m)
	return o
}

func (m *GetUnlockKeyResponse) CopyFrom(src interface{}) {

	o := src.(*GetUnlockKeyResponse)
	*m = *o
	if o.UnlockKey != nil {
		m.UnlockKey = make([]byte, len(o.UnlockKey))
		copy(m.UnlockKey, o.UnlockKey)
	}
	github_com_docker_swarmkit_api_deepcopy.Copy(&m.Version, &o.Version)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for CA service

type CAClient interface {
	GetRootCACertificate(ctx context.Context, in *GetRootCACertificateRequest, opts ...grpc.CallOption) (*GetRootCACertificateResponse, error)
	// GetUnlockKey returns the current unlock key for the cluster for the role of the client
	// asking.
	GetUnlockKey(ctx context.Context, in *GetUnlockKeyRequest, opts ...grpc.CallOption) (*GetUnlockKeyResponse, error)
}

type cAClient struct {
	cc *grpc.ClientConn
}

func NewCAClient(cc *grpc.ClientConn) CAClient {
	return &cAClient{cc}
}

func (c *cAClient) GetRootCACertificate(ctx context.Context, in *GetRootCACertificateRequest, opts ...grpc.CallOption) (*GetRootCACertificateResponse, error) {
	out := new(GetRootCACertificateResponse)
	err := grpc.Invoke(ctx, "/docker.swarmkit.v1.CA/GetRootCACertificate", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *cAClient) GetUnlockKey(ctx context.Context, in *GetUnlockKeyRequest, opts ...grpc.CallOption) (*GetUnlockKeyResponse, error) {
	out := new(GetUnlockKeyResponse)
	err := grpc.Invoke(ctx, "/docker.swarmkit.v1.CA/GetUnlockKey", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for CA service

type CAServer interface {
	GetRootCACertificate(context.Context, *GetRootCACertificateRequest) (*GetRootCACertificateResponse, error)
	// GetUnlockKey returns the current unlock key for the cluster for the role of the client
	// asking.
	GetUnlockKey(context.Context, *GetUnlockKeyRequest) (*GetUnlockKeyResponse, error)
}

func RegisterCAServer(s *grpc.Server, srv CAServer) {
	s.RegisterService(&_CA_serviceDesc, srv)
}

func _CA_GetRootCACertificate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetRootCACertificateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CAServer).GetRootCACertificate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/docker.swarmkit.v1.CA/GetRootCACertificate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CAServer).GetRootCACertificate(ctx, req.(*GetRootCACertificateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CA_GetUnlockKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetUnlockKeyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CAServer).GetUnlockKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/docker.swarmkit.v1.CA/GetUnlockKey",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CAServer).GetUnlockKey(ctx, req.(*GetUnlockKeyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _CA_serviceDesc = grpc.ServiceDesc{
	ServiceName: "docker.swarmkit.v1.CA",
	HandlerType: (*CAServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetRootCACertificate",
			Handler:    _CA_GetRootCACertificate_Handler,
		},
		{
			MethodName: "GetUnlockKey",
			Handler:    _CA_GetUnlockKey_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "ca.proto",
}

// Client API for NodeCA service

type NodeCAClient interface {
	IssueNodeCertificate(ctx context.Context, in *IssueNodeCertificateRequest, opts ...grpc.CallOption) (*IssueNodeCertificateResponse, error)
	NodeCertificateStatus(ctx context.Context, in *NodeCertificateStatusRequest, opts ...grpc.CallOption) (*NodeCertificateStatusResponse, error)
}

type nodeCAClient struct {
	cc *grpc.ClientConn
}

func NewNodeCAClient(cc *grpc.ClientConn) NodeCAClient {
	return &nodeCAClient{cc}
}

func (c *nodeCAClient) IssueNodeCertificate(ctx context.Context, in *IssueNodeCertificateRequest, opts ...grpc.CallOption) (*IssueNodeCertificateResponse, error) {
	out := new(IssueNodeCertificateResponse)
	err := grpc.Invoke(ctx, "/docker.swarmkit.v1.NodeCA/IssueNodeCertificate", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *nodeCAClient) NodeCertificateStatus(ctx context.Context, in *NodeCertificateStatusRequest, opts ...grpc.CallOption) (*NodeCertificateStatusResponse, error) {
	out := new(NodeCertificateStatusResponse)
	err := grpc.Invoke(ctx, "/docker.swarmkit.v1.NodeCA/NodeCertificateStatus", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for NodeCA service

type NodeCAServer interface {
	IssueNodeCertificate(context.Context, *IssueNodeCertificateRequest) (*IssueNodeCertificateResponse, error)
	NodeCertificateStatus(context.Context, *NodeCertificateStatusRequest) (*NodeCertificateStatusResponse, error)
}

func RegisterNodeCAServer(s *grpc.Server, srv NodeCAServer) {
	s.RegisterService(&_NodeCA_serviceDesc, srv)
}

func _NodeCA_IssueNodeCertificate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(IssueNodeCertificateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NodeCAServer).IssueNodeCertificate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/docker.swarmkit.v1.NodeCA/IssueNodeCertificate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NodeCAServer).IssueNodeCertificate(ctx, req.(*IssueNodeCertificateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NodeCA_NodeCertificateStatus_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(NodeCertificateStatusRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NodeCAServer).NodeCertificateStatus(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/docker.swarmkit.v1.NodeCA/NodeCertificateStatus",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NodeCAServer).NodeCertificateStatus(ctx, req.(*NodeCertificateStatusRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _NodeCA_serviceDesc = grpc.ServiceDesc{
	ServiceName: "docker.swarmkit.v1.NodeCA",
	HandlerType: (*NodeCAServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "IssueNodeCertificate",
			Handler:    _NodeCA_IssueNodeCertificate_Handler,
		},
		{
			MethodName: "NodeCertificateStatus",
			Handler:    _NodeCA_NodeCertificateStatus_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "ca.proto",
}

func (m *NodeCertificateStatusRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NodeCertificateStatusRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.NodeID) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintCa(dAtA, i, uint64(len(m.NodeID)))
		i += copy(dAtA[i:], m.NodeID)
	}
	return i, nil
}

func (m *NodeCertificateStatusResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NodeCertificateStatusResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Status != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintCa(dAtA, i, uint64(m.Status.Size()))
		n1, err := m.Status.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n1
	}
	if m.Certificate != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintCa(dAtA, i, uint64(m.Certificate.Size()))
		n2, err := m.Certificate.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n2
	}
	return i, nil
}

func (m *IssueNodeCertificateRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *IssueNodeCertificateRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Role != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintCa(dAtA, i, uint64(m.Role))
	}
	if len(m.CSR) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintCa(dAtA, i, uint64(len(m.CSR)))
		i += copy(dAtA[i:], m.CSR)
	}
	if len(m.Token) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintCa(dAtA, i, uint64(len(m.Token)))
		i += copy(dAtA[i:], m.Token)
	}
	if m.Availability != 0 {
		dAtA[i] = 0x20
		i++
		i = encodeVarintCa(dAtA, i, uint64(m.Availability))
	}
	return i, nil
}

func (m *IssueNodeCertificateResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *IssueNodeCertificateResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.NodeID) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintCa(dAtA, i, uint64(len(m.NodeID)))
		i += copy(dAtA[i:], m.NodeID)
	}
	if m.NodeMembership != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintCa(dAtA, i, uint64(m.NodeMembership))
	}
	return i, nil
}

func (m *GetRootCACertificateRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetRootCACertificateRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	return i, nil
}

func (m *GetRootCACertificateResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetRootCACertificateResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Certificate) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintCa(dAtA, i, uint64(len(m.Certificate)))
		i += copy(dAtA[i:], m.Certificate)
	}
	return i, nil
}

func (m *GetUnlockKeyRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetUnlockKeyRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	return i, nil
}

func (m *GetUnlockKeyResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetUnlockKeyResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.UnlockKey) > 0 {
		dAtA[i] = 0xa
		i++
		i = encodeVarintCa(dAtA, i, uint64(len(m.UnlockKey)))
		i += copy(dAtA[i:], m.UnlockKey)
	}
	dAtA[i] = 0x12
	i++
	i = encodeVarintCa(dAtA, i, uint64(m.Version.Size()))
	n3, err := m.Version.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n3
	return i, nil
}

func encodeFixed64Ca(dAtA []byte, offset int, v uint64) int {
	dAtA[offset] = uint8(v)
	dAtA[offset+1] = uint8(v >> 8)
	dAtA[offset+2] = uint8(v >> 16)
	dAtA[offset+3] = uint8(v >> 24)
	dAtA[offset+4] = uint8(v >> 32)
	dAtA[offset+5] = uint8(v >> 40)
	dAtA[offset+6] = uint8(v >> 48)
	dAtA[offset+7] = uint8(v >> 56)
	return offset + 8
}
func encodeFixed32Ca(dAtA []byte, offset int, v uint32) int {
	dAtA[offset] = uint8(v)
	dAtA[offset+1] = uint8(v >> 8)
	dAtA[offset+2] = uint8(v >> 16)
	dAtA[offset+3] = uint8(v >> 24)
	return offset + 4
}
func encodeVarintCa(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}

type raftProxyCAServer struct {
	local                       CAServer
	connSelector                raftselector.ConnProvider
	localCtxMods, remoteCtxMods []func(context.Context) (context.Context, error)
}

func NewRaftProxyCAServer(local CAServer, connSelector raftselector.ConnProvider, localCtxMod, remoteCtxMod func(context.Context) (context.Context, error)) CAServer {
	redirectChecker := func(ctx context.Context) (context.Context, error) {
		s, ok := transport.StreamFromContext(ctx)
		if !ok {
			return ctx, grpc.Errorf(codes.InvalidArgument, "remote addr is not found in context")
		}
		addr := s.ServerTransport().RemoteAddr().String()
		md, ok := metadata.FromContext(ctx)
		if ok && len(md["redirect"]) != 0 {
			return ctx, grpc.Errorf(codes.ResourceExhausted, "more than one redirect to leader from: %s", md["redirect"])
		}
		if !ok {
			md = metadata.New(map[string]string{})
		}
		md["redirect"] = append(md["redirect"], addr)
		return metadata.NewContext(ctx, md), nil
	}
	remoteMods := []func(context.Context) (context.Context, error){redirectChecker}
	remoteMods = append(remoteMods, remoteCtxMod)

	var localMods []func(context.Context) (context.Context, error)
	if localCtxMod != nil {
		localMods = []func(context.Context) (context.Context, error){localCtxMod}
	}

	return &raftProxyCAServer{
		local:         local,
		connSelector:  connSelector,
		localCtxMods:  localMods,
		remoteCtxMods: remoteMods,
	}
}
func (p *raftProxyCAServer) runCtxMods(ctx context.Context, ctxMods []func(context.Context) (context.Context, error)) (context.Context, error) {
	var err error
	for _, mod := range ctxMods {
		ctx, err = mod(ctx)
		if err != nil {
			return ctx, err
		}
	}
	return ctx, nil
}
func (p *raftProxyCAServer) pollNewLeaderConn(ctx context.Context) (*grpc.ClientConn, error) {
	ticker := rafttime.NewTicker(500 * rafttime.Millisecond)
	defer ticker.Stop()
	for {
		select {
		case <-ticker.C:
			conn, err := p.connSelector.LeaderConn(ctx)
			if err != nil {
				return nil, err
			}

			client := NewHealthClient(conn)

			resp, err := client.Check(ctx, &HealthCheckRequest{Service: "Raft"})
			if err != nil || resp.Status != HealthCheckResponse_SERVING {
				continue
			}
			return conn, nil
		case <-ctx.Done():
			return nil, ctx.Err()
		}
	}
}

func (p *raftProxyCAServer) GetRootCACertificate(ctx context.Context, r *GetRootCACertificateRequest) (*GetRootCACertificateResponse, error) {

	conn, err := p.connSelector.LeaderConn(ctx)
	if err != nil {
		if err == raftselector.ErrIsLeader {
			ctx, err = p.runCtxMods(ctx, p.localCtxMods)
			if err != nil {
				return nil, err
			}
			return p.local.GetRootCACertificate(ctx, r)
		}
		return nil, err
	}
	modCtx, err := p.runCtxMods(ctx, p.remoteCtxMods)
	if err != nil {
		return nil, err
	}

	resp, err := NewCAClient(conn).GetRootCACertificate(modCtx, r)
	if err != nil {
		if !strings.Contains(err.Error(), "is closing") && !strings.Contains(err.Error(), "the connection is unavailable") && !strings.Contains(err.Error(), "connection error") {
			return resp, err
		}
		conn, err := p.pollNewLeaderConn(ctx)
		if err != nil {
			if err == raftselector.ErrIsLeader {
				return p.local.GetRootCACertificate(ctx, r)
			}
			return nil, err
		}
		return NewCAClient(conn).GetRootCACertificate(modCtx, r)
	}
	return resp, err
}

func (p *raftProxyCAServer) GetUnlockKey(ctx context.Context, r *GetUnlockKeyRequest) (*GetUnlockKeyResponse, error) {

	conn, err := p.connSelector.LeaderConn(ctx)
	if err != nil {
		if err == raftselector.ErrIsLeader {
			ctx, err = p.runCtxMods(ctx, p.localCtxMods)
			if err != nil {
				return nil, err
			}
			return p.local.GetUnlockKey(ctx, r)
		}
		return nil, err
	}
	modCtx, err := p.runCtxMods(ctx, p.remoteCtxMods)
	if err != nil {
		return nil, err
	}

	resp, err := NewCAClient(conn).GetUnlockKey(modCtx, r)
	if err != nil {
		if !strings.Contains(err.Error(), "is closing") && !strings.Contains(err.Error(), "the connection is unavailable") && !strings.Contains(err.Error(), "connection error") {
			return resp, err
		}
		conn, err := p.pollNewLeaderConn(ctx)
		if err != nil {
			if err == raftselector.ErrIsLeader {
				return p.local.GetUnlockKey(ctx, r)
			}
			return nil, err
		}
		return NewCAClient(conn).GetUnlockKey(modCtx, r)
	}
	return resp, err
}

type raftProxyNodeCAServer struct {
	local                       NodeCAServer
	connSelector                raftselector.ConnProvider
	localCtxMods, remoteCtxMods []func(context.Context) (context.Context, error)
}

func NewRaftProxyNodeCAServer(local NodeCAServer, connSelector raftselector.ConnProvider, localCtxMod, remoteCtxMod func(context.Context) (context.Context, error)) NodeCAServer {
	redirectChecker := func(ctx context.Context) (context.Context, error) {
		s, ok := transport.StreamFromContext(ctx)
		if !ok {
			return ctx, grpc.Errorf(codes.InvalidArgument, "remote addr is not found in context")
		}
		addr := s.ServerTransport().RemoteAddr().String()
		md, ok := metadata.FromContext(ctx)
		if ok && len(md["redirect"]) != 0 {
			return ctx, grpc.Errorf(codes.ResourceExhausted, "more than one redirect to leader from: %s", md["redirect"])
		}
		if !ok {
			md = metadata.New(map[string]string{})
		}
		md["redirect"] = append(md["redirect"], addr)
		return metadata.NewContext(ctx, md), nil
	}
	remoteMods := []func(context.Context) (context.Context, error){redirectChecker}
	remoteMods = append(remoteMods, remoteCtxMod)

	var localMods []func(context.Context) (context.Context, error)
	if localCtxMod != nil {
		localMods = []func(context.Context) (context.Context, error){localCtxMod}
	}

	return &raftProxyNodeCAServer{
		local:         local,
		connSelector:  connSelector,
		localCtxMods:  localMods,
		remoteCtxMods: remoteMods,
	}
}
func (p *raftProxyNodeCAServer) runCtxMods(ctx context.Context, ctxMods []func(context.Context) (context.Context, error)) (context.Context, error) {
	var err error
	for _, mod := range ctxMods {
		ctx, err = mod(ctx)
		if err != nil {
			return ctx, err
		}
	}
	return ctx, nil
}
func (p *raftProxyNodeCAServer) pollNewLeaderConn(ctx context.Context) (*grpc.ClientConn, error) {
	ticker := rafttime.NewTicker(500 * rafttime.Millisecond)
	defer ticker.Stop()
	for {
		select {
		case <-ticker.C:
			conn, err := p.connSelector.LeaderConn(ctx)
			if err != nil {
				return nil, err
			}

			client := NewHealthClient(conn)

			resp, err := client.Check(ctx, &HealthCheckRequest{Service: "Raft"})
			if err != nil || resp.Status != HealthCheckResponse_SERVING {
				continue
			}
			return conn, nil
		case <-ctx.Done():
			return nil, ctx.Err()
		}
	}
}

func (p *raftProxyNodeCAServer) IssueNodeCertificate(ctx context.Context, r *IssueNodeCertificateRequest) (*IssueNodeCertificateResponse, error) {

	conn, err := p.connSelector.LeaderConn(ctx)
	if err != nil {
		if err == raftselector.ErrIsLeader {
			ctx, err = p.runCtxMods(ctx, p.localCtxMods)
			if err != nil {
				return nil, err
			}
			return p.local.IssueNodeCertificate(ctx, r)
		}
		return nil, err
	}
	modCtx, err := p.runCtxMods(ctx, p.remoteCtxMods)
	if err != nil {
		return nil, err
	}

	resp, err := NewNodeCAClient(conn).IssueNodeCertificate(modCtx, r)
	if err != nil {
		if !strings.Contains(err.Error(), "is closing") && !strings.Contains(err.Error(), "the connection is unavailable") && !strings.Contains(err.Error(), "connection error") {
			return resp, err
		}
		conn, err := p.pollNewLeaderConn(ctx)
		if err != nil {
			if err == raftselector.ErrIsLeader {
				return p.local.IssueNodeCertificate(ctx, r)
			}
			return nil, err
		}
		return NewNodeCAClient(conn).IssueNodeCertificate(modCtx, r)
	}
	return resp, err
}

func (p *raftProxyNodeCAServer) NodeCertificateStatus(ctx context.Context, r *NodeCertificateStatusRequest) (*NodeCertificateStatusResponse, error) {

	conn, err := p.connSelector.LeaderConn(ctx)
	if err != nil {
		if err == raftselector.ErrIsLeader {
			ctx, err = p.runCtxMods(ctx, p.localCtxMods)
			if err != nil {
				return nil, err
			}
			return p.local.NodeCertificateStatus(ctx, r)
		}
		return nil, err
	}
	modCtx, err := p.runCtxMods(ctx, p.remoteCtxMods)
	if err != nil {
		return nil, err
	}

	resp, err := NewNodeCAClient(conn).NodeCertificateStatus(modCtx, r)
	if err != nil {
		if !strings.Contains(err.Error(), "is closing") && !strings.Contains(err.Error(), "the connection is unavailable") && !strings.Contains(err.Error(), "connection error") {
			return resp, err
		}
		conn, err := p.pollNewLeaderConn(ctx)
		if err != nil {
			if err == raftselector.ErrIsLeader {
				return p.local.NodeCertificateStatus(ctx, r)
			}
			return nil, err
		}
		return NewNodeCAClient(conn).NodeCertificateStatus(modCtx, r)
	}
	return resp, err
}

func (m *NodeCertificateStatusRequest) Size() (n int) {
	var l int
	_ = l
	l = len(m.NodeID)
	if l > 0 {
		n += 1 + l + sovCa(uint64(l))
	}
	return n
}

func (m *NodeCertificateStatusResponse) Size() (n int) {
	var l int
	_ = l
	if m.Status != nil {
		l = m.Status.Size()
		n += 1 + l + sovCa(uint64(l))
	}
	if m.Certificate != nil {
		l = m.Certificate.Size()
		n += 1 + l + sovCa(uint64(l))
	}
	return n
}

func (m *IssueNodeCertificateRequest) Size() (n int) {
	var l int
	_ = l
	if m.Role != 0 {
		n += 1 + sovCa(uint64(m.Role))
	}
	l = len(m.CSR)
	if l > 0 {
		n += 1 + l + sovCa(uint64(l))
	}
	l = len(m.Token)
	if l > 0 {
		n += 1 + l + sovCa(uint64(l))
	}
	if m.Availability != 0 {
		n += 1 + sovCa(uint64(m.Availability))
	}
	return n
}

func (m *IssueNodeCertificateResponse) Size() (n int) {
	var l int
	_ = l
	l = len(m.NodeID)
	if l > 0 {
		n += 1 + l + sovCa(uint64(l))
	}
	if m.NodeMembership != 0 {
		n += 1 + sovCa(uint64(m.NodeMembership))
	}
	return n
}

func (m *GetRootCACertificateRequest) Size() (n int) {
	var l int
	_ = l
	return n
}

func (m *GetRootCACertificateResponse) Size() (n int) {
	var l int
	_ = l
	l = len(m.Certificate)
	if l > 0 {
		n += 1 + l + sovCa(uint64(l))
	}
	return n
}

func (m *GetUnlockKeyRequest) Size() (n int) {
	var l int
	_ = l
	return n
}

func (m *GetUnlockKeyResponse) Size() (n int) {
	var l int
	_ = l
	l = len(m.UnlockKey)
	if l > 0 {
		n += 1 + l + sovCa(uint64(l))
	}
	l = m.Version.Size()
	n += 1 + l + sovCa(uint64(l))
	return n
}

func sovCa(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozCa(x uint64) (n int) {
	return sovCa(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *NodeCertificateStatusRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&NodeCertificateStatusRequest{`,
		`NodeID:` + fmt.Sprintf("%v", this.NodeID) + `,`,
		`}`,
	}, "")
	return s
}
func (this *NodeCertificateStatusResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&NodeCertificateStatusResponse{`,
		`Status:` + strings.Replace(fmt.Sprintf("%v", this.Status), "IssuanceStatus", "IssuanceStatus", 1) + `,`,
		`Certificate:` + strings.Replace(fmt.Sprintf("%v", this.Certificate), "Certificate", "Certificate", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *IssueNodeCertificateRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&IssueNodeCertificateRequest{`,
		`Role:` + fmt.Sprintf("%v", this.Role) + `,`,
		`CSR:` + fmt.Sprintf("%v", this.CSR) + `,`,
		`Token:` + fmt.Sprintf("%v", this.Token) + `,`,
		`Availability:` + fmt.Sprintf("%v", this.Availability) + `,`,
		`}`,
	}, "")
	return s
}
func (this *IssueNodeCertificateResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&IssueNodeCertificateResponse{`,
		`NodeID:` + fmt.Sprintf("%v", this.NodeID) + `,`,
		`NodeMembership:` + fmt.Sprintf("%v", this.NodeMembership) + `,`,
		`}`,
	}, "")
	return s
}
func (this *GetRootCACertificateRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&GetRootCACertificateRequest{`,
		`}`,
	}, "")
	return s
}
func (this *GetRootCACertificateResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&GetRootCACertificateResponse{`,
		`Certificate:` + fmt.Sprintf("%v", this.Certificate) + `,`,
		`}`,
	}, "")
	return s
}
func (this *GetUnlockKeyRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&GetUnlockKeyRequest{`,
		`}`,
	}, "")
	return s
}
func (this *GetUnlockKeyResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&GetUnlockKeyResponse{`,
		`UnlockKey:` + fmt.Sprintf("%v", this.UnlockKey) + `,`,
		`Version:` + strings.Replace(strings.Replace(this.Version.String(), "Version", "Version", 1), `&`, ``, 1) + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringCa(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *NodeCertificateStatusRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCa
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: NodeCertificateStatusRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: NodeCertificateStatusRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCa
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCa
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NodeID = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCa(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCa
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *NodeCertificateStatusResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCa
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: NodeCertificateStatusResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: NodeCertificateStatusResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Status", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCa
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCa
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Status == nil {
				m.Status = &IssuanceStatus{}
			}
			if err := m.Status.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Certificate", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCa
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCa
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Certificate == nil {
				m.Certificate = &Certificate{}
			}
			if err := m.Certificate.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCa(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCa
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *IssueNodeCertificateRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCa
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: IssueNodeCertificateRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: IssueNodeCertificateRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Role", wireType)
			}
			m.Role = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCa
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Role |= (NodeRole(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CSR", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCa
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthCa
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CSR = append(m.CSR[:0], dAtA[iNdEx:postIndex]...)
			if m.CSR == nil {
				m.CSR = []byte{}
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Token", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCa
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCa
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Token = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Availability", wireType)
			}
			m.Availability = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCa
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Availability |= (NodeSpec_Availability(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipCa(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCa
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *IssueNodeCertificateResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCa
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: IssueNodeCertificateResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: IssueNodeCertificateResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCa
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCa
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NodeID = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeMembership", wireType)
			}
			m.NodeMembership = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCa
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NodeMembership |= (NodeSpec_Membership(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipCa(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCa
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetRootCACertificateRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCa
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetRootCACertificateRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetRootCACertificateRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipCa(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCa
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetRootCACertificateResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCa
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetRootCACertificateResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetRootCACertificateResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Certificate", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCa
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthCa
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Certificate = append(m.Certificate[:0], dAtA[iNdEx:postIndex]...)
			if m.Certificate == nil {
				m.Certificate = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCa(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCa
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetUnlockKeyRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCa
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetUnlockKeyRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetUnlockKeyRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipCa(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCa
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetUnlockKeyResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCa
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetUnlockKeyResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetUnlockKeyResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field UnlockKey", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCa
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthCa
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.UnlockKey = append(m.UnlockKey[:0], dAtA[iNdEx:postIndex]...)
			if m.UnlockKey == nil {
				m.UnlockKey = []byte{}
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Version", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCa
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCa
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Version.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCa(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCa
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipCa(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowCa
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowCa
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowCa
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthCa
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowCa
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipCa(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthCa = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowCa   = fmt.Errorf("proto: integer overflow")
)

func init() { proto.RegisterFile("ca.proto", fileDescriptorCa) }

var fileDescriptorCa = []byte{
	// 610 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x09, 0x6e, 0x88, 0x02, 0xff, 0x94, 0x54, 0xcd, 0x6e, 0xd3, 0x40,
	0x10, 0xee, 0xba, 0x25, 0x6d, 0x27, 0xa1, 0x45, 0xdb, 0x56, 0x32, 0x69, 0xea, 0x54, 0xe6, 0xd0,
	0x72, 0xc0, 0x6d, 0x03, 0x27, 0xb8, 0x90, 0x04, 0xa9, 0x8a, 0x50, 0x11, 0xda, 0x08, 0xae, 0x95,
	0xe3, 0x2c, 0xc1, 0x8a, 0xe3, 0x35, 0xde, 0x75, 0x20, 0x37, 0x24, 0x10, 0x6f, 0x80, 0xe0, 0xc4,
	0x23, 0xf0, 0x1c, 0x11, 0x27, 0x24, 0x2e, 0x9c, 0x22, 0xea, 0x07, 0xe0, 0x19, 0x90, 0xd7, 0x36,
	0xcd, 0x8f, 0x13, 0xca, 0xc9, 0xbb, 0xb3, 0xdf, 0xf7, 0xcd, 0xcc, 0xb7, 0xe3, 0x85, 0x35, 0xcb,
	0x34, 0x3c, 0x9f, 0x09, 0x86, 0x71, 0x9b, 0x59, 0x5d, 0xea, 0x1b, 0xfc, 0xb5, 0xe9, 0xf7, 0xba,
	0xb6, 0x30, 0xfa, 0x27, 0xc5, 0xbc, 0x18, 0x78, 0x94, 0xc7, 0x80, 0x62, 0x9e, 0x7b, 0xd4, 0x4a,
	0x37, 0xdb, 0x1d, 0xd6, 0x61, 0x72, 0x79, 0x14, 0xad, 0x92, 0xe8, 0x96, 0xe7, 0x04, 0x1d, 0xdb,
	0x3d, 0x8a, 0x3f, 0x71, 0x50, 0xaf, 0x43, 0xe9, 0x09, 0x6b, 0xd3, 0x3a, 0xf5, 0x85, 0xfd, 0xc2,
	0xb6, 0x4c, 0x41, 0x9b, 0xc2, 0x14, 0x01, 0x27, 0xf4, 0x55, 0x40, 0xb9, 0xc0, 0xb7, 0x60, 0xd5,
	0x65, 0x6d, 0x7a, 0x6e, 0xb7, 0x55, 0xb4, 0x8f, 0x0e, 0xd7, 0x6b, 0x10, 0x8e, 0xca, 0xb9, 0x88,
	0xd2, 0x78, 0x44, 0x72, 0xd1, 0x51, 0xa3, 0xad, 0x7f, 0x41, 0xb0, 0x37, 0x47, 0x85, 0x7b, 0xcc,
	0xe5, 0x14, 0xdf, 0x87, 0x1c, 0x97, 0x11, 0xa9, 0x92, 0xaf, 0xe8, 0xc6, 0x6c, 0x43, 0x46, 0x83,
	0xf3, 0xc0, 0x74, 0xad, 0x94, 0x9b, 0x30, 0x70, 0x15, 0xf2, 0xd6, 0xa5, 0xb0, 0xaa, 0x48, 0x81,
	0x72, 0x96, 0xc0, 0x58, 0x7e, 0x32, 0xce, 0xd1, 0x7f, 0x20, 0xd8, 0x8d, 0xd4, 0xe9, 0x54, 0x95,
	0x69, 0x97, 0xf7, 0x60, 0xc5, 0x67, 0x0e, 0x95, 0xc5, 0x6d, 0x54, 0x4a, 0x59, 0xda, 0x11, 0x93,
	0x30, 0x87, 0xd6, 0x14, 0x15, 0x11, 0x89, 0xc6, 0x37, 0x61, 0xd9, 0xe2, 0xbe, 0x2c, 0xa8, 0x50,
	0x5b, 0x0d, 0x47, 0xe5, 0xe5, 0x7a, 0x93, 0x90, 0x28, 0x86, 0xb7, 0xe1, 0x9a, 0x60, 0x5d, 0xea,
	0xaa, 0xcb, 0x91, 0x69, 0x24, 0xde, 0xe0, 0x33, 0x28, 0x98, 0x7d, 0xd3, 0x76, 0xcc, 0x96, 0xed,
	0xd8, 0x62, 0xa0, 0xae, 0xc8, 0x74, 0xb7, 0xe7, 0xa5, 0x6b, 0x7a, 0xd4, 0x32, 0xaa, 0x63, 0x04,
	0x32, 0x41, 0xd7, 0x3f, 0x22, 0x28, 0x65, 0x77, 0x95, 0xb8, 0x7e, 0x95, 0xcb, 0xc3, 0x4f, 0x61,
	0x53, 0x82, 0x7a, 0xb4, 0xd7, 0xa2, 0x3e, 0x7f, 0x69, 0x7b, 0xb2, 0xa3, 0x8d, 0xca, 0xc1, 0xc2,
	0xba, 0xce, 0xfe, 0xc2, 0xc9, 0x46, 0xc4, 0xbf, 0xdc, 0xeb, 0x7b, 0xb0, 0x7b, 0x4a, 0x05, 0x61,
	0x4c, 0xd4, 0xab, 0xb3, 0x66, 0xeb, 0x0f, 0xa1, 0x94, 0x7d, 0x9c, 0x54, 0xbd, 0x3f, 0x79, 0xdf,
	0x51, 0xe5, 0x85, 0xc9, 0xeb, 0xdc, 0x81, 0xad, 0x53, 0x2a, 0x9e, 0xb9, 0x0e, 0xb3, 0xba, 0x8f,
	0xe9, 0x20, 0x15, 0xf6, 0x61, 0x7b, 0x32, 0x9c, 0x08, 0xee, 0x01, 0x04, 0x32, 0x78, 0xde, 0xa5,
	0x83, 0x44, 0x6f, 0x3d, 0x48, 0x61, 0xf8, 0x01, 0xac, 0xf6, 0xa9, 0xcf, 0x6d, 0xe6, 0x26, 0xb3,
	0xb5, 0x9b, 0xd5, 0xf8, 0xf3, 0x18, 0x52, 0x5b, 0x19, 0x8e, 0xca, 0x4b, 0x24, 0x65, 0x54, 0xde,
	0x2b, 0xa0, 0xd4, 0xab, 0xf8, 0x1d, 0x92, 0xb9, 0x67, 0x9a, 0xc2, 0x47, 0x59, 0x5a, 0x0b, 0xdc,
	0x29, 0x1e, 0x5f, 0x9d, 0x10, 0xb7, 0xa7, 0xaf, 0x7d, 0xfb, 0xfa, 0xfb, 0xb3, 0xa2, 0xdc, 0x40,
	0xf8, 0x0d, 0x14, 0xc6, 0x0d, 0xc0, 0x07, 0x73, 0xb4, 0xa6, 0x9d, 0x2b, 0x1e, 0xfe, 0x1b, 0x98,
	0x24, 0xdb, 0x91, 0xc9, 0x36, 0xe1, 0xba, 0x44, 0xde, 0xe9, 0x99, 0xae, 0xd9, 0xa1, 0x7e, 0xe5,
	0x93, 0x02, 0x72, 0xae, 0x12, 0x2b, 0xb2, 0xa6, 0x32, 0xdb, 0x8a, 0x05, 0x7f, 0x65, 0xb6, 0x15,
	0x8b, 0x06, 0x7e, 0xcc, 0x8a, 0x0f, 0x08, 0x76, 0x32, 0x9f, 0x24, 0x7c, 0x3c, 0x6f, 0xac, 0xe7,
	0xbd, 0x81, 0xc5, 0x93, 0xff, 0x60, 0x4c, 0x17, 0x52, 0x53, 0x87, 0x17, 0xda, 0xd2, 0xcf, 0x0b,
	0x6d, 0xe9, 0x6d, 0xa8, 0xa1, 0x61, 0xa8, 0xa1, 0xef, 0xa1, 0x86, 0x7e, 0x85, 0x1a, 0x6a, 0xe5,
	0xe4, 0x0b, 0x7c, 0xf7, 0x4f, 0x00, 0x00, 0x00, 0xff, 0xff, 0x69, 0xad, 0xed, 0x8f, 0xe6, 0x05,
	0x00, 0x00,
}
