// Code generated by protoc-gen-go.
// source: api.proto
// DO NOT EDIT!

/*
Package types is a generated protocol buffer package.

It is generated from these files:
	api.proto

It has these top-level messages:
	GetServerVersionRequest
	GetServerVersionResponse
	UpdateProcessRequest
	UpdateProcessResponse
	CreateContainerRequest
	CreateContainerResponse
	SignalRequest
	SignalResponse
	AddProcessRequest
	Rlimit
	User
	AddProcessResponse
	CreateCheckpointRequest
	CreateCheckpointResponse
	DeleteCheckpointRequest
	DeleteCheckpointResponse
	ListCheckpointRequest
	Checkpoint
	ListCheckpointResponse
	StateRequest
	ContainerState
	Process
	Container
	Machine
	StateResponse
	UpdateContainerRequest
	UpdateResource
	BlockIODevice
	WeightDevice
	ThrottleDevice
	UpdateContainerResponse
	EventsRequest
	Event
	NetworkStats
	CpuUsage
	ThrottlingData
	CpuStats
	PidsStats
	MemoryData
	MemoryStats
	BlkioStatsEntry
	BlkioStats
	HugetlbStats
	CgroupStats
	StatsResponse
	StatsRequest
*/
package types

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import google_protobuf "github.com/golang/protobuf/ptypes/timestamp"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

type GetServerVersionRequest struct {
}

func (m *GetServerVersionRequest) Reset()                    { *m = GetServerVersionRequest{} }
func (m *GetServerVersionRequest) String() string            { return proto.CompactTextString(m) }
func (*GetServerVersionRequest) ProtoMessage()               {}
func (*GetServerVersionRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

type GetServerVersionResponse struct {
	Major    uint32 `protobuf:"varint,1,opt,name=major" json:"major,omitempty"`
	Minor    uint32 `protobuf:"varint,2,opt,name=minor" json:"minor,omitempty"`
	Patch    uint32 `protobuf:"varint,3,opt,name=patch" json:"patch,omitempty"`
	Revision string `protobuf:"bytes,4,opt,name=revision" json:"revision,omitempty"`
}

func (m *GetServerVersionResponse) Reset()                    { *m = GetServerVersionResponse{} }
func (m *GetServerVersionResponse) String() string            { return proto.CompactTextString(m) }
func (*GetServerVersionResponse) ProtoMessage()               {}
func (*GetServerVersionResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

func (m *GetServerVersionResponse) GetMajor() uint32 {
	if m != nil {
		return m.Major
	}
	return 0
}

func (m *GetServerVersionResponse) GetMinor() uint32 {
	if m != nil {
		return m.Minor
	}
	return 0
}

func (m *GetServerVersionResponse) GetPatch() uint32 {
	if m != nil {
		return m.Patch
	}
	return 0
}

func (m *GetServerVersionResponse) GetRevision() string {
	if m != nil {
		return m.Revision
	}
	return ""
}

type UpdateProcessRequest struct {
	Id         string `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	Pid        string `protobuf:"bytes,2,opt,name=pid" json:"pid,omitempty"`
	CloseStdin bool   `protobuf:"varint,3,opt,name=closeStdin" json:"closeStdin,omitempty"`
	Width      uint32 `protobuf:"varint,4,opt,name=width" json:"width,omitempty"`
	Height     uint32 `protobuf:"varint,5,opt,name=height" json:"height,omitempty"`
}

func (m *UpdateProcessRequest) Reset()                    { *m = UpdateProcessRequest{} }
func (m *UpdateProcessRequest) String() string            { return proto.CompactTextString(m) }
func (*UpdateProcessRequest) ProtoMessage()               {}
func (*UpdateProcessRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

func (m *UpdateProcessRequest) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *UpdateProcessRequest) GetPid() string {
	if m != nil {
		return m.Pid
	}
	return ""
}

func (m *UpdateProcessRequest) GetCloseStdin() bool {
	if m != nil {
		return m.CloseStdin
	}
	return false
}

func (m *UpdateProcessRequest) GetWidth() uint32 {
	if m != nil {
		return m.Width
	}
	return 0
}

func (m *UpdateProcessRequest) GetHeight() uint32 {
	if m != nil {
		return m.Height
	}
	return 0
}

type UpdateProcessResponse struct {
}

func (m *UpdateProcessResponse) Reset()                    { *m = UpdateProcessResponse{} }
func (m *UpdateProcessResponse) String() string            { return proto.CompactTextString(m) }
func (*UpdateProcessResponse) ProtoMessage()               {}
func (*UpdateProcessResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{3} }

type CreateContainerRequest struct {
	Id            string   `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	BundlePath    string   `protobuf:"bytes,2,opt,name=bundlePath" json:"bundlePath,omitempty"`
	Checkpoint    string   `protobuf:"bytes,3,opt,name=checkpoint" json:"checkpoint,omitempty"`
	Stdin         string   `protobuf:"bytes,4,opt,name=stdin" json:"stdin,omitempty"`
	Stdout        string   `protobuf:"bytes,5,opt,name=stdout" json:"stdout,omitempty"`
	Stderr        string   `protobuf:"bytes,6,opt,name=stderr" json:"stderr,omitempty"`
	Labels        []string `protobuf:"bytes,7,rep,name=labels" json:"labels,omitempty"`
	NoPivotRoot   bool     `protobuf:"varint,8,opt,name=noPivotRoot" json:"noPivotRoot,omitempty"`
	Runtime       string   `protobuf:"bytes,9,opt,name=runtime" json:"runtime,omitempty"`
	RuntimeArgs   []string `protobuf:"bytes,10,rep,name=runtimeArgs" json:"runtimeArgs,omitempty"`
	CheckpointDir string   `protobuf:"bytes,11,opt,name=checkpointDir" json:"checkpointDir,omitempty"`
}

func (m *CreateContainerRequest) Reset()                    { *m = CreateContainerRequest{} }
func (m *CreateContainerRequest) String() string            { return proto.CompactTextString(m) }
func (*CreateContainerRequest) ProtoMessage()               {}
func (*CreateContainerRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{4} }

func (m *CreateContainerRequest) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *CreateContainerRequest) GetBundlePath() string {
	if m != nil {
		return m.BundlePath
	}
	return ""
}

func (m *CreateContainerRequest) GetCheckpoint() string {
	if m != nil {
		return m.Checkpoint
	}
	return ""
}

func (m *CreateContainerRequest) GetStdin() string {
	if m != nil {
		return m.Stdin
	}
	return ""
}

func (m *CreateContainerRequest) GetStdout() string {
	if m != nil {
		return m.Stdout
	}
	return ""
}

func (m *CreateContainerRequest) GetStderr() string {
	if m != nil {
		return m.Stderr
	}
	return ""
}

func (m *CreateContainerRequest) GetLabels() []string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *CreateContainerRequest) GetNoPivotRoot() bool {
	if m != nil {
		return m.NoPivotRoot
	}
	return false
}

func (m *CreateContainerRequest) GetRuntime() string {
	if m != nil {
		return m.Runtime
	}
	return ""
}

func (m *CreateContainerRequest) GetRuntimeArgs() []string {
	if m != nil {
		return m.RuntimeArgs
	}
	return nil
}

func (m *CreateContainerRequest) GetCheckpointDir() string {
	if m != nil {
		return m.CheckpointDir
	}
	return ""
}

type CreateContainerResponse struct {
	Container *Container `protobuf:"bytes,1,opt,name=container" json:"container,omitempty"`
}

func (m *CreateContainerResponse) Reset()                    { *m = CreateContainerResponse{} }
func (m *CreateContainerResponse) String() string            { return proto.CompactTextString(m) }
func (*CreateContainerResponse) ProtoMessage()               {}
func (*CreateContainerResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{5} }

func (m *CreateContainerResponse) GetContainer() *Container {
	if m != nil {
		return m.Container
	}
	return nil
}

type SignalRequest struct {
	Id     string `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	Pid    string `protobuf:"bytes,2,opt,name=pid" json:"pid,omitempty"`
	Signal uint32 `protobuf:"varint,3,opt,name=signal" json:"signal,omitempty"`
}

func (m *SignalRequest) Reset()                    { *m = SignalRequest{} }
func (m *SignalRequest) String() string            { return proto.CompactTextString(m) }
func (*SignalRequest) ProtoMessage()               {}
func (*SignalRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{6} }

func (m *SignalRequest) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *SignalRequest) GetPid() string {
	if m != nil {
		return m.Pid
	}
	return ""
}

func (m *SignalRequest) GetSignal() uint32 {
	if m != nil {
		return m.Signal
	}
	return 0
}

type SignalResponse struct {
}

func (m *SignalResponse) Reset()                    { *m = SignalResponse{} }
func (m *SignalResponse) String() string            { return proto.CompactTextString(m) }
func (*SignalResponse) ProtoMessage()               {}
func (*SignalResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{7} }

type AddProcessRequest struct {
	Id              string    `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	Terminal        bool      `protobuf:"varint,2,opt,name=terminal" json:"terminal,omitempty"`
	User            *User     `protobuf:"bytes,3,opt,name=user" json:"user,omitempty"`
	Args            []string  `protobuf:"bytes,4,rep,name=args" json:"args,omitempty"`
	Env             []string  `protobuf:"bytes,5,rep,name=env" json:"env,omitempty"`
	Cwd             string    `protobuf:"bytes,6,opt,name=cwd" json:"cwd,omitempty"`
	Pid             string    `protobuf:"bytes,7,opt,name=pid" json:"pid,omitempty"`
	Stdin           string    `protobuf:"bytes,8,opt,name=stdin" json:"stdin,omitempty"`
	Stdout          string    `protobuf:"bytes,9,opt,name=stdout" json:"stdout,omitempty"`
	Stderr          string    `protobuf:"bytes,10,opt,name=stderr" json:"stderr,omitempty"`
	Capabilities    []string  `protobuf:"bytes,11,rep,name=capabilities" json:"capabilities,omitempty"`
	ApparmorProfile string    `protobuf:"bytes,12,opt,name=apparmorProfile" json:"apparmorProfile,omitempty"`
	SelinuxLabel    string    `protobuf:"bytes,13,opt,name=selinuxLabel" json:"selinuxLabel,omitempty"`
	NoNewPrivileges bool      `protobuf:"varint,14,opt,name=noNewPrivileges" json:"noNewPrivileges,omitempty"`
	Rlimits         []*Rlimit `protobuf:"bytes,15,rep,name=rlimits" json:"rlimits,omitempty"`
}

func (m *AddProcessRequest) Reset()                    { *m = AddProcessRequest{} }
func (m *AddProcessRequest) String() string            { return proto.CompactTextString(m) }
func (*AddProcessRequest) ProtoMessage()               {}
func (*AddProcessRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{8} }

func (m *AddProcessRequest) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *AddProcessRequest) GetTerminal() bool {
	if m != nil {
		return m.Terminal
	}
	return false
}

func (m *AddProcessRequest) GetUser() *User {
	if m != nil {
		return m.User
	}
	return nil
}

func (m *AddProcessRequest) GetArgs() []string {
	if m != nil {
		return m.Args
	}
	return nil
}

func (m *AddProcessRequest) GetEnv() []string {
	if m != nil {
		return m.Env
	}
	return nil
}

func (m *AddProcessRequest) GetCwd() string {
	if m != nil {
		return m.Cwd
	}
	return ""
}

func (m *AddProcessRequest) GetPid() string {
	if m != nil {
		return m.Pid
	}
	return ""
}

func (m *AddProcessRequest) GetStdin() string {
	if m != nil {
		return m.Stdin
	}
	return ""
}

func (m *AddProcessRequest) GetStdout() string {
	if m != nil {
		return m.Stdout
	}
	return ""
}

func (m *AddProcessRequest) GetStderr() string {
	if m != nil {
		return m.Stderr
	}
	return ""
}

func (m *AddProcessRequest) GetCapabilities() []string {
	if m != nil {
		return m.Capabilities
	}
	return nil
}

func (m *AddProcessRequest) GetApparmorProfile() string {
	if m != nil {
		return m.ApparmorProfile
	}
	return ""
}

func (m *AddProcessRequest) GetSelinuxLabel() string {
	if m != nil {
		return m.SelinuxLabel
	}
	return ""
}

func (m *AddProcessRequest) GetNoNewPrivileges() bool {
	if m != nil {
		return m.NoNewPrivileges
	}
	return false
}

func (m *AddProcessRequest) GetRlimits() []*Rlimit {
	if m != nil {
		return m.Rlimits
	}
	return nil
}

type Rlimit struct {
	Type string `protobuf:"bytes,1,opt,name=type" json:"type,omitempty"`
	Soft uint64 `protobuf:"varint,2,opt,name=soft" json:"soft,omitempty"`
	Hard uint64 `protobuf:"varint,3,opt,name=hard" json:"hard,omitempty"`
}

func (m *Rlimit) Reset()                    { *m = Rlimit{} }
func (m *Rlimit) String() string            { return proto.CompactTextString(m) }
func (*Rlimit) ProtoMessage()               {}
func (*Rlimit) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{9} }

func (m *Rlimit) GetType() string {
	if m != nil {
		return m.Type
	}
	return ""
}

func (m *Rlimit) GetSoft() uint64 {
	if m != nil {
		return m.Soft
	}
	return 0
}

func (m *Rlimit) GetHard() uint64 {
	if m != nil {
		return m.Hard
	}
	return 0
}

type User struct {
	Uid            uint32   `protobuf:"varint,1,opt,name=uid" json:"uid,omitempty"`
	Gid            uint32   `protobuf:"varint,2,opt,name=gid" json:"gid,omitempty"`
	AdditionalGids []uint32 `protobuf:"varint,3,rep,packed,name=additionalGids" json:"additionalGids,omitempty"`
}

func (m *User) Reset()                    { *m = User{} }
func (m *User) String() string            { return proto.CompactTextString(m) }
func (*User) ProtoMessage()               {}
func (*User) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{10} }

func (m *User) GetUid() uint32 {
	if m != nil {
		return m.Uid
	}
	return 0
}

func (m *User) GetGid() uint32 {
	if m != nil {
		return m.Gid
	}
	return 0
}

func (m *User) GetAdditionalGids() []uint32 {
	if m != nil {
		return m.AdditionalGids
	}
	return nil
}

type AddProcessResponse struct {
	SystemPid uint32 `protobuf:"varint,1,opt,name=systemPid" json:"systemPid,omitempty"`
}

func (m *AddProcessResponse) Reset()                    { *m = AddProcessResponse{} }
func (m *AddProcessResponse) String() string            { return proto.CompactTextString(m) }
func (*AddProcessResponse) ProtoMessage()               {}
func (*AddProcessResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{11} }

func (m *AddProcessResponse) GetSystemPid() uint32 {
	if m != nil {
		return m.SystemPid
	}
	return 0
}

type CreateCheckpointRequest struct {
	Id            string      `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	Checkpoint    *Checkpoint `protobuf:"bytes,2,opt,name=checkpoint" json:"checkpoint,omitempty"`
	CheckpointDir string      `protobuf:"bytes,3,opt,name=checkpointDir" json:"checkpointDir,omitempty"`
}

func (m *CreateCheckpointRequest) Reset()                    { *m = CreateCheckpointRequest{} }
func (m *CreateCheckpointRequest) String() string            { return proto.CompactTextString(m) }
func (*CreateCheckpointRequest) ProtoMessage()               {}
func (*CreateCheckpointRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{12} }

func (m *CreateCheckpointRequest) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *CreateCheckpointRequest) GetCheckpoint() *Checkpoint {
	if m != nil {
		return m.Checkpoint
	}
	return nil
}

func (m *CreateCheckpointRequest) GetCheckpointDir() string {
	if m != nil {
		return m.CheckpointDir
	}
	return ""
}

type CreateCheckpointResponse struct {
}

func (m *CreateCheckpointResponse) Reset()                    { *m = CreateCheckpointResponse{} }
func (m *CreateCheckpointResponse) String() string            { return proto.CompactTextString(m) }
func (*CreateCheckpointResponse) ProtoMessage()               {}
func (*CreateCheckpointResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{13} }

type DeleteCheckpointRequest struct {
	Id            string `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	Name          string `protobuf:"bytes,2,opt,name=name" json:"name,omitempty"`
	CheckpointDir string `protobuf:"bytes,3,opt,name=checkpointDir" json:"checkpointDir,omitempty"`
}

func (m *DeleteCheckpointRequest) Reset()                    { *m = DeleteCheckpointRequest{} }
func (m *DeleteCheckpointRequest) String() string            { return proto.CompactTextString(m) }
func (*DeleteCheckpointRequest) ProtoMessage()               {}
func (*DeleteCheckpointRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{14} }

func (m *DeleteCheckpointRequest) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *DeleteCheckpointRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *DeleteCheckpointRequest) GetCheckpointDir() string {
	if m != nil {
		return m.CheckpointDir
	}
	return ""
}

type DeleteCheckpointResponse struct {
}

func (m *DeleteCheckpointResponse) Reset()                    { *m = DeleteCheckpointResponse{} }
func (m *DeleteCheckpointResponse) String() string            { return proto.CompactTextString(m) }
func (*DeleteCheckpointResponse) ProtoMessage()               {}
func (*DeleteCheckpointResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{15} }

type ListCheckpointRequest struct {
	Id            string `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	CheckpointDir string `protobuf:"bytes,2,opt,name=checkpointDir" json:"checkpointDir,omitempty"`
}

func (m *ListCheckpointRequest) Reset()                    { *m = ListCheckpointRequest{} }
func (m *ListCheckpointRequest) String() string            { return proto.CompactTextString(m) }
func (*ListCheckpointRequest) ProtoMessage()               {}
func (*ListCheckpointRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{16} }

func (m *ListCheckpointRequest) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *ListCheckpointRequest) GetCheckpointDir() string {
	if m != nil {
		return m.CheckpointDir
	}
	return ""
}

type Checkpoint struct {
	Name        string   `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	Exit        bool     `protobuf:"varint,2,opt,name=exit" json:"exit,omitempty"`
	Tcp         bool     `protobuf:"varint,3,opt,name=tcp" json:"tcp,omitempty"`
	UnixSockets bool     `protobuf:"varint,4,opt,name=unixSockets" json:"unixSockets,omitempty"`
	Shell       bool     `protobuf:"varint,5,opt,name=shell" json:"shell,omitempty"`
	EmptyNS     []string `protobuf:"bytes,6,rep,name=emptyNS" json:"emptyNS,omitempty"`
}

func (m *Checkpoint) Reset()                    { *m = Checkpoint{} }
func (m *Checkpoint) String() string            { return proto.CompactTextString(m) }
func (*Checkpoint) ProtoMessage()               {}
func (*Checkpoint) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{17} }

func (m *Checkpoint) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Checkpoint) GetExit() bool {
	if m != nil {
		return m.Exit
	}
	return false
}

func (m *Checkpoint) GetTcp() bool {
	if m != nil {
		return m.Tcp
	}
	return false
}

func (m *Checkpoint) GetUnixSockets() bool {
	if m != nil {
		return m.UnixSockets
	}
	return false
}

func (m *Checkpoint) GetShell() bool {
	if m != nil {
		return m.Shell
	}
	return false
}

func (m *Checkpoint) GetEmptyNS() []string {
	if m != nil {
		return m.EmptyNS
	}
	return nil
}

type ListCheckpointResponse struct {
	Checkpoints []*Checkpoint `protobuf:"bytes,1,rep,name=checkpoints" json:"checkpoints,omitempty"`
}

func (m *ListCheckpointResponse) Reset()                    { *m = ListCheckpointResponse{} }
func (m *ListCheckpointResponse) String() string            { return proto.CompactTextString(m) }
func (*ListCheckpointResponse) ProtoMessage()               {}
func (*ListCheckpointResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{18} }

func (m *ListCheckpointResponse) GetCheckpoints() []*Checkpoint {
	if m != nil {
		return m.Checkpoints
	}
	return nil
}

type StateRequest struct {
	Id string `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
}

func (m *StateRequest) Reset()                    { *m = StateRequest{} }
func (m *StateRequest) String() string            { return proto.CompactTextString(m) }
func (*StateRequest) ProtoMessage()               {}
func (*StateRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{19} }

func (m *StateRequest) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

type ContainerState struct {
	Status string `protobuf:"bytes,1,opt,name=status" json:"status,omitempty"`
}

func (m *ContainerState) Reset()                    { *m = ContainerState{} }
func (m *ContainerState) String() string            { return proto.CompactTextString(m) }
func (*ContainerState) ProtoMessage()               {}
func (*ContainerState) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{20} }

func (m *ContainerState) GetStatus() string {
	if m != nil {
		return m.Status
	}
	return ""
}

type Process struct {
	Pid             string    `protobuf:"bytes,1,opt,name=pid" json:"pid,omitempty"`
	Terminal        bool      `protobuf:"varint,2,opt,name=terminal" json:"terminal,omitempty"`
	User            *User     `protobuf:"bytes,3,opt,name=user" json:"user,omitempty"`
	Args            []string  `protobuf:"bytes,4,rep,name=args" json:"args,omitempty"`
	Env             []string  `protobuf:"bytes,5,rep,name=env" json:"env,omitempty"`
	Cwd             string    `protobuf:"bytes,6,opt,name=cwd" json:"cwd,omitempty"`
	SystemPid       uint32    `protobuf:"varint,7,opt,name=systemPid" json:"systemPid,omitempty"`
	Stdin           string    `protobuf:"bytes,8,opt,name=stdin" json:"stdin,omitempty"`
	Stdout          string    `protobuf:"bytes,9,opt,name=stdout" json:"stdout,omitempty"`
	Stderr          string    `protobuf:"bytes,10,opt,name=stderr" json:"stderr,omitempty"`
	Capabilities    []string  `protobuf:"bytes,11,rep,name=capabilities" json:"capabilities,omitempty"`
	ApparmorProfile string    `protobuf:"bytes,12,opt,name=apparmorProfile" json:"apparmorProfile,omitempty"`
	SelinuxLabel    string    `protobuf:"bytes,13,opt,name=selinuxLabel" json:"selinuxLabel,omitempty"`
	NoNewPrivileges bool      `protobuf:"varint,14,opt,name=noNewPrivileges" json:"noNewPrivileges,omitempty"`
	Rlimits         []*Rlimit `protobuf:"bytes,15,rep,name=rlimits" json:"rlimits,omitempty"`
}

func (m *Process) Reset()                    { *m = Process{} }
func (m *Process) String() string            { return proto.CompactTextString(m) }
func (*Process) ProtoMessage()               {}
func (*Process) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{21} }

func (m *Process) GetPid() string {
	if m != nil {
		return m.Pid
	}
	return ""
}

func (m *Process) GetTerminal() bool {
	if m != nil {
		return m.Terminal
	}
	return false
}

func (m *Process) GetUser() *User {
	if m != nil {
		return m.User
	}
	return nil
}

func (m *Process) GetArgs() []string {
	if m != nil {
		return m.Args
	}
	return nil
}

func (m *Process) GetEnv() []string {
	if m != nil {
		return m.Env
	}
	return nil
}

func (m *Process) GetCwd() string {
	if m != nil {
		return m.Cwd
	}
	return ""
}

func (m *Process) GetSystemPid() uint32 {
	if m != nil {
		return m.SystemPid
	}
	return 0
}

func (m *Process) GetStdin() string {
	if m != nil {
		return m.Stdin
	}
	return ""
}

func (m *Process) GetStdout() string {
	if m != nil {
		return m.Stdout
	}
	return ""
}

func (m *Process) GetStderr() string {
	if m != nil {
		return m.Stderr
	}
	return ""
}

func (m *Process) GetCapabilities() []string {
	if m != nil {
		return m.Capabilities
	}
	return nil
}

func (m *Process) GetApparmorProfile() string {
	if m != nil {
		return m.ApparmorProfile
	}
	return ""
}

func (m *Process) GetSelinuxLabel() string {
	if m != nil {
		return m.SelinuxLabel
	}
	return ""
}

func (m *Process) GetNoNewPrivileges() bool {
	if m != nil {
		return m.NoNewPrivileges
	}
	return false
}

func (m *Process) GetRlimits() []*Rlimit {
	if m != nil {
		return m.Rlimits
	}
	return nil
}

type Container struct {
	Id         string     `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	BundlePath string     `protobuf:"bytes,2,opt,name=bundlePath" json:"bundlePath,omitempty"`
	Processes  []*Process `protobuf:"bytes,3,rep,name=processes" json:"processes,omitempty"`
	Status     string     `protobuf:"bytes,4,opt,name=status" json:"status,omitempty"`
	Labels     []string   `protobuf:"bytes,5,rep,name=labels" json:"labels,omitempty"`
	Pids       []uint32   `protobuf:"varint,6,rep,packed,name=pids" json:"pids,omitempty"`
	Runtime    string     `protobuf:"bytes,7,opt,name=runtime" json:"runtime,omitempty"`
}

func (m *Container) Reset()                    { *m = Container{} }
func (m *Container) String() string            { return proto.CompactTextString(m) }
func (*Container) ProtoMessage()               {}
func (*Container) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{22} }

func (m *Container) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *Container) GetBundlePath() string {
	if m != nil {
		return m.BundlePath
	}
	return ""
}

func (m *Container) GetProcesses() []*Process {
	if m != nil {
		return m.Processes
	}
	return nil
}

func (m *Container) GetStatus() string {
	if m != nil {
		return m.Status
	}
	return ""
}

func (m *Container) GetLabels() []string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *Container) GetPids() []uint32 {
	if m != nil {
		return m.Pids
	}
	return nil
}

func (m *Container) GetRuntime() string {
	if m != nil {
		return m.Runtime
	}
	return ""
}

// Machine is information about machine on which containerd is run
type Machine struct {
	Cpus   uint32 `protobuf:"varint,1,opt,name=cpus" json:"cpus,omitempty"`
	Memory uint64 `protobuf:"varint,2,opt,name=memory" json:"memory,omitempty"`
}

func (m *Machine) Reset()                    { *m = Machine{} }
func (m *Machine) String() string            { return proto.CompactTextString(m) }
func (*Machine) ProtoMessage()               {}
func (*Machine) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{23} }

func (m *Machine) GetCpus() uint32 {
	if m != nil {
		return m.Cpus
	}
	return 0
}

func (m *Machine) GetMemory() uint64 {
	if m != nil {
		return m.Memory
	}
	return 0
}

// StateResponse is information about containerd daemon
type StateResponse struct {
	Containers []*Container `protobuf:"bytes,1,rep,name=containers" json:"containers,omitempty"`
	Machine    *Machine     `protobuf:"bytes,2,opt,name=machine" json:"machine,omitempty"`
}

func (m *StateResponse) Reset()                    { *m = StateResponse{} }
func (m *StateResponse) String() string            { return proto.CompactTextString(m) }
func (*StateResponse) ProtoMessage()               {}
func (*StateResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{24} }

func (m *StateResponse) GetContainers() []*Container {
	if m != nil {
		return m.Containers
	}
	return nil
}

func (m *StateResponse) GetMachine() *Machine {
	if m != nil {
		return m.Machine
	}
	return nil
}

type UpdateContainerRequest struct {
	Id        string          `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	Pid       string          `protobuf:"bytes,2,opt,name=pid" json:"pid,omitempty"`
	Status    string          `protobuf:"bytes,3,opt,name=status" json:"status,omitempty"`
	Resources *UpdateResource `protobuf:"bytes,4,opt,name=resources" json:"resources,omitempty"`
}

func (m *UpdateContainerRequest) Reset()                    { *m = UpdateContainerRequest{} }
func (m *UpdateContainerRequest) String() string            { return proto.CompactTextString(m) }
func (*UpdateContainerRequest) ProtoMessage()               {}
func (*UpdateContainerRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{25} }

func (m *UpdateContainerRequest) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *UpdateContainerRequest) GetPid() string {
	if m != nil {
		return m.Pid
	}
	return ""
}

func (m *UpdateContainerRequest) GetStatus() string {
	if m != nil {
		return m.Status
	}
	return ""
}

func (m *UpdateContainerRequest) GetResources() *UpdateResource {
	if m != nil {
		return m.Resources
	}
	return nil
}

type UpdateResource struct {
	BlkioWeight                  uint64            `protobuf:"varint,1,opt,name=blkioWeight" json:"blkioWeight,omitempty"`
	CpuShares                    uint64            `protobuf:"varint,2,opt,name=cpuShares" json:"cpuShares,omitempty"`
	CpuPeriod                    uint64            `protobuf:"varint,3,opt,name=cpuPeriod" json:"cpuPeriod,omitempty"`
	CpuQuota                     uint64            `protobuf:"varint,4,opt,name=cpuQuota" json:"cpuQuota,omitempty"`
	CpusetCpus                   string            `protobuf:"bytes,5,opt,name=cpusetCpus" json:"cpusetCpus,omitempty"`
	CpusetMems                   string            `protobuf:"bytes,6,opt,name=cpusetMems" json:"cpusetMems,omitempty"`
	MemoryLimit                  uint64            `protobuf:"varint,7,opt,name=memoryLimit" json:"memoryLimit,omitempty"`
	MemorySwap                   uint64            `protobuf:"varint,8,opt,name=memorySwap" json:"memorySwap,omitempty"`
	MemoryReservation            uint64            `protobuf:"varint,9,opt,name=memoryReservation" json:"memoryReservation,omitempty"`
	KernelMemoryLimit            uint64            `protobuf:"varint,10,opt,name=kernelMemoryLimit" json:"kernelMemoryLimit,omitempty"`
	KernelTCPMemoryLimit         uint64            `protobuf:"varint,11,opt,name=kernelTCPMemoryLimit" json:"kernelTCPMemoryLimit,omitempty"`
	BlkioLeafWeight              uint64            `protobuf:"varint,12,opt,name=blkioLeafWeight" json:"blkioLeafWeight,omitempty"`
	BlkioWeightDevice            []*WeightDevice   `protobuf:"bytes,13,rep,name=blkioWeightDevice" json:"blkioWeightDevice,omitempty"`
	BlkioThrottleReadBpsDevice   []*ThrottleDevice `protobuf:"bytes,14,rep,name=blkioThrottleReadBpsDevice" json:"blkioThrottleReadBpsDevice,omitempty"`
	BlkioThrottleWriteBpsDevice  []*ThrottleDevice `protobuf:"bytes,15,rep,name=blkioThrottleWriteBpsDevice" json:"blkioThrottleWriteBpsDevice,omitempty"`
	BlkioThrottleReadIopsDevice  []*ThrottleDevice `protobuf:"bytes,16,rep,name=blkioThrottleReadIopsDevice" json:"blkioThrottleReadIopsDevice,omitempty"`
	BlkioThrottleWriteIopsDevice []*ThrottleDevice `protobuf:"bytes,17,rep,name=blkioThrottleWriteIopsDevice" json:"blkioThrottleWriteIopsDevice,omitempty"`
}

func (m *UpdateResource) Reset()                    { *m = UpdateResource{} }
func (m *UpdateResource) String() string            { return proto.CompactTextString(m) }
func (*UpdateResource) ProtoMessage()               {}
func (*UpdateResource) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{26} }

func (m *UpdateResource) GetBlkioWeight() uint64 {
	if m != nil {
		return m.BlkioWeight
	}
	return 0
}

func (m *UpdateResource) GetCpuShares() uint64 {
	if m != nil {
		return m.CpuShares
	}
	return 0
}

func (m *UpdateResource) GetCpuPeriod() uint64 {
	if m != nil {
		return m.CpuPeriod
	}
	return 0
}

func (m *UpdateResource) GetCpuQuota() uint64 {
	if m != nil {
		return m.CpuQuota
	}
	return 0
}

func (m *UpdateResource) GetCpusetCpus() string {
	if m != nil {
		return m.CpusetCpus
	}
	return ""
}

func (m *UpdateResource) GetCpusetMems() string {
	if m != nil {
		return m.CpusetMems
	}
	return ""
}

func (m *UpdateResource) GetMemoryLimit() uint64 {
	if m != nil {
		return m.MemoryLimit
	}
	return 0
}

func (m *UpdateResource) GetMemorySwap() uint64 {
	if m != nil {
		return m.MemorySwap
	}
	return 0
}

func (m *UpdateResource) GetMemoryReservation() uint64 {
	if m != nil {
		return m.MemoryReservation
	}
	return 0
}

func (m *UpdateResource) GetKernelMemoryLimit() uint64 {
	if m != nil {
		return m.KernelMemoryLimit
	}
	return 0
}

func (m *UpdateResource) GetKernelTCPMemoryLimit() uint64 {
	if m != nil {
		return m.KernelTCPMemoryLimit
	}
	return 0
}

func (m *UpdateResource) GetBlkioLeafWeight() uint64 {
	if m != nil {
		return m.BlkioLeafWeight
	}
	return 0
}

func (m *UpdateResource) GetBlkioWeightDevice() []*WeightDevice {
	if m != nil {
		return m.BlkioWeightDevice
	}
	return nil
}

func (m *UpdateResource) GetBlkioThrottleReadBpsDevice() []*ThrottleDevice {
	if m != nil {
		return m.BlkioThrottleReadBpsDevice
	}
	return nil
}

func (m *UpdateResource) GetBlkioThrottleWriteBpsDevice() []*ThrottleDevice {
	if m != nil {
		return m.BlkioThrottleWriteBpsDevice
	}
	return nil
}

func (m *UpdateResource) GetBlkioThrottleReadIopsDevice() []*ThrottleDevice {
	if m != nil {
		return m.BlkioThrottleReadIopsDevice
	}
	return nil
}

func (m *UpdateResource) GetBlkioThrottleWriteIopsDevice() []*ThrottleDevice {
	if m != nil {
		return m.BlkioThrottleWriteIopsDevice
	}
	return nil
}

type BlockIODevice struct {
	Major int64 `protobuf:"varint,1,opt,name=major" json:"major,omitempty"`
	Minor int64 `protobuf:"varint,2,opt,name=minor" json:"minor,omitempty"`
}

func (m *BlockIODevice) Reset()                    { *m = BlockIODevice{} }
func (m *BlockIODevice) String() string            { return proto.CompactTextString(m) }
func (*BlockIODevice) ProtoMessage()               {}
func (*BlockIODevice) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{27} }

func (m *BlockIODevice) GetMajor() int64 {
	if m != nil {
		return m.Major
	}
	return 0
}

func (m *BlockIODevice) GetMinor() int64 {
	if m != nil {
		return m.Minor
	}
	return 0
}

type WeightDevice struct {
	BlkIODevice *BlockIODevice `protobuf:"bytes,1,opt,name=blkIODevice" json:"blkIODevice,omitempty"`
	Weight      uint32         `protobuf:"varint,2,opt,name=weight" json:"weight,omitempty"`
	LeafWeight  uint32         `protobuf:"varint,3,opt,name=leafWeight" json:"leafWeight,omitempty"`
}

func (m *WeightDevice) Reset()                    { *m = WeightDevice{} }
func (m *WeightDevice) String() string            { return proto.CompactTextString(m) }
func (*WeightDevice) ProtoMessage()               {}
func (*WeightDevice) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{28} }

func (m *WeightDevice) GetBlkIODevice() *BlockIODevice {
	if m != nil {
		return m.BlkIODevice
	}
	return nil
}

func (m *WeightDevice) GetWeight() uint32 {
	if m != nil {
		return m.Weight
	}
	return 0
}

func (m *WeightDevice) GetLeafWeight() uint32 {
	if m != nil {
		return m.LeafWeight
	}
	return 0
}

type ThrottleDevice struct {
	BlkIODevice *BlockIODevice `protobuf:"bytes,1,opt,name=blkIODevice" json:"blkIODevice,omitempty"`
	Rate        uint64         `protobuf:"varint,2,opt,name=rate" json:"rate,omitempty"`
}

func (m *ThrottleDevice) Reset()                    { *m = ThrottleDevice{} }
func (m *ThrottleDevice) String() string            { return proto.CompactTextString(m) }
func (*ThrottleDevice) ProtoMessage()               {}
func (*ThrottleDevice) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{29} }

func (m *ThrottleDevice) GetBlkIODevice() *BlockIODevice {
	if m != nil {
		return m.BlkIODevice
	}
	return nil
}

func (m *ThrottleDevice) GetRate() uint64 {
	if m != nil {
		return m.Rate
	}
	return 0
}

type UpdateContainerResponse struct {
}

func (m *UpdateContainerResponse) Reset()                    { *m = UpdateContainerResponse{} }
func (m *UpdateContainerResponse) String() string            { return proto.CompactTextString(m) }
func (*UpdateContainerResponse) ProtoMessage()               {}
func (*UpdateContainerResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{30} }

type EventsRequest struct {
	// Tag 1 is deprecated (old uint64 timestamp)
	Timestamp  *google_protobuf.Timestamp `protobuf:"bytes,2,opt,name=timestamp" json:"timestamp,omitempty"`
	StoredOnly bool                       `protobuf:"varint,3,opt,name=storedOnly" json:"storedOnly,omitempty"`
	Id         string                     `protobuf:"bytes,4,opt,name=id" json:"id,omitempty"`
}

func (m *EventsRequest) Reset()                    { *m = EventsRequest{} }
func (m *EventsRequest) String() string            { return proto.CompactTextString(m) }
func (*EventsRequest) ProtoMessage()               {}
func (*EventsRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{31} }

func (m *EventsRequest) GetTimestamp() *google_protobuf.Timestamp {
	if m != nil {
		return m.Timestamp
	}
	return nil
}

func (m *EventsRequest) GetStoredOnly() bool {
	if m != nil {
		return m.StoredOnly
	}
	return false
}

func (m *EventsRequest) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

type Event struct {
	Type   string `protobuf:"bytes,1,opt,name=type" json:"type,omitempty"`
	Id     string `protobuf:"bytes,2,opt,name=id" json:"id,omitempty"`
	Status uint32 `protobuf:"varint,3,opt,name=status" json:"status,omitempty"`
	Pid    string `protobuf:"bytes,4,opt,name=pid" json:"pid,omitempty"`
	// Tag 5 is deprecated (old uint64 timestamp)
	Timestamp *google_protobuf.Timestamp `protobuf:"bytes,6,opt,name=timestamp" json:"timestamp,omitempty"`
}

func (m *Event) Reset()                    { *m = Event{} }
func (m *Event) String() string            { return proto.CompactTextString(m) }
func (*Event) ProtoMessage()               {}
func (*Event) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{32} }

func (m *Event) GetType() string {
	if m != nil {
		return m.Type
	}
	return ""
}

func (m *Event) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *Event) GetStatus() uint32 {
	if m != nil {
		return m.Status
	}
	return 0
}

func (m *Event) GetPid() string {
	if m != nil {
		return m.Pid
	}
	return ""
}

func (m *Event) GetTimestamp() *google_protobuf.Timestamp {
	if m != nil {
		return m.Timestamp
	}
	return nil
}

type NetworkStats struct {
	Name       string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	RxBytes    uint64 `protobuf:"varint,2,opt,name=rx_bytes,json=rxBytes" json:"rx_bytes,omitempty"`
	Rx_Packets uint64 `protobuf:"varint,3,opt,name=rx_Packets,json=rxPackets" json:"rx_Packets,omitempty"`
	RxErrors   uint64 `protobuf:"varint,4,opt,name=Rx_errors,json=rxErrors" json:"Rx_errors,omitempty"`
	RxDropped  uint64 `protobuf:"varint,5,opt,name=Rx_dropped,json=rxDropped" json:"Rx_dropped,omitempty"`
	TxBytes    uint64 `protobuf:"varint,6,opt,name=Tx_bytes,json=txBytes" json:"Tx_bytes,omitempty"`
	TxPackets  uint64 `protobuf:"varint,7,opt,name=Tx_packets,json=txPackets" json:"Tx_packets,omitempty"`
	TxErrors   uint64 `protobuf:"varint,8,opt,name=Tx_errors,json=txErrors" json:"Tx_errors,omitempty"`
	TxDropped  uint64 `protobuf:"varint,9,opt,name=Tx_dropped,json=txDropped" json:"Tx_dropped,omitempty"`
}

func (m *NetworkStats) Reset()                    { *m = NetworkStats{} }
func (m *NetworkStats) String() string            { return proto.CompactTextString(m) }
func (*NetworkStats) ProtoMessage()               {}
func (*NetworkStats) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{33} }

func (m *NetworkStats) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *NetworkStats) GetRxBytes() uint64 {
	if m != nil {
		return m.RxBytes
	}
	return 0
}

func (m *NetworkStats) GetRx_Packets() uint64 {
	if m != nil {
		return m.Rx_Packets
	}
	return 0
}

func (m *NetworkStats) GetRxErrors() uint64 {
	if m != nil {
		return m.RxErrors
	}
	return 0
}

func (m *NetworkStats) GetRxDropped() uint64 {
	if m != nil {
		return m.RxDropped
	}
	return 0
}

func (m *NetworkStats) GetTxBytes() uint64 {
	if m != nil {
		return m.TxBytes
	}
	return 0
}

func (m *NetworkStats) GetTxPackets() uint64 {
	if m != nil {
		return m.TxPackets
	}
	return 0
}

func (m *NetworkStats) GetTxErrors() uint64 {
	if m != nil {
		return m.TxErrors
	}
	return 0
}

func (m *NetworkStats) GetTxDropped() uint64 {
	if m != nil {
		return m.TxDropped
	}
	return 0
}

type CpuUsage struct {
	TotalUsage        uint64   `protobuf:"varint,1,opt,name=total_usage,json=totalUsage" json:"total_usage,omitempty"`
	PercpuUsage       []uint64 `protobuf:"varint,2,rep,packed,name=percpu_usage,json=percpuUsage" json:"percpu_usage,omitempty"`
	UsageInKernelmode uint64   `protobuf:"varint,3,opt,name=usage_in_kernelmode,json=usageInKernelmode" json:"usage_in_kernelmode,omitempty"`
	UsageInUsermode   uint64   `protobuf:"varint,4,opt,name=usage_in_usermode,json=usageInUsermode" json:"usage_in_usermode,omitempty"`
}

func (m *CpuUsage) Reset()                    { *m = CpuUsage{} }
func (m *CpuUsage) String() string            { return proto.CompactTextString(m) }
func (*CpuUsage) ProtoMessage()               {}
func (*CpuUsage) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{34} }

func (m *CpuUsage) GetTotalUsage() uint64 {
	if m != nil {
		return m.TotalUsage
	}
	return 0
}

func (m *CpuUsage) GetPercpuUsage() []uint64 {
	if m != nil {
		return m.PercpuUsage
	}
	return nil
}

func (m *CpuUsage) GetUsageInKernelmode() uint64 {
	if m != nil {
		return m.UsageInKernelmode
	}
	return 0
}

func (m *CpuUsage) GetUsageInUsermode() uint64 {
	if m != nil {
		return m.UsageInUsermode
	}
	return 0
}

type ThrottlingData struct {
	Periods          uint64 `protobuf:"varint,1,opt,name=periods" json:"periods,omitempty"`
	ThrottledPeriods uint64 `protobuf:"varint,2,opt,name=throttled_periods,json=throttledPeriods" json:"throttled_periods,omitempty"`
	ThrottledTime    uint64 `protobuf:"varint,3,opt,name=throttled_time,json=throttledTime" json:"throttled_time,omitempty"`
}

func (m *ThrottlingData) Reset()                    { *m = ThrottlingData{} }
func (m *ThrottlingData) String() string            { return proto.CompactTextString(m) }
func (*ThrottlingData) ProtoMessage()               {}
func (*ThrottlingData) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{35} }

func (m *ThrottlingData) GetPeriods() uint64 {
	if m != nil {
		return m.Periods
	}
	return 0
}

func (m *ThrottlingData) GetThrottledPeriods() uint64 {
	if m != nil {
		return m.ThrottledPeriods
	}
	return 0
}

func (m *ThrottlingData) GetThrottledTime() uint64 {
	if m != nil {
		return m.ThrottledTime
	}
	return 0
}

type CpuStats struct {
	CpuUsage       *CpuUsage       `protobuf:"bytes,1,opt,name=cpu_usage,json=cpuUsage" json:"cpu_usage,omitempty"`
	ThrottlingData *ThrottlingData `protobuf:"bytes,2,opt,name=throttling_data,json=throttlingData" json:"throttling_data,omitempty"`
	SystemUsage    uint64          `protobuf:"varint,3,opt,name=system_usage,json=systemUsage" json:"system_usage,omitempty"`
}

func (m *CpuStats) Reset()                    { *m = CpuStats{} }
func (m *CpuStats) String() string            { return proto.CompactTextString(m) }
func (*CpuStats) ProtoMessage()               {}
func (*CpuStats) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{36} }

func (m *CpuStats) GetCpuUsage() *CpuUsage {
	if m != nil {
		return m.CpuUsage
	}
	return nil
}

func (m *CpuStats) GetThrottlingData() *ThrottlingData {
	if m != nil {
		return m.ThrottlingData
	}
	return nil
}

func (m *CpuStats) GetSystemUsage() uint64 {
	if m != nil {
		return m.SystemUsage
	}
	return 0
}

type PidsStats struct {
	Current uint64 `protobuf:"varint,1,opt,name=current" json:"current,omitempty"`
	Limit   uint64 `protobuf:"varint,2,opt,name=limit" json:"limit,omitempty"`
}

func (m *PidsStats) Reset()                    { *m = PidsStats{} }
func (m *PidsStats) String() string            { return proto.CompactTextString(m) }
func (*PidsStats) ProtoMessage()               {}
func (*PidsStats) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{37} }

func (m *PidsStats) GetCurrent() uint64 {
	if m != nil {
		return m.Current
	}
	return 0
}

func (m *PidsStats) GetLimit() uint64 {
	if m != nil {
		return m.Limit
	}
	return 0
}

type MemoryData struct {
	Usage    uint64 `protobuf:"varint,1,opt,name=usage" json:"usage,omitempty"`
	MaxUsage uint64 `protobuf:"varint,2,opt,name=max_usage,json=maxUsage" json:"max_usage,omitempty"`
	Failcnt  uint64 `protobuf:"varint,3,opt,name=failcnt" json:"failcnt,omitempty"`
	Limit    uint64 `protobuf:"varint,4,opt,name=limit" json:"limit,omitempty"`
}

func (m *MemoryData) Reset()                    { *m = MemoryData{} }
func (m *MemoryData) String() string            { return proto.CompactTextString(m) }
func (*MemoryData) ProtoMessage()               {}
func (*MemoryData) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{38} }

func (m *MemoryData) GetUsage() uint64 {
	if m != nil {
		return m.Usage
	}
	return 0
}

func (m *MemoryData) GetMaxUsage() uint64 {
	if m != nil {
		return m.MaxUsage
	}
	return 0
}

func (m *MemoryData) GetFailcnt() uint64 {
	if m != nil {
		return m.Failcnt
	}
	return 0
}

func (m *MemoryData) GetLimit() uint64 {
	if m != nil {
		return m.Limit
	}
	return 0
}

type MemoryStats struct {
	Cache       uint64            `protobuf:"varint,1,opt,name=cache" json:"cache,omitempty"`
	Usage       *MemoryData       `protobuf:"bytes,2,opt,name=usage" json:"usage,omitempty"`
	SwapUsage   *MemoryData       `protobuf:"bytes,3,opt,name=swap_usage,json=swapUsage" json:"swap_usage,omitempty"`
	KernelUsage *MemoryData       `protobuf:"bytes,4,opt,name=kernel_usage,json=kernelUsage" json:"kernel_usage,omitempty"`
	Stats       map[string]uint64 `protobuf:"bytes,5,rep,name=stats" json:"stats,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"varint,2,opt,name=value"`
}

func (m *MemoryStats) Reset()                    { *m = MemoryStats{} }
func (m *MemoryStats) String() string            { return proto.CompactTextString(m) }
func (*MemoryStats) ProtoMessage()               {}
func (*MemoryStats) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{39} }

func (m *MemoryStats) GetCache() uint64 {
	if m != nil {
		return m.Cache
	}
	return 0
}

func (m *MemoryStats) GetUsage() *MemoryData {
	if m != nil {
		return m.Usage
	}
	return nil
}

func (m *MemoryStats) GetSwapUsage() *MemoryData {
	if m != nil {
		return m.SwapUsage
	}
	return nil
}

func (m *MemoryStats) GetKernelUsage() *MemoryData {
	if m != nil {
		return m.KernelUsage
	}
	return nil
}

func (m *MemoryStats) GetStats() map[string]uint64 {
	if m != nil {
		return m.Stats
	}
	return nil
}

type BlkioStatsEntry struct {
	Major uint64 `protobuf:"varint,1,opt,name=major" json:"major,omitempty"`
	Minor uint64 `protobuf:"varint,2,opt,name=minor" json:"minor,omitempty"`
	Op    string `protobuf:"bytes,3,opt,name=op" json:"op,omitempty"`
	Value uint64 `protobuf:"varint,4,opt,name=value" json:"value,omitempty"`
}

func (m *BlkioStatsEntry) Reset()                    { *m = BlkioStatsEntry{} }
func (m *BlkioStatsEntry) String() string            { return proto.CompactTextString(m) }
func (*BlkioStatsEntry) ProtoMessage()               {}
func (*BlkioStatsEntry) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{40} }

func (m *BlkioStatsEntry) GetMajor() uint64 {
	if m != nil {
		return m.Major
	}
	return 0
}

func (m *BlkioStatsEntry) GetMinor() uint64 {
	if m != nil {
		return m.Minor
	}
	return 0
}

func (m *BlkioStatsEntry) GetOp() string {
	if m != nil {
		return m.Op
	}
	return ""
}

func (m *BlkioStatsEntry) GetValue() uint64 {
	if m != nil {
		return m.Value
	}
	return 0
}

type BlkioStats struct {
	IoServiceBytesRecursive []*BlkioStatsEntry `protobuf:"bytes,1,rep,name=io_service_bytes_recursive,json=ioServiceBytesRecursive" json:"io_service_bytes_recursive,omitempty"`
	IoServicedRecursive     []*BlkioStatsEntry `protobuf:"bytes,2,rep,name=io_serviced_recursive,json=ioServicedRecursive" json:"io_serviced_recursive,omitempty"`
	IoQueuedRecursive       []*BlkioStatsEntry `protobuf:"bytes,3,rep,name=io_queued_recursive,json=ioQueuedRecursive" json:"io_queued_recursive,omitempty"`
	IoServiceTimeRecursive  []*BlkioStatsEntry `protobuf:"bytes,4,rep,name=io_service_time_recursive,json=ioServiceTimeRecursive" json:"io_service_time_recursive,omitempty"`
	IoWaitTimeRecursive     []*BlkioStatsEntry `protobuf:"bytes,5,rep,name=io_wait_time_recursive,json=ioWaitTimeRecursive" json:"io_wait_time_recursive,omitempty"`
	IoMergedRecursive       []*BlkioStatsEntry `protobuf:"bytes,6,rep,name=io_merged_recursive,json=ioMergedRecursive" json:"io_merged_recursive,omitempty"`
	IoTimeRecursive         []*BlkioStatsEntry `protobuf:"bytes,7,rep,name=io_time_recursive,json=ioTimeRecursive" json:"io_time_recursive,omitempty"`
	SectorsRecursive        []*BlkioStatsEntry `protobuf:"bytes,8,rep,name=sectors_recursive,json=sectorsRecursive" json:"sectors_recursive,omitempty"`
}

func (m *BlkioStats) Reset()                    { *m = BlkioStats{} }
func (m *BlkioStats) String() string            { return proto.CompactTextString(m) }
func (*BlkioStats) ProtoMessage()               {}
func (*BlkioStats) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{41} }

func (m *BlkioStats) GetIoServiceBytesRecursive() []*BlkioStatsEntry {
	if m != nil {
		return m.IoServiceBytesRecursive
	}
	return nil
}

func (m *BlkioStats) GetIoServicedRecursive() []*BlkioStatsEntry {
	if m != nil {
		return m.IoServicedRecursive
	}
	return nil
}

func (m *BlkioStats) GetIoQueuedRecursive() []*BlkioStatsEntry {
	if m != nil {
		return m.IoQueuedRecursive
	}
	return nil
}

func (m *BlkioStats) GetIoServiceTimeRecursive() []*BlkioStatsEntry {
	if m != nil {
		return m.IoServiceTimeRecursive
	}
	return nil
}

func (m *BlkioStats) GetIoWaitTimeRecursive() []*BlkioStatsEntry {
	if m != nil {
		return m.IoWaitTimeRecursive
	}
	return nil
}

func (m *BlkioStats) GetIoMergedRecursive() []*BlkioStatsEntry {
	if m != nil {
		return m.IoMergedRecursive
	}
	return nil
}

func (m *BlkioStats) GetIoTimeRecursive() []*BlkioStatsEntry {
	if m != nil {
		return m.IoTimeRecursive
	}
	return nil
}

func (m *BlkioStats) GetSectorsRecursive() []*BlkioStatsEntry {
	if m != nil {
		return m.SectorsRecursive
	}
	return nil
}

type HugetlbStats struct {
	Usage    uint64 `protobuf:"varint,1,opt,name=usage" json:"usage,omitempty"`
	MaxUsage uint64 `protobuf:"varint,2,opt,name=max_usage,json=maxUsage" json:"max_usage,omitempty"`
	Failcnt  uint64 `protobuf:"varint,3,opt,name=failcnt" json:"failcnt,omitempty"`
	Limit    uint64 `protobuf:"varint,4,opt,name=limit" json:"limit,omitempty"`
}

func (m *HugetlbStats) Reset()                    { *m = HugetlbStats{} }
func (m *HugetlbStats) String() string            { return proto.CompactTextString(m) }
func (*HugetlbStats) ProtoMessage()               {}
func (*HugetlbStats) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{42} }

func (m *HugetlbStats) GetUsage() uint64 {
	if m != nil {
		return m.Usage
	}
	return 0
}

func (m *HugetlbStats) GetMaxUsage() uint64 {
	if m != nil {
		return m.MaxUsage
	}
	return 0
}

func (m *HugetlbStats) GetFailcnt() uint64 {
	if m != nil {
		return m.Failcnt
	}
	return 0
}

func (m *HugetlbStats) GetLimit() uint64 {
	if m != nil {
		return m.Limit
	}
	return 0
}

type CgroupStats struct {
	CpuStats     *CpuStats                `protobuf:"bytes,1,opt,name=cpu_stats,json=cpuStats" json:"cpu_stats,omitempty"`
	MemoryStats  *MemoryStats             `protobuf:"bytes,2,opt,name=memory_stats,json=memoryStats" json:"memory_stats,omitempty"`
	BlkioStats   *BlkioStats              `protobuf:"bytes,3,opt,name=blkio_stats,json=blkioStats" json:"blkio_stats,omitempty"`
	HugetlbStats map[string]*HugetlbStats `protobuf:"bytes,4,rep,name=hugetlb_stats,json=hugetlbStats" json:"hugetlb_stats,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	PidsStats    *PidsStats               `protobuf:"bytes,5,opt,name=pids_stats,json=pidsStats" json:"pids_stats,omitempty"`
}

func (m *CgroupStats) Reset()                    { *m = CgroupStats{} }
func (m *CgroupStats) String() string            { return proto.CompactTextString(m) }
func (*CgroupStats) ProtoMessage()               {}
func (*CgroupStats) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{43} }

func (m *CgroupStats) GetCpuStats() *CpuStats {
	if m != nil {
		return m.CpuStats
	}
	return nil
}

func (m *CgroupStats) GetMemoryStats() *MemoryStats {
	if m != nil {
		return m.MemoryStats
	}
	return nil
}

func (m *CgroupStats) GetBlkioStats() *BlkioStats {
	if m != nil {
		return m.BlkioStats
	}
	return nil
}

func (m *CgroupStats) GetHugetlbStats() map[string]*HugetlbStats {
	if m != nil {
		return m.HugetlbStats
	}
	return nil
}

func (m *CgroupStats) GetPidsStats() *PidsStats {
	if m != nil {
		return m.PidsStats
	}
	return nil
}

type StatsResponse struct {
	NetworkStats []*NetworkStats `protobuf:"bytes,1,rep,name=network_stats,json=networkStats" json:"network_stats,omitempty"`
	CgroupStats  *CgroupStats    `protobuf:"bytes,2,opt,name=cgroup_stats,json=cgroupStats" json:"cgroup_stats,omitempty"`
	// Tag 3 is deprecated (old uint64 timestamp)
	Timestamp *google_protobuf.Timestamp `protobuf:"bytes,4,opt,name=timestamp" json:"timestamp,omitempty"`
}

func (m *StatsResponse) Reset()                    { *m = StatsResponse{} }
func (m *StatsResponse) String() string            { return proto.CompactTextString(m) }
func (*StatsResponse) ProtoMessage()               {}
func (*StatsResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{44} }

func (m *StatsResponse) GetNetworkStats() []*NetworkStats {
	if m != nil {
		return m.NetworkStats
	}
	return nil
}

func (m *StatsResponse) GetCgroupStats() *CgroupStats {
	if m != nil {
		return m.CgroupStats
	}
	return nil
}

func (m *StatsResponse) GetTimestamp() *google_protobuf.Timestamp {
	if m != nil {
		return m.Timestamp
	}
	return nil
}

type StatsRequest struct {
	Id string `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
}

func (m *StatsRequest) Reset()                    { *m = StatsRequest{} }
func (m *StatsRequest) String() string            { return proto.CompactTextString(m) }
func (*StatsRequest) ProtoMessage()               {}
func (*StatsRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{45} }

func (m *StatsRequest) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func init() {
	proto.RegisterType((*GetServerVersionRequest)(nil), "types.GetServerVersionRequest")
	proto.RegisterType((*GetServerVersionResponse)(nil), "types.GetServerVersionResponse")
	proto.RegisterType((*UpdateProcessRequest)(nil), "types.UpdateProcessRequest")
	proto.RegisterType((*UpdateProcessResponse)(nil), "types.UpdateProcessResponse")
	proto.RegisterType((*CreateContainerRequest)(nil), "types.CreateContainerRequest")
	proto.RegisterType((*CreateContainerResponse)(nil), "types.CreateContainerResponse")
	proto.RegisterType((*SignalRequest)(nil), "types.SignalRequest")
	proto.RegisterType((*SignalResponse)(nil), "types.SignalResponse")
	proto.RegisterType((*AddProcessRequest)(nil), "types.AddProcessRequest")
	proto.RegisterType((*Rlimit)(nil), "types.Rlimit")
	proto.RegisterType((*User)(nil), "types.User")
	proto.RegisterType((*AddProcessResponse)(nil), "types.AddProcessResponse")
	proto.RegisterType((*CreateCheckpointRequest)(nil), "types.CreateCheckpointRequest")
	proto.RegisterType((*CreateCheckpointResponse)(nil), "types.CreateCheckpointResponse")
	proto.RegisterType((*DeleteCheckpointRequest)(nil), "types.DeleteCheckpointRequest")
	proto.RegisterType((*DeleteCheckpointResponse)(nil), "types.DeleteCheckpointResponse")
	proto.RegisterType((*ListCheckpointRequest)(nil), "types.ListCheckpointRequest")
	proto.RegisterType((*Checkpoint)(nil), "types.Checkpoint")
	proto.RegisterType((*ListCheckpointResponse)(nil), "types.ListCheckpointResponse")
	proto.RegisterType((*StateRequest)(nil), "types.StateRequest")
	proto.RegisterType((*ContainerState)(nil), "types.ContainerState")
	proto.RegisterType((*Process)(nil), "types.Process")
	proto.RegisterType((*Container)(nil), "types.Container")
	proto.RegisterType((*Machine)(nil), "types.Machine")
	proto.RegisterType((*StateResponse)(nil), "types.StateResponse")
	proto.RegisterType((*UpdateContainerRequest)(nil), "types.UpdateContainerRequest")
	proto.RegisterType((*UpdateResource)(nil), "types.UpdateResource")
	proto.RegisterType((*BlockIODevice)(nil), "types.BlockIODevice")
	proto.RegisterType((*WeightDevice)(nil), "types.WeightDevice")
	proto.RegisterType((*ThrottleDevice)(nil), "types.ThrottleDevice")
	proto.RegisterType((*UpdateContainerResponse)(nil), "types.UpdateContainerResponse")
	proto.RegisterType((*EventsRequest)(nil), "types.EventsRequest")
	proto.RegisterType((*Event)(nil), "types.Event")
	proto.RegisterType((*NetworkStats)(nil), "types.NetworkStats")
	proto.RegisterType((*CpuUsage)(nil), "types.CpuUsage")
	proto.RegisterType((*ThrottlingData)(nil), "types.ThrottlingData")
	proto.RegisterType((*CpuStats)(nil), "types.CpuStats")
	proto.RegisterType((*PidsStats)(nil), "types.PidsStats")
	proto.RegisterType((*MemoryData)(nil), "types.MemoryData")
	proto.RegisterType((*MemoryStats)(nil), "types.MemoryStats")
	proto.RegisterType((*BlkioStatsEntry)(nil), "types.BlkioStatsEntry")
	proto.RegisterType((*BlkioStats)(nil), "types.BlkioStats")
	proto.RegisterType((*HugetlbStats)(nil), "types.HugetlbStats")
	proto.RegisterType((*CgroupStats)(nil), "types.CgroupStats")
	proto.RegisterType((*StatsResponse)(nil), "types.StatsResponse")
	proto.RegisterType((*StatsRequest)(nil), "types.StatsRequest")
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for API service

type APIClient interface {
	GetServerVersion(ctx context.Context, in *GetServerVersionRequest, opts ...grpc.CallOption) (*GetServerVersionResponse, error)
	CreateContainer(ctx context.Context, in *CreateContainerRequest, opts ...grpc.CallOption) (*CreateContainerResponse, error)
	UpdateContainer(ctx context.Context, in *UpdateContainerRequest, opts ...grpc.CallOption) (*UpdateContainerResponse, error)
	Signal(ctx context.Context, in *SignalRequest, opts ...grpc.CallOption) (*SignalResponse, error)
	UpdateProcess(ctx context.Context, in *UpdateProcessRequest, opts ...grpc.CallOption) (*UpdateProcessResponse, error)
	AddProcess(ctx context.Context, in *AddProcessRequest, opts ...grpc.CallOption) (*AddProcessResponse, error)
	CreateCheckpoint(ctx context.Context, in *CreateCheckpointRequest, opts ...grpc.CallOption) (*CreateCheckpointResponse, error)
	DeleteCheckpoint(ctx context.Context, in *DeleteCheckpointRequest, opts ...grpc.CallOption) (*DeleteCheckpointResponse, error)
	ListCheckpoint(ctx context.Context, in *ListCheckpointRequest, opts ...grpc.CallOption) (*ListCheckpointResponse, error)
	State(ctx context.Context, in *StateRequest, opts ...grpc.CallOption) (*StateResponse, error)
	Events(ctx context.Context, in *EventsRequest, opts ...grpc.CallOption) (API_EventsClient, error)
	Stats(ctx context.Context, in *StatsRequest, opts ...grpc.CallOption) (*StatsResponse, error)
}

type aPIClient struct {
	cc *grpc.ClientConn
}

func NewAPIClient(cc *grpc.ClientConn) APIClient {
	return &aPIClient{cc}
}

func (c *aPIClient) GetServerVersion(ctx context.Context, in *GetServerVersionRequest, opts ...grpc.CallOption) (*GetServerVersionResponse, error) {
	out := new(GetServerVersionResponse)
	err := grpc.Invoke(ctx, "/types.API/GetServerVersion", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *aPIClient) CreateContainer(ctx context.Context, in *CreateContainerRequest, opts ...grpc.CallOption) (*CreateContainerResponse, error) {
	out := new(CreateContainerResponse)
	err := grpc.Invoke(ctx, "/types.API/CreateContainer", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *aPIClient) UpdateContainer(ctx context.Context, in *UpdateContainerRequest, opts ...grpc.CallOption) (*UpdateContainerResponse, error) {
	out := new(UpdateContainerResponse)
	err := grpc.Invoke(ctx, "/types.API/UpdateContainer", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *aPIClient) Signal(ctx context.Context, in *SignalRequest, opts ...grpc.CallOption) (*SignalResponse, error) {
	out := new(SignalResponse)
	err := grpc.Invoke(ctx, "/types.API/Signal", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *aPIClient) UpdateProcess(ctx context.Context, in *UpdateProcessRequest, opts ...grpc.CallOption) (*UpdateProcessResponse, error) {
	out := new(UpdateProcessResponse)
	err := grpc.Invoke(ctx, "/types.API/UpdateProcess", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *aPIClient) AddProcess(ctx context.Context, in *AddProcessRequest, opts ...grpc.CallOption) (*AddProcessResponse, error) {
	out := new(AddProcessResponse)
	err := grpc.Invoke(ctx, "/types.API/AddProcess", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *aPIClient) CreateCheckpoint(ctx context.Context, in *CreateCheckpointRequest, opts ...grpc.CallOption) (*CreateCheckpointResponse, error) {
	out := new(CreateCheckpointResponse)
	err := grpc.Invoke(ctx, "/types.API/CreateCheckpoint", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *aPIClient) DeleteCheckpoint(ctx context.Context, in *DeleteCheckpointRequest, opts ...grpc.CallOption) (*DeleteCheckpointResponse, error) {
	out := new(DeleteCheckpointResponse)
	err := grpc.Invoke(ctx, "/types.API/DeleteCheckpoint", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *aPIClient) ListCheckpoint(ctx context.Context, in *ListCheckpointRequest, opts ...grpc.CallOption) (*ListCheckpointResponse, error) {
	out := new(ListCheckpointResponse)
	err := grpc.Invoke(ctx, "/types.API/ListCheckpoint", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *aPIClient) State(ctx context.Context, in *StateRequest, opts ...grpc.CallOption) (*StateResponse, error) {
	out := new(StateResponse)
	err := grpc.Invoke(ctx, "/types.API/State", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *aPIClient) Events(ctx context.Context, in *EventsRequest, opts ...grpc.CallOption) (API_EventsClient, error) {
	stream, err := grpc.NewClientStream(ctx, &_API_serviceDesc.Streams[0], c.cc, "/types.API/Events", opts...)
	if err != nil {
		return nil, err
	}
	x := &aPIEventsClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type API_EventsClient interface {
	Recv() (*Event, error)
	grpc.ClientStream
}

type aPIEventsClient struct {
	grpc.ClientStream
}

func (x *aPIEventsClient) Recv() (*Event, error) {
	m := new(Event)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *aPIClient) Stats(ctx context.Context, in *StatsRequest, opts ...grpc.CallOption) (*StatsResponse, error) {
	out := new(StatsResponse)
	err := grpc.Invoke(ctx, "/types.API/Stats", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for API service

type APIServer interface {
	GetServerVersion(context.Context, *GetServerVersionRequest) (*GetServerVersionResponse, error)
	CreateContainer(context.Context, *CreateContainerRequest) (*CreateContainerResponse, error)
	UpdateContainer(context.Context, *UpdateContainerRequest) (*UpdateContainerResponse, error)
	Signal(context.Context, *SignalRequest) (*SignalResponse, error)
	UpdateProcess(context.Context, *UpdateProcessRequest) (*UpdateProcessResponse, error)
	AddProcess(context.Context, *AddProcessRequest) (*AddProcessResponse, error)
	CreateCheckpoint(context.Context, *CreateCheckpointRequest) (*CreateCheckpointResponse, error)
	DeleteCheckpoint(context.Context, *DeleteCheckpointRequest) (*DeleteCheckpointResponse, error)
	ListCheckpoint(context.Context, *ListCheckpointRequest) (*ListCheckpointResponse, error)
	State(context.Context, *StateRequest) (*StateResponse, error)
	Events(*EventsRequest, API_EventsServer) error
	Stats(context.Context, *StatsRequest) (*StatsResponse, error)
}

func RegisterAPIServer(s *grpc.Server, srv APIServer) {
	s.RegisterService(&_API_serviceDesc, srv)
}

func _API_GetServerVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetServerVersionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(APIServer).GetServerVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/types.API/GetServerVersion",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(APIServer).GetServerVersion(ctx, req.(*GetServerVersionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _API_CreateContainer_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateContainerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(APIServer).CreateContainer(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/types.API/CreateContainer",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(APIServer).CreateContainer(ctx, req.(*CreateContainerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _API_UpdateContainer_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateContainerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(APIServer).UpdateContainer(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/types.API/UpdateContainer",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(APIServer).UpdateContainer(ctx, req.(*UpdateContainerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _API_Signal_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SignalRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(APIServer).Signal(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/types.API/Signal",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(APIServer).Signal(ctx, req.(*SignalRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _API_UpdateProcess_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateProcessRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(APIServer).UpdateProcess(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/types.API/UpdateProcess",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(APIServer).UpdateProcess(ctx, req.(*UpdateProcessRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _API_AddProcess_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AddProcessRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(APIServer).AddProcess(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/types.API/AddProcess",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(APIServer).AddProcess(ctx, req.(*AddProcessRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _API_CreateCheckpoint_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateCheckpointRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(APIServer).CreateCheckpoint(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/types.API/CreateCheckpoint",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(APIServer).CreateCheckpoint(ctx, req.(*CreateCheckpointRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _API_DeleteCheckpoint_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteCheckpointRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(APIServer).DeleteCheckpoint(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/types.API/DeleteCheckpoint",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(APIServer).DeleteCheckpoint(ctx, req.(*DeleteCheckpointRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _API_ListCheckpoint_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListCheckpointRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(APIServer).ListCheckpoint(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/types.API/ListCheckpoint",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(APIServer).ListCheckpoint(ctx, req.(*ListCheckpointRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _API_State_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(APIServer).State(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/types.API/State",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(APIServer).State(ctx, req.(*StateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _API_Events_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(EventsRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(APIServer).Events(m, &aPIEventsServer{stream})
}

type API_EventsServer interface {
	Send(*Event) error
	grpc.ServerStream
}

type aPIEventsServer struct {
	grpc.ServerStream
}

func (x *aPIEventsServer) Send(m *Event) error {
	return x.ServerStream.SendMsg(m)
}

func _API_Stats_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StatsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(APIServer).Stats(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/types.API/Stats",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(APIServer).Stats(ctx, req.(*StatsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _API_serviceDesc = grpc.ServiceDesc{
	ServiceName: "types.API",
	HandlerType: (*APIServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetServerVersion",
			Handler:    _API_GetServerVersion_Handler,
		},
		{
			MethodName: "CreateContainer",
			Handler:    _API_CreateContainer_Handler,
		},
		{
			MethodName: "UpdateContainer",
			Handler:    _API_UpdateContainer_Handler,
		},
		{
			MethodName: "Signal",
			Handler:    _API_Signal_Handler,
		},
		{
			MethodName: "UpdateProcess",
			Handler:    _API_UpdateProcess_Handler,
		},
		{
			MethodName: "AddProcess",
			Handler:    _API_AddProcess_Handler,
		},
		{
			MethodName: "CreateCheckpoint",
			Handler:    _API_CreateCheckpoint_Handler,
		},
		{
			MethodName: "DeleteCheckpoint",
			Handler:    _API_DeleteCheckpoint_Handler,
		},
		{
			MethodName: "ListCheckpoint",
			Handler:    _API_ListCheckpoint_Handler,
		},
		{
			MethodName: "State",
			Handler:    _API_State_Handler,
		},
		{
			MethodName: "Stats",
			Handler:    _API_Stats_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "Events",
			Handler:       _API_Events_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "api.proto",
}

func init() { proto.RegisterFile("api.proto", fileDescriptor0) }

var fileDescriptor0 = []byte{
	// 2616 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x09, 0x6e, 0x88, 0x02, 0xff, 0xec, 0x19, 0x4d, 0x6f, 0x1c, 0x49,
	0x35, 0x33, 0xd3, 0x9e, 0xf1, 0xbc, 0xf9, 0xb0, 0xa7, 0xe2, 0xd8, 0x9d, 0xd9, 0xdd, 0xc4, 0xdb,
	0x5a, 0x58, 0x03, 0x2b, 0x27, 0x38, 0x1b, 0x88, 0x58, 0x09, 0x29, 0xb1, 0xc3, 0x62, 0x36, 0x4e,
	0x26, 0x6d, 0x9b, 0x08, 0x09, 0x69, 0xd4, 0xee, 0xae, 0xcc, 0x14, 0xee, 0xe9, 0xea, 0x54, 0x57,
	0xdb, 0xe3, 0xcb, 0x1e, 0x38, 0xc0, 0x0d, 0xae, 0x48, 0x1c, 0xb9, 0x71, 0xe7, 0x00, 0x7f, 0x00,
	0x89, 0x1f, 0xc2, 0x6d, 0xef, 0x1c, 0x51, 0x7d, 0x74, 0x77, 0xf5, 0x7c, 0x38, 0x09, 0x12, 0xe2,
	0xc2, 0xa5, 0x55, 0xef, 0xd5, 0xfb, 0xaa, 0x57, 0xef, 0xbd, 0x7a, 0x55, 0x0d, 0x4d, 0x2f, 0x26,
	0xbb, 0x31, 0xa3, 0x9c, 0xa2, 0x15, 0x7e, 0x15, 0xe3, 0xa4, 0x7f, 0x77, 0x44, 0xe9, 0x28, 0xc4,
	0xf7, 0x24, 0xf2, 0x2c, 0x7d, 0x7d, 0x8f, 0x93, 0x09, 0x4e, 0xb8, 0x37, 0x89, 0x15, 0x9d, 0x73,
	0x1b, 0xb6, 0xbe, 0xc4, 0xfc, 0x18, 0xb3, 0x0b, 0xcc, 0x7e, 0x8e, 0x59, 0x42, 0x68, 0xe4, 0xe2,
	0x37, 0x29, 0x4e, 0xb8, 0x33, 0x05, 0x7b, 0x7e, 0x2a, 0x89, 0x69, 0x94, 0x60, 0xb4, 0x01, 0x2b,
	0x13, 0xef, 0x57, 0x94, 0xd9, 0x95, 0xed, 0xca, 0x4e, 0xc7, 0x55, 0x80, 0xc4, 0x92, 0x88, 0x32,
	0xbb, 0xaa, 0xb1, 0x02, 0x10, 0xd8, 0xd8, 0xe3, 0xfe, 0xd8, 0xae, 0x29, 0xac, 0x04, 0x50, 0x1f,
	0x56, 0x19, 0xbe, 0x20, 0x42, 0xaa, 0x6d, 0x6d, 0x57, 0x76, 0x9a, 0x6e, 0x0e, 0x3b, 0xbf, 0xa9,
	0xc0, 0xc6, 0x69, 0x1c, 0x78, 0x1c, 0x0f, 0x18, 0xf5, 0x71, 0x92, 0x68, 0x93, 0x50, 0x17, 0xaa,
	0x24, 0x90, 0x3a, 0x9b, 0x6e, 0x95, 0x04, 0x68, 0x1d, 0x6a, 0x31, 0x09, 0xa4, 0xba, 0xa6, 0x2b,
	0x86, 0xe8, 0x0e, 0x80, 0x1f, 0xd2, 0x04, 0x1f, 0xf3, 0x80, 0x44, 0x52, 0xe3, 0xaa, 0x6b, 0x60,
	0x84, 0x31, 0x97, 0x24, 0xe0, 0x63, 0xa9, 0xb3, 0xe3, 0x2a, 0x00, 0x6d, 0x42, 0x7d, 0x8c, 0xc9,
	0x68, 0xcc, 0xed, 0x15, 0x89, 0xd6, 0x90, 0xb3, 0x05, 0xb7, 0x66, 0xec, 0x50, 0xeb, 0x77, 0xfe,
	0x51, 0x85, 0xcd, 0x7d, 0x86, 0x3d, 0x8e, 0xf7, 0x69, 0xc4, 0x3d, 0x12, 0x61, 0xb6, 0xcc, 0xc6,
	0x3b, 0x00, 0x67, 0x69, 0x14, 0x84, 0x78, 0xe0, 0xf1, 0xb1, 0x36, 0xd5, 0xc0, 0x48, 0x8b, 0xc7,
	0xd8, 0x3f, 0x8f, 0x29, 0x89, 0xb8, 0xb4, 0xb8, 0xe9, 0x1a, 0x18, 0x61, 0x71, 0x22, 0x17, 0xa3,
	0xbc, 0xa4, 0x00, 0x61, 0x71, 0xc2, 0x03, 0x9a, 0x2a, 0x8b, 0x9b, 0xae, 0x86, 0x34, 0x1e, 0x33,
	0x66, 0xd7, 0x73, 0x3c, 0x66, 0x4c, 0xe0, 0x43, 0xef, 0x0c, 0x87, 0x89, 0xdd, 0xd8, 0xae, 0x09,
	0xbc, 0x82, 0xd0, 0x36, 0xb4, 0x22, 0x3a, 0x20, 0x17, 0x94, 0xbb, 0x94, 0x72, 0x7b, 0x55, 0x3a,
	0xcc, 0x44, 0x21, 0x1b, 0x1a, 0x2c, 0x8d, 0x44, 0xdc, 0xd8, 0x4d, 0x29, 0x32, 0x03, 0x05, 0xaf,
	0x1e, 0x3e, 0x66, 0xa3, 0xc4, 0x06, 0x29, 0xd8, 0x44, 0xa1, 0x4f, 0xa0, 0x53, 0xac, 0xe4, 0x80,
	0x30, 0xbb, 0x25, 0x25, 0x94, 0x91, 0xce, 0x21, 0x6c, 0xcd, 0xf9, 0x52, 0xc7, 0xd9, 0x2e, 0x34,
	0xfd, 0x0c, 0x29, 0x7d, 0xda, 0xda, 0x5b, 0xdf, 0x95, 0xa1, 0xbd, 0x5b, 0x10, 0x17, 0x24, 0xce,
	0x21, 0x74, 0x8e, 0xc9, 0x28, 0xf2, 0xc2, 0x77, 0x8f, 0x18, 0xe1, 0x31, 0xc9, 0xa2, 0xe3, 0x53,
	0x43, 0xce, 0x3a, 0x74, 0x33, 0x51, 0x7a, 0xd3, 0xff, 0x52, 0x83, 0xde, 0xe3, 0x20, 0x78, 0x4b,
	0x4c, 0xf6, 0x61, 0x95, 0x63, 0x36, 0x21, 0x42, 0x62, 0x55, 0xba, 0x33, 0x87, 0xd1, 0x5d, 0xb0,
	0xd2, 0x04, 0x33, 0xa9, 0xa9, 0xb5, 0xd7, 0xd2, 0x2b, 0x39, 0x4d, 0x30, 0x73, 0xe5, 0x04, 0x42,
	0x60, 0x79, 0xc2, 0x97, 0x96, 0xf4, 0xa5, 0x1c, 0x0b, 0x93, 0x71, 0x74, 0x61, 0xaf, 0x48, 0x94,
	0x18, 0x0a, 0x8c, 0x7f, 0x19, 0xe8, 0x1d, 0x16, 0xc3, 0x6c, 0x59, 0x8d, 0x62, 0x59, 0x79, 0xd8,
	0xac, 0x2e, 0x0e, 0x9b, 0xe6, 0x92, 0xb0, 0x81, 0x52, 0xd8, 0x38, 0xd0, 0xf6, 0xbd, 0xd8, 0x3b,
	0x23, 0x21, 0xe1, 0x04, 0x27, 0x76, 0x4b, 0x1a, 0x51, 0xc2, 0xa1, 0x1d, 0x58, 0xf3, 0xe2, 0xd8,
	0x63, 0x13, 0xca, 0x06, 0x8c, 0xbe, 0x26, 0x21, 0xb6, 0xdb, 0x52, 0xc8, 0x2c, 0x5a, 0x48, 0x4b,
	0x70, 0x48, 0xa2, 0x74, 0xfa, 0x4c, 0x44, 0x9f, 0xdd, 0x91, 0x64, 0x25, 0x9c, 0x90, 0x16, 0xd1,
	0xe7, 0xf8, 0x72, 0xc0, 0xc8, 0x05, 0x09, 0xf1, 0x08, 0x27, 0x76, 0x57, 0x7a, 0x71, 0x16, 0x8d,
	0x3e, 0x85, 0x06, 0x0b, 0xc9, 0x84, 0xf0, 0xc4, 0x5e, 0xdb, 0xae, 0xed, 0xb4, 0xf6, 0x3a, 0xda,
	0x9f, 0xae, 0xc4, 0xba, 0xd9, 0xac, 0x73, 0x00, 0x75, 0x85, 0x12, 0xee, 0x15, 0x24, 0x7a, 0xb7,
	0xe4, 0x58, 0xe0, 0x12, 0xfa, 0x9a, 0xcb, 0xbd, 0xb2, 0x5c, 0x39, 0x16, 0xb8, 0xb1, 0xc7, 0x02,
	0xb9, 0x4f, 0x96, 0x2b, 0xc7, 0x8e, 0x0b, 0x96, 0xd8, 0x28, 0xe1, 0xea, 0x54, 0x6f, 0x78, 0xc7,
	0x15, 0x43, 0x81, 0x19, 0xe9, 0x98, 0xea, 0xb8, 0x62, 0x88, 0xbe, 0x0d, 0x5d, 0x2f, 0x08, 0x08,
	0x27, 0x34, 0xf2, 0xc2, 0x2f, 0x49, 0x90, 0xd8, 0xb5, 0xed, 0xda, 0x4e, 0xc7, 0x9d, 0xc1, 0x3a,
	0x7b, 0x80, 0xcc, 0x80, 0xd2, 0x41, 0xff, 0x21, 0x34, 0x93, 0xab, 0x84, 0xe3, 0xc9, 0x20, 0xd7,
	0x53, 0x20, 0x9c, 0x5f, 0x57, 0xf2, 0x74, 0xc9, 0xb3, 0x68, 0x59, 0x2c, 0x7e, 0xbf, 0x54, 0x5b,
	0xaa, 0x32, 0xea, 0x7a, 0x59, 0xfe, 0x14, 0xdc, 0x66, 0xb9, 0x99, 0x4b, 0xd9, 0xda, 0xa2, 0x94,
	0xed, 0x83, 0x3d, 0x6f, 0x83, 0x4e, 0x13, 0x1f, 0xb6, 0x0e, 0x70, 0x88, 0xdf, 0xc5, 0x3e, 0x04,
	0x56, 0xe4, 0x4d, 0xb0, 0x4e, 0x47, 0x39, 0x7e, 0x77, 0x03, 0xe6, 0x95, 0x68, 0x03, 0x8e, 0xe0,
	0xd6, 0x33, 0x92, 0xf0, 0xb7, 0xab, 0x9f, 0x53, 0x55, 0x5d, 0xa4, 0xea, 0x0f, 0x15, 0x80, 0x42,
	0x56, 0x6e, 0x73, 0xc5, 0xb0, 0x19, 0x81, 0x85, 0xa7, 0x84, 0xeb, 0x7c, 0x97, 0x63, 0x11, 0x15,
	0xdc, 0x8f, 0xf5, 0x11, 0x24, 0x86, 0xa2, 0x5e, 0xa6, 0x11, 0x99, 0x1e, 0x53, 0xff, 0x1c, 0xf3,
	0x44, 0xd6, 0xf3, 0x55, 0xd7, 0x44, 0xc9, 0xa4, 0x1d, 0xe3, 0x30, 0x94, 0x45, 0x7d, 0xd5, 0x55,
	0x80, 0xa8, 0xc0, 0x78, 0x12, 0xf3, 0xab, 0xe7, 0xc7, 0x76, 0x5d, 0xe6, 0x5f, 0x06, 0x3a, 0x47,
	0xb0, 0x39, 0xbb, 0x52, 0x1d, 0x43, 0x0f, 0xa0, 0x55, 0xac, 0x22, 0xb1, 0x2b, 0x32, 0x41, 0x16,
	0x6c, 0xbd, 0x49, 0xe5, 0xdc, 0x81, 0xf6, 0x31, 0xf7, 0x38, 0x5e, 0xe2, 0x2f, 0x67, 0x07, 0xba,
	0x79, 0xd5, 0x95, 0x84, 0xaa, 0x6e, 0x78, 0x3c, 0x4d, 0x34, 0x95, 0x86, 0x9c, 0xbf, 0xd6, 0xa0,
	0xa1, 0xc3, 0x3a, 0xab, 0x4d, 0x95, 0xa2, 0x36, 0xfd, 0x4f, 0x4a, 0x64, 0x29, 0xab, 0x1a, 0x33,
	0x59, 0xf5, 0xff, 0x72, 0x59, 0x94, 0xcb, 0xbf, 0x57, 0xa0, 0x99, 0x6f, 0xf3, 0x7b, 0xb7, 0x33,
	0x9f, 0x41, 0x33, 0x56, 0x1b, 0x8f, 0x55, 0xd5, 0x6b, 0xed, 0x75, 0xb5, 0xa2, 0xac, 0xce, 0x15,
	0x04, 0x46, 0xfc, 0x58, 0x66, 0xfc, 0x18, 0xed, 0xca, 0x4a, 0xa9, 0x5d, 0x41, 0x60, 0xc5, 0xa2,
	0x9c, 0xd6, 0x65, 0x39, 0x95, 0x63, 0xb3, 0x41, 0x69, 0x94, 0x1a, 0x14, 0xe7, 0x21, 0x34, 0x8e,
	0x3c, 0x7f, 0x4c, 0x22, 0x99, 0xa1, 0x7e, 0xac, 0xc3, 0xb4, 0xe3, 0xca, 0xb1, 0x50, 0x32, 0xc1,
	0x13, 0xca, 0xae, 0x74, 0xed, 0xd7, 0x90, 0x73, 0x0e, 0x1d, 0x9d, 0x06, 0x3a, 0x99, 0xee, 0x03,
	0xe4, 0x2d, 0x46, 0x96, 0x4b, 0xf3, 0x6d, 0x88, 0x41, 0x83, 0x76, 0xa0, 0x31, 0x51, 0x9a, 0x75,
	0xd5, 0xcd, 0x7c, 0xa0, 0xed, 0x71, 0xb3, 0x69, 0xe7, 0xb7, 0x15, 0xd8, 0x54, 0x3d, 0xe6, 0x5b,
	0x3b, 0xc9, 0xc5, 0xbd, 0x8b, 0x72, 0x5f, 0xad, 0xe4, 0xbe, 0x07, 0xd0, 0x64, 0x38, 0xa1, 0x29,
	0xf3, 0xb1, 0xf2, 0x6c, 0x6b, 0xef, 0x56, 0x96, 0x49, 0x52, 0x97, 0xab, 0x67, 0xdd, 0x82, 0xce,
	0xf9, 0xa6, 0x0e, 0xdd, 0xf2, 0xac, 0xa8, 0x58, 0x67, 0xe1, 0x39, 0xa1, 0xaf, 0x54, 0x73, 0x5c,
	0x91, 0x6e, 0x32, 0x51, 0x22, 0xab, 0xfc, 0x38, 0x3d, 0x1e, 0x7b, 0x0c, 0x27, 0xda, 0x8d, 0x05,
	0x42, 0xcf, 0x0e, 0x30, 0x23, 0x34, 0x3b, 0x4c, 0x0b, 0x84, 0x28, 0x03, 0x7e, 0x9c, 0xbe, 0x4c,
	0x29, 0xf7, 0xa4, 0x91, 0x96, 0x9b, 0xc3, 0xb2, 0x2b, 0x8e, 0xd3, 0x04, 0xf3, 0x7d, 0xb1, 0x6b,
	0x2b, 0xba, 0x2b, 0xce, 0x31, 0xc5, 0xfc, 0x11, 0x9e, 0x24, 0x3a, 0xcd, 0x0d, 0x8c, 0xb0, 0x5c,
	0xed, 0xe6, 0x33, 0x11, 0xd4, 0x32, 0x30, 0x2c, 0xd7, 0x44, 0x09, 0x09, 0x0a, 0x3c, 0xbe, 0xf4,
	0x62, 0x99, 0xf6, 0x96, 0x6b, 0x60, 0xd0, 0x67, 0xd0, 0x53, 0x90, 0x8b, 0x13, 0xcc, 0x2e, 0x3c,
	0x71, 0x6c, 0xcb, 0x32, 0x60, 0xb9, 0xf3, 0x13, 0x82, 0xfa, 0x1c, 0xb3, 0x08, 0x87, 0x47, 0x86,
	0x56, 0x50, 0xd4, 0x73, 0x13, 0x68, 0x0f, 0x36, 0x14, 0xf2, 0x64, 0x7f, 0x60, 0x32, 0xb4, 0x24,
	0xc3, 0xc2, 0x39, 0x91, 0xe9, 0xd2, 0xf1, 0xcf, 0xb0, 0xf7, 0x5a, 0xef, 0x47, 0x5b, 0x92, 0xcf,
	0xa2, 0xd1, 0x63, 0xe8, 0x19, 0x5b, 0x74, 0x80, 0x2f, 0x88, 0x8f, 0xed, 0x8e, 0x8c, 0xda, 0x9b,
	0x3a, 0x0a, 0xcc, 0x29, 0x77, 0x9e, 0x1a, 0x9d, 0x42, 0x5f, 0x22, 0x4f, 0xc6, 0x8c, 0x72, 0x1e,
	0x62, 0x17, 0x7b, 0xc1, 0x93, 0x38, 0xd1, 0xb2, 0xba, 0x52, 0x56, 0x16, 0x51, 0x19, 0x8d, 0x96,
	0x76, 0x0d, 0x23, 0x7a, 0x05, 0x1f, 0x94, 0x66, 0x5f, 0x31, 0xc2, 0x71, 0x21, 0x77, 0xed, 0x3a,
	0xb9, 0xd7, 0x71, 0xce, 0x09, 0x16, 0x6a, 0x0f, 0x69, 0x2e, 0x78, 0xfd, 0xdd, 0x05, 0x97, 0x39,
	0xd1, 0x2f, 0xe0, 0xc3, 0x79, 0xbd, 0x86, 0xe4, 0xde, 0x75, 0x92, 0xaf, 0x65, 0x75, 0xbe, 0x80,
	0xce, 0x93, 0x90, 0xfa, 0xe7, 0x87, 0x2f, 0xb4, 0xae, 0xd2, 0xa5, 0xba, 0xb6, 0xf0, 0x52, 0x5d,
	0xd3, 0x97, 0x6a, 0xe7, 0x6b, 0x68, 0x97, 0x36, 0xec, 0x07, 0x32, 0x53, 0x33, 0x51, 0xfa, 0xaa,
	0xb4, 0xa1, 0xcd, 0x2a, 0xa9, 0x71, 0x4d, 0x42, 0x51, 0x41, 0x2e, 0x55, 0x30, 0xa9, 0xf6, 0x55,
	0x43, 0x22, 0x3b, 0xc2, 0x22, 0xd0, 0xd4, 0xcd, 0xc8, 0xc0, 0x38, 0xbf, 0x84, 0x6e, 0x79, 0xb1,
	0xff, 0xb1, 0x05, 0x08, 0x2c, 0xe6, 0x71, 0x9c, 0xf5, 0xdf, 0x62, 0xec, 0xdc, 0x86, 0xad, 0xb9,
	0x9a, 0xa8, 0x9b, 0xbb, 0x2b, 0xe8, 0x3c, 0xbd, 0xc0, 0x11, 0xcf, 0xef, 0x5f, 0x8f, 0xa0, 0x99,
	0x3f, 0x6a, 0xe8, 0x62, 0xdb, 0xdf, 0x55, 0xcf, 0x1e, 0xbb, 0xd9, 0xb3, 0xc7, 0xee, 0x49, 0x46,
	0xe1, 0x16, 0xc4, 0x62, 0x8d, 0x09, 0xa7, 0x0c, 0x07, 0x2f, 0xa2, 0xf0, 0x2a, 0x7b, 0x2b, 0x28,
	0x30, 0xba, 0xfe, 0x5a, 0x79, 0xfb, 0xf3, 0xfb, 0x0a, 0xac, 0x48, 0xdd, 0x0b, 0xef, 0x11, 0x8a,
	0xba, 0x9a, 0x57, 0xeb, 0x72, 0x6d, 0xee, 0xe4, 0xb5, 0x59, 0x57, 0x71, 0xab, 0xa8, 0xe2, 0xa5,
	0x15, 0xd4, 0xdf, 0x63, 0x05, 0xce, 0xef, 0xaa, 0xd0, 0x7e, 0x8e, 0xf9, 0x25, 0x65, 0xe7, 0xe2,
	0xc4, 0x4a, 0x16, 0x36, 0xa7, 0xb7, 0x61, 0x95, 0x4d, 0x87, 0x67, 0x57, 0x3c, 0xaf, 0xd0, 0x0d,
	0x36, 0x7d, 0x22, 0x40, 0xf4, 0x11, 0x00, 0x9b, 0x0e, 0x07, 0x9e, 0x6a, 0x48, 0x75, 0x81, 0x66,
	0x53, 0x8d, 0x40, 0x1f, 0x40, 0xd3, 0x9d, 0x0e, 0x31, 0x63, 0x94, 0x25, 0x59, 0x85, 0x66, 0xd3,
	0xa7, 0x12, 0x16, 0xbc, 0xee, 0x74, 0x18, 0x30, 0x1a, 0xc7, 0x38, 0x90, 0x15, 0x5a, 0xf2, 0x1e,
	0x28, 0x84, 0xd0, 0x7a, 0x92, 0x69, 0xad, 0x2b, 0xad, 0xbc, 0xd0, 0x7a, 0x32, 0x1d, 0xc6, 0x5a,
	0xab, 0x2a, 0xcd, 0x4d, 0x6e, 0x6a, 0x3d, 0xc9, 0xb5, 0xaa, 0xba, 0xbc, 0xca, 0x0d, 0xad, 0x27,
	0x85, 0xd6, 0x66, 0xc6, 0xab, 0xb5, 0x3a, 0x7f, 0xae, 0xc0, 0xea, 0x7e, 0x9c, 0x9e, 0x26, 0xde,
	0x08, 0xa3, 0xbb, 0xd0, 0xe2, 0x94, 0x7b, 0xe1, 0x30, 0x15, 0xa0, 0x3e, 0xbd, 0x40, 0xa2, 0x14,
	0xc1, 0xc7, 0xd0, 0x8e, 0x31, 0xf3, 0xe3, 0x54, 0x53, 0x54, 0xb7, 0x6b, 0xe2, 0x94, 0x50, 0x38,
	0x45, 0xb2, 0x0b, 0x37, 0xe5, 0xdc, 0x90, 0x44, 0x43, 0x55, 0x96, 0x27, 0x34, 0xc0, 0xda, 0x55,
	0x3d, 0x39, 0x75, 0x18, 0x7d, 0x95, 0x4f, 0xa0, 0xef, 0x42, 0x2f, 0xa7, 0x17, 0xed, 0xaa, 0xa4,
	0x56, 0xae, 0x5b, 0xd3, 0xd4, 0xa7, 0x1a, 0xed, 0x7c, 0x9d, 0xe7, 0x10, 0x89, 0x46, 0x07, 0x1e,
	0xf7, 0x44, 0x2b, 0x13, 0xcb, 0xb3, 0x31, 0xd1, 0xd6, 0x66, 0x20, 0xfa, 0x1e, 0xf4, 0xb8, 0xce,
	0xb7, 0x60, 0x98, 0xd1, 0xa8, 0xdd, 0x5c, 0xcf, 0x27, 0x06, 0x9a, 0xf8, 0x5b, 0xd0, 0x2d, 0x88,
	0x65, 0x63, 0xa4, 0xec, 0xed, 0xe4, 0x58, 0x11, 0x4d, 0xce, 0x1f, 0x95, 0xb3, 0x54, 0xe4, 0x7c,
	0x26, 0x8f, 0x6a, 0xc3, 0x55, 0xad, 0xbd, 0xb5, 0xac, 0xc5, 0xd1, 0xce, 0x90, 0xc7, 0xb3, 0x72,
	0xcb, 0x8f, 0x61, 0x8d, 0xe7, 0xa6, 0x0f, 0x03, 0x8f, 0x7b, 0x3a, 0xf5, 0x66, 0x2a, 0xa1, 0x5e,
	0x98, 0xdb, 0xe5, 0xe5, 0x85, 0x7e, 0x0c, 0x6d, 0xd5, 0x7b, 0x6b, 0x85, 0xca, 0xbe, 0x96, 0xc2,
	0x49, 0x15, 0xce, 0x17, 0xd0, 0x1c, 0x90, 0x20, 0x51, 0xd6, 0xd9, 0xd0, 0xf0, 0x53, 0xc6, 0x70,
	0x94, 0x35, 0x21, 0x19, 0x28, 0xca, 0xa3, 0xec, 0x5b, 0xb5, 0x33, 0x14, 0xe0, 0x50, 0x00, 0x75,
	0x76, 0x4a, 0x6d, 0x1b, 0xb0, 0x62, 0x86, 0x80, 0x02, 0x44, 0x9c, 0x4d, 0xbc, 0x69, 0xbe, 0xf5,
	0x32, 0xce, 0x26, 0xde, 0x54, 0x2d, 0xd0, 0x86, 0xc6, 0x6b, 0x8f, 0x84, 0xbe, 0x7e, 0x92, 0xb3,
	0xdc, 0x0c, 0x2c, 0x14, 0x5a, 0xa6, 0xc2, 0x3f, 0x55, 0xa1, 0xa5, 0x34, 0x2a, 0x83, 0x37, 0x60,
	0xc5, 0xf7, 0xfc, 0x71, 0xae, 0x52, 0x02, 0xe8, 0xd3, 0xcc, 0x90, 0xf2, 0x55, 0xbc, 0x30, 0x35,
	0xb3, 0xed, 0x3e, 0x40, 0x72, 0xe9, 0xc5, 0x86, 0x77, 0x16, 0x52, 0x37, 0x05, 0x91, 0x32, 0xf8,
	0x73, 0x68, 0xab, 0xf8, 0xd4, 0x3c, 0xd6, 0x32, 0x9e, 0x96, 0x22, 0x53, 0x5c, 0x0f, 0xc4, 0xb5,
	0xc7, 0xe3, 0xaa, 0xcd, 0x6e, 0xed, 0x7d, 0x54, 0x22, 0x97, 0x2b, 0xd9, 0x95, 0xdf, 0xa7, 0x11,
	0x67, 0x57, 0xae, 0xa2, 0xed, 0x3f, 0x02, 0x28, 0x90, 0xa2, 0x9e, 0x9d, 0xe3, 0xab, 0xec, 0x7a,
	0x77, 0x8e, 0xaf, 0xc4, 0xda, 0x2f, 0xbc, 0x30, 0xcd, 0x9c, 0xaa, 0x80, 0x1f, 0x55, 0x1f, 0x55,
	0x1c, 0x1f, 0xd6, 0x9e, 0x88, 0x23, 0xd1, 0x60, 0x2f, 0x1d, 0x7a, 0xd6, 0xc2, 0x43, 0xcf, 0xca,
	0x5e, 0x92, 0xbb, 0x50, 0xa5, 0xb1, 0x6e, 0x75, 0xab, 0x34, 0x2e, 0x14, 0x59, 0x86, 0x22, 0xe7,
	0x9f, 0x16, 0x40, 0xa1, 0x05, 0x1d, 0x43, 0x9f, 0xd0, 0xa1, 0xe8, 0xd4, 0x88, 0x8f, 0x55, 0x41,
	0x1a, 0x32, 0xec, 0xa7, 0x2c, 0x21, 0x17, 0x58, 0x37, 0xf3, 0x9b, 0xf9, 0x31, 0x55, 0x32, 0xce,
	0xdd, 0x22, 0xf4, 0x58, 0x31, 0xca, 0xca, 0xe5, 0x66, 0x6c, 0xe8, 0x67, 0x70, 0xab, 0x10, 0x1a,
	0x18, 0xf2, 0xaa, 0xd7, 0xca, 0xbb, 0x99, 0xcb, 0x0b, 0x0a, 0x59, 0x3f, 0x81, 0x9b, 0x84, 0x0e,
	0xdf, 0xa4, 0x38, 0x2d, 0x49, 0xaa, 0x5d, 0x2b, 0xa9, 0x47, 0xe8, 0x4b, 0xc9, 0x51, 0xc8, 0x79,
	0x09, 0xb7, 0x8d, 0x85, 0x8a, 0xb4, 0x37, 0xa4, 0x59, 0xd7, 0x4a, 0xdb, 0xcc, 0xed, 0x12, 0x85,
	0xa1, 0x10, 0xf9, 0x15, 0x6c, 0x12, 0x3a, 0xbc, 0xf4, 0x08, 0x9f, 0x95, 0xb7, 0xf2, 0xb6, 0x75,
	0xbe, 0xf2, 0x08, 0x2f, 0x0b, 0x53, 0xeb, 0x9c, 0x60, 0x36, 0x2a, 0xad, 0xb3, 0xfe, 0xb6, 0x75,
	0x1e, 0x49, 0x8e, 0x42, 0xce, 0x13, 0xe8, 0x11, 0x3a, 0x6b, 0x4f, 0xe3, 0x5a, 0x29, 0x6b, 0x84,
	0x96, 0x6d, 0xd9, 0x87, 0x5e, 0x82, 0x7d, 0x4e, 0x99, 0x19, 0x0b, 0xab, 0xd7, 0xca, 0x58, 0xd7,
	0x0c, 0xb9, 0x10, 0xe7, 0x0d, 0xb4, 0x7f, 0x9a, 0x8e, 0x30, 0x0f, 0xcf, 0xf2, 0x9c, 0xff, 0x6f,
	0x97, 0x99, 0x7f, 0x55, 0xa1, 0xb5, 0x3f, 0x62, 0x34, 0x8d, 0x4b, 0x55, 0x5b, 0xe5, 0xf0, 0x5c,
	0xd5, 0x96, 0x34, 0xb2, 0x6a, 0x2b, 0xea, 0x87, 0xd0, 0x56, 0x37, 0x17, 0xcd, 0xa0, 0xaa, 0x10,
	0x9a, 0x4f, 0xfa, 0xec, 0xa6, 0xa4, 0xd8, 0xf6, 0xf4, 0x2d, 0x50, 0x73, 0x95, 0xab, 0x51, 0xe1,
	0x26, 0x17, 0xce, 0x8a, 0xac, 0x3b, 0x84, 0xce, 0x58, 0xf9, 0x46, 0x73, 0xa9, 0x00, 0xfc, 0x24,
	0x33, 0xae, 0x58, 0xc3, 0xae, 0xe9, 0x43, 0xe5, 0xea, 0xf6, 0xd8, 0x74, 0xeb, 0x3d, 0x00, 0x71,
	0xcf, 0x1f, 0x66, 0x85, 0xca, 0xfc, 0x09, 0x90, 0x9f, 0x10, 0x6e, 0x33, 0xce, 0x86, 0xfd, 0x13,
	0xe8, 0xcd, 0xc9, 0x5c, 0x50, 0xa6, 0xbe, 0x63, 0x96, 0xa9, 0xe2, 0x6a, 0x64, 0xb2, 0x9a, 0xb5,
	0xeb, 0x6f, 0x15, 0xf5, 0x2c, 0x50, 0xbc, 0xd3, 0x3e, 0x82, 0x4e, 0xa4, 0x9a, 0xaf, 0x7c, 0x03,
	0xcc, 0x3b, 0x96, 0xd9, 0x98, 0xb9, 0xed, 0xc8, 0x6c, 0xd3, 0x1e, 0x42, 0xdb, 0x97, 0x1e, 0x58,
	0xb8, 0x11, 0x86, 0x73, 0xdc, 0x96, 0x6f, 0xec, 0x76, 0xa9, 0x51, 0xb4, 0xde, 0xa7, 0x51, 0xd4,
	0x2f, 0x7b, 0xcb, 0x7e, 0x5a, 0xec, 0x7d, 0x53, 0x87, 0xda, 0xe3, 0xc1, 0x21, 0x3a, 0x85, 0xf5,
	0xd9, 0x7f, 0x7e, 0xe8, 0x8e, 0x36, 0x6b, 0xc9, 0x7f, 0xc2, 0xfe, 0xdd, 0xa5, 0xf3, 0xba, 0x65,
	0xbf, 0x81, 0x5c, 0x58, 0x9b, 0xf9, 0xc3, 0x83, 0xb2, 0xa3, 0x66, 0xf1, 0x5f, 0xb4, 0xfe, 0x9d,
	0x65, 0xd3, 0xa6, 0xcc, 0x99, 0x3b, 0x42, 0x2e, 0x73, 0xf1, 0x7b, 0x4a, 0x2e, 0x73, 0xd9, 0xd5,
	0xe2, 0x06, 0xfa, 0x21, 0xd4, 0xd5, 0x3f, 0x1f, 0x94, 0x5d, 0x5c, 0x4a, 0x7f, 0x93, 0xfa, 0xb7,
	0x66, 0xb0, 0x39, 0xe3, 0x33, 0xe8, 0x94, 0x7e, 0x14, 0xa2, 0x0f, 0x4a, 0xba, 0xca, 0xbf, 0x8c,
	0xfa, 0x1f, 0x2e, 0x9e, 0xcc, 0xa5, 0xed, 0x03, 0x14, 0xbf, 0x05, 0x90, 0xad, 0xa9, 0xe7, 0x7e,
	0x3d, 0xf5, 0x6f, 0x2f, 0x98, 0xc9, 0x85, 0x9c, 0xc2, 0xfa, 0xec, 0x13, 0x3d, 0x9a, 0xf1, 0xea,
	0xec, 0x03, 0x79, 0xbe, 0x95, 0x4b, 0xdf, 0xf6, 0xa5, 0xd8, 0xd9, 0x87, 0xf7, 0x5c, 0xec, 0x92,
	0x67, 0xff, 0x5c, 0xec, 0xd2, 0x17, 0xfb, 0x1b, 0xe8, 0x05, 0x74, 0xcb, 0x2f, 0xd9, 0x28, 0x73,
	0xd2, 0xc2, 0xa7, 0xfc, 0xfe, 0x47, 0x4b, 0x66, 0x73, 0x81, 0x9f, 0xc3, 0x8a, 0x7a, 0xa2, 0xce,
	0xd2, 0xd1, 0x7c, 0xd9, 0xee, 0x6f, 0x94, 0x91, 0x39, 0xd7, 0x7d, 0xa8, 0xab, 0xdb, 0x65, 0x1e,
	0x00, 0xa5, 0xcb, 0x66, 0xbf, 0x6d, 0x62, 0x9d, 0x1b, 0xf7, 0x2b, 0x99, 0x9e, 0xa4, 0xa4, 0x27,
	0x59, 0xa4, 0xc7, 0xd8, 0x9c, 0xb3, 0xba, 0x4c, 0xd7, 0x07, 0xff, 0x0e, 0x00, 0x00, 0xff, 0xff,
	0x11, 0x58, 0x45, 0xd9, 0xb2, 0x1f, 0x00, 0x00,
}
