Name:           dnsperf
Version:        2.13.0
Release:        1%{?dist}
Summary:        DNS Performance Testing Tool
Group:          Productivity/Networking/DNS/Utilities

License:        Apache-2.0
URL:            https://www.dns-oarc.net/tools/dnsperf
# Source needs to be generated by dist-tools/create-source-packages, see
# https://github.com/jelu/dist-tools
Source0:        https://www.dns-oarc.net/files/dnsperf/%{name}-%{version}.tar.gz?/%{name}_%{version}.orig.tar.gz

BuildRequires:  autoconf
BuildRequires:  automake
BuildRequires:  libtool
BuildRequires:  openssl-devel
BuildRequires:  pkgconfig
BuildRequires:  ldns-devel
BuildRequires:  ck-devel
BuildRequires:  libnghttp2-devel

%description
dnsperf and resperf are free tools developed by Nominum/Akamai (2006-2018)
and DNS-OARC (since 2019) that make it simple to gather accurate latency and
throughput metrics for Domain Name Service (DNS). These tools are easy-to-use
and simulate typical Internet, so network operators can benchmark their naming
and addressing infrastructure and plan for upgrades. The latest version of
the dnsperf and resperf can be used with test files that include IPv6
queries.

dnsperf "self-paces" the DNS query load to simulate network conditions.

New features in dnsperf improve the precision of latency measurements and
allow for per packet per-query latency reporting is possible. dnsperf is
now multithreaded, multiple dnsperf clients can be supported in multicore
systems (each client requires two cores). The output of dnsperf has also
been improved so it is more concise and useful. Latency data can be used to
make detailed graphs, so it is simple for network operators to take advantage
of the data.


%package -n resperf
Summary:        DNS Resolution Performance Testing Tool
Group:          Productivity/Networking/DNS/Utilities


%description -n resperf
dnsperf and resperf are free tools developed by Nominum/Akamai (2006-2018)
and DNS-OARC (since 2019) that make it simple to gather accurate latency and
throughput metrics for Domain Name Service (DNS). These tools are easy-to-use
and simulate typical Internet, so network operators can benchmark their naming
and addressing infrastructure and plan for upgrades. The latest version of
the dnsperf and resperf can be used with test files that include IPv6
queries.

resperf systematically increases the query rate and monitors the response
rate to simulate caching DNS services.


%prep
%setup -q -n %{name}_%{version}


%build
sh autogen.sh
%configure "--with-extra-cflags=-I /usr/include/bind"
make %{?_smp_mflags}


%check
make test


%install
rm -rf $RPM_BUILD_ROOT
make install DESTDIR=$RPM_BUILD_ROOT


%clean
rm -rf $RPM_BUILD_ROOT


%files
%defattr(-,root,root)
%{_bindir}/dnsperf
%{_datadir}/doc/*
%{_mandir}/man1/dnsperf.*


%files -n resperf
%defattr(-,root,root)
%{_bindir}/resperf
%{_bindir}/resperf-report
%{_mandir}/man1/resperf.*


%changelog
* Thu Jun 15 2023 Jerry Lundström <lundstrom.jerry@gmail.com> 2.13.0-1
- Release 2.13.0
  * This release adds a new option `-O tls-sni=...` to set the Server Name
    Indication when using TLS transport, currently for DNS-over-TLS and
    DNS-over-HTTPS.
  * Commits:
    dbe84f6 TLS SNI
    5fb2282 Add TLS Server Name Indication extension support
* Sun May 21 2023 Jerry Lundström <lundstrom.jerry@gmail.com> 2.12.0-1
- Release 2.12.0
  * This release fixes a segfault when doing DNS-over-HTTPS and changes the
    way maximum queries per second are handled.
  * The DNS-over-HTTPS module handled reconnecting incorrectly and destroyed
    the nghttp2 context during callbacks. Thanks to the help from
    @kgillis2000 it was quickly found and fixed.
  * The way maximum QPS is handled has been changed by Petr Špaček @pspacek
    (ISC). The new way solves an over-shoot problem that happened due to
    max QPS being counted for the whole runtime and based on completed
    queries, not just sent.
  * A new option `qps_threshold_wait` has also been added. This controls
    the threshold for using `nanosleep()` between sending packet and the
    default is measured on start-up. If the time between packets, based on
    max QPS `-Q`, is smaller then no sleep will be performed. This improves
    performance when doing high max QPS limiting.
  * Other changes:
    - `dnsperf`: Statistics output
      - Fixed missing connection statistics if only reconnections happened
      - Flush output to allow pipe/grep processing
      - Add percentage on reconnections based on total connections
    - Support OpenSSL 3.0+
  * Commits:
    9aca046 OpenSSL 3.0
    6d3d6b4 Stats, DoH
    316f901 qps_threshold_wait
    ed52770 WIP: use busy wait only if necessary
    32229b6 WIP: import nanosleep benchmark
    1842b88 Fix dnsperf -Q to not overshot target value
* Thu Mar 16 2023 Jerry Lundström <lundstrom.jerry@gmail.com> 2.11.2-1
- Release 2.11.2
  * Fixed long option argument handling (again), wasn't completely fixed
    in v2.11.1.
  * Commits:
    e6dbd78 Long opt
* Fri Mar 10 2023 Jerry Lundström <lundstrom.jerry@gmail.com> 2.11.1-1
- Release 2.11.1
  * Fixed long option argument handling that broke in v2.11.0 and enhanced
    long option help text, now includes argument type.
  * Commits:
    034e893 Long opt
* Wed Feb 08 2023 Jerry Lundström <lundstrom.jerry@gmail.com> 2.11.0-1
- Release 2.11.0
  * A couple of new features this release courtesy of Petr Špaček
    @pspacek (ISC) and a bunch of bugfixes.
  * First off `dnsperf` can now do verbose statistics during each interval
    when using `-S`, see long option `verbose-interval-stats`.
  * Next is a new latency histogram output using data structures (hg64)
    created by Tony Finch @fanf2 (ISC), see long option
    `latency-histogram`. These will also be shown during `-S` when used
    together with `verbose-interval-stats`.
  * Lastly a small change to boolean long options, they no longer require
    a value (`=yes`) to be enabled.
  * Bugfixes:
    - Make sure the number of outstanding queries don't go negative,
      happens if queries are timed out before being sent
    - Fixed #208:
      - `recv_one()`: Fix handling errno, only store EAGAIN if no other
        error has been received
      - `do_recv()`: Don't break on error as it will count it as a received
        message
      - Treat `EBADF` as `EAGAIN` for stateful connections, receive thread
        might read from a closed socket if send thread is reconnecting
    - `dnsperf`: warn if -c, -T, -q, -Q values are auto-adjusted
    - Fixed #222: don't process unexpected message if the message is
      suppressed
  * Commits:
    14db835 Opt arg
    fb81481 Suppress unexpected
    64b8c6d stats_t initialization
    8290775 Fix first call to diff_stats
    4f8bd24 Compile support histograms
    a9b4f04 External code, latency histograms
    d1f4b65 add detailed latency histograms
    044e3a2 data structures for detailed latency histograms
    ad3fb03 Opt, verbose statistics
    38bc936 Command usage warnings
    9f31595 Bad file descriptor
    d3650eb Receive socket error handling
    84c8e72 Negative outstanding
    e7df5e1 Clarify meaning of dnsperf -S output in the man page
    830eb43 verbose interval stats for dnsperf
* Fri Nov 11 2022 Jerry Lundström <lundstrom.jerry@gmail.com> 2.10.0-1
- Release 2.10.0
  * This release adds a binary datafile (DNS wire) format to `dnsperf`
    thanks to a contribution from Petr Špaček @pspacek (ISC).
  * The new binary format greatly improves performance in some cases, for
    Petr's case it was testing dynamic updates. Switching to this
    pre-compiled DNS wire format increased QPS from 4k to 600k, an increase
    of 150 times throughput from `dnsperf`!
  * See man-page for `-B` for more information and examples how to use.
  * Commits:
    5971cb9 Doc
    a241068 CodeQL
    2a7d10a Fix CodeQL workflow
    0ce15f6 Fix COPR
    0ae4a54 CodeQL
    f52e4b1 wire format input
    c423aa9 wire format input
    2b0693d Input binary format
* Wed Dec 08 2021 Jerry Lundström <lundstrom.jerry@gmail.com> 2.9.0-1
- Release 2.9.0
  * This release brings a new message suppression option and a way to control
    how many queries are sent over a connection.
  * You can now suppress the message about receiving unexpected DNS message
    IDs by using `-O suppress=unexpected`.
  * With `-O num-queries-per-conn=<num>` you can now limit the number of
    queries sent over a connection before triggering a re-connection, see
    the `dnsperf(3)` man-page for more information how this works.
  * Commits:
    cd9df40 Tests
    864a968 Queries per connection
    7c5d6ab Suppress unexpected
    8e9f4a2 Suppress
* Tue Nov 02 2021 Jerry Lundström <lundstrom.jerry@gmail.com> 2.8.0-1
- Release 2.8.0
  * This release fixes response handling for DNS-over-HTTPS when multiple
    responses are received within the same receive cycle, and adds a new
    option to suppress some of the normal and verbose output.
  * The network model within dnsperf and resperf can not process more then
    one response at a time from a protocol module, so a buffer has been added
    to the DNS-over-HTTPS module to handle this situation (this already exists
    in all other modules).
  * The new option `-O suppress=<message,...>` can selectively suppress parts
    of the normal and verbose output. Some of these messages might be
    excessively displayed due to the network model and depending on what
    protocol you use which makes usage harder then necessary. For example
    during TCP connection stage, if you end-point is slow to establish
    connection you will get a lot of output saying that the socket isn't ready
    yet.
  * Commits:
    6a452b0 DoH response handling
    e2828e7 Suppress
* Fri Sep 17 2021 Jerry Lundström <lundstrom.jerry@gmail.com> 2.7.1-1
- Release 2.7.1
  * This release fixes issues with constructing wire-format DNS when the
    domain names includes escaped characters such as `\123` or `\.`.
  * Other changes:
    - Bump Debian package compat level to 10
  * Commits:
    4873f02 DNS encoding
    c4eccc0 debhelper
* Mon Aug 09 2021 Jerry Lundström <lundstrom.jerry@gmail.com> 2.7.0-1
- Release 2.7.0
  * This release adds DNS-over-HTTPS support!
  * DNS-over-HTTPS can be used by specifying transport mode `doh` and you
    should also look at the dnsperf(1) man-page (or `-H`) for the extended
    options `doh-uri` and `doh-method`, which controls aspects of DoH/HTTP/2
    that you might want to set.
  * Other fixes:
    - Add check when constructing DNS packet so that total length of labels
      does not exceed 255 bytes
    - Fix connection/reconnection state handling for DoT transport
    - Fix event handling by initializing them directly when opening the
      sockets, otherwise events could have been missed which would give
      incorrect statistics
  * Commits:
    61b5eac Tests with dumdumd
    d71071c Tests with dumdumd
    b42f92e DoH sending
    2fa40bb Net stats
    f7f8692 DoH fixes
    ea62b49 DoH concurrent streams
    91929f1 DoH reconnect
    17660e6 DoH fixes
    5276aa6 resperf buckets
    585860e Packages
    3ffc601 Fixes
    1570609 Man-page
    6bcadc7 README
    f81adf1 Fixes
    1acd71f Code structure
    6c47876 Fixes
    2d379f4 Fixes
    4d5384b Fixes
    cee93b3 Initial DNS-over-HTTPS support implementation
    4ff3ebc Events
    8b24bbf DoT state
    6a5b5ef Fix too long name
    71fa09f long opts
* Mon May 31 2021 Jerry Lundström <lundstrom.jerry@gmail.com> 2.6.0-1
- Release 2.6.0
  * This release adds EDNS options parameter `-E` to `resperf` and a script
    for generating EDNS Client Subnet options (see `contrib/ecs-gen`).
  * Commits:
    d29d880 ECS opt
    877f31e edns option
* Thu Mar 25 2021 Jerry Lundström <lundstrom.jerry@gmail.com> 2.5.2-1
- Release 2.5.2
  * This release tweaks the reconnect code for TCP and DoT.
  * For TCP, atomic operations are used to signal the need to reconnect
    from the receiving thread to the sending, as the sending is the one in
    charge of reconnecting.
    This speeds up detection of connection lost which reduces the amount of
    lost queries on a disconnect.
  * This change does not affect DoT as much, as the SSL context shared
    between the threads are protected by a mutex.
    But a bug was found in `sendto()` for DoT that could drop a query if
    the socket was busy sending.
  * The connect and reconnect socket events has been split into connecting,
    connected and reconnecting, reconnected. This is to report more correct
    reconnect events when it comes to DoT, because the connection can be
    lost while negotiating TLS.
  * Lastly, additional tests has been added for the network code.
  * Commits:
    d9e5663 net test
    22f49df network tests
    8e5b56e reconnect
* Mon Mar 22 2021 Jerry Lundström <lundstrom.jerry@gmail.com> 2.5.1-1
- Release 2.5.1
  * This release re-adds support for TYPEnnn and ANY in the datafile, this
    was missed during the removal of the dependency on BINDs development
    libraries in v2.4.0.
  * Also note that with v2.5.0, this software now depends on Concurrency
    Kit (ck) for atomic operations.
  * Commits:
    924e6ea ANY
    0a444c0 TYPEnnn
* Fri Mar 12 2021 Jerry Lundström <lundstrom.jerry@gmail.com> 2.5.0-1
- Release 2.5.0
  * This release adds re-connection support for TCP and DoT protocol,
    new options to `resperf` and fixes a few bugs.
  * `dnsperf` and `resperf` will now try to re-connect when they lose a TCP
    or DoT connection, and with that comes a few new statistics metrics.
    For `dnsperf`, if a connection oriented protocol is used, it will now
    show the total number of re-connections made and the connection latency.
    For `resperf` it also shows the total number of re-connections made and
    the gnuplot data now contains the total number of connections made and
    the connection latency for each interval.
    Beside re-connection support, improvements have been made when it comes
    to tracking socket readiness while connections are established which
    should generate less warnings about "socket not ready".
  * New `resperf` options:
    - `-R`: Reopen the datafile if it runs out of data before the testing
      is completed. This allows for long running tests on very small and
      simple query datafile.
    - `-F <fall_behind>`: Sets the maximum number of queries that can fall
      behind being sent. `resperf` will stop when this many queries should
      have been sent and it can be relative easy to hit if `-m <max_qps>`
      is set too high.
      The default is 1000 and setting it to zero (0) disables the check.
  * Bugfixes:
    - Fixed port handling for host/network format when setting client side
      port with `-x`
    - Fix support for quoted characters, `\000` and `\.`, in domain names,
      this was lost when removing BIND's internal development libraries
    - Fix issue in `dnsperf`, it would loop forever if no connection could
      be established
    - Fix potential buffer overrun in `resperf` when using response id
      for `queries[]`
    - DoT: Fix bug when sending from buffer
  * Other changes:
    - Always use `IPV6_V6ONLY` socket option for IPv6
    - Add man-page on `-W` option added in v2.4.0
    - Reformat man-pages
    - `resperf`:
      - Try and process more request each run to hopefully not hit max
        outstanding so easy when high QPS
      - Add default value to `-C` so it shows in help
  * Commits:
    9308361 man-page format
    0e52fb4 man-page, opts, tuneups
    e36211d stats
    d9b9ba3 Response qid to index
    2b2c37e fixes, reconnection
    acd31e5 dname quote
    de8f049 net
* Tue Feb 23 2021 Jerry Lundström <lundstrom.jerry@gmail.com> 2.4.2-1
- Release 2.4.2
  * This release fixes a few issues with reading of the datafile which
    could lead to "ran out of data" errors.
  * The problem was that reading from the datafile was done before finding
    a socket to send it on, or socket readyness, and that lead to progressing
    the queries without really doing anything.
    Another issues that's been fixed was that if the read lines perfectly
    aligned with the buffer, it would be treated like EOF and caused an exit.
  * Commits:
    9937287 resperf TLS
    6736956 datafile
    55faec6 ran out of data
* Tue Feb 09 2021 Jerry Lundström <lundstrom.jerry@gmail.com> 2.4.1-1
- Release 2.4.1
  * This release fixes an issue with the socket readiness function that
    could cause a buffer overflow (`-T 10 -c 2000`) due to `select()` being
    limited to check 1023 sockets. `poll()` is now used which has no limit.
  * There has also been a few fixes to the contrib script `queryparse` that
    has to do with python v2 and v3 compatibility and better exception
    handling.
  * Commits:
    24e5bee poll
    7dceca7 Handle only common exceptions
    5603294 Fix error on python3
    48fa517 TSIG
* Wed Dec 09 2020 Jerry Lundström <lundstrom.jerry@gmail.com> 2.4.0-1
- Release 2.4.0
  * This release removes the dependency on BIND's internal development
    libraries! This make building and packaging a lot easier and less
    troublesome in the future.
  * This software now depends only on OpenSSL (for TSIG feature) with an
    optional depend on LDNS (for dynamic updates feature).
  * New option:
    - Transport mode option `-m`/`-M` now recognizes `dot` alongside `tls`
      for encrypted DNS
    - Added `-W` for outputting warnings and errors to stdout
  * Other changes / bugfixes:
    - Fix potential memory leak of query descriptions when using verbose
    - Only use TLS v1.2 and above for DoT/TLS
    - Add a lot of tests
    - Add coverage testing
  * Commits:
    d17743b datafile
    434bbf2 Checks, coverage, log, test IPv6
    9fb305f Coverage
    123ebf1 DOT, TLS version, Sonarcloud
    26df0bd BIND dependency
    ee660e7 Sonarcloud
    c9ea0ab base64
    4e9be82 TSIG
    4275045 EDNS, https
    7c3f51c BIND dependency
    6e1be5d ISC dependencies
    e36f19d Buffer
    485cdd2 ISC mem, tests
    663dc24 Namespace clash
    2c44987 dynamic updates, edns, headers
    5d109b2 Disable HMAC
    79cae93 datafile, query desc
    663d814 net
    c867de6 isc_result_t
    651ee5d opt
    7d30804 isc_result_t
    58ad313 ISC linked list
    7b4da6d Info
    8079ebc Tests
    e3fb685 Tests
    2bb603a Tests
    297b23b Test
    c4e244b Test
    1caac35 Makefile
    e9f2aaa Coverage
    27af853 Fix typo in configure.ac
    521faa6 Badges
    8fa2ec4 LGTM
    75c89e5 COPR
* Fri May 15 2020 Jerry Lundström <lundstrom.jerry@gmail.com> 2.3.4-1
- Release 2.3.4
  * This release adds a workaround, thanks to patch from Petr Menšík, for
    building on systems with BIND 9.16. Also improves error handling by
    using thread-safe `strerror_r()` instead of `strerror()`.
  * Commits:
    88c3ef4 strerror
    1917f67 openSUSE Tumbleweed
    fd39641 AS_VAR_APPEND
    aeeef74 bind 9.16
    07732cd BIND, libcrypto, clang format
    08146e3 Add crypto library to checks
    e4307c2 Add checks to pass with BIND 9.16
    3f9aed3 Prepare check for bind 9.11/9.16 return types
* Wed May 06 2020 Jerry Lundström <lundstrom.jerry@gmail.com> 2.3.3-1
- Release 2.3.3
  * This release changes the behavior of `dnsperf` and `resperf` when it
    comes to TCP and TLS connections, and updates package building using
    COPR (thanks to patch from Petr Menšík (Red Hat)).
  * Connection reset or close are now treated as "try again" so that the
    run is finished and not aborted. As SIGPIPE might be received on usage
    of closed connections it's now blocked in `dnsperf` and handled as
    a fatal action in `resperf`.
  * Commits:
    62885ad SIGPIPE
    106c50e connection
    3ef0899 README
    61a3b1c COPR
    35efa27 COPR
    46b37a1 COPR
    5c126ae COPR
    1c51b76 Provide full URL in spec
    2a4dd0e Allow recreation of source archive
    931d6cc Do not require root for archive creation
* Fri Aug 23 2019 Jerry Lundström <lundstrom.jerry@gmail.com> 2.3.2-1
- Release 2.3.2
  * This release fixes a buffer overflow when using TSIG and algorithms
    with digests larger then SHA256, reported by Mukund Sivaraman. Also
    fix build dependencies for `sqrt()`.
  * Commits:
    e54aa58 Digest
    bca5d8d sqrt
    d9eaa5b Package
* Wed Jul 24 2019 Jerry Lundström <lundstrom.jerry@gmail.com> 2.3.1-1
- Release 2.3.1
  * After a report and additional confirming results the use of `poll()` in
    the network receive code for TCP and TLS has been removed. This `poll()`
    initially gave better results while testing in a docker container on
    it's loopback interface but when on physical networks it reduced
    performance to 1/12th, so it had to go.
  * Thanks to Brian Wellington (Akamai/Nominum) for the initial report and
    testing, and to Jan Hák (CZ.NIC) for testing and confirming the results.
  * Bugfix:
    - Fix check for having more DNS messages in the receive buffer for TCP
      and TLS
  * Commits:
    670db9c TCP/TLS receive
    b8925b2 recvbuf have more
* Wed Jul 17 2019 Jerry Lundström <lundstrom.jerry@gmail.com> 2.3.0-1
- Release 2.3.0
  * This release adds support for DNS over TCP and TLS which can be selected
    by using the mode option for `dnsperf` and `resperf`. The default server
    port used is now determined by the transport mode, udp/tcp port 53 and
    tls port 853.
  * Note that the mode option is different between the program because it was
    already taken for `resperf`.
  * `dnsperf` changes:
    - Add `-m` for setting transport mode, `udp` (default), `tcp` or `tls`
    - Add verbose messages about network readiness and congestion
  * `resperf` changes:
    - Add `-M` for setting transport mode, `udp` (default), `tcp` or `tls`
    - Add `-v` for verbose mode to report about network readiness and
      congestion
  * Commits:
    ffa49cf LGTM, SonarCloud
    4cd5441 TLS
    35624d1 TCP send, socket ready loop
    fbf76aa TCP support
    5988b06 Funding
* Mon Jan 28 2019 Jerry Lundström <lundstrom.jerry@gmail.com> 2.2.1-1
- Release 2.2.1
  * The commit pulled from a fork that used `inttypes.h`, instead of ISC
    internal types, missed to remove the old conversion specifier.
    This was reported and fixed by Vladimír Čunát.
  * Commits:
    9534ce1 remove visible "u" characters after numbers
* Mon Dec 03 2018 Jerry Lundström <lundstrom.jerry@gmail.com> 2.2.0-1
- Release 2.2.0
  * First release by DNS-OARC with a rework of the code to use autotools,
    semantic versioning 2.0 and bugfixes pulled from other's forks.
  * Bugfixes:
    - Fix infinite loop in argument parsing
    - Fix min/max latency summing for multithreaded runs
    - Fix calculation of per_thread socket counts
    - Fixes to queryparse
      - Mark correctly end of file
      - Support python3
      - Stop looping on end of file undefinitely
    - Fix compilation issues and work around missing `dns_fixedname_initname()`
    - Clang `scan-build` fixes
  * Other changes:
    - add "configure --with-bind" option
    - Handle bind library changes to HMAC (see #22) and other differences
      between versions
    - Workaround issue on FreeBSD (see #23)
    - Use `snprintf()` and OpenBSD's `strlcat()`
    - Add/update build dependencies for Debia, Ubuntu, CentOS, FreeBSD
      and OpenBSD
  * Commits:
    ae9bc91 Clang format
    b9bb085 CI, buildbot
    b84e41b Autotools, README, changelog
    a2e1732 License
    9dcb661 Remove $Id markers, Principal Author and Reviewed tags from the
            full source tree
    0677bf0 Use dns_fixedname_initname() where possible
    d8d4696 [master] add "configure --with-bind" option to dnsperf
    b71a280 Add deb based distros dependencies
    439c614 Replace custom isc_boolean_t with C standard bool type
    407ae7c Replace custom isc_u?intNN_t types with C99 u?intNN_t types
    c27afd4 Replace ISC_PRINT_QUADFORMAT with inttypes.h format constants
    6fdb2f7 Fix queryparse
    4909b78 README
    2782d50 README.md: Rectify link to software
    e31ddf4 fix calculation of per_thread socket counts
    3bd7fb4 Fix min/max latency summing for multithreaded runs
    2207e27 Fix infinite loop in argument parsing.
    3bfe97a Include the github URL; remove the bug reports section.
    0cee04a Add note about bug reports.
    62c4b32 add .gitignore
    c45f0be Initial import.
    149172b Initial commit
