#ifndef SNIFFID_H
#include <pcap.h>
#include "config.h"
#define SNIFFID_H

#define MAX_DATAS	1024		/* Max data length in datas from _dns_packet structure */

/* Structs to make life more beautiful */
/* Make it point to the beginning of the DNS paquet (UDP data) */
/* Be careful with alignment... Multiple of 2 (sizeof) */
/* Example from ADM paper :
+---------------------------------+--------------------------------------+
|   ID = 1999                     | QR = 0 opcode = 0 RD = 1             |
+---------------------------------+--------------------------------------+
| numbers of questions = htons(1) | numbers of answers = 0               |
+---------------------------------+--------------------------------------+
| number of RR authoritative = 0  | number of supplementary RR = 0       |
+---------------------------------+--------------------------------------+
<the question part>
+------------------------------------------------------------------------+
|   name  of the question = [3|w|w|w|5|h|e|i|k|e|3|c|o|m|0]              |
+------------------------------------------------------------------------+
|  type of question = htons(1)    |      type of query=htons(1)          |
+---------------------------------+--------------------------------------+
*/
typedef struct _dns_packet *dns_packet;
typedef struct _dns_packet
{
	unsigned short dns_id;
	unsigned short flags;
	unsigned short num_q;
	unsigned short num_a;
	unsigned short num_auth_rr;
	unsigned short num_supp_rr;
	u_char datas[MAX_DATAS];			/* Need to be static */
}dns_packet_t;

/**********************/
/* Callback functions */
/**********************/
/* Send packets to the host who made the request (hope the first will be received before
 * the answser of the legitimate server) */
void callback_dnsid(u_char *args, const struct pcap_pkthdr* pkthdr, const u_char *packet);


/******************/
/* Grab functions */
/******************/
/* Grab dns queries on "device" from "hostsrc" and run the callback function (sniffing packets)
 * If device == NULL, then use pcap_lookupdev
 * Optional : file. If file!=NULL, log DNS ID to 'file' */
int grab_dns_IDs(char *device, char *srchost, char *file);

#endif
