#! /bin/sh

# What's needed:
# Monotone
# TMPDIR

BINARIES="DisTractNewBug DisTractUpdateBug DisTractUpdateAllBugs DisTractFormatBug DisTractFormatNew"

MTN=$(which mtn)
if [[ "x$MTN" == "x" || ! -x $MTN ]]
then
    echo "Unable to locate monotone (mtn) executable."
    exit 1
fi

MKTEMP=$(which mktemp)
if [[ "x$MKTEMP" == "x" || ! -x $MKTEMP ]]
then
    echo "Unable to locate mktemp executable."
    exit 1
fi

RM=$(which rm)
if [[ "x$RM" == "x" || ! -x $RM ]]
then
    echo "Unable to locate rm executable!"
    exit 1
fi

MKDIR=$(which mkdir)
if [[ "x$MKDIR" == "x" || ! -x $MKDIR ]]
then
    echo "Unable to locate mkdir executable!"
    exit 1
fi

SED=$(which sed)
if [[ "x$SED" == "x" || ! -x $SED ]]
then
    echo "Unable to locate sed executable!"
    exit 1
fi

HEAD=$(which head)
if [[ "x$HEAD" == "x" || ! -x $HEAD ]]
then
    echo "Unable to locate head executable!"
    exit 1
fi

DIR_TEMPLATE=DisTractSetup.XXXXXXXXXX
DIR=$($MKTEMP -t -d $DIR_TEMPLATE) || exit 1
MTNDB=$DIR/db.mtn
INITDIR=$(pwd)
#1. Make new mtn database
#2. Make necessary directories
#3. Create suitable branches
   $MTN -d $MTNDB db init \
&& USER=$($MTN -d $MTNDB ls keys | $SED -n '/\[private/,${/^[0-9a-f]/s/[0-9a-f]* //p}' | $HEAD -n 1) \
&& if [ -z $USER ]
   then
     echo "Can't find suitable user from monotone private keys"
     exit 1
   else
     echo "Using userid $USER"
   fi \
&& for d in bugs bin html prefs
   do
     $MKDIR $DIR/$d
   done \
&& $MTN -d $MTNDB setup -b DisTract.bugs $DIR/bugs \
&& $MTN -d $MTNDB setup -b DisTract.prefs.$USER $DIR/prefs \
&& cp monotonerc $DIR/bugs/_MTN/ \
&& pushd . \
&& cd $DIR/prefs \
&& echo -e "mtn=$MTN\ndb=$MTNDB" > config \
&& echo "^config$" > .mtn-ignore \
&& $MTN -d $MTNDB add .mtn-ignore \
&& $MTN -d $MTNDB ci -m "Adding .mtn-ignore" . \
&& cd $DIR/bugs \
&& echo "^bug-" > .mtn-ignore \
&& $MKDIR fields \
&& cp $INITDIR/defaultFields/* fields/ \
&& $MTN -d $MTNDB ls unknown | xargs $MTN -d $MTNDB add \
&& $MTN -d $MTNDB ci -m "Adding .mtn-ignore and default fields" . \
&& popd

for binary in $BINARIES
do
    if [ -x ../haskell/dist/build/$binary/$binary ]
    then
        cp ../haskell/dist/build/$binary/$binary $DIR/bin/$binary
    fi
done

if [ -d ../html/lib ]
then
    cp -a ../html/lib $DIR/html/
fi

$DIR/bin/DisTractFormatNew $DIR

if [ -z $NOCLEAN ]
then
    $($RM -rf $DIR)
else
    echo "NOCLEAN set, not cleaning up $DIR"
    echo "PATH=$DIR/bin:\$PATH"
fi
