/*
 * DisTractBug.js
 *     - utils for dealing with bugs
 *
 * Copyright (c) 2007, Matthew Sackman (matthew@wellquite.org)
 *
 * DisTract is freely distributable under the terms of a 3-Clause
 * BSD-style license. For details, see the DisTract web site:
 *   http://distract.wellquite.org/
 *
 */

var comments = new Object();
var fields = new Object();
fields.ary = new Array();

function registerComment (commentId, text, date, author) {
    var preamble = "*On " + date + ", " + author + " wrote:*\n\n";
    comments.commentId = preamble + text.replace(/^/mg, '> ') + "\n";
    $(commentId).innerHTML = markdownToHTML(text, []);
    return true;
}

function registerField (name, origValue) {
    var obj = new Object();
    obj.name = name;
    obj.value = origValue;
    fields.ary.push(obj);
    return true;
}

function makeFieldsObject () {
  var result = new Object();
  for (var idx = 0; idx < fields.ary.length; ++idx) {
    var name = fields.ary[idx].name;
    var origVal = fields.ary[idx].value;
    var inputEl = $(name);
    var newVal = origVal;
    if ('text' == inputEl.type) {
      newVal = inputEl.value;
    } else if (undefined !== inputEl.selectedIndex &&
               null != inputEl.selectedIndex) {
      newVal = inputEl[inputEl.selectedIndex].text;
    } else {
      var inputs = inputEl.getElementsByTagName ('input');
      if (undefined !== inputs && null != inputs) {
        for (var i = 0; i < inputs.length; ++i) {
          if (inputs[i].type == 'radio' &&
              inputs[i].name == name &&
              inputs[i].checked) {
            newVal = inputs[i].value;
          }
        }
      }
    }
    if (undefined !== origVal && null != origVal &&
        undefined !== newVal && null != newVal &&
        origVal != newVal) {
      result[name] = newVal;
    }
  }
  return result;
}

function makeCommentsObject () {
  var inReplyTo = $('comment-inReplyTo').value;
  var text = $('comment-textarea').value;
  var obj = new Object();
  if (text.length > 0) {
    obj.text = text;
    obj.inReplyTo = inReplyTo;
  }
  return obj;
}

function appendToReplyFunc (commentTextArea, commentInReplyTo, updateFunc) {
    var func = function (commentId) {
                   var text = comments.commentId;
                   text = $(commentTextArea).value + text;
                   $(commentTextArea).value = text;
                   updateFunc(text);
                   $(commentInReplyTo).value = commentId;
                   return true;
               }
    return func;
}

function updateCommentPreviewFunc (commentPreview) {
    var func = function (text) {
                   $(commentPreview).innerHTML = markdownToHTML(text, []);
                   return true;
               }
    return func;
}

function makeWikiLinkString(name, pages) {
  return name; // no wiki links (yet?)
}

