 {- DisTract ------------------------------------------------------\
 |                                                                 |
 | Copyright (c) 2007, Matthew Sackman (matthew@wellquite.org)     |
 |                                                                 |
 | DisTract is freely distributable under the terms of a 3-Clause  |
 | BSD-style license. For details, see the DisTract web site:      |
 |   http://distract.wellquite.org/                                |
 |                                                                 |
 \-----------------------------------------------------------------}

module Main
    (main)
    where

import DisTract.Config
import DisTract.Types
import DisTract.Parsers
import DisTract.HTML.BugView
import DisTract.IOUtils
import DisTract.Bug
import Data.Either
import Data.Maybe

main :: IO ()
main = do { config <- buildConfig
          ; case args config of
              (bugIdStr:update:_)
                  -> do { bugM <- if (read update)
                                  then updateAndLoadBug config bugId
                                  else loadBug config bugId
                        ; case bugM of
                            Nothing -> error $ "Bug " ++ (show bugId) ++ " not found"
                            (Just _) -> formatBug config bugM
                        }
                  where
                    bugId = either (\e -> error $ (show e) ++
                                    "Invalid bug id " ++ bugIdStr)
                                   id
                                   (findBugId bugIdStr)
              _ -> return ()
          }
