 {- DisTract ------------------------------------------------------\
 |                                                                 |
 | Copyright (c) 2007, Matthew Sackman (matthew@wellquite.org)     |
 |                                                                 |
 | DisTract is freely distributable under the terms of a 3-Clause  |
 | BSD-style license. For details, see the DisTract web site:      |
 |   http://distract.wellquite.org/                                |
 |                                                                 |
 \-----------------------------------------------------------------}

module Main
    (main)
    where

import DisTract.BugFileInputLoader
import DisTract.Config
import DisTract.Types
import DisTract.Bug
import DisTract.Utils

main :: IO ()
main = do { config <- buildConfig
          ; case args config of
              [] -> return ()
              (fp:_) -> do { bugDetails <- parseForNewBug fp
                           ; case bugDetails of
                               Nothing -> return ()
                               (Just (comment, fields)) ->
                                   do { bug <- makeNewBug config comment fields
                                      ; writeFileStrict fp (show . bugId $ bug)
                                      ; log . show $ bug
                                      }
                                   where
                                     log = logStr . logger $ config
                           }
          }
