 {- DisTract ------------------------------------------------------\
 |                                                                 |
 | Copyright (c) 2007, Matthew Sackman (matthew@wellquite.org)     |
 |                                                                 |
 | DisTract is freely distributable under the terms of a 3-Clause  |
 | BSD-style license. For details, see the DisTract web site:      |
 |   http://distract.wellquite.org/                                |
 |                                                                 |
 \-----------------------------------------------------------------}

module DisTract.Config.Parser
    (parseConfig,
     findUserInPrefsBranch
    )
where

import DisTract.Monotone.Parser (handleParseError)
import qualified Data.Map as M
import Text.ParserCombinators.Parsec

parseConfig :: String -> M.Map String String
parseConfig = handleParseError . runParser (configParser M.empty) ()
              "DisTract.Config.Parser"

configParser :: (M.Map String String) -> Parser (M.Map String String)
configParser m = do { key <- manyTill anyChar (try (char '='))
                    ; value <- manyTill anyChar
                               ((try (do {newline; return ()})) <|> eof)
                    ; rest <- configParser m
                    ; return (M.insert key value rest)
                    }
                 <|> return m

findUserInPrefsBranch :: String -> String
findUserInPrefsBranch = handleParseError . runParser parseUserBranch ()
                        "DisTract.Config.Parser userBranch"

parseUserBranch :: Parser String
parseUserBranch = do { manyTill anyChar (try (string ".prefs."))
                     ; user <- manyTill anyChar
                               ((try (do {newline; return ()})) <|> eof)
                     ; return user
                     }
