/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.junit;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.derbyTesting.junit.BaseTestCase;

public final class SpawnedProcess {
    private static final String TAG = "DEBUG: {SpawnedProcess} ";
    private static Timer KILL_TIMER;
    private static final String KILL_THRESHOLD_PROPERTY = "derby.tests.process.killThreshold";
    private static final long KILL_THRESHOLD_DEFAULT = 2700000L;
    private static final long KILL_THRESHOLD;
    private final String name;
    private final Process javaProcess;
    private final StreamSaver errSaver;
    private final StreamSaver outSaver;
    private boolean suppressOutput;
    private final TimerTask killTask;
    int stdOutReadOffset;

    private static void sleep(long ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException ie) {
            System.out.println("DEBUG: {SpawnedProcess} Interrupted while sleeping (ignored)");
        }
    }

    public SpawnedProcess(Process javaProcess, String name) {
        this.javaProcess = javaProcess;
        this.name = name;
        this.errSaver = this.startStreamSaver(javaProcess.getErrorStream(), name.concat(":System.err"));
        this.outSaver = this.startStreamSaver(javaProcess.getInputStream(), name.concat(":System.out"));
        this.killTask = this.scheduleKill(javaProcess, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TimerTask scheduleKill(Process process, String name) {
        String string = KILL_THRESHOLD_PROPERTY;
        synchronized (KILL_THRESHOLD_PROPERTY) {
            if (KILL_TIMER == null) {
                KILL_TIMER = new Timer(true);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            ProcessKillerTask killer = new ProcessKillerTask(process, name);
            KILL_TIMER.schedule((TimerTask)killer, KILL_THRESHOLD);
            return killer;
        }
    }

    public void suppressOutputOnComplete() {
        this.suppressOutput = true;
    }

    public Process getProcess() {
        return this.javaProcess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFullServerOutput() throws InterruptedException {
        this.outSaver.thread.join();
        SpawnedProcess spawnedProcess = this;
        synchronized (spawnedProcess) {
            return this.outSaver.stream.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFullServerError() throws InterruptedException {
        this.errSaver.thread.join();
        SpawnedProcess spawnedProcess = this;
        synchronized (spawnedProcess) {
            return this.errSaver.stream.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getNextServerOutput() {
        byte[] fullData;
        SpawnedProcess spawnedProcess = this;
        synchronized (spawnedProcess) {
            fullData = this.outSaver.stream.toByteArray();
        }
        String output = new String(fullData, this.stdOutReadOffset, fullData.length - this.stdOutReadOffset);
        this.stdOutReadOffset = fullData.length;
        return output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFailMessage(String reason) {
        SpawnedProcess.sleep(500L);
        StringBuffer sb = new StringBuffer();
        sb.append(reason);
        sb.append(":Spawned ");
        sb.append(this.name);
        sb.append(" exitCode=");
        try {
            sb.append(this.javaProcess.exitValue());
        }
        catch (IllegalThreadStateException e) {
            sb.append("running");
        }
        ByteArrayOutputStream err = this.errSaver.stream;
        ByteArrayOutputStream out = this.outSaver.stream;
        SpawnedProcess spawnedProcess = this;
        synchronized (spawnedProcess) {
            if (err.size() != 0) {
                sb.append("\nSTDERR:\n");
                sb.append(err.toString());
            }
            if (out.size() != 0) {
                sb.append("\nSTDOUT:\n");
                sb.append(out.toString());
            }
        }
        return sb.toString();
    }

    public int complete() throws IOException {
        return this.complete(Long.MAX_VALUE);
    }

    public int complete(long timeout) throws IOException {
        long start = System.currentTimeMillis();
        Integer exitCode = null;
        while (exitCode == null) {
            try {
                exitCode = new Integer(this.javaProcess.exitValue());
            }
            catch (IllegalThreadStateException itse) {
                if (System.currentTimeMillis() - start > timeout) {
                    this.javaProcess.destroy();
                }
                SpawnedProcess.sleep(500L);
            }
        }
        this.killTask.cancel();
        this.joinWith(this.errSaver.thread);
        this.joinWith(this.outSaver.thread);
        this.cleanupProcess();
        this.printDiagnostics(exitCode);
        return exitCode;
    }

    private void cleanupProcess() {
        this.closeStream(this.javaProcess.getOutputStream());
        this.closeStream(this.javaProcess.getErrorStream());
        this.closeStream(this.javaProcess.getInputStream());
        this.javaProcess.destroy();
    }

    private synchronized void printDiagnostics(int exitCode) throws IOException {
        ByteArrayOutputStream err = this.errSaver.stream;
        if (!this.suppressOutput && err.size() != 0) {
            System.err.println("START-SPAWNED:" + this.name + " ERROR OUTPUT:");
            err.writeTo(System.err);
            System.err.println("END-SPAWNED  :" + this.name + " ERROR OUTPUT:");
        }
        ByteArrayOutputStream out = this.outSaver.stream;
        if (!this.suppressOutput && exitCode != 0 && out.size() != 0) {
            System.out.println("START-SPAWNED:" + this.name + " STANDARD OUTPUT: exit code=" + exitCode);
            out.writeTo(System.out);
            System.out.println("END-SPAWNED  :" + this.name + " STANDARD OUTPUT:");
        }
    }

    private void joinWith(Thread t) {
        try {
            t.join();
        }
        catch (InterruptedException ie) {
            System.out.println("DEBUG: {SpawnedProcess} Interrupted while joining with thread '" + t.toString() + "'");
        }
    }

    private void closeStream(Object stream) {
        if (stream instanceof InputStream) {
            try {
                ((InputStream)stream).close();
            }
            catch (IOException ioe) {}
        } else if (stream instanceof OutputStream) {
            try {
                ((OutputStream)stream).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private StreamSaver startStreamSaver(final InputStream in, String name) {
        final ByteArrayOutputStream out = new ByteArrayOutputStream(){

            public void reset() {
                super.reset();
                new Throwable("WWW").printStackTrace(System.out);
            }
        };
        Thread streamReader = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                try {
                    int read;
                    byte[] buffer = new byte[1024];
                    while ((read = in.read(buffer)) != -1) {
                        SpawnedProcess spawnedProcess = SpawnedProcess.this;
                        synchronized (spawnedProcess) {
                            out.write(buffer, 0, read);
                        }
                    }
                    return;
                }
                catch (IOException ioe) {
                    ioe.printStackTrace(new PrintStream(out, true));
                }
            }
        }, name);
        streamReader.setDaemon(true);
        streamReader.start();
        return new StreamSaver(out, streamReader);
    }

    static {
        long tmpThreshold = 2700000L;
        String tmp = BaseTestCase.getSystemProperty(KILL_THRESHOLD_PROPERTY);
        if (tmp != null) {
            try {
                tmpThreshold = Long.parseLong(tmp);
            }
            catch (NumberFormatException nfe) {
                System.err.println("DEBUG: {SpawnedProcess} Invalid kill threshold: " + tmp);
            }
        }
        KILL_THRESHOLD = tmpThreshold;
    }

    private static class ProcessKillerTask
    extends TimerTask {
        private final String name;
        private Process process;

        public ProcessKillerTask(Process process, String name) {
            this.process = process;
            this.name = name;
        }

        public synchronized boolean cancel() {
            this.process = null;
            return super.cancel();
        }

        public synchronized void run() {
            int retriesAllowed;
            if (this.process == null) {
                return;
            }
            System.err.println("DEBUG: Destroying process '" + this.name + "'");
            this.process.destroy();
            for (retriesAllowed = 10; retriesAllowed > 0; --retriesAllowed) {
                try {
                    int exitCode = this.process.exitValue();
                    System.err.println("DEBUG: Destroyed process '" + this.name + "', exit code is " + exitCode);
                    break;
                }
                catch (IllegalThreadStateException itse) {
                    SpawnedProcess.sleep(1000L);
                    continue;
                }
            }
            if (retriesAllowed == 0) {
                System.err.println("DEBUG: Failed to destroy process '" + this.name + "'");
            }
            this.process = null;
        }
    }

    private static class StreamSaver {
        final ByteArrayOutputStream stream;
        final Thread thread;

        StreamSaver(ByteArrayOutputStream stream, Thread thread) {
            this.stream = stream;
            this.thread = thread;
        }
    }
}

