/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.junit;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.derbyTesting.functionTests.util.PrivilegedFileOpsForTests;
import org.apache.derbyTesting.junit.BaseTestCase;
import org.apache.derbyTesting.junit.DerbyVersion;

public class DerbyDistribution
implements Comparable {
    private static File[] EMPTY_FILE_ARRAY = new File[0];
    public static final String JAR_RUN = "derbyrun.jar";
    public static final String JAR_CLIENT = "derbyclient.jar";
    public static final String JAR_ENGINE = "derby.jar";
    public static final String JAR_NET = "derbynet.jar";
    public static final String JAR_TESTING = "derbyTesting.jar";
    private static final String[] REQUIRED_JARS = new String[]{"derby.jar", "derbynet.jar", "derbyclient.jar"};
    private final DerbyVersion version;
    private final String derbyRunJarPath;
    private final String derbyClientJarPath;
    private final String derbyEngineJarPath;
    private final String derbyNetJarPath;
    private final String productionClasspath;
    private final String testingClasspath;

    private DerbyDistribution(DerbyVersion version, File[] productionJars, File[] testingJars) throws IOException {
        if (version == null) {
            throw new NullPointerException("version is null");
        }
        this.version = version;
        this.productionClasspath = DerbyDistribution.constructJarClasspath(productionJars);
        this.testingClasspath = DerbyDistribution.constructJarClasspath(testingJars);
        File root = productionJars[0].getParentFile();
        this.derbyRunJarPath = this.getPath(root, JAR_RUN);
        this.derbyClientJarPath = this.getPath(root, JAR_CLIENT);
        this.derbyEngineJarPath = this.getPath(root, JAR_ENGINE);
        this.derbyNetJarPath = this.getPath(root, JAR_NET);
    }

    private String getPath(File root, String jar) {
        File f = new File(root, jar);
        if (PrivilegedFileOpsForTests.exists(f)) {
            return f.getAbsolutePath();
        }
        return null;
    }

    public boolean hasDerbyRunJar() {
        return this.derbyRunJarPath != null;
    }

    public String getDerbyRunJarPath() {
        return this.derbyRunJarPath;
    }

    public String getDerbyClientJarPath() {
        return this.derbyClientJarPath;
    }

    public String getDerbyEngineJarPath() {
        return this.derbyEngineJarPath;
    }

    public String getDerbyNetJarPath() {
        return this.derbyEngineJarPath;
    }

    public String getServerClasspath() {
        return this.derbyNetJarPath + File.pathSeparator + this.derbyEngineJarPath;
    }

    public String getProductionClasspath() {
        return this.productionClasspath;
    }

    public String getTestingClasspath() {
        return this.testingClasspath;
    }

    public String getFullClassPath() {
        return this.productionClasspath + File.pathSeparatorChar + this.testingClasspath;
    }

    public DerbyVersion getVersion() {
        return this.version;
    }

    public int compareTo(Object o) {
        return this.compareTo((DerbyDistribution)o);
    }

    public int compareTo(DerbyDistribution o) {
        return this.version.compareTo(o.version);
    }

    private static boolean hasRequiredJars(List jars) {
        for (int i = 0; i < REQUIRED_JARS.length; ++i) {
            boolean hasJar = false;
            Iterator jarIter = jars.iterator();
            while (jarIter.hasNext()) {
                File jar = (File)jarIter.next();
                if (!jar.getName().equalsIgnoreCase(REQUIRED_JARS[i])) continue;
                hasJar = true;
                break;
            }
            if (hasJar) continue;
            return false;
        }
        return true;
    }

    private static File[] getProductionJars(File libDir) {
        File[] pJars = libDir.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.toUpperCase().endsWith(".JAR") && !DerbyDistribution.isTestingJar(name);
            }
        });
        if (pJars == null) {
            return EMPTY_FILE_ARRAY;
        }
        return pJars;
    }

    private static File[] getTestingJars(File libDir) {
        File[] tJars = libDir.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return DerbyDistribution.isTestingJar(name);
            }
        });
        if (tJars == null) {
            return EMPTY_FILE_ARRAY;
        }
        return tJars;
    }

    public static File[] getJars(File libDir) {
        File[] jars = libDir.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.toUpperCase().endsWith(".JAR");
            }
        });
        return jars;
    }

    private static boolean isTestingJar(String name) {
        return name.toUpperCase().endsWith(JAR_TESTING.toUpperCase());
    }

    private static String constructJarClasspath(File[] jars) throws IOException {
        StringBuffer sb = new StringBuffer(512);
        for (int i = 0; i < jars.length; ++i) {
            sb.append(jars[i].getCanonicalPath());
            sb.append(File.pathSeparatorChar);
        }
        if (jars.length > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public static DerbyDistribution getInstance(File dir, DerbyVersion version) throws IOException {
        File[] productionJars = DerbyDistribution.getProductionJars(dir);
        File[] testingJars = DerbyDistribution.getTestingJars(dir);
        ArrayList<File> tmpJars = new ArrayList<File>();
        tmpJars.addAll(Arrays.asList(productionJars));
        tmpJars.addAll(Arrays.asList(testingJars));
        if (DerbyDistribution.hasRequiredJars(tmpJars)) {
            return new DerbyDistribution(version, productionJars, testingJars);
        }
        BaseTestCase.println("Distribution deemed invalid (note that running off classes isn't supported): " + dir.getAbsolutePath());
        return null;
    }
}

